/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.common.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import de.cismet.projecttracker.client.ImageConstants;
import de.cismet.projecttracker.client.ProjectTrackerEntryPoint;
import de.cismet.projecttracker.client.common.ui.LoginPanel;
import de.cismet.projecttracker.client.listener.BasicAsyncCallback;

public class LoginPanel
extends Composite
implements ClickHandler,
KeyUpHandler {
    private static LoginPanelUiBinder uiBinder = (LoginPanelUiBinder)GWT.create(LoginPanelUiBinder.class);
    @UiField
    FlowPanel loginPanel;
    private TextBox username = new TextBox();
    private PasswordTextBox password = new PasswordTextBox();
    private Button login = new Button("Sign in");
    private Button logout = new Button("Sign out");
    private Label userDataLab = new Label("");
    private Image gravatar = new Image();
    private Image slackLink = new Image(ImageConstants.INSTANCE.slackLogo());

    public LoginPanel() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.init();
    }

    public void onClick(ClickEvent event) {
        if (event.getSource() == this.login) {
            this.login();
        } else if (event.getSource() == this.logout) {
            BasicAsyncCallback callback = new BasicAsyncCallback();
            ProjectTrackerEntryPoint.getProjectService((boolean)true).logout((AsyncCallback)callback);
            ProjectTrackerEntryPoint.getInstance().logout();
        }
    }

    public void onKeyUp(KeyUpEvent event) {
        if (event.getNativeKeyCode() == 13 && !ProjectTrackerEntryPoint.getInstance().isLoggedIn()) {
            this.login();
        }
    }

    private void init() {
        this.loginPanel.add((Widget)this.username);
        this.loginPanel.add((Widget)this.password);
        this.loginPanel.add((Widget)this.login);
        this.username.setStyleName("input-small white");
        this.password.setStyleName("input-small");
        this.password.addKeyUpHandler((KeyUpHandler)this);
        this.login.setStyleName("btn");
        this.logout.setStyleName("btn");
        this.logout.addClickHandler((ClickHandler)this);
        this.login.addKeyUpHandler((KeyUpHandler)this);
        this.login.addClickHandler((ClickHandler)this);
        this.userDataLab.setStyleName("user-data");
        this.gravatar.setStyleName("pull-left gravatar-image");
        this.slackLink.setStyleName("image-link pull-left gravatar-image");
        this.slackLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void login() {
        2 callback = new /* Unavailable Anonymous Inner Class!! */;
        ProjectTrackerEntryPoint.getProjectService((boolean)true).login(this.username.getText(), this.password.getText(), (AsyncCallback)callback);
    }

    public void setLoggedIn(boolean loggedIn, String user) {
        if (loggedIn) {
            this.userDataLab.setText(user);
            this.loginPanel.clear();
            this.loginPanel.add((Widget)this.slackLink);
            this.loginPanel.add((Widget)this.gravatar);
            this.loginPanel.add((Widget)this.userDataLab);
            this.loginPanel.add((Widget)this.logout);
        } else {
            this.loginPanel.clear();
            this.loginPanel.add((Widget)this.username);
            this.loginPanel.add((Widget)this.password);
            this.loginPanel.add((Widget)this.login);
        }
    }

    public void setGravatar(String url) {
        this.gravatar.setUrl(url);
    }

    public void setSlack(String url) {
        this.slackLink.setUrl(url);
    }

    static /* synthetic */ TextBox access$000(LoginPanel x0) {
        return x0.username;
    }

    static /* synthetic */ PasswordTextBox access$100(LoginPanel x0) {
        return x0.password;
    }
}

