/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.common.ui;

import com.allen_sauer.gwt.dnd.client.PickupDragController;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import de.cismet.projecttracker.client.ProjectTrackerEntryPoint;
import de.cismet.projecttracker.client.common.ui.FlowPanelWithSpacer;
import de.cismet.projecttracker.client.common.ui.RecentStory;
import de.cismet.projecttracker.client.common.ui.RestorePickupDragController;
import de.cismet.projecttracker.client.common.ui.TaskNotice;
import de.cismet.projecttracker.client.common.ui.TaskStory;
import de.cismet.projecttracker.client.dto.ActivityDTO;
import java.util.ArrayList;

public class RecentStory
extends Composite {
    private static RecentStoryUiBinder uiBinder = (RecentStoryUiBinder)GWT.create(RecentStoryUiBinder.class);
    protected PickupDragController mondayDragController;
    protected TaskStory taskStory;
    protected boolean initialised = false;
    protected ArrayList<ActivityDTO> activites = new ArrayList();
    @UiField
    FlowPanelWithSpacer recentTasks;
    @UiField
    AbsolutePanel boundaryPanel;
    @UiField
    Label recentLab;

    public RecentStory() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.setLabels();
    }

    protected void setLabels() {
        this.recentLab.setStyleName("TimeHeader");
        this.recentLab.setText("My Recent Tasks");
    }

    public void setTaskStory(TaskStory taskStory) {
        if (!this.initialised) {
            this.taskStory = taskStory;
            this.activites.clear();
            this.mondayDragController = new RestorePickupDragController((AbsolutePanel)RootPanel.get(), false);
            taskStory.initDragController(this.mondayDragController, null);
            1 callback = new /* Unavailable Anonymous Inner Class!! */;
            ProjectTrackerEntryPoint.getProjectService((boolean)true).getLastActivitiesForUser(ProjectTrackerEntryPoint.getInstance().getStaff(), (AsyncCallback)callback);
        }
    }

    public void addTask(TaskNotice tn) {
        if (this.initialised) {
            if (this.contains(tn.getActivity())) {
                this.removeCorrespondingWidget(tn.getActivity());
            }
            this.activites.add(tn.getActivity());
            this.recentTasks.insert((Widget)tn, 0);
            this.mondayDragController.makeDraggable((Widget)tn, tn.getMouseHandledWidget());
        }
    }

    protected void removeCorrespondingWidget(ActivityDTO activity) {
        for (int i = 0; i < this.recentTasks.getWidgetCount(); ++i) {
            ActivityDTO tmp = ((TaskNotice)this.recentTasks.getWidget(i)).getActivity();
            if (!activity.getWorkPackage().equals((Object)tmp.getWorkPackage()) || !activity.getDescription().equals(tmp.getDescription())) continue;
            this.recentTasks.remove(this.recentTasks.getWidget(i));
            this.activites.remove(tmp);
            return;
        }
    }

    protected boolean contains(ActivityDTO act) {
        for (int i = 0; i < this.activites.size(); ++i) {
            ActivityDTO tmp = (ActivityDTO)this.activites.get(i);
            if (!act.getWorkPackage().equals((Object)tmp.getWorkPackage()) || act.getDescription() != tmp.getDescription() && (act.getDescription() == null || !act.getDescription().equals(tmp.getDescription()))) continue;
            return true;
        }
        return false;
    }

    protected void addTask(ActivityDTO activity) {
        TaskNotice widget = new TaskNotice(activity, true);
        this.recentTasks.add((Widget)widget);
        this.activites.add(activity);
        this.mondayDragController.makeDraggable((Widget)widget, widget.getMouseHandledWidget());
    }

    public PickupDragController getDragController() {
        return this.mondayDragController;
    }

    public void setInitialised(boolean initState) {
        this.initialised = initState;
    }
}

