/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.common.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.cismet.projecttracker.client.ProjectTrackerEntryPoint;
import de.cismet.projecttracker.client.common.ui.Story;
import de.cismet.projecttracker.client.common.ui.TimeNotice;
import de.cismet.projecttracker.client.common.ui.event.TimeStoryEvent;
import de.cismet.projecttracker.client.common.ui.listener.TaskDeleteListener;
import de.cismet.projecttracker.client.common.ui.listener.TimeNoticeListener;
import de.cismet.projecttracker.client.common.ui.listener.TimeStoryListener;
import de.cismet.projecttracker.client.dto.ActivityDTO;
import de.cismet.projecttracker.client.helper.DateHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class Story
extends Composite
implements ClickHandler,
TaskDeleteListener,
TimeNoticeListener {
    private static StoryUiBinder uiBinder = (StoryUiBinder)GWT.create(StoryUiBinder.class);
    private static final String DOW_TOOLTIP_SUFFX = "\n(click to add a new time slot)";
    @UiField
    FlowPanel monday;
    @UiField
    FlowPanel tuesday;
    @UiField
    FlowPanel wednesday;
    @UiField
    FlowPanel thursday;
    @UiField
    FlowPanel friday;
    @UiField
    FlowPanel saturday;
    @UiField
    FlowPanel sunday;
    @UiField
    AbsolutePanel boundaryPanel;
    @UiField
    Label mondayLab;
    @UiField
    Label tuesdayLab;
    @UiField
    Label wednesdayLab;
    @UiField
    Label thursdayLab;
    @UiField
    Label fridayLab;
    @UiField
    Label saturdayLab;
    @UiField
    Label sundayLab;
    Button addTask = new Button();
    private FlowPanel[] daysOfWeek = new FlowPanel[7];
    private HashMap<FlowPanel, List<TimeNotice>> taskMap = new HashMap();
    private Date firstDayOfWeek = new Date();
    private List<TimeStoryListener> listener = new ArrayList();

    public Story() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.daysOfWeek[0] = this.sunday;
        this.daysOfWeek[1] = this.monday;
        this.daysOfWeek[2] = this.tuesday;
        this.daysOfWeek[3] = this.wednesday;
        this.daysOfWeek[4] = this.thursday;
        this.daysOfWeek[5] = this.friday;
        this.daysOfWeek[6] = this.saturday;
        this.mondayLab.addClickHandler((ClickHandler)this);
        this.tuesdayLab.addClickHandler((ClickHandler)this);
        this.wednesdayLab.addClickHandler((ClickHandler)this);
        this.thursdayLab.addClickHandler((ClickHandler)this);
        this.fridayLab.addClickHandler((ClickHandler)this);
        this.saturdayLab.addClickHandler((ClickHandler)this);
        this.sundayLab.addClickHandler((ClickHandler)this);
        this.mondayLab.setStyleName("TimeHeader");
        this.tuesdayLab.setStyleName("TimeHeader");
        this.wednesdayLab.setStyleName("TimeHeader");
        this.thursdayLab.setStyleName("TimeHeader");
        this.fridayLab.setStyleName("TimeHeader");
        this.saturdayLab.setStyleName("TimeHeader");
        this.sundayLab.setStyleName("TimeHeader");
        this.mondayLab.setText("Monday");
        this.tuesdayLab.setText("Tuesday");
        this.wednesdayLab.setText("Wednesday");
        this.thursdayLab.setText("Thursday");
        this.fridayLab.setText("Friday");
        this.saturdayLab.setText("Saturday");
        this.sundayLab.setText("Sunday");
        for (FlowPanel columnPanel : this.daysOfWeek) {
            this.taskMap.put(columnPanel, new ArrayList());
        }
    }

    public void taskDelete(Object source) {
        if (source instanceof TimeNotice) {
            TimeNotice time = (TimeNotice)source;
            for (FlowPanel tmpPanel : this.taskMap.keySet()) {
                List tmpList = (List)this.taskMap.get(tmpPanel);
                if (!tmpList.contains(time)) continue;
                tmpList.remove(time);
                tmpPanel.remove((Widget)time);
                break;
            }
            TimeStoryEvent e = new TimeStoryEvent((Object)this, false, time.getStart());
            for (TimeStoryListener tmp : this.listener) {
                tmp.timeNoticeDeleted(e);
            }
        }
        ProjectTrackerEntryPoint.getInstance().validateSize();
    }

    public void timeChanged(Object source) {
        TimeStoryEvent e = new TimeStoryEvent((Object)this, false, ((TimeNotice)source).getStart());
        for (TimeStoryListener tmp : this.listener) {
            tmp.timeNoticeChanged(e);
        }
    }

    public void addTask(ActivityDTO start, ActivityDTO end, FlowPanel columnPanel) {
        TimeNotice widget = new TimeNotice(start, end);
        widget.addListener((TaskDeleteListener)this);
        widget.addTimeNoticeListener((TimeNoticeListener)this);
        widget.addStyleName("alert alert-block info timebox");
        columnPanel.add((Widget)widget);
        ((List)this.taskMap.get(columnPanel)).add(widget);
        ProjectTrackerEntryPoint.getInstance().validateSize();
    }

    public void setTimes(Date firstDayOfWeek, List<ActivityDTO> activities) {
        this.firstDayOfWeek = firstDayOfWeek;
        this.setDates();
        this.removeAllTasks();
        if (activities.isEmpty()) {
            return;
        }
        Collections.sort(activities);
        ArrayList<ActivityDTO> tmp = new ArrayList<ActivityDTO>();
        for (ActivityDTO act : activities) {
            if (act.getKindofactivity() != 1 && act.getKindofactivity() != 2) continue;
            tmp.add(act);
        }
        if (tmp.isEmpty()) {
            return;
        }
        Date d = new Date(((ActivityDTO)tmp.get(0)).getDay().getTime());
        ArrayList<ActivityDTO> beginEndActivities = new ArrayList<ActivityDTO>();
        for (int i = 0; i < tmp.size(); ++i) {
            ActivityDTO lookAhead;
            ActivityDTO act = (ActivityDTO)tmp.get(i);
            beginEndActivities.add(act);
            ActivityDTO activityDTO = lookAhead = i != tmp.size() - 1 ? (ActivityDTO)tmp.get(i + 1) : null;
            if (lookAhead != null && (DateHelper.isSameDay((Date)lookAhead.getDay(), (Date)d) || lookAhead.getDay().getHours() < 4) && lookAhead.getDay().getDay() - d.getDay() <= 1) continue;
            if (!beginEndActivities.isEmpty()) {
                this.addAllTimes(this.deterimineDay(beginEndActivities), beginEndActivities);
            }
            beginEndActivities = new ArrayList();
            if (lookAhead == null || (d = new Date(lookAhead.getDay().getTime())).getHours() >= 4) continue;
            DateHelper.addDays((Date)d, (int)-1);
        }
    }

    private void setDates() {
        this.mondayLab.setTitle("\t" + DateHelper.formatDate((Date)this.firstDayOfWeek) + DOW_TOOLTIP_SUFFX);
        Date tmpDay = (Date)this.firstDayOfWeek.clone();
        DateHelper.addDays((Date)tmpDay, (int)1);
        this.tuesdayLab.setTitle("\t" + DateHelper.formatDate((Date)tmpDay) + DOW_TOOLTIP_SUFFX);
        DateHelper.addDays((Date)tmpDay, (int)1);
        this.wednesdayLab.setTitle("\t" + DateHelper.formatDate((Date)tmpDay) + DOW_TOOLTIP_SUFFX);
        DateHelper.addDays((Date)tmpDay, (int)1);
        this.thursdayLab.setTitle("\t" + DateHelper.formatDate((Date)tmpDay) + DOW_TOOLTIP_SUFFX);
        DateHelper.addDays((Date)tmpDay, (int)1);
        this.fridayLab.setTitle("\t" + DateHelper.formatDate((Date)tmpDay) + DOW_TOOLTIP_SUFFX);
        DateHelper.addDays((Date)tmpDay, (int)1);
        this.saturdayLab.setTitle("\t" + DateHelper.formatDate((Date)tmpDay) + DOW_TOOLTIP_SUFFX);
        DateHelper.addDays((Date)tmpDay, (int)1);
        this.sundayLab.setTitle("\t" + DateHelper.formatDate((Date)tmpDay) + DOW_TOOLTIP_SUFFX);
    }

    void onAddTaskClick(ClickEvent event) {
    }

    private void removeAllTasks() {
        for (FlowPanel tmp : this.daysOfWeek) {
            List list = (List)this.taskMap.get(tmp);
            for (TimeNotice widget : list) {
                tmp.remove((Widget)widget);
            }
            list.clear();
        }
    }

    public void addTask(int day, ActivityDTO begin, ActivityDTO end) {
        this.addTask(begin, end, this.daysOfWeek[day]);
    }

    public void onClick(ClickEvent event) {
        if (event.getSource() == this.mondayLab) {
            this.addTime(this.calcDateForDay(0));
        } else if (event.getSource() == this.tuesdayLab) {
            this.addTime(this.calcDateForDay(1));
        } else if (event.getSource() == this.wednesdayLab) {
            this.addTime(this.calcDateForDay(2));
        } else if (event.getSource() == this.thursdayLab) {
            this.addTime(this.calcDateForDay(3));
        } else if (event.getSource() == this.fridayLab) {
            this.addTime(this.calcDateForDay(4));
        } else if (event.getSource() == this.saturdayLab) {
            this.addTime(this.calcDateForDay(5));
        } else if (event.getSource() == this.sundayLab) {
            this.addTime(this.calcDateForDay(6));
        }
    }

    public double getTimeForDay(int day) {
        FlowPanel test = this.daysOfWeek[day];
        List timeList = (List)this.taskMap.get(test);
        double sum = 0.0;
        for (TimeNotice tmp : timeList) {
            sum += tmp.getHours();
        }
        return sum;
    }

    public List<TimeNotice> getTimeNoticesForDay(int day) {
        return (List)this.taskMap.get(this.daysOfWeek[day]);
    }

    private void addTime(Date day) {
        1 callback = new /* Unavailable Anonymous Inner Class!! */;
        ProjectTrackerEntryPoint.getProjectService((boolean)true).isDayLocked(day, ProjectTrackerEntryPoint.getInstance().getStaff(), (AsyncCallback)callback);
    }

    private void addTimeStartEnd(Date day, Date startTime, Date endTime) {
        ActivityDTO end;
        ActivityDTO start = new ActivityDTO();
        ActivityDTO activityDTO = end = endTime == null ? null : new ActivityDTO();
        if (startTime.getHours() >= 4) {
            start.setDay(DateHelper.createDateObject((Date)day, (Date)startTime));
            if (end != null) {
                end.setDay(DateHelper.createDateObject((Date)day, (Date)endTime));
            }
        } else {
            Date d = new Date(day.getTime());
            DateHelper.addDays((Date)d, (int)1);
            d.setHours(startTime.getHours());
            d.setMinutes(startTime.getMinutes());
            start.setDay(d);
            if (end != null) {
                end.setDay(DateHelper.createDateObject((Date)day, (Date)endTime));
                if (end.getDay().before(start.getDay())) {
                    end.setDay(DateHelper.createDateObject((Date)day, (Date)start.getDay()));
                    end.setDay(new Date(end.getDay().getTime() + 60000L));
                }
            }
        }
        start.setKindofactivity(1);
        start.setStaff(ProjectTrackerEntryPoint.getInstance().getStaff());
        2 startCallback = new /* Unavailable Anonymous Inner Class!! */;
        3 endCallback = new /* Unavailable Anonymous Inner Class!! */;
        ProjectTrackerEntryPoint.getProjectService((boolean)true).createActivity(start, (AsyncCallback)startCallback);
        if (end != null) {
            end.setKindofactivity(2);
            end.setStaff(ProjectTrackerEntryPoint.getInstance().getStaff());
            ProjectTrackerEntryPoint.getProjectService((boolean)true).createActivity(end, (AsyncCallback)endCallback);
        }
    }

    private Date calcDateForDay(int day) {
        Date newDate = (Date)this.firstDayOfWeek.clone();
        DateHelper.addDays((Date)newDate, (int)day);
        return newDate;
    }

    private void fireTimeNoticeCreated(TimeStoryEvent e) {
        for (TimeStoryListener l : this.listener) {
            l.timeNoticeCreated(e);
        }
    }

    public void addTimeStoryListener(TimeStoryListener l) {
        this.listener.add(l);
    }

    public void removeTimeStoryListener(TimeStoryListener l) {
        this.listener.remove(l);
    }

    private void addAllTimes(int day, ArrayList<ActivityDTO> beginEndActivities) {
        for (int i = 0; i < beginEndActivities.size(); i += 2) {
            ActivityDTO end;
            ActivityDTO begin = beginEndActivities.get(i);
            ActivityDTO activityDTO = end = i != beginEndActivities.size() - 1 ? beginEndActivities.get(i + 1) : null;
            if (end != null && end.getKindofactivity() != 2) {
                this.addTask(day, begin, null);
                continue;
            }
            this.addTask(day, begin, end);
        }
    }

    private int deterimineDay(ArrayList<ActivityDTO> beginEndActivities) {
        if (beginEndActivities == null || beginEndActivities.isEmpty()) {
            return -1;
        }
        Date d = beginEndActivities.get(0).getDay();
        boolean shiftOneDay = true;
        for (ActivityDTO act : beginEndActivities) {
            if (act.getDay().getHours() < 4) continue;
            shiftOneDay = false;
            break;
        }
        if (shiftOneDay) {
            DateHelper.addDays((Date)d, (int)-1);
        }
        return d.getDay();
    }

    static /* synthetic */ FlowPanel[] access$000(Story x0) {
        return x0.daysOfWeek;
    }

    static /* synthetic */ HashMap access$100(Story x0) {
        return x0.taskMap;
    }

    static /* synthetic */ void access$200(Story x0, Date x1, Date x2, Date x3) {
        x0.addTimeStartEnd(x1, x2, x3);
    }

    static /* synthetic */ void access$300(Story x0, TimeStoryEvent x1) {
        x0.fireTimeNoticeCreated(x1);
    }
}

