/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.common.ui;

import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.storage.client.Storage;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimpleCheckBox;
import com.google.gwt.user.client.ui.Widget;
import de.cismet.projecttracker.client.ImageConstants;
import de.cismet.projecttracker.client.ProjectTrackerEntryPoint;
import de.cismet.projecttracker.client.common.ui.Story;
import de.cismet.projecttracker.client.common.ui.StoryForm;
import de.cismet.projecttracker.client.common.ui.TaskNotice;
import de.cismet.projecttracker.client.common.ui.TaskStory;
import de.cismet.projecttracker.client.dto.ActivityDTO;
import de.cismet.projecttracker.client.dto.ContractDTO;
import de.cismet.projecttracker.client.dto.ProjectDTO;
import de.cismet.projecttracker.client.dto.ProjectPeriodDTO;
import de.cismet.projecttracker.client.dto.WorkCategoryDTO;
import de.cismet.projecttracker.client.dto.WorkPackageDTO;
import de.cismet.projecttracker.client.dto.WorkPackagePeriodDTO;
import de.cismet.projecttracker.client.exceptions.InvalidInputValuesException;
import de.cismet.projecttracker.client.helper.DateHelper;
import de.cismet.projecttracker.client.helper.GUIHelper;
import de.cismet.projecttracker.client.utilities.TaskFiller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class StoryForm
extends Composite
implements ChangeHandler,
KeyUpHandler,
ClickHandler {
    private static StoryFormUiBinder uiBinder = (StoryFormUiBinder)GWT.create(StoryFormUiBinder.class);
    private static WorkCategoryDTO travelCatagory = null;
    @UiField
    com.google.gwt.user.client.ui.TextBox description;
    @UiField
    TextBox duration;
    @UiField
    Button saveButton;
    @UiField
    Button fillTaskBtn;
    @UiField
    Button cancelButton;
    @UiField
    ListBox project;
    @UiField
    ListBox workpackage;
    @UiField
    CheckBox travel;
    @UiField
    SimpleCheckBox wpDateFilterCB;
    @UiField
    ControlGroup durationCtrlGroup;
    @UiField
    SpanElement hoursLeft;
    private DialogBox form;
    private TaskStory caller;
    private Story story;
    private Date day = new Date();
    private List<ProjectDTO> projects;
    private boolean modification = false;
    private TaskNotice tn;
    private final Storage storage = Storage.getLocalStorageIfSupported();
    private String currentProject;
    private double totalHours = Double.MAX_VALUE;
    private double totalHoursWithOutCurrent = Double.MAX_VALUE;
    private double totalIssueHours = -1.0;

    public StoryForm(DialogBox form, TaskStory tb, Story s, TaskNotice tn) {
        this.form = form;
        this.caller = tb;
        this.tn = tn;
        tn.getActivity().getDay();
        this.story = s;
        this.modification = true;
        this.day = tn.getActivity().getDay();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.init();
        this.description.setText(tn.getActivity().getDescription());
        if (tn.getActivity().getWorkCategory() != null && tn.getActivity().getWorkCategory().getId() == 4L) {
            this.travel.setValue(Boolean.valueOf(true));
        } else {
            this.travel.setValue(Boolean.valueOf(false));
        }
        this.duration.setText(DateHelper.doubleToHours((double)tn.getActivity().getWorkinghours()));
        this.setProjectById(tn.getActivity().getWorkPackage().getProject().getId());
        this.initWorkpackage();
        this.setWPById(tn.getActivity().getWorkPackage().getId());
        this.project.addChangeHandler((ChangeHandler)this);
        this.workpackage.addChangeHandler((ChangeHandler)this);
        this.saveButton.setText("Save");
        this.setDefaultButton();
        this.configFillButton();
        this.configDurationBox();
        this.setProjectHoursLeft();
    }

    public StoryForm(DialogBox form, TaskStory tb, Story s, Date day) {
        this.form = form;
        this.caller = tb;
        this.day = day;
        this.story = s;
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.init();
        this.project.addChangeHandler((ChangeHandler)this);
        this.workpackage.addChangeHandler((ChangeHandler)this);
        this.setDefaultButton();
        this.configFillButton();
        this.configDurationBox();
        this.setProjectHoursLeft();
    }

    private void configDurationBox() {
        this.duration.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.duration.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setProjectHoursLeft() {
        ArrayList<WorkPackageDTO> wpList = new ArrayList<WorkPackageDTO>();
        wpList.add(this.getSelectedWorkpackage());
        3 cb = new /* Unavailable Anonymous Inner Class!! */;
        ProjectTrackerEntryPoint.getProjectService((boolean)false).getHoursSumForActivites(wpList, null, null, null, null, (AsyncCallback)cb);
        if (this.tn != null && this.tn.getActivity() != null && this.tn.getActivity().getId() > 0L) {
            4 cb1 = new /* Unavailable Anonymous Inner Class!! */;
            ProjectTrackerEntryPoint.getProjectService((boolean)false).getHoursSumForActivites(wpList, null, null, null, null, this.tn.getActivity(), (AsyncCallback)cb1);
        }
    }

    private void loadIssueTime(List<WorkPackageDTO> wpList) {
        if (this.description.getText().contains("#") && this.description.getText().lastIndexOf("#") == this.description.getText().indexOf("#")) {
            String issueNumber = this.getIssue(this.description.getText());
            5 cb1 = new /* Unavailable Anonymous Inner Class!! */;
            ProjectTrackerEntryPoint.getProjectService((boolean)false).getHoursSumForActivites(wpList, null, null, null, issueNumber, null, true, (AsyncCallback)cb1);
        }
    }

    private String getIssue(String desc) {
        RegExp regExp = RegExp.compile((String)"#(\\d+)", (String)"g");
        MatchResult matcher = regExp.exec(desc);
        boolean lastIndex = false;
        String issueNumber = null;
        if (matcher != null) {
            for (int i = 0; i < matcher.getGroupCount(); ++i) {
                String groupStr = matcher.getGroup(i);
                if (!groupStr.startsWith("#")) continue;
                issueNumber = groupStr.substring(0);
                break;
            }
        }
        return issueNumber;
    }

    private void validateDuration() {
        String durationText = this.duration.getText();
        boolean isValid = false;
        if (durationText != null) {
            isValid = (ProjectTrackerEntryPoint.getInstance().getStaff().getPermissions() & 2) == 2 ? durationText.matches("-?[0-9:]*") : durationText.matches("[0-9:]*");
        }
        if (!isValid) {
            this.durationCtrlGroup.setType(ControlGroupType.ERROR);
            this.saveButton.setEnabled(false);
        } else {
            this.durationCtrlGroup.setType(ControlGroupType.NONE);
            this.saveButton.setEnabled(true);
        }
    }

    public void onClick(ClickEvent event) {
        if (event.getSource() == this.wpDateFilterCB) {
            this.initWorkpackage();
        }
    }

    public void onChange(ChangeEvent event) {
        if (event.getSource() == this.project) {
            if (this.storage != null && this.project != null && this.project.getSelectedItemText() != null) {
                this.storage.setItem("activityProject", this.project.getSelectedItemText());
            }
            this.initWorkpackage();
            this.setProjectHoursLeft();
        } else if (event.getSource() == this.workpackage) {
            this.setProjectHoursLeft();
        }
    }

    private void setDefaultButton() {
        this.saveButton.setFocus(true);
        this.description.addKeyUpHandler((KeyUpHandler)this);
        this.duration.addKeyUpHandler((KeyUpHandler)this);
        this.project.addKeyUpHandler((KeyUpHandler)this);
        this.workpackage.addKeyUpHandler((KeyUpHandler)this);
    }

    private void configFillButton() {
        this.fillTaskBtn.setHTML("<img src='" + ImageConstants.INSTANCE.magicFiller().getURL() + "' />");
        this.fillTaskBtn.setStyleName("btn pull-left");
        this.fillTaskBtn.getElement().getStyle().setProperty("padding", "8px 12px");
    }

    @UiHandler(value={"saveButton"})
    void onButtonClick(ClickEvent event) {
        if (this.travel.getValue().booleanValue() && travelCatagory == null) {
            6 callback = new /* Unavailable Anonymous Inner Class!! */;
            ProjectTrackerEntryPoint.getProjectService((boolean)true).getWorkCategory(4L, (AsyncCallback)callback);
            return;
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiHandler(value={"fillTaskBtn"})
    void onFillButtonClick(ClickEvent event) {
        double timeToFill = TaskFiller.getTimeToFill((Date)this.day, null, (TaskStory)this.caller, (Story)this.story);
        try {
            if (this.duration.getText() != null && !this.duration.getText().isEmpty()) {
                timeToFill += DateHelper.hoursToDouble((String)this.duration.getText());
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        finally {
            if (timeToFill < 0.0) {
                ProjectTrackerEntryPoint.outputBox((String)"The fill operation would set a negative time for this task.");
                return;
            }
            this.duration.setText(DateHelper.doubleToHours((double)timeToFill));
        }
    }

    private void save() {
        7 callback;
        WorkPackageDTO wp;
        WorkPackagePeriodDTO period;
        boolean createTask;
        double hoursForWP;
        double workinghours = 0.0;
        try {
            String durationAsText = this.duration.getText();
            if (durationAsText != null && !durationAsText.equals("")) {
                if ((ProjectTrackerEntryPoint.getInstance().getStaff().getPermissions() & 2) == 2) {
                    boolean startWithMinus = durationAsText.startsWith("-");
                    if (startWithMinus) {
                        durationAsText = durationAsText.substring(1);
                    }
                    workinghours = DateHelper.hoursToDouble((String)durationAsText);
                    if (startWithMinus) {
                        workinghours *= -1.0;
                    }
                } else {
                    workinghours = DateHelper.hoursToDouble((String)durationAsText);
                }
            }
        }
        catch (NumberFormatException e) {
            ProjectTrackerEntryPoint.outputBox((String)"The duration is not valid");
            return;
        }
        if (this.description.getText().trim().equals("") && !this.getSelectedProject().getName().equals("Abwesenheit") && !this.getSelectedWorkpackage().getName().equalsIgnoreCase("Teambesprechung") && !this.getSelectedProject().getName().equals("Abgleich Zeitkonto")) {
            ProjectTrackerEntryPoint.outputBox((String)"An empty description is not allowed.");
            return;
        }
        String workpackageName = this.getSelectedWorkpackage().getName().trim().replaceAll("^\\d*_", "");
        String descriptionText = this.description.getText().trim().replaceAll("^\\d*_", "");
        double d = hoursForWP = this.totalHoursWithOutCurrent != Double.MAX_VALUE ? this.totalHoursWithOutCurrent : this.totalHours;
        if (this.getSelectedWorkpackage().getName().startsWith("10_") && hoursForWP != Double.MAX_VALUE && hoursForWP < 0.0 && hoursForWP + workinghours > 0.01 && !(createTask = ProjectTrackerEntryPoint.outputBoxConfirm((String)"If this is a new activity, the workpackage time will be positive. Do you still want to create this task?"))) {
            return;
        }
        if (this.similarity(workpackageName, descriptionText) > 0.5) {
            ProjectTrackerEntryPoint.outputBox((String)"The description and the name of the workpackage are too similar.");
            return;
        }
        ActivityDTO newActivity = this.modification ? this.tn.getActivity().createCopy() : new ActivityDTO();
        newActivity.setDay(this.day);
        newActivity.setWorkPackage(this.getSelectedWorkpackage());
        newActivity.setDescription(this.description.getText());
        newActivity.setStaff(ProjectTrackerEntryPoint.getInstance().getStaff());
        newActivity.setKindofactivity(0);
        newActivity.setWorkinghours(workinghours);
        if (newActivity.getWorkPackage() != null && (period = (wp = newActivity.getWorkPackage()).determineMostRecentPeriod()) != null && !DateHelper.isDayInWorkPackagePeriod((Date)this.day, (WorkPackagePeriodDTO)period)) {
            ProjectTrackerEntryPoint.outputBox((String)("Can not drop this activity here since the workpackage is out of date ( " + DateHelper.formatDate((Date)period.getFromdate()) + " - " + DateHelper.formatDate((Date)period.getTodate()) + " Your administrators advice is: " + wp.getExpirationDescription()));
            return;
        }
        if (this.travel.getValue().booleanValue()) {
            newActivity.setWorkCategory(travelCatagory);
        } else {
            newActivity.setWorkCategory(null);
        }
        if (this.modification) {
            callback = new /* Unavailable Anonymous Inner Class!! */;
            ProjectTrackerEntryPoint.getProjectService((boolean)true).saveActivity(newActivity, (AsyncCallback)callback);
        } else {
            callback = new /* Unavailable Anonymous Inner Class!! */;
            ProjectTrackerEntryPoint.getProjectService((boolean)true).createActivity(newActivity, (AsyncCallback)callback);
        }
    }

    private double similarity(String s1, String s2) {
        return 1.0 - this.levenshtein(s1, s2) / (double)Math.max(s1.length(), s2.length());
    }

    private double levenshtein(String s1, String s2) {
        int j;
        int m = s1.length();
        int n = s2.length();
        int[][] d = new int[m + 1][n + 1];
        for (int i = 0; i <= m; ++i) {
            d[i] = new int[n];
            d[i][0] = i;
        }
        for (j = 0; j <= n; ++j) {
            d[0][j] = j;
        }
        for (j = 1; j <= n; ++j) {
            for (int i = 1; i <= m; ++i) {
                d[i][j] = s1.charAt(i - 1) == s2.charAt(j - 1) ? d[i - 1][j - 1] : Math.min(Math.min(d[i - 1][j] + 1, d[i][j - 1] + 1), d[i - 1][j - 1] + 1);
            }
        }
        return d[m][n];
    }

    @UiHandler(value={"cancelButton"})
    void onButtoClick(ClickEvent event) {
        this.form.hide();
    }

    private void init() {
        String companyName;
        if (this.storage != null) {
            this.currentProject = this.storage.getItem("activityProject");
        }
        this.wpDateFilterCB.setValue(Boolean.valueOf(true));
        this.wpDateFilterCB.setTitle(" if selected, only WorkPackages which are in the current period of the project, are shown");
        this.wpDateFilterCB.addClickHandler((ClickHandler)this);
        List result = ProjectTrackerEntryPoint.getInstance().getProjects();
        ContractDTO contract = null;
        try {
            contract = ProjectTrackerEntryPoint.getInstance().getContractForStaff(this.day);
        }
        catch (InvalidInputValuesException ex) {
            Logger.getLogger(StoryForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        String string = companyName = contract == null ? "" : contract.getCompany().getName();
        if (result == null) {
            9 callback = new /* Unavailable Anonymous Inner Class!! */;
            ProjectTrackerEntryPoint.getProjectService((boolean)true).getAllProjectsFull((AsyncCallback)callback);
        } else {
            int index = 0;
            int selectedProjectIndex = 0;
            for (ProjectDTO tmp : result) {
                ProjectPeriodDTO period = tmp.determineMostRecentPeriod();
                if (!GUIHelper.canUserBillToProject((String)companyName, (ProjectDTO)tmp) || period != null && !DateHelper.isDayInProjectPeriod((Date)this.day, (ProjectPeriodDTO)period)) continue;
                this.project.addItem(tmp.getName(), "" + tmp.getId());
                if (tmp.getName().equals(this.currentProject)) {
                    selectedProjectIndex = index;
                }
                ++index;
            }
            this.projects = result;
            this.project.setSelectedIndex(selectedProjectIndex);
            this.initWorkpackage();
        }
    }

    private void initWorkpackage() {
        ProjectDTO selectedProject = this.getSelectedProject();
        if (selectedProject != null) {
            this.workpackage.clear();
            if (selectedProject.getWorkPackages() != null) {
                Object[] wps = selectedProject.getWorkPackages().toArray(new WorkPackageDTO[selectedProject.getWorkPackages().size()]);
                Arrays.sort(wps);
                if (selectedProject.getName().equals("Abwesenheit")) {
                    int alreadyAdded = 0;
                    for (int i = 0; i < wps.length; ++i) {
                        Object wp = wps[i];
                        if (wp.getId() != 409L && wp.getId() != 410L && wp.getId() != 408L) continue;
                        Object tmp = wps[alreadyAdded];
                        wps[alreadyAdded] = wp;
                        wps[i] = tmp;
                        ++alreadyAdded;
                    }
                }
                for (Object tmp : wps) {
                    WorkPackagePeriodDTO period = tmp.determineMostRecentPeriod();
                    if (this.wpDateFilterCB.getValue().booleanValue()) {
                        if (period != null && !DateHelper.isDayInWorkPackagePeriod((Date)this.day, (WorkPackagePeriodDTO)period) || tmp.getName() == null) continue;
                        this.workpackage.addItem(StoryForm.extractWorkpackageName((WorkPackageDTO)tmp), String.valueOf(tmp.getId()));
                        continue;
                    }
                    if (tmp.getName() == null) continue;
                    this.workpackage.addItem(StoryForm.extractWorkpackageName((WorkPackageDTO)tmp), String.valueOf(tmp.getId()));
                }
                for (int i = 0; i < this.workpackage.getItemCount(); ++i) {
                    String itemText = this.workpackage.getItemText(i);
                    if (!itemText.toUpperCase().startsWith("WP")) continue;
                    ((Element)this.workpackage.getElement().getElementsByTagName("option").getItem(i)).setAttribute("disabled", "disabled");
                }
            }
        }
    }

    private static String extractWorkpackageName(WorkPackageDTO workpackage) {
        String prefix = "";
        for (WorkPackageDTO tmp = workpackage.getWorkPackage(); tmp != null; tmp = tmp.getWorkPackage()) {
            prefix = prefix + "  ";
        }
        return prefix + workpackage.getName();
    }

    private WorkPackageDTO getSelectedWorkpackage() {
        String value = this.workpackage.getValue(this.workpackage.getSelectedIndex());
        return this.getWorkpackageById(Long.parseLong(value));
    }

    private WorkPackageDTO getWorkpackageById(long id) {
        for (WorkPackageDTO tmp : this.getSelectedProject().getWorkPackages()) {
            if (tmp.getId() != id) continue;
            return tmp;
        }
        return null;
    }

    private ProjectDTO getSelectedProject() {
        String value = this.project.getValue(this.project.getSelectedIndex());
        return this.getProjectById(Long.parseLong(value));
    }

    private ProjectDTO getProjectById(long id) {
        for (ProjectDTO tmp : this.projects) {
            if (tmp.getId() != id) continue;
            return tmp;
        }
        return null;
    }

    private void setProjectById(long id) {
        for (int i = 0; i < this.project.getItemCount(); ++i) {
            if (!this.project.getValue(i).equals("" + id)) continue;
            this.project.setSelectedIndex(i);
        }
    }

    private void setWPById(long id) {
        for (int i = 0; i < this.workpackage.getItemCount(); ++i) {
            if (!this.workpackage.getValue(i).equals("" + id)) continue;
            this.workpackage.setSelectedIndex(i);
        }
    }

    public void onKeyUp(KeyUpEvent event) {
        if (event.getNativeKeyCode() == 13) {
            this.save();
        }
    }

    static /* synthetic */ void access$000(StoryForm x0) {
        x0.validateDuration();
    }

    static /* synthetic */ double access$102(StoryForm x0, double x1) {
        x0.totalHours = x1;
        return x0.totalHours;
    }

    static /* synthetic */ void access$200(StoryForm x0, List x1) {
        x0.loadIssueTime(x1);
    }

    static /* synthetic */ double access$302(StoryForm x0, double x1) {
        x0.totalHoursWithOutCurrent = x1;
        return x0.totalHoursWithOutCurrent;
    }

    static /* synthetic */ double access$100(StoryForm x0) {
        return x0.totalHours;
    }

    static /* synthetic */ double access$402(StoryForm x0, double x1) {
        x0.totalIssueHours = x1;
        return x0.totalIssueHours;
    }

    static /* synthetic */ WorkCategoryDTO access$500() {
        return travelCatagory;
    }

    static /* synthetic */ WorkCategoryDTO access$502(WorkCategoryDTO x0) {
        travelCatagory = x0;
        return travelCatagory;
    }

    static /* synthetic */ void access$600(StoryForm x0) {
        x0.save();
    }

    static /* synthetic */ TaskNotice access$700(StoryForm x0) {
        return x0.tn;
    }

    static /* synthetic */ DialogBox access$800(StoryForm x0) {
        return x0.form;
    }

    static /* synthetic */ TaskStory access$900(StoryForm x0) {
        return x0.caller;
    }

    static /* synthetic */ Date access$1000(StoryForm x0) {
        return x0.day;
    }

    static /* synthetic */ String access$1100(StoryForm x0) {
        return x0.currentProject;
    }

    static /* synthetic */ List access$1202(StoryForm x0, List x1) {
        x0.projects = x1;
        return x0.projects;
    }

    static /* synthetic */ void access$1300(StoryForm x0) {
        x0.initWorkpackage();
    }
}

