/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.common.ui;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.cismet.projecttracker.client.ProjectTrackerEntryPoint;
import de.cismet.projecttracker.client.common.ui.TaskNotice;
import de.cismet.projecttracker.client.common.ui.listener.TaskDeleteListener;
import de.cismet.projecttracker.client.common.ui.listener.TaskNoticeListener;
import de.cismet.projecttracker.client.dto.ActivityDTO;
import de.cismet.projecttracker.client.dto.StaffDTO;
import de.cismet.projecttracker.client.dto.WorkPackageDTO;
import de.cismet.projecttracker.client.helper.DateHelper;
import java.util.ArrayList;
import java.util.List;

public class TaskNotice
extends Composite
implements ClickHandler {
    private static final String MAIN_STYLES = "alert alert-block timebox";
    private static final String PROJECT_STYLES_PREFIX = "proj";
    protected HTML lab;
    protected Label hoursLeft = new Label();
    protected ActivityDTO activity;
    private final FlowPanel mainPanel = new FlowPanel();
    private final Label close = new Label("x");
    private final List<TaskDeleteListener> listener = new ArrayList();
    private final List<TaskNoticeListener> taskListener = new ArrayList();
    private boolean deleteButtonDisabled;
    private boolean status;
    private boolean redBorder;

    public TaskNotice(ActivityDTO activity) {
        this(activity, false);
    }

    public TaskNotice(ActivityDTO activity, boolean deleteButtonDisabled) {
        this(activity, deleteButtonDisabled, false);
    }

    public TaskNotice(ActivityDTO activity, boolean deleteButtonDisabled, boolean status) {
        this.deleteButtonDisabled = deleteButtonDisabled;
        this.status = status;
        this.activity = activity;
        this.init();
        this.initWidget((Widget)this.mainPanel);
    }

    private void init() {
        this.lab = new HTML();
        this.hoursLeft.setStyleName("statusCircle pull-right");
        if (!this.deleteButtonDisabled) {
            this.close.setStyleName("close pull-right closeButton");
            this.close.addClickHandler((ClickHandler)this);
            this.mainPanel.add((Widget)this.close);
            this.redBorder = true;
        } else {
            this.redBorder = false;
        }
        this.mainPanel.add((Widget)this.lab);
        this.mainPanel.add((Widget)this.hoursLeft);
        this.refresh();
    }

    private void setStatus() {
        if (!this.deleteButtonDisabled && !this.status) {
            1 cb = new /* Unavailable Anonymous Inner Class!! */;
            ArrayList<WorkPackageDTO> wpList = new ArrayList<WorkPackageDTO>();
            wpList.add(this.activity.getWorkPackage());
            ProjectTrackerEntryPoint.getProjectService((boolean)false).getHoursSumForActivites(wpList, null, null, null, null, (AsyncCallback)cb);
        }
    }

    private void setColour() {
        if (this.activity.getWorkPackage() != null && this.activity.getWorkPackage().getProject() != null) {
            List proj = ProjectTrackerEntryPoint.getInstance().getProjects();
            if (proj != null) {
                long projectId = this.activity.getWorkPackage().getProject().getId();
                String a = this.mainPanel.getStyleName();
                if (this.activity.getWorkinghours() == 0.0 && this.redBorder) {
                    this.mainPanel.setStyleName("alert alert-block timebox red-border proj" + projectId);
                } else {
                    this.mainPanel.setStyleName("alert alert-block timebox proj" + projectId);
                }
            } else {
                2 t = new /* Unavailable Anonymous Inner Class!! */;
                t.schedule(2000);
            }
        }
    }

    protected String getTextFromActivity() {
        String desc = this.getDesccription(this.activity.getDescription());
        StringBuilder text = new StringBuilder();
        if (this.activity.getWorkCategory() != null && this.activity.getWorkCategory().getId() == 4L) {
            text.append("Travel: ").append(this.activity.getWorkPackage().getAbbreviation());
        } else {
            text.append(this.activity.getWorkPackage().getAbbreviation());
        }
        String modifiedDesc = desc;
        RegExp regExp = RegExp.compile((String)"#(\\d+)", (String)"g");
        MatchResult matcher = regExp.exec(desc);
        int lastIndex = 0;
        while (matcher != null) {
            for (int i = 0; i < matcher.getGroupCount(); ++i) {
                String url;
                String groupStr = matcher.getGroup(i);
                if (groupStr.startsWith("#") && (url = ProjectTrackerEntryPoint.getInstance().getProjectUrlByWP(this.activity.getWorkPackage())) != null) {
                    modifiedDesc = modifiedDesc.replace(groupStr, "<u><a href=\"" + url + groupStr.substring(1) + "\" target=\"_blank\">" + groupStr + "</a></u>");
                }
                if (desc.lastIndexOf(groupStr) + groupStr.length() <= lastIndex) continue;
                lastIndex = desc.lastIndexOf(groupStr) + groupStr.length();
            }
            regExp.setLastIndex(lastIndex);
            matcher = regExp.exec(desc);
        }
        double hours = (double)Math.round(this.activity.getWorkinghours() * 100.0) / 100.0;
        text.append("<br />").append(modifiedDesc);
        if (hours != 0.0 && hours != -1.0 && !this.deleteButtonDisabled) {
            text.append("<br />").append(DateHelper.doubleToHours((double)hours)).append(" hours");
        }
        return text.toString();
    }

    protected String getDesccription(String desc) {
        if (desc == null) {
            return "";
        }
        int i = desc.indexOf("(@");
        if (i != -1) {
            String result = desc.substring(0, i);
            return result;
        }
        return desc;
    }

    protected String getTooltipTextFromActivity() {
        StringBuilder text = new StringBuilder(this.activity.getWorkPackage().getProject().getName());
        text.append("\n").append(this.activity.getWorkPackage().getName());
        if (this.activity.getDescription() != null) {
            text.append("\n").append(this.activity.getDescription());
        }
        return text.toString();
    }

    public Widget getMouseHandledWidget() {
        return this.lab;
    }

    public ActivityDTO getActivity() {
        return this.activity;
    }

    public void setActivity(ActivityDTO activity) {
        this.activity = activity;
        this.refresh();
        this.fireActivityModified();
    }

    public void refresh() {
        this.lab.setHTML(this.getTextFromActivity());
        this.mainPanel.setTitle(this.getTooltipTextFromActivity());
        this.lab.setTitle(this.getTooltipTextFromActivity());
        this.setColour();
        this.setStatus();
    }

    public void save() {
        3 callback = new /* Unavailable Anonymous Inner Class!! */;
        ProjectTrackerEntryPoint.getProjectService((boolean)true).saveActivity(this.activity, (AsyncCallback)callback);
    }

    public void onClick(ClickEvent event) {
        if (event.getSource() == this.close) {
            StaffDTO staff = ProjectTrackerEntryPoint.getInstance().getStaff();
            4 callback = new /* Unavailable Anonymous Inner Class!! */;
            ProjectTrackerEntryPoint.getProjectService((boolean)true).isDayLocked(this.activity.getDay(), this.activity.getStaff(), (AsyncCallback)callback);
        }
    }

    private void deleteTask() {
        5 callback = new /* Unavailable Anonymous Inner Class!! */;
        ProjectTrackerEntryPoint.getProjectService((boolean)true).deleteActivity(this.activity, (AsyncCallback)callback);
    }

    public void addListener(TaskDeleteListener l) {
        this.listener.add(l);
    }

    public void removeListener(TaskDeleteListener l) {
        this.listener.remove(l);
    }

    private void fireActivityDelete() {
        for (TaskDeleteListener l : this.listener) {
            l.taskDelete((Object)this);
        }
    }

    public void addTaskNoticeListener(TaskNoticeListener l) {
        this.taskListener.add(l);
    }

    public void removeTaskNoticeListener(TaskNoticeListener l) {
        this.taskListener.remove(l);
    }

    private void fireActivityModified() {
        for (TaskNoticeListener l : this.taskListener) {
            l.taskChanged((Object)this);
        }
    }

    public void setDeleteButtonEnabled(boolean aFlag) {
        this.deleteButtonDisabled = aFlag;
        this.refresh();
    }

    public void setRedBorderEnabled(boolean aFlag) {
        this.redBorder = aFlag;
        this.refresh();
    }

    public boolean equals(Object obj) {
        return obj instanceof TaskNotice && ((TaskNotice)obj).getActivity().getId() == this.getActivity().getId();
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.activity != null ? (int)this.activity.getId() : 0);
        return hash;
    }

    public void setCloseButtonVisible(boolean aFlag) {
        this.close.setVisible(aFlag);
    }

    static /* synthetic */ void access$000(TaskNotice x0) {
        x0.setColour();
    }

    static /* synthetic */ void access$100(TaskNotice x0) {
        x0.deleteTask();
    }

    static /* synthetic */ void access$200(TaskNotice x0) {
        x0.fireActivityDelete();
    }
}

