/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.common.ui;

import com.allen_sauer.gwt.dnd.client.PickupDragController;
import com.allen_sauer.gwt.dnd.client.drop.DropController;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.DoubleClickHandler;
import com.google.gwt.event.dom.client.HasDoubleClickHandlers;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import de.cismet.projecttracker.client.ProjectTrackerEntryPoint;
import de.cismet.projecttracker.client.common.ui.FlowPanelWithSpacer;
import de.cismet.projecttracker.client.common.ui.HolidayTaskNotice;
import de.cismet.projecttracker.client.common.ui.LockPanel;
import de.cismet.projecttracker.client.common.ui.RestorePickupDragController;
import de.cismet.projecttracker.client.common.ui.Story;
import de.cismet.projecttracker.client.common.ui.StoryForm;
import de.cismet.projecttracker.client.common.ui.TaskNotice;
import de.cismet.projecttracker.client.common.ui.TaskStory;
import de.cismet.projecttracker.client.common.ui.TaskStoryController;
import de.cismet.projecttracker.client.common.ui.event.TaskStoryEvent;
import de.cismet.projecttracker.client.common.ui.listener.TaskDeleteListener;
import de.cismet.projecttracker.client.common.ui.listener.TaskNoticeListener;
import de.cismet.projecttracker.client.common.ui.listener.TaskStoryListener;
import de.cismet.projecttracker.client.dto.ActivityDTO;
import de.cismet.projecttracker.client.helper.DateHelper;
import de.cismet.projecttracker.client.types.HolidayType;
import de.cismet.projecttracker.client.utilities.IllnessChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class TaskStory
extends Composite
implements TaskDeleteListener,
DoubleClickHandler,
TaskNoticeListener {
    private static final TaskStoryUiBinder uiBinder = (TaskStoryUiBinder)GWT.create(TaskStoryUiBinder.class);
    @UiField
    FlowPanelWithSpacer monday;
    @UiField
    FlowPanelWithSpacer tuesday;
    @UiField
    FlowPanelWithSpacer wednesday;
    @UiField
    FlowPanelWithSpacer thursday;
    @UiField
    FlowPanelWithSpacer friday;
    @UiField
    FlowPanelWithSpacer saturday;
    @UiField
    FlowPanelWithSpacer sunday;
    @UiField
    AbsolutePanel boundaryPanel;
    private final FlowPanelWithSpacer[] daysOfWeek = new FlowPanelWithSpacer[7];
    private final HashMap<FlowPanelWithSpacer, List<TaskNotice>> taskMap = new HashMap();
    private final HashMap<FlowPanelWithSpacer, PickupDragController> dragMap = new HashMap();
    private final HashMap<FlowPanelWithSpacer, TaskStoryController> taskStoryControllerMap = new HashMap();
    private Date firstDayOfWeek = new Date();
    private final PickupDragController mondayDragController;
    private final PickupDragController tuesdayDragController;
    private final PickupDragController wednesdayDragController;
    private final PickupDragController thursdayDragController;
    private final PickupDragController fridayDragController;
    private final PickupDragController saturdayDragController;
    private final PickupDragController sundayDragController;
    private LockPanel lockPanel;
    private final List<TaskStoryListener> listener = new ArrayList();
    private final Story story;

    public TaskStory(Story s) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.story = s;
        this.boundaryPanel.addStyleName("verticalScroller");
        this.daysOfWeek[0] = this.sunday;
        this.daysOfWeek[1] = this.monday;
        this.daysOfWeek[2] = this.tuesday;
        this.daysOfWeek[3] = this.wednesday;
        this.daysOfWeek[4] = this.thursday;
        this.daysOfWeek[5] = this.friday;
        this.daysOfWeek[6] = this.saturday;
        for (FlowPanelWithSpacer columnPanel : this.daysOfWeek) {
            this.taskMap.put(columnPanel, new ArrayList());
        }
        this.addTaskStoryListener((TaskStoryListener)new IllnessChecker(this));
        this.mondayDragController = new RestorePickupDragController((AbsolutePanel)RootPanel.get(), false);
        this.tuesdayDragController = new RestorePickupDragController((AbsolutePanel)RootPanel.get(), false);
        this.wednesdayDragController = new RestorePickupDragController((AbsolutePanel)RootPanel.get(), false);
        this.thursdayDragController = new RestorePickupDragController((AbsolutePanel)RootPanel.get(), false);
        this.fridayDragController = new RestorePickupDragController((AbsolutePanel)RootPanel.get(), false);
        this.saturdayDragController = new RestorePickupDragController((AbsolutePanel)RootPanel.get(), false);
        this.sundayDragController = new RestorePickupDragController((AbsolutePanel)RootPanel.get(), false);
        this.initDragController(this.mondayDragController, this.monday);
        this.initDragController(this.tuesdayDragController, this.tuesday);
        this.initDragController(this.wednesdayDragController, this.wednesday);
        this.initDragController(this.thursdayDragController, this.thursday);
        this.initDragController(this.fridayDragController, this.friday);
        this.initDragController(this.saturdayDragController, this.saturday);
        this.initDragController(this.sundayDragController, this.sunday);
    }

    public void taskDelete(Object source) {
        if (source instanceof TaskNotice) {
            TaskNotice task = (TaskNotice)source;
            for (FlowPanelWithSpacer tmpPanel : this.taskMap.keySet()) {
                List tmpList = (List)this.taskMap.get(tmpPanel);
                if (!tmpList.contains(task)) continue;
                tmpList.remove(task);
                tmpPanel.remove((Widget)task);
                break;
            }
            TaskStoryEvent e = new TaskStoryEvent((Object)this, task, task.getActivity().getDay());
            this.fireTaskNoticeDeleted(e);
        }
    }

    public void registerTaskStoryController(TaskStoryController controller, Date day) {
        this.daysOfWeek[day.getDay()].addDoubleClickHandler((DoubleClickHandler)controller);
        this.taskStoryControllerMap.put(this.daysOfWeek[day.getDay()], controller);
    }

    public void initDragController(PickupDragController controller, FlowPanelWithSpacer except) {
        controller.setBehaviorMultipleSelection(false);
        this.dragMap.put(except, controller);
        for (FlowPanelWithSpacer columnPanel : this.daysOfWeek) {
            if (columnPanel == except) continue;
            1 widgetDropController = new /* Unavailable Anonymous Inner Class!! */;
            controller.registerDropController((DropController)widgetDropController);
        }
    }

    public Collection<PickupDragController> getDragControllers() {
        return this.dragMap.values();
    }

    public AbsolutePanel getBoundaryPanel() {
        return this.boundaryPanel;
    }

    public void addTask(ActivityDTO activity, FlowPanelWithSpacer columnPanel) {
        Object widget = null;
        widget = activity.getKindofactivity() == 0 ? new TaskNotice(activity) : new HolidayTaskNotice(activity);
        widget.addListener((TaskDeleteListener)this);
        widget.addTaskNoticeListener((TaskNoticeListener)this);
        columnPanel.add((Widget)widget);
        ((HasDoubleClickHandlers)widget.getMouseHandledWidget()).addDoubleClickHandler((DoubleClickHandler)this);
        ((PickupDragController)this.dragMap.get(columnPanel)).makeDraggable((Widget)widget, widget.getMouseHandledWidget());
        ((List)this.taskMap.get(columnPanel)).add(widget);
        TaskStoryEvent e = new TaskStoryEvent((Object)this, widget, widget.getActivity().getDay());
        this.fireTaskNoticeCreated(e);
    }

    public void setActivities(Date fistDayOfWeek, List<ActivityDTO> activities, List<HolidayType> holidays) {
        this.firstDayOfWeek = fistDayOfWeek;
        this.removeAllTasks();
        Collections.sort(activities);
        for (ActivityDTO activityDTO : activities) {
            if (activityDTO.getKindofactivity() == 0) {
                this.addTask(activityDTO);
                continue;
            }
            if (activityDTO.getKindofactivity() != 3) continue;
            this.lockPanel.setLocked(activityDTO.getDay(), Boolean.valueOf(true));
        }
        for (HolidayType holidayType : holidays) {
            int type = holidayType.isHalfHoliday() ? -2 : -1;
            this.addTask(new ActivityDTO(0L, null, null, null, holidayType.getHours(), holidayType.getName(), holidayType.getDate(), true, type));
        }
    }

    public void setLockPanel(LockPanel p) {
        this.lockPanel = p;
    }

    private void removeAllTasks() {
        Date d = new Date(this.firstDayOfWeek.getTime());
        for (FlowPanelWithSpacer tmp : this.daysOfWeek) {
            this.lockPanel.setLocked(d, Boolean.valueOf(false));
            DateHelper.addDays((Date)d, (int)1);
            List list = (List)this.taskMap.get(tmp);
            for (TaskNotice widget : list) {
                PickupDragController c = (PickupDragController)this.dragMap.get(tmp);
                tmp.remove((Widget)widget);
            }
            list.clear();
        }
    }

    public void addTask(ActivityDTO activity) {
        this.addTask(activity, this.daysOfWeek[activity.getDay().getDay()]);
    }

    public List<TaskNotice> getTasksForDay(int day) {
        return (List)this.taskMap.get(this.daysOfWeek[day]);
    }

    public void modifyTask(TaskNotice notice) {
        DialogBox taskForm = new DialogBox();
        StoryForm form = new StoryForm(taskForm, this, this.story, notice);
        taskForm.setWidget((Widget)form);
        taskForm.center();
    }

    public void onDoubleClick(DoubleClickEvent event) {
        TaskNotice notice = (TaskNotice)((Widget)event.getSource()).getParent().getParent();
        2 callback = new /* Unavailable Anonymous Inner Class!! */;
        ProjectTrackerEntryPoint.getProjectService((boolean)true).isDayLocked(notice.getActivity().getDay(), notice.getActivity().getStaff(), (AsyncCallback)callback);
    }

    public void setHeight(String height) {
        super.setHeight(height);
        this.boundaryPanel.setHeight(height);
    }

    public void addTaskStoryListener(TaskStoryListener l) {
        this.listener.add(l);
    }

    public void removeTaskStoryListener(TaskStoryListener l) {
        this.listener.remove(l);
    }

    private void fireTaskNoticeChange(TaskStoryEvent e) {
        for (TaskStoryListener l : this.listener) {
            l.taskNoticeChanged(e);
        }
    }

    private void fireTaskNoticeCreated(TaskStoryEvent e) {
        for (TaskStoryListener l : this.listener) {
            l.taskNoticeCreated(e);
        }
    }

    private void fireTaskNoticeDeleted(TaskStoryEvent e) {
        for (TaskStoryListener l : this.listener) {
            l.taskNoticeDeleted(e);
        }
    }

    public void taskChanged(Object source) {
        TaskStoryEvent e = new TaskStoryEvent((Object)this, (TaskNotice)source, ((TaskNotice)source).getActivity().getDay());
        this.fireTaskNoticeChange(e);
    }

    static /* synthetic */ HashMap access$000(TaskStory x0) {
        return x0.taskMap;
    }

    static /* synthetic */ Date access$100(TaskStory x0) {
        return x0.firstDayOfWeek;
    }
}

