/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.common.ui;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.DoubleClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import de.cismet.projecttracker.client.ImageConstants;
import de.cismet.projecttracker.client.ProjectTrackerEntryPoint;
import de.cismet.projecttracker.client.common.ui.Story;
import de.cismet.projecttracker.client.common.ui.TaskStory;
import de.cismet.projecttracker.client.common.ui.TaskStoryController;
import de.cismet.projecttracker.client.dto.StaffDTO;
import de.cismet.projecttracker.client.utilities.TaskFiller;
import java.util.Date;

public class TaskStoryController
extends Composite
implements ClickHandler,
DoubleClickHandler {
    private final FlowPanel mainPanel = new FlowPanel();
    private final Button add = new Button("<img src='" + ImageConstants.INSTANCE.plus().getURL() + "' />", (ClickHandler)this);
    private final Button fill = new Button("<img src='" + ImageConstants.INSTANCE.magicFiller().getURL() + "' />", (ClickHandler)this);
    private Date day;
    private TaskStory taskStory;
    private Story story;
    private boolean isRegistered = false;

    public TaskStoryController() {
        this.add.setStyleName("btn inlineComponent");
        this.fill.setStyleName("btn inlineComponent");
        this.mainPanel.add((Widget)this.add);
        this.mainPanel.add((Widget)this.fill);
        this.initWidget((Widget)this.mainPanel);
        this.add.setTitle("add task");
        this.fill.setTitle("fill");
    }

    public void setDay(Date day) {
        this.day = day;
    }

    public void setTaskStory(TaskStory taskStory) {
        this.taskStory = taskStory;
        if (!this.isRegistered) {
            taskStory.registerTaskStoryController(this, this.day);
            this.isRegistered = true;
        }
    }

    public void setStory(Story story) {
        this.story = story;
    }

    public void onClick(ClickEvent event) {
        if (event.getSource() == this.add) {
            this.addTask();
        } else if (event.getSource() == this.fill) {
            if (event.isControlKeyDown()) {
                TaskFiller.fillTasksToTime((Date)new Date(), (Date)this.day, (TaskStory)this.taskStory, (Story)this.story);
            } else {
                TaskFiller.fillTasks((Date)this.day, (TaskStory)this.taskStory, (Story)this.story);
            }
        }
    }

    private void addTask() {
        StaffDTO staff = ProjectTrackerEntryPoint.getInstance().getStaff();
        1 callback = new /* Unavailable Anonymous Inner Class!! */;
        ProjectTrackerEntryPoint.getProjectService((boolean)true).isDayLocked(this.day, staff, (AsyncCallback)callback);
    }

    public void onDoubleClick(DoubleClickEvent event) {
        this.addTask();
    }

    static /* synthetic */ Date access$000(TaskStoryController x0) {
        return x0.day;
    }

    static /* synthetic */ TaskStory access$100(TaskStoryController x0) {
        return x0.taskStory;
    }

    static /* synthetic */ Story access$200(TaskStoryController x0) {
        return x0.story;
    }
}

