/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.common.ui;

import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.cismet.projecttracker.client.ProjectTrackerEntryPoint;
import de.cismet.projecttracker.client.common.ui.TimeNotice;
import de.cismet.projecttracker.client.common.ui.listener.TaskDeleteListener;
import de.cismet.projecttracker.client.common.ui.listener.TimeNoticeListener;
import de.cismet.projecttracker.client.dto.ActivityDTO;
import de.cismet.projecttracker.client.helper.DateHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TimeNotice
extends Composite
implements ChangeHandler,
ClickHandler {
    private final FlowPanel mainPanel = new FlowPanel();
    private final ActivityDTO start;
    private ActivityDTO end;
    private final ControlGroup startCtrlGroup = new ControlGroup();
    private final ControlGroup endCtrlGroup = new ControlGroup();
    private final TextBox startTime = new TextBox();
    private final TextBox endTime = new TextBox();
    private final Label close = new Label("x");
    private final List<TaskDeleteListener> listener = new ArrayList();
    private final List<TimeNoticeListener> timeListener = new ArrayList();

    public TimeNotice(ActivityDTO start, ActivityDTO end) {
        this.start = start;
        this.end = end;
        this.init();
        this.initWidget((Widget)this.mainPanel);
        this.mainPanel.setStyleName("time-notice");
    }

    private void init() {
        this.startTime.setMaxLength(5);
        this.endTime.setMaxLength(5);
        this.startTime.setStyleName("inlineComponent time-input");
        this.endTime.setStyleName("inlineComponent time-input");
        1 timeValidator = new /* Unavailable Anonymous Inner Class!! */;
        this.startTime.addKeyUpHandler((KeyUpHandler)timeValidator);
        this.endTime.addKeyUpHandler((KeyUpHandler)timeValidator);
        this.startCtrlGroup.addStyleName("time-notice-control");
        this.endCtrlGroup.addStyleName("time-notice-control");
        this.startCtrlGroup.add((Widget)this.startTime);
        this.endCtrlGroup.add((Widget)this.endTime);
        this.close.setStyleName("close pull-right closeButton");
        this.close.addClickHandler((ClickHandler)this);
        this.mainPanel.add((Widget)this.close);
        this.mainPanel.add((Widget)this.startCtrlGroup);
        this.mainPanel.add((Widget)this.endCtrlGroup);
        this.startTime.setText(DateHelper.formatTime((Date)this.start.getDay()));
        if (this.end != null) {
            this.endTime.setText(DateHelper.formatTime((Date)this.end.getDay()));
        } else {
            this.endTime.setText("");
        }
        this.startTime.addChangeHandler((ChangeHandler)this);
        this.endTime.addChangeHandler((ChangeHandler)this);
    }

    public void onChange(ChangeEvent event) {
        Object eventSource = event.getSource();
        2 callback = new /* Unavailable Anonymous Inner Class!! */;
        ProjectTrackerEntryPoint.getProjectService((boolean)true).isDayLocked(this.start.getDay(), this.start.getStaff(), (AsyncCallback)callback);
    }

    /*
     * Unable to fully structure code
     */
    private void changeTimeNotice(Object eventSource) {
        activityToSave = null;
        newDate = null;
        endAtNextDay = false;
        createNewActivity = false;
        if (eventSource == this.startTime) {
            activityToSave = this.start;
            if (!this.isTimeInputValid(this.startTime.getText())) {
                if (this.start != null) {
                    this.startTime.setText(DateHelper.formatTime((Date)this.start.getDay()));
                } else {
                    this.startTime.setText("");
                }
                this.startCtrlGroup.setType(ControlGroupType.NONE);
                return;
            }
            newDate = this.parseTimeInput(this.startTime.getText());
            this.startTime.setText(newDate);
            if (!this.startTime.getText().equals("")) {
                try {
                    startDate = DateHelper.parseString((String)this.startTime.getText(), (DateTimeFormat)DateTimeFormat.getFormat((String)"HH:mm"));
                    if (startDate.getHours() >= 4) ** GOTO lbl59
                    endAtNextDay = true;
                }
                catch (IllegalArgumentException e) {
                    ((TextBox)eventSource).setText(DateHelper.formatTime((Date)activityToSave.getDay()));
                    return;
                }
            }
        } else if (eventSource == this.endTime) {
            activityToSave = this.end;
            if (!this.endTime.getText().isEmpty() && !this.isTimeInputValid(this.endTime.getText())) {
                if (this.end != null) {
                    this.endTime.setText(DateHelper.formatTime((Date)this.end.getDay()));
                } else {
                    this.endTime.setText("");
                }
                this.endCtrlGroup.setType(ControlGroupType.NONE);
                return;
            }
            newDate = this.parseTimeInput(this.endTime.getText());
            this.endTime.setText(newDate);
            if (!this.endTime.getText().equals("")) {
                try {
                    endDate = DateHelper.parseString((String)newDate, (DateTimeFormat)DateTimeFormat.getFormat((String)"HH:mm"));
                    startDate = DateHelper.parseString((String)this.startTime.getText(), (DateTimeFormat)DateTimeFormat.getFormat((String)"HH:mm"));
                    if (endDate.before(startDate)) {
                        if (endDate.getHours() > 3) {
                            ProjectTrackerEntryPoint.outputBox((String)"The end time must not be after 3:59 a.m. at the next day.");
                            ((TextBox)eventSource).setText(DateHelper.formatTime((Date)activityToSave.getDay()));
                            return;
                        }
                        endAtNextDay = true;
                    }
                    if (activityToSave != null) ** GOTO lbl59
                    this.end = new ActivityDTO();
                    this.end.setKindofactivity(2);
                    this.end.setStaff(ProjectTrackerEntryPoint.getInstance().getStaff());
                    this.end.setDay((Date)this.start.getDay().clone());
                    activityToSave = this.end;
                    createNewActivity = true;
                }
                catch (IllegalArgumentException e) {
                    ((TextBox)eventSource).setText(DateHelper.formatTime((Date)activityToSave.getDay()));
                    return;
                }
            } else {
                activityToSave = null;
            }
        }
lbl59:
        // 8 sources

        callback = null;
        createCallback = null;
        if (!createNewActivity) {
            if (activityToSave == null) {
                if (this.end != null) {
                    deleteCallback = new /* Unavailable Anonymous Inner Class!! */;
                    ProjectTrackerEntryPoint.getProjectService((boolean)true).deleteActivity(this.end, (AsyncCallback)deleteCallback);
                    return;
                }
            } else {
                callback = new /* Unavailable Anonymous Inner Class!! */;
            }
        } else {
            createCallback = new /* Unavailable Anonymous Inner Class!! */;
        }
        try {
            time = DateHelper.parseString((String)newDate, (DateTimeFormat)DateTimeFormat.getFormat((String)"HH:mm"));
            dayOfActivity = activityToSave.getDay();
            if (endAtNextDay) {
                if (DateHelper.isSameDay((Date)this.start.getDay(), (Date)dayOfActivity)) {
                    DateHelper.addDays((Date)dayOfActivity, (int)1);
                }
            } else if (!endAtNextDay) {
                if (eventSource == this.startTime && dayOfActivity.getHours() < 4 && time.getHours() >= 4) {
                    DateHelper.addDays((Date)dayOfActivity, (int)-1);
                }
                if (eventSource == this.endTime && !DateHelper.isSameDay((Date)this.start.getDay(), (Date)dayOfActivity)) {
                    DateHelper.addDays((Date)dayOfActivity, (int)-1);
                }
            }
            time = DateHelper.createDateObject((Date)dayOfActivity, (Date)time);
            activityToSave.setDay(time);
            if (!createNewActivity) {
                ProjectTrackerEntryPoint.getProjectService((boolean)true).saveActivity(activityToSave, (AsyncCallback)callback);
            } else {
                ProjectTrackerEntryPoint.getProjectService((boolean)true).createActivity(activityToSave, (AsyncCallback)createCallback);
            }
            this.fireTimeChanged();
        }
        catch (IllegalArgumentException e) {
            ((TextBox)eventSource).setText(DateHelper.formatTime((Date)activityToSave.getDay()));
        }
    }

    private String parseTimeInput(String s) {
        if (!s.matches("([01]?[0-9]|2[0-3]):[0-5][0-9]")) {
            if (s.matches("[01][0-9]|2[0-3]")) {
                s = s + ":00";
            } else if (s.matches("[0-9]|2[0-3]")) {
                s = "0" + s + ":00";
            }
        }
        return s;
    }

    private boolean isTimeInputValid(String s) {
        boolean isValid = s.matches("([01]?[0-9]|2[0-3]):[0-5][0-9]");
        if (!isValid) {
            isValid = s.matches("[01][0-9]|2[0-3]") || s.matches("[0-9]|2[0-3]");
        }
        return isValid;
    }

    public void onClick(ClickEvent event) {
        Object eventSource = event.getSource();
        6 callback = new /* Unavailable Anonymous Inner Class!! */;
        ProjectTrackerEntryPoint.getProjectService((boolean)true).isDayLocked(this.start.getDay(), this.start.getStaff(), (AsyncCallback)callback);
    }

    private void deleteTimeNotice(Object eventSource) {
        if (eventSource == this.close) {
            7 callback = new /* Unavailable Anonymous Inner Class!! */;
            8 endCallback = new /* Unavailable Anonymous Inner Class!! */;
            if (this.end != null) {
                ProjectTrackerEntryPoint.getProjectService((boolean)true).deleteActivity(this.end, (AsyncCallback)endCallback);
            } else {
                ProjectTrackerEntryPoint.getProjectService((boolean)true).deleteActivity(this.start, (AsyncCallback)callback);
            }
        }
    }

    public void addListener(TaskDeleteListener l) {
        this.listener.add(l);
    }

    public void removeListener(TaskDeleteListener l) {
        this.listener.remove(l);
    }

    public void addTimeNoticeListener(TimeNoticeListener l) {
        this.timeListener.add(l);
    }

    public void removeTimeNoticeListener(TimeNoticeListener l) {
        this.timeListener.remove(l);
    }

    public double getHours() {
        if (this.end != null) {
            return DateHelper.substract((Date)this.start.getDay(), (Date)this.end.getDay());
        }
        return 0.0;
    }

    private void fireActivityDelete() {
        for (TaskDeleteListener l : this.listener) {
            l.taskDelete((Object)this);
        }
    }

    private void fireTimeChanged() {
        for (TimeNoticeListener l : this.timeListener) {
            l.timeChanged((Object)this);
        }
    }

    public Date getStart() {
        return this.start.getDay();
    }

    public Date getEnd() {
        if (this.end == null) {
            return null;
        }
        return this.end.getDay();
    }

    public void setEnabled(boolean aFlag) {
        this.close.setVisible(aFlag);
        this.startTime.setEnabled(aFlag);
        this.endTime.setEnabled(aFlag);
    }

    static /* synthetic */ TextBox access$000(TimeNotice x0) {
        return x0.startTime;
    }

    static /* synthetic */ ControlGroup access$100(TimeNotice x0) {
        return x0.startCtrlGroup;
    }

    static /* synthetic */ TextBox access$200(TimeNotice x0) {
        return x0.endTime;
    }

    static /* synthetic */ ControlGroup access$300(TimeNotice x0) {
        return x0.endCtrlGroup;
    }

    static /* synthetic */ boolean access$400(TimeNotice x0, String x1) {
        return x0.isTimeInputValid(x1);
    }

    static /* synthetic */ void access$500(TimeNotice x0, Object x1) {
        x0.changeTimeNotice(x1);
    }

    static /* synthetic */ ActivityDTO access$602(TimeNotice x0, ActivityDTO x1) {
        x0.end = x1;
        return x0.end;
    }

    static /* synthetic */ void access$700(TimeNotice x0) {
        x0.fireTimeChanged();
    }

    static /* synthetic */ ActivityDTO access$600(TimeNotice x0) {
        return x0.end;
    }

    static /* synthetic */ ActivityDTO access$800(TimeNotice x0) {
        return x0.start;
    }

    static /* synthetic */ void access$900(TimeNotice x0, Object x1) {
        x0.deleteTimeNotice(x1);
    }

    static /* synthetic */ void access$1000(TimeNotice x0) {
        x0.fireActivityDelete();
    }
}

