/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.common.ui.profile;

import com.github.gwtbootstrap.client.ui.CheckBox;
import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.Legend;
import com.github.gwtbootstrap.client.ui.SubmitButton;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import de.cismet.projecttracker.client.ProjectTrackerEntryPoint;
import de.cismet.projecttracker.client.common.ui.profile.AccountSettingsForm;
import de.cismet.projecttracker.client.dto.ProfileDTO;
import de.cismet.projecttracker.client.dto.StaffDTO;

public class AccountSettingsForm
extends Composite
implements ClickHandler {
    private static final AccountSettingsFormUiBinder uiBinder = (AccountSettingsFormUiBinder)GWT.create(AccountSettingsFormUiBinder.class);
    @UiField
    CheckBox weekLockCB;
    @UiField
    CheckBox dayLockCB;
    @UiField
    SubmitButton submitBtn;
    @UiField
    Legend residualVacLegend;
    @UiField
    ControlGroup residualVacationGroup;
    @UiField
    TextBox residualVacation;
    private ProfileDTO profile;

    public AccountSettingsForm() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.init();
    }

    private void init() {
        ProfileDTO p = ProjectTrackerEntryPoint.getInstance().getStaff().getProfile();
        if (!ProjectTrackerEntryPoint.getInstance().isAdmin()) {
            this.residualVacLegend.addStyleName("noDisplay");
            this.residualVacationGroup.addStyleName("noDisplay");
        }
        this.profile = p != null ? p : new ProfileDTO(true, true, 0.0);
        if (this.profile.getWeekLockModeEnabled()) {
            this.weekLockCB.setValue(Boolean.valueOf(true));
        } else {
            this.weekLockCB.setValue(Boolean.valueOf(false));
        }
        if (this.profile.getDayLockModeEnabled()) {
            this.dayLockCB.setValue(Boolean.valueOf(true));
        } else {
            this.dayLockCB.setValue(Boolean.valueOf(false));
        }
        this.residualVacation.setText("" + this.profile.getResidualVacation());
    }

    @UiHandler(value={"submitBtn"})
    public void onClick(ClickEvent event) {
        if (!this.weekLockCB.getValue().booleanValue() && !this.dayLockCB.getValue().booleanValue()) {
            ProjectTrackerEntryPoint.outputBox((String)"You have to select at least one lock option");
            return;
        }
        StaffDTO staff = ProjectTrackerEntryPoint.getInstance().getStaff();
        this.profile.setWeekLockModeEnabled(this.weekLockCB.getValue().booleanValue());
        this.profile.setDayLockModeEnabled(this.dayLockCB.getValue().booleanValue());
        if (ProjectTrackerEntryPoint.getInstance().isAdmin()) {
            this.profile.setResidualVacation(Double.valueOf(this.residualVacation.getText()).doubleValue());
        }
        staff.setProfile(this.profile);
        1 callback = new /* Unavailable Anonymous Inner Class!! */;
        ProjectTrackerEntryPoint.getProjectService((boolean)true).saveStaff(staff, (AsyncCallback)callback);
    }
}

