/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.common.ui.report;

import com.github.gwtbootstrap.client.ui.CheckBox;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.storage.client.Storage;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import de.cismet.projecttracker.client.ProjectTrackerEntryPoint;
import de.cismet.projecttracker.client.common.ui.WeekDatePicker;
import de.cismet.projecttracker.client.common.ui.report.ReportFilterPanel;
import de.cismet.projecttracker.client.common.ui.report.ReportSearchParamListener;
import de.cismet.projecttracker.client.dto.ProjectDTO;
import de.cismet.projecttracker.client.dto.ProjectPeriodDTO;
import de.cismet.projecttracker.client.dto.StaffDTO;
import de.cismet.projecttracker.client.dto.WorkPackageDTO;
import de.cismet.projecttracker.client.dto.WorkPackagePeriodDTO;
import de.cismet.projecttracker.client.helper.DateHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReportFilterPanel
extends Composite
implements ChangeHandler,
ClickHandler,
ValueChangeHandler<Date>,
KeyUpHandler {
    private static ReportFilterPanelUiBinder uiBinder = (ReportFilterPanelUiBinder)GWT.create(ReportFilterPanelUiBinder.class);
    public static final String WORKPACKAGE_KEY = "WP";
    public static final String PROJECT_KEY = "PROJECT";
    public static final String DATE_CHECKBOX_KEY = "DATE_CHECK";
    public static final String OLD_PROJECTS_KEY = "OLD_PROJECTS_CHECK";
    public static final String STAFF_KEY = "STAFF";
    public static final String DATE_FROM_KEY = "FROM";
    public static final String DATE_TO_KEY = "TO";
    public static final String DESC_KEY = "DESCRIPTION";
    @UiField
    TextBox description;
    @UiField
    com.google.gwt.user.client.ui.ListBox project;
    @UiField(provided=true)
    ListBox workpackages = new ListBox(true);
    @UiField(provided=true)
    ListBox users = new ListBox(true);
    @UiField
    HorizontalPanel datepickerPanel;
    @UiField
    HTMLPanel statisticWrapper;
    StaffDTO loggedInUser;
    @UiField
    CheckBox dateFilterCB;
    @UiField
    CheckBox oldProjectFilterCB;
    private List<ProjectDTO> projects;
    private List<ReportSearchParamListener> listeners = new LinkedList();
    Timer t = new /* Unavailable Anonymous Inner Class!! */;
    private String wp = null;
    private String staff = null;
    private String from = null;
    private String to = null;
    private String desc = null;
    private String lastProject = null;
    private String dateCheck = null;
    private String oldProjectsCheck = null;
    private boolean userInitialised = false;
    private boolean projectsInitialised = false;
    private boolean localConfigLoaded = false;
    private final Storage storage = Storage.getLocalStorageIfSupported();
    private List<StaffDTO> userList = new ArrayList();
    private WeekDatePicker periodFrom = new WeekDatePicker();
    private Button periodFromButton = new Button("<i class='icon-calendar'></i>", (ClickHandler)this);
    private WeekDatePicker periodTo = new WeekDatePicker();
    private Button periodToButton = new Button("<i class='icon-calendar'></i>", (ClickHandler)this);
    private boolean isFromPickerVisible = false;
    private boolean isToPickerVisible = false;
    private long lastInvocation = -1L;

    public ReportFilterPanel() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.init();
        this.project.addChangeHandler((ChangeHandler)this);
        this.workpackages.addChangeHandler((ChangeHandler)this);
        this.workpackages.setItemSelected(0, true);
        int index = 0;
        for (int i = 0; i < this.project.getItemCount(); ++i) {
            if (!this.project.getValue(i).equals("-1")) continue;
            index = i;
            break;
        }
        this.project.setItemSelected(index, true);
        DomEvent.fireNativeEvent((NativeEvent)Document.get().createChangeEvent(), (HasHandlers)this.project);
    }

    public void onChange(ChangeEvent event) {
        if (event.getSource() == this.project) {
            this.initWorkpackage();
        }
        this.fireSearchParamsChanged();
    }

    public void onClick(ClickEvent event) {
        if (event.getSource() == this.periodFromButton) {
            if (this.isFromPickerVisible) {
                this.isFromPickerVisible = false;
                this.periodFrom.hide();
            } else {
                this.isFromPickerVisible = true;
                this.periodFrom.show();
            }
        } else if (event.getSource() == this.periodToButton) {
            if (this.isToPickerVisible) {
                this.isToPickerVisible = false;
                this.periodTo.hide();
            } else {
                this.isToPickerVisible = true;
                this.periodTo.show();
            }
        } else if (event.getSource() == this.dateFilterCB) {
            this.fireSearchParamsChanged();
        } else if (event.getSource() == this.oldProjectFilterCB) {
            this.initProjects();
        }
    }

    public void onValueChange(ValueChangeEvent<Date> event) {
        this.fireSearchParamsChanged();
    }

    public void onKeyUp(KeyUpEvent event) {
        double msBetweenInvocations;
        long time = System.currentTimeMillis();
        if (this.lastInvocation > 0L && (msBetweenInvocations = (double)(time - this.lastInvocation)) < 500.0) {
            this.t.cancel();
        }
        this.lastInvocation = time;
        this.t.schedule(800);
    }

    private void init() {
        if (this.storage != null) {
            this.wp = this.storage.getItem("searchWp");
            this.staff = this.storage.getItem("searchStaff");
            this.from = this.storage.getItem("searchFrom");
            this.to = this.storage.getItem("searchTo");
            this.desc = this.storage.getItem("searchDesc");
            this.lastProject = this.storage.getItem("searchProject");
            this.dateCheck = this.storage.getItem("searchDateCheck");
            this.oldProjectsCheck = this.storage.getItem("searchOldProjects");
        }
        this.loggedInUser = ProjectTrackerEntryPoint.getInstance().getLoggedInStaff();
        this.projects = ProjectTrackerEntryPoint.getInstance().getProjects();
        if (this.projects != null && this.projects.isEmpty()) {
            this.projects = null;
        }
        this.initProjects();
        this.project.addItem("* all Elements", "-1");
        this.initUsers();
        this.users.setStyleName("report-filter-user-list");
        this.users.addChangeHandler((ChangeHandler)this);
        this.dateFilterCB.addClickHandler((ClickHandler)this);
        this.oldProjectFilterCB.addClickHandler((ClickHandler)this);
        this.periodFrom.setFormat("dd.mm.yyyy");
        this.periodFrom.setAutoClose(true);
        this.periodFrom.setStyleName("report-datePicker");
        this.periodFrom.setWeekStart(1);
        Date startDate = new Date();
        DateHelper.addDays((Date)startDate, (int)-1);
        this.periodFrom.setValue(startDate);
        this.periodFrom.addValueChangeHandler((ValueChangeHandler)this);
        this.periodFromButton.setWidth("10px;");
        this.periodFromButton.addStyleName("btn");
        this.periodFromButton.addStyleName("report-datePicker-button");
        this.periodFromButton.setTitle("Click to select the first day of search period");
        this.periodTo.setFormat("dd.mm.yyyy");
        this.periodTo.setAutoClose(true);
        this.periodTo.setStyleName("report-datePicker");
        this.periodTo.setWeekStart(1);
        this.periodTo.addValueChangeHandler((ValueChangeHandler)this);
        this.periodToButton.setWidth("10px;");
        this.periodToButton.addStyleName("btn");
        this.periodToButton.addStyleName("report-datePicker-button");
        this.periodToButton.setTitle("Click to select the last day of search period");
        Label fromLbl = new Label("from:");
        fromLbl.addStyleName("report-lbl");
        Label toLbl = new Label("to:");
        toLbl.addStyleName("report-lbl");
        this.datepickerPanel.add((Widget)fromLbl);
        this.datepickerPanel.add((Widget)this.periodFrom);
        this.datepickerPanel.add((Widget)this.periodFromButton);
        this.datepickerPanel.add((Widget)toLbl);
        this.datepickerPanel.add((Widget)this.periodTo);
        this.datepickerPanel.add((Widget)this.periodToButton);
        this.description.setStyleName("report-filter-textfield");
        this.description.addKeyUpHandler((KeyUpHandler)this);
        this.loadConfigurationfromStorage();
    }

    private void loadConfigurationfromStorage() {
        if (this.storage != null && this.projectsInitialised && this.userInitialised && !this.localConfigLoaded) {
            boolean isSelected;
            String value;
            int i;
            this.localConfigLoaded = true;
            if (this.oldProjectsCheck != null && this.oldProjectsCheck.equalsIgnoreCase("true")) {
                this.oldProjectFilterCB.setValue(Boolean.valueOf(true));
                this.initProjects();
            }
            if (this.lastProject != null) {
                for (int i2 = 0; i2 < this.project.getItemCount(); ++i2) {
                    if (!this.project.getValue(i2).equals(this.lastProject)) continue;
                    this.project.setSelectedIndex(i2);
                    this.initWorkpackage();
                }
            }
            if (this.desc != null && !this.desc.isEmpty()) {
                this.description.setText(this.desc);
            }
            if (this.dateCheck != null && this.dateCheck.equalsIgnoreCase("true")) {
                if (!this.dateFilterCB.getValue().booleanValue()) {
                    this.dateFilterCB.setValue(Boolean.valueOf(true), true);
                    ProjectTrackerEntryPoint.toggle();
                }
                if (this.to != null) {
                    try {
                        Date toDate = DateHelper.parseString((String)this.to, null);
                        this.periodTo.setValue(toDate);
                    }
                    catch (IllegalArgumentException toDate) {
                        // empty catch block
                    }
                }
                if (this.from != null) {
                    try {
                        Date fromDate = DateHelper.parseString((String)this.from, null);
                        this.periodFrom.setValue(fromDate);
                    }
                    catch (IllegalArgumentException fromDate) {
                        // empty catch block
                    }
                }
            }
            if (this.wp != null) {
                Object[] wps = this.IdStringToArray(this.wp);
                Arrays.sort(wps);
                for (i = 0; i < this.workpackages.getItemCount(); ++i) {
                    value = this.workpackages.getValue(i);
                    isSelected = Arrays.binarySearch(wps, value) >= 0;
                    this.workpackages.setItemSelected(i, isSelected);
                }
            }
            if (this.staff != null) {
                Object[] staffArray = this.IdStringToArray(this.staff);
                Arrays.sort(staffArray);
                for (i = 0; i < this.users.getItemCount(); ++i) {
                    value = this.users.getValue(i);
                    isSelected = Arrays.binarySearch(staffArray, value) >= 0;
                    this.users.setItemSelected(i, isSelected);
                }
            }
        }
    }

    private String[] IdStringToArray(String idString) {
        String[] splitted;
        ArrayList<String> list = new ArrayList<String>();
        for (String token : splitted = idString.split(",")) {
            list.add(token);
        }
        return list.toArray(new String[list.size()]);
    }

    private void initProjects() {
        if (this.projects == null) {
            2 callback = new /* Unavailable Anonymous Inner Class!! */;
            ProjectTrackerEntryPoint.getProjectService((boolean)true).getAllProjectsFull((AsyncCallback)callback);
        } else {
            this.project.clear();
            for (ProjectDTO tmp : this.projects) {
                ProjectPeriodDTO period = tmp.determineMostRecentPeriod();
                if (period != null && !this.oldProjectFilterCB.getValue().booleanValue() && !DateHelper.isDayInProjectPeriod((Date)new Date(), (ProjectPeriodDTO)period)) continue;
                this.project.addItem(tmp.getName(), "" + tmp.getId());
            }
            this.initWorkpackage();
            this.projectsInitialised = true;
            this.loadConfigurationfromStorage();
        }
    }

    private void initWorkpackage() {
        ProjectDTO selectedProject = this.getSelectedProject();
        this.workpackages.clear();
        this.workpackages.addItem("* all WorkPackages", "-1");
        if (selectedProject != null) {
            if (selectedProject.getWorkPackages() != null) {
                Object[] wps = selectedProject.getWorkPackages().toArray(new WorkPackageDTO[selectedProject.getWorkPackages().size()]);
                Arrays.sort(wps);
                for (Object tmp : wps) {
                    WorkPackagePeriodDTO period = tmp.determineMostRecentPeriod();
                    if (tmp.getName() == null) continue;
                    if (period != null && period.getTodate() != null) {
                        if (!this.oldProjectFilterCB.getValue().booleanValue() && !DateHelper.isDateGreaterOrEqual((Date)period.getTodate(), (Date)new Date())) continue;
                        this.workpackages.addItem(ReportFilterPanel.extractWorkpackageName((WorkPackageDTO)tmp), String.valueOf(tmp.getId()));
                        this.setTotalHours((WorkPackageDTO)tmp);
                        continue;
                    }
                    this.workpackages.addItem(ReportFilterPanel.extractWorkpackageName((WorkPackageDTO)tmp), String.valueOf(tmp.getId()));
                    this.setTotalHours((WorkPackageDTO)tmp);
                }
                for (int i = 0; i < this.workpackages.getItemCount(); ++i) {
                    String itemText = this.workpackages.getItemText(i);
                    if (!itemText.toUpperCase().startsWith("WP")) continue;
                    ((Element)this.workpackages.getElement().getElementsByTagName("option").getItem(i)).setAttribute("disabled", "disabled");
                }
            }
        } else {
            for (ProjectDTO proj : ProjectTrackerEntryPoint.getInstance().getProjects()) {
                for (WorkPackageDTO wp : proj.getWorkPackages()) {
                    WorkPackagePeriodDTO period = wp.determineMostRecentPeriod();
                    if (wp.getName() == null) continue;
                    if (period != null && period.getTodate() != null) {
                        if (!this.oldProjectFilterCB.getValue().booleanValue() && !DateHelper.isDateGreaterOrEqual((Date)period.getTodate(), (Date)new Date())) continue;
                        this.workpackages.addItem(ReportFilterPanel.extractWorkpackageName((WorkPackageDTO)wp), String.valueOf(wp.getId()));
                        this.setTotalHours(wp);
                        continue;
                    }
                    this.workpackages.addItem(ReportFilterPanel.extractWorkpackageName((WorkPackageDTO)wp), String.valueOf(wp.getId()));
                    this.setTotalHours(wp);
                }
            }
            for (int i = 0; i < this.workpackages.getItemCount(); ++i) {
                String itemText = this.workpackages.getItemText(i);
                if (!itemText.toUpperCase().startsWith("WP") && !itemText.startsWith("--")) continue;
                ((Element)this.workpackages.getElement().getElementsByTagName("option").getItem(i)).setAttribute("disabled", "disabled");
            }
            this.workpackages.setSelectedIndex(0);
        }
    }

    private void setTotalHours(WorkPackageDTO wp) {
        3 cb = new /* Unavailable Anonymous Inner Class!! */;
        ArrayList<WorkPackageDTO> wpList = new ArrayList<WorkPackageDTO>();
        wpList.add(wp);
        ProjectTrackerEntryPoint.getProjectService((boolean)false).getHoursSumForActivites(wpList, null, null, null, null, (AsyncCallback)cb);
    }

    private void initUsers() {
        5 callback = new /* Unavailable Anonymous Inner Class!! */;
        ProjectTrackerEntryPoint.getProjectService((boolean)true).getCurrentEmployees((AsyncCallback)callback);
    }

    private ProjectDTO getSelectedProject() {
        String value = this.project.getValue(this.project.getSelectedIndex());
        if (value.equals("-1")) {
            return null;
        }
        return this.getProjectById(Long.parseLong(value));
    }

    private ProjectDTO getProjectById(long id) {
        for (ProjectDTO tmp : this.projects) {
            if (tmp.getId() != id) continue;
            return tmp;
        }
        return null;
    }

    private List<WorkPackageDTO> getSelectedWorkpackages() {
        ArrayList<WorkPackageDTO> selectedItems = null;
        for (int i = 0; i < this.workpackages.getItemCount(); ++i) {
            if (!this.workpackages.isItemSelected(i)) continue;
            String value = this.workpackages.getValue(i);
            if (value.equals("-1")) {
                return null;
            }
            long wpId = Long.parseLong(value);
            WorkPackageDTO wp = this.getWorkpackageById(wpId);
            if (selectedItems == null) {
                selectedItems = new ArrayList<WorkPackageDTO>();
            }
            selectedItems.add(wp);
        }
        return selectedItems;
    }

    private WorkPackageDTO getWorkpackageById(long id) {
        ProjectDTO proj = this.getSelectedProject();
        if (proj == null) {
            for (ProjectDTO p : ProjectTrackerEntryPoint.getInstance().getProjects()) {
                for (WorkPackageDTO tmp : p.getWorkPackages()) {
                    if (tmp.getId() != id) continue;
                    return tmp;
                }
            }
        } else {
            for (WorkPackageDTO tmp : proj.getWorkPackages()) {
                if (tmp.getId() != id) continue;
                return tmp;
            }
        }
        return null;
    }

    private static String extractWorkpackageName(WorkPackageDTO workpackage) {
        String prefix = "";
        for (WorkPackageDTO tmp = workpackage.getWorkPackage(); tmp != null; tmp = tmp.getWorkPackage()) {
            prefix = prefix + "  ";
        }
        return prefix + workpackage.getName();
    }

    public void addSearchParamListener(ReportSearchParamListener l) {
        this.listeners.add(l);
    }

    public void removeSearchParamListener(ReportSearchParamListener l) {
        this.listeners.remove(l);
    }

    public void setStatisticsPanel(Composite p) {
        this.statisticWrapper.clear();
        this.statisticWrapper.add((Widget)p);
    }

    private void fireSearchParamsChanged() {
        for (ReportSearchParamListener l : this.listeners) {
            l.searchParamsChanged();
        }
    }

    private StaffDTO getSelectedUser() {
        try {
            long value = Long.parseLong(this.users.getValue(this.users.getSelectedIndex()));
            if (value == -1L) {
                return null;
            }
            for (StaffDTO staff : this.userList) {
                if (staff.getId() != value) continue;
                return staff;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public HashMap<String, Object> getSearchParams() {
        ProjectDTO proj;
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList workpackages = this.getSelectedWorkpackages();
        if ((workpackages == null || workpackages.isEmpty()) && (proj = this.getSelectedProject()) != null) {
            if (workpackages == null) {
                workpackages = new ArrayList();
            }
            workpackages.addAll(proj.getWorkPackages());
        }
        map.put("WP", workpackages);
        map.put("PROJECT", this.getSelectedProject());
        map.put("OLD_PROJECTS_CHECK", this.oldProjectFilterCB.getValue());
        map.put("DATE_CHECK", this.dateFilterCB.getValue());
        ArrayList searchStaff = new ArrayList();
        ArrayList selectedUsers = this.getSelectedUsers();
        if (selectedUsers != null) {
            searchStaff.addAll(selectedUsers);
        }
        map.put("STAFF", searchStaff);
        if (this.dateFilterCB.getValue().booleanValue()) {
            map.put("FROM", this.periodFrom.getValue());
            map.put("TO", this.periodTo.getValue());
        }
        map.put("DESCRIPTION", this.description.getText());
        return map;
    }

    private ArrayList<StaffDTO> getSelectedUsers() {
        ArrayList<StaffDTO> selectedItems = new ArrayList<StaffDTO>();
        block0: for (int i = 0; i < this.users.getItemCount(); ++i) {
            if (!this.users.isItemSelected(i)) continue;
            long value = Long.parseLong(this.users.getValue(i));
            if (value == -1L) {
                return null;
            }
            for (StaffDTO staff : this.userList) {
                if (staff.getId() != value) continue;
                selectedItems.add(staff);
                continue block0;
            }
        }
        return selectedItems;
    }

    public void refresh() {
        if (ProjectTrackerEntryPoint.getInstance().getLoggedInStaff() != this.loggedInUser) {
            this.userList.clear();
            this.users.clear();
            this.users.setEnabled(true);
            this.initUsers();
        }
    }

    static /* synthetic */ void access$000(ReportFilterPanel x0) {
        x0.fireSearchParamsChanged();
    }

    static /* synthetic */ List access$102(ReportFilterPanel x0, List x1) {
        x0.projects = x1;
        return x0.projects;
    }

    static /* synthetic */ void access$200(ReportFilterPanel x0) {
        x0.initWorkpackage();
    }

    static /* synthetic */ boolean access$302(ReportFilterPanel x0, boolean x1) {
        x0.projectsInitialised = x1;
        return x0.projectsInitialised;
    }

    static /* synthetic */ void access$400(ReportFilterPanel x0) {
        x0.loadConfigurationfromStorage();
    }

    static /* synthetic */ String access$500(WorkPackageDTO x0) {
        return ReportFilterPanel.extractWorkpackageName((WorkPackageDTO)x0);
    }

    static /* synthetic */ List access$602(ReportFilterPanel x0, List x1) {
        x0.userList = x1;
        return x0.userList;
    }

    static /* synthetic */ boolean access$702(ReportFilterPanel x0, boolean x1) {
        x0.userInitialised = x1;
        return x0.userInitialised;
    }
}

