/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.common.ui.report;

import com.github.gwtbootstrap.client.ui.AccordionGroup;
import com.github.gwtbootstrap.client.ui.AlertBlock;
import com.github.gwtbootstrap.client.ui.NavLink;
import com.github.gwtbootstrap.client.ui.constants.AlertType;
import com.github.gwtbootstrap.client.ui.event.ShowHandler;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.storage.client.Storage;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import de.cismet.projecttracker.client.ProjectTrackerEntryPoint;
import de.cismet.projecttracker.client.common.ui.LoadingSpinner;
import de.cismet.projecttracker.client.common.ui.report.LargeReportResultAlert;
import de.cismet.projecttracker.client.common.ui.report.ReportFilterPanel;
import de.cismet.projecttracker.client.common.ui.report.ReportResultPanel;
import de.cismet.projecttracker.client.common.ui.report.ReportResultsSummaryDataGrid;
import de.cismet.projecttracker.client.common.ui.report.StaffSummaryEntry;
import de.cismet.projecttracker.client.common.ui.report.StatisticsPanel;
import de.cismet.projecttracker.client.dto.ActivityDTO;
import de.cismet.projecttracker.client.dto.BasicDTO;
import de.cismet.projecttracker.client.dto.ProjectDTO;
import de.cismet.projecttracker.client.dto.StaffDTO;
import de.cismet.projecttracker.client.dto.WorkPackageDTO;
import de.cismet.projecttracker.client.helper.DateHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ReportResultPanel
extends Composite {
    AccordionGroup activityAccordionPanel = new AccordionGroup();
    private LargeReportResultAlert sizeAlert = new LargeReportResultAlert(this);
    private FlowPanel mainPanel = new FlowPanel();
    final Timer showLongResultalertTimer = new /* Unavailable Anonymous Inner Class!! */;
    private FlowPanel activityList = new FlowPanel();
    private FlowPanel activityDetailPanel = new FlowPanel();
    private FlowPanel summaryPanel = new FlowPanel();
    private ReportFilterPanel filterPanel;
    private LoadingSpinner loadSpinner = new LoadingSpinner();
    private int users = 0;
    private double hoursInTotal = 0.0;
    private int activityCount = 0;
    private Date firstActivity = null;
    private Date lastActivity = null;
    private int detailActivityLoaded = 100;
    private ArrayList<ActivityDTO> lastSearchResult;
    private ProcessActivitiesIncrementalCommand processCommand;
    private boolean synchFlag = false;
    private boolean addFlag = true;
    private boolean timerStarted = false;
    private Timer synchTimer = new /* Unavailable Anonymous Inner Class!! */;

    public ReportResultPanel(ReportFilterPanel filterPanel) {
        this.initWidget((Widget)this.mainPanel);
        this.filterPanel = filterPanel;
        this.init();
    }

    private void init() {
        this.activityAccordionPanel.addShowHandler((ShowHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.loadSpinner.setStyleName("report-result-lbl");
        this.mainPanel.setStyleName("report-results-area verticalScroller");
        this.mainPanel.add((Widget)this.summaryPanel);
        this.activityAccordionPanel.setHeading("Show single activites");
        this.activityAccordionPanel.setDefaultOpen(false);
        this.activityAccordionPanel.add((Widget)this.activityDetailPanel);
        NavLink loadMoreLink = new NavLink("load next 100 activities");
        loadMoreLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.activityAccordionPanel.add((Widget)loadMoreLink);
    }

    private void showLoadSpinner() {
        this.mainPanel.clear();
        this.mainPanel.add((Widget)this.loadSpinner);
    }

    public void refresh() {
        if (this.synchFlag) {
            if (!this.timerStarted) {
                this.addFlag = false;
                this.synchTimer.schedule(100);
            }
        } else {
            this.synchFlag = true;
            this.hoursInTotal = 0.0;
            this.activityCount = 0;
            this.firstActivity = null;
            this.lastActivity = null;
            this.users = 0;
            this.activityList.clear();
            this.detailActivityLoaded = 100;
            this.lastSearchResult = null;
            this.showLoadSpinner();
            HashMap params = this.filterPanel.getSearchParams();
            List workpackages = (List)params.get("WP");
            ArrayList staff = (ArrayList)params.get("STAFF");
            Date from = null;
            Date to = null;
            if (params.containsKey("FROM")) {
                from = (Date)params.get("FROM");
            }
            if (params.containsKey("TO")) {
                to = (Date)params.get("TO");
            }
            ProjectDTO project = (ProjectDTO)params.get("PROJECT");
            Boolean dateCheck = (Boolean)params.get("DATE_CHECK");
            Boolean oldProjectsCheck = (Boolean)params.get("OLD_PROJECTS_CHECK");
            String descr = (String)params.get("DESCRIPTION");
            this.showLongResultalertTimer.schedule(5000);
            5 cb = new /* Unavailable Anonymous Inner Class!! */;
            Storage localStorage = Storage.getLocalStorageIfSupported();
            if (localStorage != null) {
                localStorage.setItem("searchWp", this.arrayToIdString(workpackages));
                localStorage.setItem("searchStaff", this.arrayToIdString((List)staff));
                localStorage.setItem("searchFrom", DateHelper.formatDate((Date)from));
                localStorage.setItem("searchTo", DateHelper.formatDate((Date)to));
                localStorage.setItem("searchDesc", descr);
                localStorage.setItem("searchProject", project != null ? String.valueOf(project.getId()) : null);
                localStorage.setItem("searchDateCheck", dateCheck != null ? String.valueOf(dateCheck) : null);
                localStorage.setItem("searchOldProjects", oldProjectsCheck != null ? String.valueOf(oldProjectsCheck) : null);
            }
            ProjectTrackerEntryPoint.getProjectService((boolean)true).getActivites(workpackages, (List)staff, from, to, descr, (AsyncCallback)cb);
        }
    }

    private String arrayToIdString(List<? extends BasicDTO> list) {
        String idString = null;
        if (list != null) {
            for (BasicDTO basicDTO : list) {
                idString = idString != null ? idString + "," : "";
                idString = idString + basicDTO.getId();
            }
        }
        return idString;
    }

    private void showAlert(boolean close, AlertType type, String text) {
        AlertBlock message;
        AlertBlock b = message = new AlertBlock(true);
        6 closeAlertTimer = new /* Unavailable Anonymous Inner Class!! */;
        b.setAnimation(true);
        this.mainPanel.clear();
        b.setClose(close);
        b.setType(type);
        b.setText(text);
        this.mainPanel.add((Widget)message);
        closeAlertTimer.schedule(3000);
        this.synchFlag = false;
        this.addFlag = true;
    }

    private void showSizeAlert() {
        this.sizeAlert = new LargeReportResultAlert(this);
        this.mainPanel.add((Widget)this.sizeAlert);
    }

    private void clearUI() {
        this.mainPanel.clear();
    }

    public void abort() {
        if (this.processCommand != null) {
            this.processCommand.cancel();
            Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void generateAndPropagateStatisticsPanel() {
        StatisticsPanel statPan = new StatisticsPanel(this.hoursInTotal, this.users, this.activityCount, this.firstActivity, this.lastActivity);
        this.filterPanel.setStatisticsPanel((Composite)statPan);
    }

    private void fillSummaryPanel(HashMap<StaffDTO, Double> stuffSummary, HashMap<StaffDTO, HashMap<WorkPackageDTO, Double>> staffWpList, HashMap<StaffDTO, HashMap<YearMonthKey, Double>> staffMonthList) {
        ReportResultsSummaryDataGrid table = new ReportResultsSummaryDataGrid();
        for (StaffDTO staff : staffWpList.keySet()) {
            Double whPerStaff = stuffSummary.get(staff);
            HashMap<WorkPackageDTO, Double> wpSum = staffWpList.get(staff);
            HashMap<YearMonthKey, Double> montSum = staffMonthList.get(staff);
            String iconUrl = "";
            if (staff.getEmail() != null) {
                StringBuilder stringBuilder = new StringBuilder().append(ProjectTrackerEntryPoint.GRAVATAR_URL_PREFIX);
                ProjectTrackerEntryPoint.getInstance();
                iconUrl = stringBuilder.append(ProjectTrackerEntryPoint.md5((String)staff.getEmail())).append("?s=32").toString();
            }
            StaffSummaryEntry staffOverview = new StaffSummaryEntry(iconUrl, staff.getFirstname() + staff.getName(), "", whPerStaff.doubleValue());
            HashSet<StaffSummaryEntry> wpOverview = new HashSet<StaffSummaryEntry>();
            HashSet<StaffSummaryEntry> monthOverview = new HashSet<StaffSummaryEntry>();
            for (WorkPackageDTO wp : wpSum.keySet()) {
                double sumWH = wpSum.get(wp);
                wpOverview.add(new StaffSummaryEntry(null, "", wp.getName(), sumWH));
            }
            ArrayList<YearMonthKey> list = new ArrayList<YearMonthKey>();
            list.addAll(montSum.keySet());
            Collections.sort(list);
            for (YearMonthKey key : list) {
                double sumMonth = montSum.get(key);
                monthOverview.add(new StaffSummaryEntry("", "", key.getYear() + " - " + DateHelper.NAME_OF_MONTH[key.getMonth()], sumMonth));
            }
            table.addStaffEntry(staffOverview, wpOverview, monthOverview);
        }
        this.summaryPanel.clear();
        this.summaryPanel.add((Widget)table);
    }

    static /* synthetic */ void access$000(ReportResultPanel x0) {
        x0.showSizeAlert();
    }

    static /* synthetic */ boolean access$100(ReportResultPanel x0) {
        return x0.synchFlag;
    }

    static /* synthetic */ boolean access$202(ReportResultPanel x0, boolean x1) {
        x0.timerStarted = x1;
        return x0.timerStarted;
    }

    static /* synthetic */ boolean access$302(ReportResultPanel x0, boolean x1) {
        x0.addFlag = x1;
        return x0.addFlag;
    }

    static /* synthetic */ FlowPanel access$400(ReportResultPanel x0) {
        return x0.activityList;
    }

    static /* synthetic */ FlowPanel access$500(ReportResultPanel x0) {
        return x0.activityDetailPanel;
    }

    static /* synthetic */ int access$600(ReportResultPanel x0) {
        return x0.detailActivityLoaded;
    }

    static /* synthetic */ ArrayList access$700(ReportResultPanel x0) {
        return x0.lastSearchResult;
    }

    static /* synthetic */ int access$608(ReportResultPanel x0) {
        return x0.detailActivityLoaded++;
    }

    static /* synthetic */ ArrayList access$702(ReportResultPanel x0, ArrayList x1) {
        x0.lastSearchResult = x1;
        return x0.lastSearchResult;
    }

    static /* synthetic */ void access$800(ReportResultPanel x0, boolean x1, AlertType x2, String x3) {
        x0.showAlert(x1, x2, x3);
    }

    static /* synthetic */ ProcessActivitiesIncrementalCommand access$902(ReportResultPanel x0, ProcessActivitiesIncrementalCommand x1) {
        x0.processCommand = x1;
        return x0.processCommand;
    }

    static /* synthetic */ ProcessActivitiesIncrementalCommand access$900(ReportResultPanel x0) {
        return x0.processCommand;
    }

    static /* synthetic */ void access$1000(ReportResultPanel x0) {
        x0.clearUI();
    }

    static /* synthetic */ FlowPanel access$1100(ReportResultPanel x0) {
        return x0.mainPanel;
    }

    static /* synthetic */ double access$1200(ReportResultPanel x0) {
        return x0.hoursInTotal;
    }

    static /* synthetic */ double access$1202(ReportResultPanel x0, double x1) {
        x0.hoursInTotal = x1;
        return x0.hoursInTotal;
    }

    static /* synthetic */ int access$1308(ReportResultPanel x0) {
        return x0.activityCount++;
    }

    static /* synthetic */ Date access$1400(ReportResultPanel x0) {
        return x0.firstActivity;
    }

    static /* synthetic */ Date access$1402(ReportResultPanel x0, Date x1) {
        x0.firstActivity = x1;
        return x0.firstActivity;
    }

    static /* synthetic */ Date access$1500(ReportResultPanel x0) {
        return x0.lastActivity;
    }

    static /* synthetic */ Date access$1502(ReportResultPanel x0, Date x1) {
        x0.lastActivity = x1;
        return x0.lastActivity;
    }

    static /* synthetic */ int access$1602(ReportResultPanel x0, int x1) {
        x0.users = x1;
        return x0.users;
    }

    static /* synthetic */ void access$1700(ReportResultPanel x0) {
        x0.generateAndPropagateStatisticsPanel();
    }

    static /* synthetic */ boolean access$300(ReportResultPanel x0) {
        return x0.addFlag;
    }

    static /* synthetic */ void access$1800(ReportResultPanel x0, HashMap x1, HashMap x2, HashMap x3) {
        x0.fillSummaryPanel(x1, x2, x3);
    }

    static /* synthetic */ FlowPanel access$1900(ReportResultPanel x0) {
        return x0.summaryPanel;
    }

    static /* synthetic */ boolean access$102(ReportResultPanel x0, boolean x1) {
        x0.synchFlag = x1;
        return x0.synchFlag;
    }
}

