/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.common.ui.report;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.cismet.projecttracker.client.ProjectTrackerEntryPoint;
import de.cismet.projecttracker.client.common.ui.report.ReportTaskNotice;
import de.cismet.projecttracker.client.dto.ActivityDTO;
import de.cismet.projecttracker.client.dto.WorkPackageDTO;
import de.cismet.projecttracker.client.helper.DateHelper;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class ReportTaskNotice
extends Composite {
    private static final ReportTaskNoticeUiBinder uiBinder = (ReportTaskNoticeUiBinder)GWT.create(ReportTaskNoticeUiBinder.class);
    private static final String MAIN_STYLES = "alert alert-block timebox";
    private static final String[] ADDITIONAL_PROJECT_STYLES = new String[]{"proj1", "proj2", "proj3", "proj4", "proj5", "proj6", "proj7"};
    private static final HashMap<Long, Integer> projectStyle = new HashMap();
    @UiField
    HTMLPanel imagePanel;
    @UiField
    HTMLPanel descrPanel;
    @UiField
    HTMLPanel datePanel;
    @UiField
    HTMLPanel hoursPanel;
    @UiField
    HTMLPanel containerPanel;
    private ActivityDTO activity;
    private Image gravatar = new Image();

    public ReportTaskNotice(ActivityDTO activity) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.activity = activity;
        if (activity != null && activity.getStaff() != null && activity.getStaff().getEmail() != null) {
            StringBuilder stringBuilder = new StringBuilder().append(ProjectTrackerEntryPoint.GRAVATAR_URL_PREFIX);
            ProjectTrackerEntryPoint.getInstance();
            this.gravatar.setUrl(stringBuilder.append(ProjectTrackerEntryPoint.md5((String)activity.getStaff().getEmail())).append("?s=32").toString());
            this.imagePanel.add((Widget)this.gravatar);
        }
        Label workPackage = new Label();
        WorkPackageDTO wp = activity.getWorkPackage();
        if (wp != null) {
            workPackage.setText(wp.getName());
        }
        this.descrPanel.add((Widget)workPackage);
        Label desc = new Label();
        String descr = activity.getDescription() == null ? " " : activity.getDescription();
        desc.setText(descr);
        this.descrPanel.add((Widget)desc);
        this.datePanel.add((Widget)new Label(DateHelper.formatDate((Date)activity.getDay())));
        this.datePanel.add((Widget)new Label(DateHelper.doubleToHours((double)activity.getWorkinghours()) + " h"));
        this.setColour();
    }

    private void setColour() {
        if (this.activity.getWorkPackage() != null && this.activity.getWorkPackage().getProject() != null) {
            List proj = ProjectTrackerEntryPoint.getInstance().getProjects();
            if (proj != null) {
                long projectId = this.activity.getWorkPackage().getProject().getId();
                Integer index = (Integer)projectStyle.get(projectId);
                if (index == null) {
                    index = 6;
                }
                if (index < 0 || index >= ADDITIONAL_PROJECT_STYLES.length) {
                    index = ADDITIONAL_PROJECT_STYLES.length - 1;
                }
                this.containerPanel.setStyleName("alert alert-block timebox " + ADDITIONAL_PROJECT_STYLES[index]);
            } else {
                1 t = new /* Unavailable Anonymous Inner Class!! */;
                t.schedule(2000);
            }
        }
    }

    static /* synthetic */ void access$000(ReportTaskNotice x0) {
        x0.setColour();
    }

    static {
        projectStyle.put(1L, 0);
        projectStyle.put(2L, 1);
        projectStyle.put(18L, 2);
        projectStyle.put(21L, 3);
        projectStyle.put(20L, 4);
        projectStyle.put(10L, 5);
    }
}

