/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.dto;

import de.cismet.projecttracker.client.dto.ActivityDTO;
import de.cismet.projecttracker.client.dto.BasicDTO;
import de.cismet.projecttracker.client.dto.StaffDTO;
import de.cismet.projecttracker.client.dto.WorkCategoryDTO;
import de.cismet.projecttracker.client.dto.WorkPackageDTO;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ActivityExtDTO
extends BasicDTO<ActivityExtDTO> {
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    private ActivityDTO activity;

    public ActivityExtDTO() {
    }

    public ActivityExtDTO(ActivityDTO activity) {
        this.activity = activity;
        this.id = activity.getId();
    }

    public StaffDTO getStaff() {
        return this.activity.getStaff();
    }

    public void setStaff(StaffDTO staff) {
        this.activity.setStaff(staff);
    }

    public WorkPackageDTO getWorkPackage() {
        return this.activity.getWorkPackage();
    }

    public void setWorkPackage(WorkPackageDTO workPackage) {
        this.activity.setWorkPackage(workPackage);
    }

    public WorkCategoryDTO getWorkCategory() {
        return this.activity.getWorkCategory();
    }

    public void setWorkCategory(WorkCategoryDTO workCategory) {
        this.activity.setWorkCategory(workCategory);
    }

    public double getWorkinghours() {
        return this.activity.getWorkinghours();
    }

    public void setWorkinghours(double workinghours) {
        this.activity.setWorkinghours(workinghours);
    }

    public String getDescription() {
        return this.activity.getDescription();
    }

    public void setDescription(String description) {
        this.activity.setDescription(description);
    }

    public String getDay() {
        return this.format.format(this.activity.getDay());
    }

    public void setDay(String day) {
        try {
            this.activity.setDay(this.format.parse(day));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getKindofactivity() {
        return this.activity.getKindofactivity();
    }

    public void setKindofactivity(int kindofactivity) {
        this.activity.setKindofactivity(kindofactivity);
    }

    public boolean getCommitted() {
        return this.activity.getCommitted();
    }

    public void setCommitted(boolean committed) {
        this.activity.setCommitted(committed);
    }

    public ActivityExtDTO createCopy() {
        return new ActivityExtDTO(this.activity);
    }

    public void reset(ActivityExtDTO obj) {
        this.activity = obj.activity;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass().getName().equals(this.getClass().getName())) {
            if (this.id == 0L && ((BasicDTO)obj).getId() == 0L) {
                return this == obj;
            }
            return this.id == ((BasicDTO)obj).getId();
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + (int)(this.id ^ this.id >>> 32);
        return hash;
    }

    public boolean hasSameContent(Object obj) {
        if (obj instanceof ActivityExtDTO) {
            ActivityExtDTO other = (ActivityExtDTO)obj;
            return other.activity.hasSameContent((Object)this.activity);
        }
        return false;
    }

    private boolean isSame(Object obj, Object other) {
        if (obj == null && other == null) {
            return true;
        }
        if (obj == null || other == null) {
            return false;
        }
        if (obj instanceof Date && other instanceof Date) {
            long millis2;
            long millis1 = ((Date)obj).getTime();
            return millis1 == (millis2 = ((Date)other).getTime());
        }
        return obj.equals(other);
    }

    public int compareTo(ActivityExtDTO o) {
        return o.activity.compareTo(this.activity);
    }
}

