/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.cismet.projecttracker.client.dto.BasicDTO;
import de.cismet.projecttracker.client.dto.CostCategoryDTO;
import de.cismet.projecttracker.client.dto.ProjectBodyDTO;
import de.cismet.projecttracker.client.dto.ProjectCategoryDTO;
import de.cismet.projecttracker.client.dto.ProjectComponentTagDTO;
import de.cismet.projecttracker.client.dto.ProjectPeriodDTO;
import de.cismet.projecttracker.client.dto.ProjectShortDTO;
import de.cismet.projecttracker.client.dto.StaffDTO;
import de.cismet.projecttracker.client.dto.WorkPackageDTO;
import java.util.ArrayList;

public class ProjectDTO
extends ProjectShortDTO {
    private ProjectBodyDTO projectBody;
    private ProjectDTO project;
    private double hoursofamanday = 8.0;
    private double daysofamanmonth = 19.0;
    private boolean overtimehoursallowed = true;
    private double warnlevel;
    private double criticallevel;
    private double fullstoplevel;
    private StaffDTO responsiblestaff;
    @JsonIgnore
    private ArrayList<ProjectDTO> projects = new ArrayList(0);
    @JsonIgnore
    private ArrayList<CostCategoryDTO> costCategories = new ArrayList(0);
    @JsonIgnore
    private ArrayList<WorkPackageDTO> workPackages = new ArrayList(0);
    @JsonIgnore
    private ArrayList<ProjectComponentTagDTO> projectComponentTags = new ArrayList(0);

    public ProjectDTO() {
    }

    public ProjectDTO(long id, String name, String description, double overheadratio, ProjectCategoryDTO projectCategory, ArrayList<ProjectPeriodDTO> projectPeriods) {
        super(id, name, description, overheadratio, projectCategory, projectPeriods);
    }

    public ProjectDTO(long id, String name, String description, double overheadratio, ProjectCategoryDTO projectCategory, ArrayList<ProjectPeriodDTO> projectPeriods, StaffDTO responsiblestaff, ProjectBodyDTO projectBody, ProjectDTO project, double hoursofamanday, double daysofamanmonth, boolean overtimehoursallowed, double warnlevel, double criticallevel, double fullstoplevel, ArrayList<ProjectDTO> projects, ArrayList<CostCategoryDTO> costCategories, ArrayList<WorkPackageDTO> workPackages, ArrayList<ProjectComponentTagDTO> projectComponentTags) {
        super(id, name, description, overheadratio, projectCategory, projectPeriods);
        this.responsiblestaff = responsiblestaff;
        this.projectBody = projectBody;
        this.project = project;
        this.projectBody = projectBody;
        this.project = project;
        this.hoursofamanday = hoursofamanday;
        this.daysofamanmonth = daysofamanmonth;
        this.overtimehoursallowed = overtimehoursallowed;
        this.projects = projects;
        this.costCategories = costCategories;
        this.workPackages = workPackages;
        this.projectComponentTags = projectComponentTags;
        this.warnlevel = warnlevel;
        this.criticallevel = criticallevel;
        this.fullstoplevel = fullstoplevel;
    }

    public ProjectBodyDTO getProjectBody() {
        return this.projectBody;
    }

    public void setProjectBody(ProjectBodyDTO projectBody) {
        this.projectBody = projectBody;
    }

    public ProjectDTO getProject() {
        return this.project;
    }

    public void setProject(ProjectDTO project) {
        this.project = project;
    }

    public double getHoursofamanday() {
        return this.hoursofamanday;
    }

    public void setHoursofamanday(double hoursofamanday) {
        this.hoursofamanday = hoursofamanday;
    }

    public double getDaysofamanmonth() {
        return this.daysofamanmonth;
    }

    public void setDaysofamanmonth(double daysofamanmonth) {
        this.daysofamanmonth = daysofamanmonth;
    }

    public boolean getOvertimehoursallowed() {
        return this.overtimehoursallowed;
    }

    public void setOvertimehoursallowed(boolean overtimehoursallowed) {
        this.overtimehoursallowed = overtimehoursallowed;
    }

    public ArrayList<ProjectDTO> getProjects() {
        return this.projects;
    }

    public void setProjects(ArrayList<ProjectDTO> projects) {
        this.projects = projects;
    }

    public ArrayList<CostCategoryDTO> getCostCategories() {
        return this.costCategories;
    }

    public void setCostCategories(ArrayList<CostCategoryDTO> costCategories) {
        this.costCategories = costCategories;
    }

    public ArrayList<WorkPackageDTO> getWorkPackages() {
        return this.workPackages;
    }

    public void setWorkPackages(ArrayList<WorkPackageDTO> workPackages) {
        this.workPackages = workPackages;
    }

    public ArrayList<ProjectComponentTagDTO> getProjectComponentTags() {
        return this.projectComponentTags;
    }

    public void setProjectComponentTags(ArrayList<ProjectComponentTagDTO> projectComponentTags) {
        this.projectComponentTags = projectComponentTags;
    }

    public BasicDTO createCopy() {
        return new ProjectDTO(this.id, this.name, this.description, this.overheadratio, this.projectCategory, this.projectPeriods, this.getResponsiblestaff(), this.projectBody, this.project, this.hoursofamanday, this.daysofamanmonth, this.overtimehoursallowed, this.warnlevel, this.criticallevel, this.fullstoplevel, this.projects, this.costCategories, this.workPackages, this.projectComponentTags);
    }

    public void reset(BasicDTO obj) {
        ProjectDTO prj = (ProjectDTO)obj;
        this.id = prj.id;
        this.name = prj.name;
        this.description = prj.description;
        this.overheadratio = prj.overheadratio;
        this.projectCategory = prj.projectCategory;
        this.projectPeriods = prj.projectPeriods;
        this.setResponsiblestaff(prj.getResponsiblestaff());
        this.projectBody = prj.projectBody;
        this.project = prj.project;
        this.hoursofamanday = prj.hoursofamanday;
        this.daysofamanmonth = prj.daysofamanmonth;
        this.overtimehoursallowed = prj.overtimehoursallowed;
        this.warnlevel = prj.warnlevel;
        this.criticallevel = prj.criticallevel;
        this.fullstoplevel = prj.fullstoplevel;
        this.projects = prj.projects;
        this.costCategories = prj.costCategories;
        this.workPackages = prj.workPackages;
        this.projectComponentTags = prj.projectComponentTags;
    }

    public ProjectShortDTO toShortVersion() {
        return new ProjectShortDTO(this.id, this.name, this.description, this.overheadratio, this.projectCategory, this.projectPeriods);
    }

    public double getWarnlevel() {
        return this.warnlevel;
    }

    public void setWarnlevel(double warnlevel) {
        this.warnlevel = warnlevel;
    }

    public double getCriticallevel() {
        return this.criticallevel;
    }

    public void setCriticallevel(double criticallevel) {
        this.criticallevel = criticallevel;
    }

    public double getFullstoplevel() {
        return this.fullstoplevel;
    }

    public void setFullstoplevel(double fullstoplevel) {
        this.fullstoplevel = fullstoplevel;
    }

    public StaffDTO getResponsiblestaff() {
        return this.responsiblestaff;
    }

    public void setResponsiblestaff(StaffDTO responsiblestaff) {
        this.responsiblestaff = responsiblestaff;
    }

    public ProjectPeriodDTO determineMostRecentPeriod() {
        ProjectPeriodDTO currentPeriod = null;
        if (this.getProjectPeriods() != null && this.getProjectPeriods().size() > 0) {
            for (ProjectPeriodDTO tmp : this.getProjectPeriods()) {
                if (currentPeriod != null && tmp.getAsof() != null && (currentPeriod.getAsof() == null || !tmp.getAsof().after(currentPeriod.getAsof()))) continue;
                currentPeriod = tmp;
            }
        }
        return currentPeriod;
    }
}

