/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.dto;

import de.cismet.projecttracker.client.MessageConstants;
import de.cismet.projecttracker.client.dto.BasicDTO;
import de.cismet.projecttracker.client.dto.ProjectDTO;
import de.cismet.projecttracker.client.helper.DateHelper;
import java.util.Date;

public class ProjectPeriodDTO
extends BasicDTO<ProjectPeriodDTO>
implements Comparable<ProjectPeriodDTO> {
    private ProjectDTO project;
    private Date fromdate;
    private Date todate;
    private Date asof;

    public ProjectPeriodDTO() {
    }

    public ProjectPeriodDTO(long id, ProjectDTO project, Date fromdate, Date todate, Date asof) {
        this.id = id;
        this.project = project;
        this.fromdate = fromdate;
        this.todate = todate;
        this.asof = asof;
    }

    public ProjectDTO getProject() {
        return this.project;
    }

    public void setProject(ProjectDTO project) {
        this.project = project;
    }

    public Date getFromdate() {
        return this.fromdate;
    }

    public void setFromdate(Date fromdate) {
        this.fromdate = fromdate;
    }

    public Date getTodate() {
        return this.todate;
    }

    public void setTodate(Date todate) {
        this.todate = todate;
    }

    public Date getAsof() {
        return this.asof;
    }

    public void setAsof(Date asof) {
        this.asof = asof;
    }

    public ProjectPeriodDTO createCopy() {
        return new ProjectPeriodDTO(this.id, this.project, this.fromdate, this.todate, this.asof);
    }

    public void reset(ProjectPeriodDTO obj) {
        this.id = obj.id;
        this.project = obj.project;
        this.fromdate = obj.fromdate;
        this.todate = obj.todate;
        this.asof = obj.asof;
    }

    public String toString() {
        MessageConstants messages = this.getMessagesInstance();
        if (messages != null) {
            return messages.periodMessage(DateHelper.formatDateTime((Date)this.asof), DateHelper.formatDate((Date)this.fromdate), DateHelper.formatDate((Date)this.todate));
        }
        return super.toString();
    }

    @Override
    public int compareTo(ProjectPeriodDTO o) {
        if (o == null || o.asof == null) {
            return -1;
        }
        if (this.asof == null) {
            return 1;
        }
        long diff = this.asof.getTime() - o.asof.getTime();
        return (int)Math.signum(diff);
    }
}

