/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.dto;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import de.cismet.projecttracker.client.dto.BasicDTO;
import de.cismet.projecttracker.client.dto.ContractDTO;
import de.cismet.projecttracker.client.dto.ProfileDTO;
import de.cismet.projecttracker.client.helper.DateHelper;
import java.util.ArrayList;
import java.util.Date;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="id")
public class StaffDTO
extends BasicDTO<StaffDTO>
implements Comparable<StaffDTO> {
    private String firstname;
    private String name;
    private int permissions;
    private String username;
    private String email;
    @JsonIgnore
    private ArrayList<ContractDTO> contracts = new ArrayList(0);
    @JsonIgnore
    private ProfileDTO profile;

    public StaffDTO() {
    }

    public StaffDTO(long id, String firstname, String name, int permissions, String username, String email, ArrayList<ContractDTO> contracts, ProfileDTO profile) {
        this.id = id;
        this.firstname = firstname;
        this.name = name;
        this.permissions = permissions;
        this.username = username;
        this.email = email;
        this.contracts = contracts;
        this.profile = profile;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPermissions() {
        return this.permissions;
    }

    public void setPermissions(int permissions) {
        this.permissions = permissions;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public ArrayList<ContractDTO> getContracts() {
        return this.contracts;
    }

    public void setContracts(ArrayList<ContractDTO> contracts) {
        this.contracts = contracts;
    }

    public ProfileDTO getProfile() {
        return this.profile;
    }

    public void setProfile(ProfileDTO profile) {
        this.profile = profile;
    }

    public StaffDTO createCopy() {
        return new StaffDTO(this.id, this.firstname, this.name, this.permissions, this.username, this.email, this.contracts, this.profile);
    }

    public void reset(StaffDTO obj) {
        this.id = obj.id;
        this.firstname = obj.firstname;
        this.name = obj.name;
        this.permissions = obj.permissions;
        this.username = obj.username;
        this.email = obj.email;
        this.contracts = obj.contracts;
        this.profile = obj.profile;
    }

    @JsonIgnore
    public boolean isActiveStaff() {
        Date now = new Date();
        ArrayList cont = this.getContracts();
        if (cont == null || cont.isEmpty()) {
            return true;
        }
        for (ContractDTO tmp : cont) {
            if (tmp.getFromdate() == null || !DateHelper.isDateGreaterOrEqual((Date)now, (Date)tmp.getFromdate()) || tmp.getTodate() != null && !DateHelper.isDateLessOrEqual((Date)now, (Date)tmp.getTodate())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(StaffDTO o) {
        int result = this.firstname.compareTo(o.firstname);
        if (result == 0) {
            return this.name.compareTo(o.name);
        }
        return result;
    }
}

