/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.dto;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import de.cismet.projecttracker.client.MessageConstants;
import de.cismet.projecttracker.client.dto.BasicDTO;
import de.cismet.projecttracker.client.dto.WorkPackageDTO;
import de.cismet.projecttracker.client.helper.DateHelper;
import java.util.Date;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@id")
public class WorkPackagePeriodDTO
extends BasicDTO<WorkPackagePeriodDTO>
implements Comparable<Object> {
    private WorkPackageDTO workPackage;
    private Date fromdate;
    private Date todate;
    private Date asof;

    public WorkPackagePeriodDTO() {
    }

    public WorkPackagePeriodDTO(long id, WorkPackageDTO workPackage, Date fromdate, Date todate, Date asof) {
        this.id = id;
        this.workPackage = workPackage;
        this.fromdate = fromdate;
        this.todate = todate;
        this.asof = asof;
    }

    public WorkPackageDTO getWorkPackage() {
        return this.workPackage;
    }

    public void setWorkPackage(WorkPackageDTO workPackage) {
        this.workPackage = workPackage;
    }

    public Date getFromdate() {
        return this.fromdate;
    }

    public void setFromdate(Date fromdate) {
        this.fromdate = fromdate;
    }

    public Date getTodate() {
        return this.todate;
    }

    public void setTodate(Date todate) {
        this.todate = todate;
    }

    public Date getAsof() {
        return this.asof;
    }

    public void setAsof(Date asof) {
        this.asof = asof;
    }

    public WorkPackagePeriodDTO createCopy() {
        return new WorkPackagePeriodDTO(this.id, this.workPackage, this.fromdate, this.todate, this.asof);
    }

    public void reset(WorkPackagePeriodDTO obj) {
        this.id = obj.id;
        this.workPackage = obj.workPackage;
        this.fromdate = obj.fromdate;
        this.todate = obj.todate;
        this.asof = obj.asof;
    }

    public String toString() {
        MessageConstants messages = this.getMessagesInstance();
        if (messages != null) {
            return messages.periodMessage(DateHelper.formatDateTime((Date)this.asof), DateHelper.formatDate((Date)this.fromdate), DateHelper.formatDate((Date)this.todate));
        }
        return super.toString();
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof WorkPackagePeriodDTO) {
            long result = this.asof.getTime() - ((WorkPackagePeriodDTO)o).asof.getTime();
            return (int)Math.signum(result);
        }
        if (o instanceof Date) {
            long result = this.asof.getTime() - ((Date)o).getTime();
            return (int)Math.signum(result);
        }
        return 0;
    }
}

