/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.helper;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.datepicker.client.CalendarUtil;
import de.cismet.projecttracker.client.CalendarMessages;
import de.cismet.projecttracker.client.dto.ProjectPeriodDTO;
import de.cismet.projecttracker.client.dto.WorkPackagePeriodDTO;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateHelper {
    private static final CalendarMessages MESSAGES = (CalendarMessages)GWT.create(CalendarMessages.class);
    public static final String[] DAYS_OF_WEEK = new String[]{MESSAGES.mondayAbbreviation(), MESSAGES.tuesdayAbbreviation(), MESSAGES.wednesdayAbbreviation(), MESSAGES.thursdayAbbreviation(), MESSAGES.fridayAbbreviation(), MESSAGES.saturdayAbbreviation(), MESSAGES.sundayAbbreviation()};
    public static final String[] DAYS_OF_WEEK_LONG = new String[]{MESSAGES.mondayAbbreviationLong(), MESSAGES.tuesdayAbbreviationLong(), MESSAGES.wednesdayAbbreviationLong(), MESSAGES.thursdayAbbreviationLong(), MESSAGES.fridayAbbreviationLong(), MESSAGES.saturdayAbbreviationLong(), MESSAGES.sundayAbbreviationLong()};
    public static final String[] NAME_OF_MONTH = new String[]{MESSAGES.januaryAbbreviation(), MESSAGES.februaryAbbreviation(), MESSAGES.marchAbbreviation(), MESSAGES.aprilAbbreviation(), MESSAGES.mayAbbreviation(), MESSAGES.juneAbbreviation(), MESSAGES.julyAbbreviation(), MESSAGES.augustAbbreviation(), MESSAGES.septemberAbbreviation(), MESSAGES.octoberAbbreviation(), MESSAGES.novemberAbbreviation(), MESSAGES.decemberAbbreviation()};
    public static final long DAY_IN_MILLIS = 86400000L;
    public static final long HOUR_IN_MILLIS = 3600000L;
    public static final long MINUTE_IN_MILLIS = 60000L;
    public static final int DAYS_PER_WEEK = 7;
    public static final int SUNDAY = 0;
    public static final int MONDAY = 1;
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int THURSDAY = 4;
    public static final int FRIDAY = 5;
    public static final int SATURDAY = 6;

    public static String formatShortDate(Date date) {
        if (date == null) {
            return "";
        }
        return "" + date.getDate() + "." + (date.getMonth() + 1);
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        return MESSAGES.dateFormat(date.getYear() + 1900, date.getMonth() + 1, date.getDate());
    }

    public static void addDays(Date day, int days) {
        CalendarUtil.addDaysToDate((Date)day, (int)days);
    }

    public static String doubleToHours(double ihours) {
        boolean roundHours = Math.abs(ihours - (double)((int)ihours)) < 1.0E-5 || Math.abs(ihours - (double)((int)ihours)) > 0.9999;
        double correctedHours = roundHours ? (double)Math.round(ihours) : ihours;
        double hours = Math.abs(correctedHours);
        int minutes = (int)Math.round((hours - (double)((int)hours)) * 60.0);
        if (minutes == 60) {
            hours += 1.0;
            minutes = 0;
        }
        return (correctedHours < 0.0 ? "-" : "") + (int)hours + ":" + DateHelper.IntToDoubleDigit((int)minutes);
    }

    public static double hoursToDouble(String hours) throws NumberFormatException {
        String[] st = hours.split(":");
        if (st.length == 2) {
            String hour = st[0];
            String minute = st[1];
            int hourInt = Integer.parseInt(hour);
            int minuteInt = Integer.parseInt(minute);
            return (double)hourInt + (double)minuteInt / 60.0;
        }
        if (st.length == 1) {
            try {
                return Integer.parseInt(st[0]);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException(hours + " is no valid duration");
            }
        }
        throw new NumberFormatException(hours + " is no valid duration");
    }

    public static String formatDateTime(Date date) {
        if (date == null) {
            return "";
        }
        return MESSAGES.dateTimeFormat(date.getYear() + 1900, date.getMonth() + 1, date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds());
    }

    public static String formatTime(Date date) {
        if (date == null) {
            return "";
        }
        return MESSAGES.timeFormat(date.getHours(), date.getMinutes());
    }

    public static Date createDateObject(Date day, Date time) {
        return new Date(day.getYear(), day.getMonth(), day.getDate(), time.getHours(), time.getMinutes(), time.getSeconds());
    }

    public static boolean isSameDay(Date date, Date otherDate) {
        if (date == null && otherDate == null) {
            return true;
        }
        if (date == null || otherDate == null) {
            return false;
        }
        return date.getYear() == otherDate.getYear() && date.getMonth() == otherDate.getMonth() && date.getDate() == otherDate.getDate();
    }

    public static boolean isSameDaySV(Date date, Date otherDate) {
        if (date == null && otherDate == null) {
            return true;
        }
        if (date == null || otherDate == null) {
            return false;
        }
        if (date.getYear() == otherDate.getYear() && date.getMonth() == otherDate.getMonth()) {
            int otherDateDay;
            int dateDay = date.getDay();
            int diff = dateDay - (otherDateDay = otherDate.getDay());
            if (diff == 0) {
                return (date.getHours() >= 4 || otherDate.getHours() <= 4) && (date.getHours() <= 4 || otherDate.getHours() >= 4);
            }
            if (diff == 1) {
                return date.getHours() < 4 && otherDate.getHours() > 4;
            }
            if (diff == -1) {
                return otherDate.getHours() < 4 && date.getHours() > 4;
            }
            return false;
        }
        return false;
    }

    public static boolean isDateLessOrEqual(Date date1, Date date2) {
        int secondDate;
        int firstDate = (date1.getYear() + 1900) * 10000 + date1.getMonth() * 100 + date1.getDate();
        return firstDate <= (secondDate = (date2.getYear() + 1900) * 10000 + date2.getMonth() * 100 + date2.getDate());
    }

    public static boolean isDateGreaterOrEqual(Date date1, Date date2) {
        int secondDate;
        int firstDate = (date1.getYear() + 1900) * 10000 + date1.getMonth() * 100 + date1.getDate();
        return firstDate >= (secondDate = (date2.getYear() + 1900) * 10000 + date2.getMonth() * 100 + date2.getDate());
    }

    public static Date parseString(String dateString, DateTimeFormat dtf) throws IllegalArgumentException {
        if (dtf == null) {
            dtf = DateTimeFormat.getFormat((String)"y-M-d");
        }
        return dtf.parseStrict(dateString);
    }

    private static String IntToDoubleDigit(int number) {
        if (number < 10) {
            return "0" + number;
        }
        return "" + number;
    }

    public static int getCurrentWeek() {
        return DateHelper.getWeekOfYear((Date)new Date());
    }

    public static int getYear(Date d) {
        return d.getYear() + 1900;
    }

    public static int getWeekOfYear(Date date) {
        Date givenDate = new Date(date.getTime());
        Date firstWeek = new Date(givenDate.getTime());
        firstWeek.setMonth(0);
        firstWeek.setDate(4);
        int dayOfWeekJanTheFourth = DateHelper.convertDayOfWeek((int)firstWeek.getDay());
        int dayOfWeekNow = DateHelper.convertDayOfWeek((int)givenDate.getDay());
        int diff = dayOfWeekJanTheFourth - dayOfWeekNow;
        givenDate.setTime(givenDate.getTime() + (long)diff * 86400000L);
        long givenDateNormalized = givenDate.getTime() - (long)(givenDate.getTimezoneOffset() * 60000);
        long firstWeekNormalized = firstWeek.getTime() - (long)(firstWeek.getTimezoneOffset() * 60000);
        long timeDistance = givenDateNormalized - firstWeekNormalized;
        long week = timeDistance / 604800000L + 1L;
        if (week == 0L) {
            week = DateHelper.getWeekCountForYear((int)(date.getYear() + 1899));
        } else if (week == 53L && DateHelper.getWeekCountForYear((int)(date.getYear() + 1900)) == 52) {
            week = 1L;
        } else if (week > 53L) {
            week = 1L;
        }
        return (int)week;
    }

    public static String getDayAbbreviation(Date d) {
        return d.getDay() == 0 ? DAYS_OF_WEEK_LONG[6] : DAYS_OF_WEEK_LONG[d.getDay() - 1];
    }

    public static int getMonthsOfPeriod(Date start, Date end) {
        int year = end.getYear() - start.getYear();
        int months = end.getMonth() - start.getMonth();
        int day = 1;
        if (end.getDate() < start.getDate()) {
            day = 0;
        }
        return months + year * 12 + day;
    }

    public static int getWeekCountForYear(int year) {
        int weekCount = 52;
        Date date = new Date(year - 1900, 0, 1);
        if (date.getDay() == 4) {
            weekCount = 53;
        } else {
            date = new Date(year - 1900, 11, 31);
            if (date.getDay() == 4) {
                weekCount = 53;
            }
        }
        return weekCount;
    }

    public static Date getBeginOfWeek(int year, int week) {
        Date date = new Date(year - 1900, 0, 1);
        date.setTime(date.getTime() - (long)DateHelper.convertDayOfWeek((int)date.getDay()) * 86400000L);
        int currentWeekOfYear = DateHelper.getWeekOfYear((Date)date);
        int origWeek = week--;
        if (currentWeekOfYear == 1) {
            // empty if block
        }
        date.setTime(date.getTime() + (long)week * 86400000L * 7L);
        return date;
    }

    public static Date getBeginOfWeek(Date day) {
        int week = DateHelper.getWeekOfYear((Date)day);
        int year = DateHelper.getYear((Date)day);
        if (week >= 52 && day.getDate() < 4) {
            --year;
        }
        if (week == 1 && day.getDate() > 28) {
            ++year;
        }
        return DateHelper.getBeginOfWeek((int)year, (int)week);
    }

    public static int convertDayOfWeek(int dayOfWeek) {
        return DateHelper.mod((int)(dayOfWeek - 1), (int)7);
    }

    private static int mod(int number, int range) {
        return (number % range + range) % range;
    }

    public static boolean isDayInWorkPackagePeriod(Date day, WorkPackagePeriodDTO period) {
        return DateHelper.isDateGreaterOrEqual((Date)day, (Date)period.getFromdate()) && (period.getTodate() == null || DateHelper.isDateLessOrEqual((Date)day, (Date)period.getTodate()));
    }

    public static boolean isDayInProjectPeriod(Date day, ProjectPeriodDTO period) {
        return DateHelper.isDateGreaterOrEqual((Date)day, (Date)period.getFromdate()) && (period.getTodate() == null || DateHelper.isDateLessOrEqual((Date)day, (Date)period.getTodate()));
    }

    public static double substract(Date time, Date otherTime) {
        return (double)(otherTime.getTime() - time.getTime()) / 3600000.0;
    }
}

