/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.helper;

import de.cismet.projecttracker.client.dto.ProjectCategoryDTO;
import de.cismet.projecttracker.client.dto.ProjectDTO;
import de.cismet.projecttracker.client.dto.WorkPackageDTO;
import de.cismet.projecttracker.client.dto.WorkPackagePeriodDTO;
import de.cismet.projecttracker.client.types.WorkpackageTreeItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

public class GUIHelper {
    public static WorkPackagePeriodDTO getPeriodForTime(WorkPackageDTO wk, Date time) {
        WorkPackagePeriodDTO currentPeriod = null;
        if (wk.getWorkPackagePeriods() != null && wk.getWorkPackagePeriods().size() > 0) {
            ArrayList<WorkPackagePeriodDTO> periods = new ArrayList<WorkPackagePeriodDTO>();
            for (WorkPackagePeriodDTO tmp : wk.getWorkPackagePeriods()) {
                periods.add(tmp);
            }
            Collections.sort(periods);
            int searchRes = Collections.binarySearch(periods, time);
            if (searchRes > 0) {
                currentPeriod = (WorkPackagePeriodDTO)periods.get(searchRes);
            } else {
                if ((searchRes = (searchRes + 1) * -1) != 0) {
                    --searchRes;
                }
                currentPeriod = (WorkPackagePeriodDTO)periods.get(searchRes);
            }
        }
        return currentPeriod;
    }

    public static boolean canUserBillToProject(String companyName, ProjectDTO project) {
        String projectRestrictedCompany;
        String name;
        String[] splittedName;
        ProjectCategoryDTO category = project.getProjectCategory();
        if (companyName.equals("0")) {
            return true;
        }
        return category == null || (splittedName = (name = category.getName()).split("_")).length <= 1 || companyName.equalsIgnoreCase(projectRestrictedCompany = splittedName[0]);
    }

    private static int indexOfWorkPackage(ArrayList<WorkpackageTreeItem> itemList, WorkPackageDTO work) {
        for (int i = 0; i < itemList.size(); ++i) {
            if (itemList.get(i).getWorkpackage().getId() != work.getId()) continue;
            return i;
        }
        return -1;
    }
}

