/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.listener;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.InvocationException;
import de.cismet.projecttracker.client.MessageConstants;
import de.cismet.projecttracker.client.ProjectTrackerEntryPoint;
import de.cismet.projecttracker.client.common.ui.LoadingPanel;
import de.cismet.projecttracker.client.exceptions.FullStopException;
import de.cismet.projecttracker.client.exceptions.NoSessionException;

public class BasicAsyncCallback<E>
implements AsyncCallback<E> {
    protected static final MessageConstants MESSAGES = (MessageConstants)GWT.create(MessageConstants.class);
    private static boolean criticalErrorAppeared = false;

    public void onFailure(Throwable caught) {
        this.afterExecution(null, true);
        if (!criticalErrorAppeared) {
            try {
                LoadingPanel.getInstance().hideLoadingAnimation();
                throw caught;
            }
            catch (FullStopException e) {
                ProjectTrackerEntryPoint.outputBox((String)MESSAGES.workPackageOverbookedString(e.getMessage()));
            }
            catch (IncompatibleRemoteServiceException e) {
                ProjectTrackerEntryPoint.outputBox((String)MESSAGES.clientIsNotCompatiblerWithServerString());
                criticalErrorAppeared = true;
            }
            catch (InvocationException e) {
                ProjectTrackerEntryPoint.outputBox((String)(MESSAGES.callDidNotCompleteCleanlyString() + "\n" + e.getLocalizedMessage()));
                criticalErrorAppeared = true;
            }
            catch (NoSessionException e) {
                if (ProjectTrackerEntryPoint.getInstance().isLoggedIn()) {
                    ProjectTrackerEntryPoint.getInstance().onClick(null);
                    ProjectTrackerEntryPoint.outputBox((String)MESSAGES.sessionExpiredString());
                    criticalErrorAppeared = true;
                }
            }
            catch (Throwable e) {
                ProjectTrackerEntryPoint.outputBox((String)e.getMessage());
                criticalErrorAppeared = true;
            }
        }
    }

    public void onSuccess(E result) {
        this.afterExecution(result, false);
        criticalErrorAppeared = false;
        LoadingPanel.getInstance().hideLoadingAnimation();
    }

    protected void afterExecution(E result, boolean operationFailed) {
    }
}

