/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.types;

import de.cismet.projecttracker.client.dto.EstimatedComponentCostDTO;
import de.cismet.projecttracker.client.helper.DateHelper;
import de.cismet.projecttracker.client.types.ListItem;
import java.util.Date;

public class EstimationListItem
extends ListItem {
    private EstimatedComponentCostDTO estimation;

    public EstimationListItem() {
    }

    public EstimationListItem(EstimatedComponentCostDTO estimation) {
        super("" + estimation.getId(), DateHelper.formatDateTime((Date)estimation.getCreationtime()));
        this.estimation = estimation;
    }

    public EstimationListItem(String id, String name) {
        super(id, name);
    }

    public EstimatedComponentCostDTO getEstimation() {
        return this.estimation;
    }

    public void setEstimation(EstimatedComponentCostDTO estimation) {
        this.estimation = estimation;
        super.setId("" + estimation.getId());
        super.setName(DateHelper.formatDateTime((Date)estimation.getCreationtime()));
    }

    public int compareTo(ListItem o) {
        if (o instanceof EstimationListItem) {
            long result = this.estimation.getCreationtime().getTime() - ((EstimationListItem)o).estimation.getCreationtime().getTime();
            return (int)Math.signum(result);
        }
        return super.compareTo(o);
    }
}

