/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.types;

import de.cismet.projecttracker.client.common.ui.listener.ListItemChangeListener;
import java.util.ArrayList;

public class ListItem
implements Comparable<ListItem> {
    private String name;
    private String id;
    private String tooltip;
    private ArrayList<ListItemChangeListener> listener = new ArrayList();

    public ListItem() {
    }

    public ListItem(String id, String name) {
        this.id = id;
        this.name = name;
        this.tooltip = name;
    }

    public ListItem(String id, String name, String tooltip) {
        this.id = id;
        this.name = name;
        this.tooltip = tooltip;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.changeEvent(oldName);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public void addChangeListener(ListItemChangeListener lis) {
        this.listener.add(lis);
    }

    public boolean removeChangeListener(ListItemChangeListener lis) {
        return this.listener.remove(lis);
    }

    private void changeEvent(String oldName) {
        for (ListItemChangeListener tmp : this.listener) {
            tmp.onChange(this, oldName);
        }
    }

    @Override
    public int compareTo(ListItem o) {
        return this.name.compareTo(o.name);
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }
}

