/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.uicomps;

import com.github.gwtbootstrap.client.ui.Label;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import de.cismet.projecttracker.client.ProjectTrackerEntryPoint;
import de.cismet.projecttracker.client.common.ui.event.MenuEvent;
import de.cismet.projecttracker.client.common.ui.listener.MenuListener;
import de.cismet.projecttracker.client.common.ui.profile.ProfileMenue;
import de.cismet.projecttracker.client.dto.StaffDTO;
import de.cismet.projecttracker.client.helper.DateHelper;
import de.cismet.projecttracker.client.uicomps.ProfilePanel;
import de.cismet.projecttracker.client.utilities.TimeCalculator;
import java.util.Date;

public class ProfilePanel
extends Composite
implements MenuListener,
ChangeHandler,
ResizeHandler {
    double remainingVacation = 0.0;
    final Label vacationPlannedContent = new Label(" Days");
    FlowPanel carryOver = new FlowPanel();
    Label carryOverKey;
    final Label carryOverContent = new Label(" Days");
    final Label totalVacationContent = new Label(" Days");
    final Label holidayBalContent = new Label(" Days");
    final Label vacationTakenContent = new Label(" Days");
    final Label accBalContent = new Label("");
    final Label w1Content = new Label("");
    final Label w2Content = new Label("");
    final Label w3Content = new Label("");
    private FlowPanel mainPanel = new FlowPanel();
    private FlowPanel pageHeaderPanel = new FlowPanel();
    private FlowPanel pageHeaderAccBalPanel = new FlowPanel();
    private FlowPanel pageHeaderHolidayPanel = new FlowPanel();
    private FlowPanel contentPanel = new FlowPanel();
    private FlowPanel masterView = new FlowPanel();
    private FlowPanel detailView = new FlowPanel();
    private Image gravatar = new Image();
    private ProfileMenue menue;
    private Label nameLabel = new Label();

    public ProfilePanel() {
        this.init();
        this.initWidget((Widget)this.mainPanel);
        this.setStyleName("content");
    }

    private void init() {
        this.initPageHeader();
        this.contentPanel.setStyleName("profile-content");
        this.masterView.setStyleName("profile-master-view");
        this.detailView.setStyleName("profile-detail-view");
        this.menue = new ProfileMenue(this.detailView);
        this.masterView.add((Widget)this.menue);
        this.contentPanel.add((Widget)this.masterView);
        this.contentPanel.add((Widget)this.detailView);
        this.mainPanel.add((Widget)this.pageHeaderPanel);
        this.mainPanel.add((Widget)this.contentPanel);
        Window.addResizeHandler((ResizeHandler)this);
        this.resize(Window.getClientHeight());
    }

    public void menuChangeEvent(MenuEvent e) {
        if (e.getNumber() == 3) {
            RootPanel.get((String)"contentId").clear();
            RootPanel.get((String)"contentId").add((Widget)this);
            this.menue.refreshDetailContainer();
            this.refresh();
        }
    }

    private void initPageHeader() {
        this.pageHeaderPanel.setStyleName("profile-page-header");
        this.pageHeaderAccBalPanel.setStyleName("pull-right page-header-acc-bal");
        this.pageHeaderHolidayPanel.setStyleName("pull-right page-header-holidays");
        this.gravatar.setStyleName("pull-left profile-gravatar-image");
        this.nameLabel.setStyleName("profile-name-label");
        this.refreshProfileImage();
        Label accountBalanceLabel = new Label("Account Balance");
        accountBalanceLabel.setStyleName("h3 page-header-title");
        this.pageHeaderAccBalPanel.add((Widget)accountBalanceLabel);
        this.pageHeaderPanel.add((Widget)this.pageHeaderAccBalPanel);
        Label holidayBalanceLabel = new Label("Holiday Balance");
        holidayBalanceLabel.setStyleName("h3 page-header-title");
        this.pageHeaderHolidayPanel.add((Widget)holidayBalanceLabel);
        this.pageHeaderPanel.add((Widget)this.pageHeaderHolidayPanel);
        this.initAccountBalance();
        this.initHolidayBalance();
    }

    private void initAccountBalance() {
        FlowPanel w3 = new FlowPanel();
        w3.setStyleName("clear");
        Label w3Key = new Label("current week-2:");
        w3Key.setStyleName("profile-header-label");
        this.w3Content.setStyleName("pull-right");
        w3.add((Widget)w3Key);
        w3.add((Widget)this.w3Content);
        this.pageHeaderAccBalPanel.add((Widget)w3);
        FlowPanel w2 = new FlowPanel();
        w2.setStyleName("clear");
        Label w2Key = new Label("current week-1:");
        w2Key.setStyleName("profile-header-label");
        this.w2Content.setStyleName("pull-right");
        w2.add((Widget)w2Key);
        w2.add((Widget)this.w2Content);
        this.pageHeaderAccBalPanel.add((Widget)w2);
        FlowPanel w1 = new FlowPanel();
        w1.setStyleName("clear");
        Label w1Key = new Label("current week:");
        w1Key.setStyleName("profile-header-label");
        this.w1Content.setStyleName("pull-right");
        w1.add((Widget)w1Key);
        w1.add((Widget)this.w1Content);
        this.pageHeaderAccBalPanel.add((Widget)w1);
        HTML spacerLabel = new HTML("<hr />");
        spacerLabel.setStyleName("page-header-spacer");
        this.pageHeaderAccBalPanel.add((Widget)spacerLabel);
        FlowPanel accBal = new FlowPanel();
        Label accBalKey = new Label("Account Balance:");
        accBalKey.setStyleName("label label-info");
        this.accBalContent.setStyleName("pull-right");
        accBal.add((Widget)accBalKey);
        accBal.add((Widget)this.accBalContent);
        this.pageHeaderAccBalPanel.add((Widget)accBal);
    }

    private void refreshAccountBalanceLables() {
        StaffDTO staff = ProjectTrackerEntryPoint.getInstance().getStaff();
        1 callback = new /* Unavailable Anonymous Inner Class!! */;
        ProjectTrackerEntryPoint.getProjectService((boolean)true).getAccountBalance(staff, (AsyncCallback)callback);
        Date now = new Date();
        Date d = DateHelper.getBeginOfWeek((int)DateHelper.getYear((Date)now), (int)DateHelper.getWeekOfYear((Date)now));
        TimeCalculator.getWorkingBalanceForWeek((int)DateHelper.getYear((Date)d), (int)DateHelper.getWeekOfYear((Date)d), (StaffDTO)staff, (com.google.gwt.user.client.ui.Label)this.w1Content, (String)"");
        DateHelper.addDays((Date)d, (int)-7);
        TimeCalculator.getWorkingBalanceForWeek((int)DateHelper.getYear((Date)d), (int)DateHelper.getWeekOfYear((Date)d), (StaffDTO)staff, (com.google.gwt.user.client.ui.Label)this.w2Content, (String)"");
        DateHelper.addDays((Date)d, (int)-7);
        TimeCalculator.getWorkingBalanceForWeek((int)DateHelper.getYear((Date)d), (int)DateHelper.getWeekOfYear((Date)d), (StaffDTO)staff, (com.google.gwt.user.client.ui.Label)this.w3Content, (String)"");
    }

    private void initHolidayBalance() {
        FlowPanel total = new FlowPanel();
        total.setStyleName("clear");
        Label totalKey = new Label("Total:");
        totalKey.setStyleName("profile-header-label");
        this.totalVacationContent.setStyleName("pull-right");
        total.add((Widget)totalKey);
        total.add((Widget)this.totalVacationContent);
        this.pageHeaderHolidayPanel.add((Widget)total);
        int lastYear = DateHelper.getYear((Date)new Date()) - 1;
        this.carryOverKey = new Label("Remaining from " + lastYear);
        this.carryOver.setStyleName("clear");
        this.carryOverContent.setStyleName("pull-right profile-header-label");
        this.carryOver.add((Widget)this.carryOverKey);
        this.carryOver.add((Widget)this.carryOverContent);
        this.pageHeaderHolidayPanel.add((Widget)this.carryOver);
        FlowPanel taken = new FlowPanel();
        taken.setStyleName("clear");
        Label takenKey = new Label("Taken:");
        takenKey.setStyleName("profile-header-labelw");
        this.vacationTakenContent.setStyleName("pull-right");
        taken.add((Widget)takenKey);
        taken.add((Widget)this.vacationTakenContent);
        this.pageHeaderHolidayPanel.add((Widget)taken);
        FlowPanel planned = new FlowPanel();
        planned.setStyleName("clear");
        Label plannedKey = new Label("Planned:");
        plannedKey.setStyleName("profile-header-label");
        this.vacationPlannedContent.setStyleName("pull-right");
        planned.add((Widget)plannedKey);
        planned.add((Widget)this.vacationPlannedContent);
        this.pageHeaderHolidayPanel.add((Widget)planned);
        HTML spacerLabel = new HTML("<hr />");
        spacerLabel.setStyleName("page-header-spacer");
        this.pageHeaderHolidayPanel.add((Widget)spacerLabel);
        FlowPanel holidayBal = new FlowPanel();
        Label holidayBalKey = new Label("Remaining:");
        holidayBalKey.setStyleName("label label-info");
        this.holidayBalContent.setStyleName("pull-right");
        holidayBal.add((Widget)holidayBalKey);
        holidayBal.add((Widget)this.holidayBalContent);
        this.pageHeaderHolidayPanel.add((Widget)holidayBal);
    }

    private void refreshHolidayBalanceLabels() {
        StaffDTO staff = ProjectTrackerEntryPoint.getInstance().getStaff();
        2 vacationDaysTakenCallback = new /* Unavailable Anonymous Inner Class!! */;
        3 vacationDaysPlannedCallback = new /* Unavailable Anonymous Inner Class!! */;
        4 carryOverCallback = new /* Unavailable Anonymous Inner Class!! */;
        5 totalCB = new /* Unavailable Anonymous Inner Class!! */;
        ProjectTrackerEntryPoint.getProjectService((boolean)true).getTotalVacationForYear(staff, new Date(), (AsyncCallback)totalCB);
    }

    private void refreshProfileImage() {
        this.pageHeaderPanel.remove((Widget)this.gravatar);
        this.pageHeaderPanel.remove((Widget)this.nameLabel);
        String email = ProjectTrackerEntryPoint.getInstance().getStaff().getEmail();
        if (email != null) {
            StringBuilder stringBuilder = new StringBuilder().append(ProjectTrackerEntryPoint.GRAVATAR_URL_PREFIX);
            ProjectTrackerEntryPoint.getInstance();
            this.gravatar.setUrl(stringBuilder.append(ProjectTrackerEntryPoint.md5((String)email)).append("?s=110").toString());
        }
        this.pageHeaderPanel.add((Widget)this.gravatar);
        String s = ProjectTrackerEntryPoint.getInstance().getStaff().getFirstname() + " " + ProjectTrackerEntryPoint.getInstance().getStaff().getName();
        this.nameLabel = new Label(s);
        this.nameLabel.setStyleName("profile-name-label");
        this.pageHeaderPanel.add((Widget)this.nameLabel);
    }

    private void refresh() {
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String formatDays(double d) {
        return NumberFormat.getFormat((String)"#.##").format(d);
    }

    public void onChange(ChangeEvent event) {
        this.refreshProfileImage();
        this.refresh();
        this.menue.refreshDetailContainer();
    }

    public void onResize(ResizeEvent event) {
        this.resize(event.getHeight());
    }

    private void resize(int heigth) {
        int newHeight = heigth - 300;
        if (newHeight < 150) {
            newHeight = 150;
        }
        this.contentPanel.getElement().getStyle().setProperty("maxHeight", newHeight + "px");
        int nh = newHeight - 20;
        this.detailView.getElement().getStyle().setProperty("maxHeight", nh + "px");
    }

    static /* synthetic */ String access$000(ProfilePanel x0, double x1) {
        return x0.formatDays(x1);
    }

    static /* synthetic */ void access$100(ProfilePanel x0) {
        x0.refreshAccountBalanceLables();
    }

    static /* synthetic */ void access$200(ProfilePanel x0) {
        x0.refreshHolidayBalanceLabels();
    }
}

