/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.uicomps;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import de.cismet.projecttracker.client.common.ui.event.MenuEvent;
import de.cismet.projecttracker.client.common.ui.listener.MenuListener;
import de.cismet.projecttracker.client.common.ui.report.ReportFilterPanel;
import de.cismet.projecttracker.client.common.ui.report.ReportResultPanel;
import de.cismet.projecttracker.client.common.ui.report.ReportSearchParamListener;

public class ReportsPanel
extends Composite
implements MenuListener,
ChangeHandler,
ReportSearchParamListener,
ResizeHandler {
    private FlowPanel mainPanel = new FlowPanel();
    private FlowPanel contentPanel = new FlowPanel();
    private FlowPanel filterContainerPanel = new FlowPanel();
    private FlowPanel summaryPanel = new FlowPanel();
    private ReportResultPanel resultsPanel;
    private ReportFilterPanel filterPanel;

    public ReportsPanel() {
        this.init();
        this.initWidget((Widget)this.mainPanel);
        this.setStyleName("content");
    }

    public void menuChangeEvent(MenuEvent e) {
        if (e.getNumber() == 2) {
            RootPanel.get((String)"contentId").clear();
            RootPanel.get((String)"contentId").add((Widget)this);
            this.filterPanel.refresh();
        }
    }

    public void onChange(ChangeEvent event) {
    }

    private void init() {
        this.contentPanel.setStyleName("report-content");
        this.initFilterArea();
        this.initResultsArea();
        this.contentPanel.add((Widget)this.filterContainerPanel);
        this.contentPanel.add((Widget)this.summaryPanel);
        this.contentPanel.add((Widget)this.resultsPanel);
        this.mainPanel.add((Widget)this.contentPanel);
        Window.addResizeHandler((ResizeHandler)this);
        this.resize(Window.getClientHeight());
    }

    private void initFilterArea() {
        this.filterContainerPanel.setStyleName("report-filter-area");
        Label lblHeader = new Label("Activity Quick-Search");
        lblHeader.setStyleName("profile-name-label");
        this.filterContainerPanel.add((Widget)lblHeader);
        this.filterPanel = new ReportFilterPanel();
        this.filterPanel.addSearchParamListener((ReportSearchParamListener)this);
        this.filterContainerPanel.add((Widget)this.filterPanel);
    }

    private void initResultsArea() {
        this.resultsPanel = new ReportResultPanel(this.filterPanel);
    }

    public void searchParamsChanged() {
        this.resultsPanel.refresh();
    }

    private void resize(int heigth) {
        int newHeight = heigth - 300;
        if (newHeight < 300) {
            newHeight = 300;
        }
        this.contentPanel.getElement().getStyle().setProperty("maxHeight", newHeight + "px");
        int nh = newHeight - 235;
        this.resultsPanel.getElement().getStyle().setProperty("maxHeight", nh + "px");
    }

    public void onResize(ResizeEvent event) {
        this.resize(event.getHeight());
    }
}

