/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.uicomps;

import com.github.gwtbootstrap.client.ui.resources.ResourceInjector;
import com.github.gwtbootstrap.datepicker.client.ui.resources.DatepickerResourceInjector;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimpleCheckBox;
import com.google.gwt.user.client.ui.Widget;
import de.cismet.projecttracker.client.ProjectTrackerEntryPoint;
import de.cismet.projecttracker.client.common.ui.DailyHoursOfWork;
import de.cismet.projecttracker.client.common.ui.ExtendedRecentTaskStory;
import de.cismet.projecttracker.client.common.ui.FavouriteTaskStory;
import de.cismet.projecttracker.client.common.ui.LockPanel;
import de.cismet.projecttracker.client.common.ui.RecentStory;
import de.cismet.projecttracker.client.common.ui.Story;
import de.cismet.projecttracker.client.common.ui.TaskNotice;
import de.cismet.projecttracker.client.common.ui.TaskStory;
import de.cismet.projecttracker.client.common.ui.TaskStoryControllerPanel;
import de.cismet.projecttracker.client.common.ui.WeekDatePicker;
import de.cismet.projecttracker.client.common.ui.event.MenuEvent;
import de.cismet.projecttracker.client.common.ui.event.TaskStoryEvent;
import de.cismet.projecttracker.client.common.ui.event.TimeStoryEvent;
import de.cismet.projecttracker.client.common.ui.listener.MenuListener;
import de.cismet.projecttracker.client.common.ui.listener.TaskStoryListener;
import de.cismet.projecttracker.client.common.ui.listener.TimeStoryListener;
import de.cismet.projecttracker.client.dto.ActivityDTO;
import de.cismet.projecttracker.client.dto.ContractDTO;
import de.cismet.projecttracker.client.dto.ProfileDTO;
import de.cismet.projecttracker.client.dto.StaffDTO;
import de.cismet.projecttracker.client.exceptions.InvalidInputValuesException;
import de.cismet.projecttracker.client.helper.DateHelper;
import de.cismet.projecttracker.client.uicomps.SheetsPanel;
import de.cismet.projecttracker.client.utilities.TimeCalculator;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SheetsPanel
extends Composite
implements ResizeHandler,
ClickHandler,
ChangeHandler,
TaskStoryListener,
TimeStoryListener,
MenuListener,
ValueChangeHandler<Date> {
    private static final String WEEKLY_HOURS_OF_WORK = "Total: ";
    private static final String PREVIOUS_WEEK_BALANCE = "prev. Week Bal.: ";
    private static final String ACCOUNT_BALANCE = "Acc. Bal.: ";
    private static final String WEEK_BALANCE = "Week Bal.: ";
    private static final int TRAVEL_WORK_CATEGORY = 4;
    private FlowPanel mainPanel = new FlowPanel();
    private FlowPanel pageHeaderPanel = new FlowPanel();
    private FlowPanel contentNodeParentPanel = new FlowPanel();
    private FlowPanel contentNodePanel = new FlowPanel();
    private FlowPanel taskContentNodePanel = new FlowPanel();
    private FlowPanel controlPanel = new FlowPanel();
    private FlowPanel buttonPanel = new FlowPanel();
    private TaskStoryControllerPanel taskControlPanel = new TaskStoryControllerPanel();
    private Button prevWeek = new Button("previous week", (ClickHandler)this);
    private Button nextWeek = new Button("next week", (ClickHandler)this);
    private Story times = new Story();
    private FavouriteTaskStory favs = new FavouriteTaskStory();
    private TaskStory tasks;
    private RecentStory recent = new RecentStory();
    private ExtendedRecentTaskStory allRecent = new ExtendedRecentTaskStory();
    private DailyHoursOfWork dailyHours = new DailyHoursOfWork();
    private LockPanel lockPanel = new LockPanel();
    private Label weekHoursLab = new Label("Total: ");
    private Label accountBalanceLab = new Label("Acc. Bal.: ");
    private Label previousWeekBalLab = new Label("prev. Week Bal.: ");
    private Label weekBalanceLab = new Label("Week Bal.: ");
    private Label weekDates = new Label();
    private Label weekLockLab = new Label("Lock Week: ");
    private long lastAccountBalanceCalc = 0L;
    private SimpleCheckBox weekLockCB = new SimpleCheckBox();
    private WeekDatePicker datePicker;
    private Button datePickerButton = new Button("<i class='icon-calendar'></i>", (ClickHandler)this);
    private boolean isDatePickerVisible = false;
    private int requestNumber = 0;

    public SheetsPanel() {
        this.tasks = new TaskStory(this.times);
        this.init();
        this.initWidget((Widget)this.mainPanel);
        this.setStyleName("content");
        this.tasks.addTaskStoryListener((TaskStoryListener)this);
        this.times.addTimeStoryListener((TimeStoryListener)this);
        this.tasks.setLockPanel(this.lockPanel);
    }

    private void init() {
        Label yearLab = new Label("Year:");
        Label weekLab = new Label("Week:");
        this.pageHeaderPanel.setStyleName("page-header");
        this.contentNodeParentPanel.setStyleName("span12");
        this.recent.setStyleName("my-recent-tasks pull-left pre prettyprint noxoverflow");
        this.allRecent.setStyleName("recent-tasks pull-left pre prettyprint noxoverflow");
        this.favs.setStyleName("fav-tasks pull-right pre prettyprint noxoverflow");
        this.contentNodePanel.addStyleName("times-panel pre prettyprint noxoverflow");
        this.contentNodePanel.add((Widget)this.times);
        this.taskContentNodePanel.addStyleName("contentNode pre prettyprint verticalScroller");
        this.taskContentNodePanel.setWidth("802px");
        this.taskContentNodePanel.add((Widget)this.tasks);
        this.contentNodeParentPanel.add((Widget)this.contentNodePanel);
        this.contentNodeParentPanel.add((Widget)this.dailyHours);
        this.contentNodeParentPanel.add((Widget)this.lockPanel);
        this.contentNodeParentPanel.add((Widget)this.taskContentNodePanel);
        this.contentNodeParentPanel.add((Widget)this.taskControlPanel);
        this.controlPanel.setStyleName("pull-center");
        yearLab.setStyleName("formLabel");
        weekLab.setStyleName("formLabel");
        this.weekDates.setStyleName("formLabel weekDates");
        this.weekHoursLab.setStyleName("formLabel totalLab");
        this.weekBalanceLab.setStyleName("formLabel accountBalanceLab");
        this.weekLockLab.setStyleName("formlabel");
        this.prevWeek.addStyleName("btn btn-primary pull-left span3");
        this.nextWeek.addStyleName("btn btn-info pull-right span3");
        FlowPanel upperCtrlPanel = new FlowPanel();
        ResourceInjector.configure();
        DatepickerResourceInjector.configure();
        this.datePicker = new WeekDatePicker();
        this.datePicker.setFormat("dd.mm.yyyy");
        this.datePicker.setAutoClose(true);
        this.datePicker.setStyleName("datepickerTextBox");
        this.datePicker.setWeekStart(1);
        this.datePicker.addValueChangeHandler((ValueChangeHandler)this);
        this.datePicker.setValue(DateHelper.getBeginOfWeek((int)DateHelper.getYear((Date)new Date()), (int)DateHelper.getWeekOfYear((Date)new Date())));
        Date lastDay = new Date(this.datePicker.getValue().getTime());
        DateHelper.addDays((Date)lastDay, (int)6);
        this.weekDates.setText(" - Sun.: " + DateHelper.formatShortDate((Date)lastDay) + "." + DateHelper.getYear((Date)lastDay));
        Label mondayLab = new Label("Mon.:");
        mondayLab.setStyleName("formLabel");
        upperCtrlPanel.add((Widget)mondayLab);
        upperCtrlPanel.add((Widget)this.datePicker);
        upperCtrlPanel.add((Widget)this.weekDates);
        this.datePickerButton.setWidth("10px;");
        this.datePickerButton.addStyleName("btn");
        this.datePickerButton.setTitle("Click to select a week");
        upperCtrlPanel.add((Widget)this.datePickerButton);
        FlowPanel lowerCtrlPanel = new FlowPanel();
        lowerCtrlPanel.addStyleName("lowerCtrlPanel-margin");
        lowerCtrlPanel.add((Widget)this.weekHoursLab);
        lowerCtrlPanel.add((Widget)this.weekBalanceLab);
        lowerCtrlPanel.add((Widget)this.weekLockLab);
        this.weekLockCB.setTitle("Select to lock the entire week");
        lowerCtrlPanel.add((Widget)this.weekLockCB);
        this.weekLockCB.addClickHandler((ClickHandler)this);
        this.controlPanel.add((Widget)upperCtrlPanel);
        this.controlPanel.add((Widget)lowerCtrlPanel);
        this.buttonPanel.add((Widget)this.prevWeek);
        this.buttonPanel.add((Widget)this.nextWeek);
        this.buttonPanel.add((Widget)this.controlPanel);
        this.pageHeaderPanel.add((Widget)this.buttonPanel);
        FlowPanel whoPrevWeekLabel = new FlowPanel();
        whoPrevWeekLabel.addStyleName("howPrevWeek pull-left pre prettyprint noxoverflow");
        whoPrevWeekLabel.add((Widget)this.previousWeekBalLab);
        FlowPanel accountBalancePanel = new FlowPanel();
        accountBalancePanel.addStyleName("accountBalance pull-right pre prettyprint noxoverflow");
        accountBalancePanel.add((Widget)this.accountBalanceLab);
        this.mainPanel.add((Widget)whoPrevWeekLabel);
        this.mainPanel.add((Widget)this.allRecent);
        this.mainPanel.add((Widget)this.recent);
        this.mainPanel.add((Widget)accountBalancePanel);
        this.mainPanel.add((Widget)this.favs);
        this.mainPanel.add((Widget)this.pageHeaderPanel);
        this.mainPanel.add((Widget)this.contentNodeParentPanel);
    }

    public int getSelectedWeek() {
        return DateHelper.getWeekOfYear((Date)this.datePicker.getValue());
    }

    public int getSelectedYear() {
        return DateHelper.getYear((Date)this.datePicker.getValue());
    }

    public void onResize(ResizeEvent event) {
        int newHeight = event.getHeight() - this.contentNodePanel.getAbsoluteTop() - 145 - this.contentNodePanel.getOffsetHeight() - 50;
        if (newHeight < 150) {
            newHeight = 150;
        }
        this.taskContentNodePanel.setHeight(newHeight + "px");
        this.tasks.setHeight(newHeight + "px");
        this.recent.setHeight((newHeight += this.contentNodePanel.getOffsetHeight() + 110) + "px");
        this.allRecent.setHeight(newHeight + "px");
        this.favs.setHeight(newHeight + "px");
    }

    public void onClick(ClickEvent event) {
        if (event.getSource() == this.prevWeek) {
            Date d = this.datePicker.getValue();
            DateHelper.addDays((Date)d, (int)-7);
            if (d.getDay() != 1) {
                this.datePicker.setValue(DateHelper.getBeginOfWeek((Date)d));
            }
            Date lastDay = (Date)d.clone();
            DateHelper.addDays((Date)lastDay, (int)6);
            this.weekDates.setText(" - Sun.: " + DateHelper.formatShortDate((Date)lastDay) + "." + DateHelper.getYear((Date)lastDay));
            this.datePicker.setValue(d);
        } else if (event.getSource() == this.nextWeek) {
            Date d = this.datePicker.getValue();
            DateHelper.addDays((Date)d, (int)7);
            if (d.getDay() != 1) {
                this.datePicker.setValue(DateHelper.getBeginOfWeek((Date)d));
            }
            Date lastDay = (Date)d.clone();
            DateHelper.addDays((Date)lastDay, (int)6);
            this.weekDates.setText(" - Sun.: " + DateHelper.formatShortDate((Date)lastDay) + "." + DateHelper.getYear((Date)lastDay));
            this.datePicker.setValue(d);
        } else {
            if (event.getSource() == this.weekLockCB) {
                this.weekLockCB.setEnabled(false);
                if (!this.weekLockCB.getValue().booleanValue()) {
                    if (ProjectTrackerEntryPoint.getInstance().isAdmin()) {
                        this.lockPanel.unlockAllDaysInWeek();
                    }
                } else {
                    this.lockPanel.lockAllDaysInWeek();
                }
                return;
            }
            if (event.getSource() == this.datePickerButton) {
                if (this.isDatePickerVisible) {
                    this.isDatePickerVisible = false;
                    this.datePicker.hide();
                } else {
                    this.isDatePickerVisible = true;
                    this.datePicker.show();
                }
            }
        }
        this.refresh();
    }

    public void refresh(Date d) {
        if (d.getDay() != 1) {
            d = DateHelper.getBeginOfWeek((Date)d);
        }
        this.datePicker.setValue(d);
        Date lastDay = (Date)d.clone();
        DateHelper.addDays((Date)lastDay, (int)6);
        this.weekDates.setText(" - Sun.: " + DateHelper.formatShortDate((Date)lastDay) + "." + DateHelper.getYear((Date)lastDay));
        this.datePicker.setValue(d);
        this.refresh();
    }

    public void refresh() {
        Date firstDay = this.datePicker.getValue();
        Date lastDay = new Date(firstDay.getTime());
        DateHelper.addDays((Date)lastDay, (int)6);
        int request = ++this.requestNumber;
        1 callback = new /* Unavailable Anonymous Inner Class!! */;
        ProjectTrackerEntryPoint.getProjectService((boolean)true).getActivityDataByWeek(ProjectTrackerEntryPoint.getInstance().getStaff(), firstDay, lastDay, (AsyncCallback)callback);
    }

    public void onChange(ChangeEvent event) {
        this.refresh();
    }

    public void refreshAccountBalance() {
        2 callback = new /* Unavailable Anonymous Inner Class!! */;
        if (System.currentTimeMillis() - this.lastAccountBalanceCalc > 100L) {
            this.lastAccountBalanceCalc = System.currentTimeMillis();
            ProjectTrackerEntryPoint.getProjectService((boolean)true).getAccountBalance(ProjectTrackerEntryPoint.getInstance().getStaff(), (AsyncCallback)callback);
        }
    }

    public void refreshWeeklyHoursOfWork() {
        double hours = 0.0;
        double weekDebit = 0.0;
        double hoursBillable = 0.0;
        double hoursWorked = 0.0;
        for (int i = 0; i < 7; ++i) {
            List taskList = this.tasks.getTasksForDay(i);
            for (TaskNotice tmp : taskList) {
                if (tmp.getActivity().getKindofactivity() == 0 && tmp.getActivity().getWorkPackage().getId() != 407L) {
                    hours += TimeCalculator.getWorkingHoursForActivity((ActivityDTO)tmp.getActivity());
                    hoursWorked += TimeCalculator.getWorkingHoursForActivity((ActivityDTO)tmp.getActivity());
                    hoursBillable += TimeCalculator.getBillableWorkingHoursForActivity((ActivityDTO)tmp.getActivity());
                    continue;
                }
                if (tmp.getActivity().getKindofactivity() != -1 && tmp.getActivity().getKindofactivity() != -2) continue;
                hours += TimeCalculator.getWorkingHoursForActivity((ActivityDTO)tmp.getActivity());
            }
        }
        double billableFactor = (double)Math.round(hoursBillable / hoursWorked * 100.0) / 100.0;
        this.weekHoursLab.setText("Total:  " + DateHelper.doubleToHours((double)hours) + " h (" + billableFactor + ")");
        try {
            Date d = this.datePicker.getValue();
            double whow = 0.0;
            for (int i = 0; i <= 4; ++i) {
                ContractDTO co = ProjectTrackerEntryPoint.getInstance().getContractForStaff(d);
                if (co != null) {
                    whow += co.getWhow() / 5.0;
                }
                DateHelper.addDays((Date)d, (int)1);
            }
            weekDebit = hours - whow;
        }
        catch (InvalidInputValuesException ex) {
            Logger.getLogger(SheetsPanel.class.getName()).log(Level.SEVERE, "Could not get valid Contract for Staff " + ProjectTrackerEntryPoint.getInstance().getStaff() + " and Week/year" + this.getSelectedWeek() + "/" + this.getSelectedYear(), ex);
        }
        this.weekBalanceLab.setText("Week Bal.:  " + DateHelper.doubleToHours((double)weekDebit) + " h");
    }

    private void refreshPrevWeekBalance() {
        int pyear;
        int pweek;
        if (this.getSelectedWeek() > 0) {
            pweek = this.getSelectedWeek() - 1;
            pyear = this.getSelectedYear();
        } else {
            pyear = this.getSelectedYear() + 1;
            pweek = this.getSelectedWeek() - 1;
        }
        TimeCalculator.getWorkingBalanceForWeek((int)pyear, (int)pweek, (StaffDTO)ProjectTrackerEntryPoint.getInstance().getStaff(), (Label)this.previousWeekBalLab, (String)PREVIOUS_WEEK_BALANCE);
    }

    private void refreshMyRecentTasks(TaskNotice tn) {
        long wpId;
        if (tn.getActivity().getKindofactivity() == 0 && (wpId = tn.getActivity().getWorkPackage().getId()) != 408L) {
            TaskNotice newTaskNotice = new TaskNotice(tn.getActivity(), true);
            Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public Story getTimes() {
        return this.times;
    }

    public void taskNoticeCreated(TaskStoryEvent e) {
        this.refreshWeeklyHoursOfWork();
        this.refreshAccountBalance();
        this.refreshMyRecentTasks(e.getTaskNotice());
    }

    public void taskNoticeChanged(TaskStoryEvent e) {
        this.refreshWeeklyHoursOfWork();
        this.refreshAccountBalance();
        this.refreshMyRecentTasks(e.getTaskNotice());
    }

    public void taskNoticeDeleted(TaskStoryEvent e) {
        this.refreshWeeklyHoursOfWork();
        this.refreshAccountBalance();
    }

    public void timeNoticeCreated(TimeStoryEvent e) {
        this.refreshWeeklyHoursOfWork();
        this.refreshAccountBalance();
    }

    public void timeNoticeChanged(TimeStoryEvent e) {
        this.refreshWeeklyHoursOfWork();
        this.refreshAccountBalance();
    }

    public void timeNoticeDeleted(TimeStoryEvent e) {
        this.refreshWeeklyHoursOfWork();
        this.refreshAccountBalance();
    }

    public void menuChangeEvent(MenuEvent e) {
        if (e.getNumber() == 1) {
            4 t = new /* Unavailable Anonymous Inner Class!! */;
            t.schedule(500);
        }
    }

    public void onValueChange(ValueChangeEvent<Date> event) {
        this.isDatePickerVisible = false;
        Date d = (Date)event.getValue();
        if (d.getDay() != 1) {
            this.datePicker.setValue(DateHelper.getBeginOfWeek((Date)d));
        }
        Date lastDay = new Date(this.datePicker.getValue().getTime());
        DateHelper.addDays((Date)lastDay, (int)6);
        this.weekDates.setText(" - Sun.: " + DateHelper.formatShortDate((Date)lastDay) + "." + DateHelper.getYear((Date)lastDay));
        this.refresh();
    }

    public void setLockComponents() {
        ProfileDTO profile;
        StaffDTO staff = ProjectTrackerEntryPoint.getInstance().getLoggedInStaff();
        if (staff != null && (profile = staff.getProfile()) != null) {
            if (profile.getWeekLockModeEnabled()) {
                this.weekLockCB.removeStyleName("noDisplay");
                this.weekLockLab.removeStyleName("noDisplay");
            } else {
                this.weekLockCB.addStyleName("noDisplay");
                this.weekLockLab.addStyleName("noDisplay");
            }
            if (profile.getDayLockModeEnabled()) {
                this.lockPanel.removeStyleName("noDisplay");
            } else {
                this.lockPanel.addStyleName("noDisplay");
            }
        }
    }

    static /* synthetic */ int access$000(SheetsPanel x0) {
        return x0.requestNumber;
    }

    static /* synthetic */ TaskStory access$100(SheetsPanel x0) {
        return x0.tasks;
    }

    static /* synthetic */ Story access$200(SheetsPanel x0) {
        return x0.times;
    }

    static /* synthetic */ SimpleCheckBox access$300(SheetsPanel x0) {
        return x0.weekLockCB;
    }

    static /* synthetic */ Button access$400(SheetsPanel x0) {
        return x0.prevWeek;
    }

    static /* synthetic */ Button access$500(SheetsPanel x0) {
        return x0.nextWeek;
    }

    static /* synthetic */ LockPanel access$600(SheetsPanel x0) {
        return x0.lockPanel;
    }

    static /* synthetic */ TaskStoryControllerPanel access$700(SheetsPanel x0) {
        return x0.taskControlPanel;
    }

    static /* synthetic */ RecentStory access$800(SheetsPanel x0) {
        return x0.recent;
    }

    static /* synthetic */ FavouriteTaskStory access$900(SheetsPanel x0) {
        return x0.favs;
    }

    static /* synthetic */ ExtendedRecentTaskStory access$1000(SheetsPanel x0) {
        return x0.allRecent;
    }

    static /* synthetic */ DailyHoursOfWork access$1100(SheetsPanel x0) {
        return x0.dailyHours;
    }

    static /* synthetic */ void access$1200(SheetsPanel x0) {
        x0.refreshPrevWeekBalance();
    }

    static /* synthetic */ Label access$1300(SheetsPanel x0) {
        return x0.accountBalanceLab;
    }
}

