/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.uicomps;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import de.cismet.projecttracker.client.ImageConstants;
import de.cismet.projecttracker.client.MessageConstants;
import de.cismet.projecttracker.client.ProjectTrackerEntryPoint;
import de.cismet.projecttracker.client.common.ui.LoginPanel;
import de.cismet.projecttracker.client.common.ui.event.MenuEvent;
import de.cismet.projecttracker.client.common.ui.listener.MenuListener;
import de.cismet.projecttracker.client.dto.StaffDTO;
import de.cismet.projecttracker.client.uicomps.ProfilePanel;
import de.cismet.projecttracker.client.uicomps.ReportsPanel;
import de.cismet.projecttracker.client.uicomps.TopPanel;
import java.util.ArrayList;
import java.util.List;

public class TopPanel
extends Composite
implements ClickHandler,
ChangeHandler {
    public static final int SHEETS = 1;
    public static final int REPORTS = 2;
    public static final int PROFILE = 3;
    private static final MessageConstants MESSAGES = (MessageConstants)GWT.create(MessageConstants.class);
    private Image logo = new Image(ImageConstants.INSTANCE.cLogo());
    private FlowPanel topPanel = new FlowPanel();
    private FlowPanel containerPanel = new FlowPanel();
    private LoginPanel loginPanel = new LoginPanel();
    private FlowPanel userPanel = new FlowPanel();
    private Label sheetsLab = new Label("Sheets");
    private Label reportsLab = new Label("Reports");
    private Label profileLab = new Label("Profile");
    private Label logoLab = new Label("cismet Tracker");
    private Label activeLab = this.sheetsLab;
    private ListBox user = new ListBox();
    private List<MenuListener> listener = new ArrayList();
    private List<StaffDTO> userList = new ArrayList();
    private ProfilePanel profilePanel = null;
    private ReportsPanel reportsPanel = null;
    private boolean loggedIn = false;
    private List<ChangeHandler> changeListeners = new ArrayList();

    public TopPanel() {
        this.init();
        this.topPanel.setWidth("100%");
        this.setActiveLab();
        this.initWidget((Widget)this.topPanel);
        this.user.addChangeHandler((ChangeHandler)this);
    }

    private void init() {
        this.user.setWidth("150px");
        this.containerPanel.add((Widget)this.logo);
        this.containerPanel.add((Widget)this.logoLab);
        this.containerPanel.add((Widget)this.sheetsLab);
        this.containerPanel.add((Widget)this.reportsLab);
        this.containerPanel.add((Widget)this.profileLab);
        this.containerPanel.add((Widget)this.userPanel);
        this.containerPanel.add((Widget)this.loginPanel);
        this.topPanel.add((Widget)this.containerPanel);
        this.logo.setStyleName("cismet-logo");
        this.logoLab.setStyleName("brand");
        this.loginPanel.setStyleName("pull-right loginPanel");
        this.userPanel.setStyleName("pull-left userList");
        this.containerPanel.setStyleName("container");
        this.sheetsLab.setStyleName("LabelLink");
        this.reportsLab.setStyleName("LabelLink");
        this.profileLab.setStyleName("LabelLink");
        this.topPanel.setStyleName("navbar-inner");
        this.sheetsLab.addClickHandler((ClickHandler)this);
        this.profileLab.addClickHandler((ClickHandler)this);
        this.reportsLab.addClickHandler((ClickHandler)this);
    }

    public void fillUser() {
        this.user.clear();
        if (!ProjectTrackerEntryPoint.getInstance().isAdmin()) {
            return;
        }
        1 callback = new /* Unavailable Anonymous Inner Class!! */;
        ProjectTrackerEntryPoint.getProjectService((boolean)true).getCurrentEmployees((AsyncCallback)callback);
        this.userPanel.add((Widget)this.user);
    }

    private void setActiveLab() {
        this.sheetsLab.removeStyleDependentName("active");
        this.reportsLab.removeStyleDependentName("active");
        this.profileLab.removeStyleDependentName("active");
        this.activeLab.addStyleDependentName("active");
    }

    public void addSignOutListener(ClickHandler handler) {
    }

    public void onClick(ClickEvent event) {
        if (this.loggedIn) {
            this.activeLab = (Label)event.getSource();
            this.setActiveLab();
            MenuEvent newEvent = new MenuEvent();
            newEvent.setSource((Object)this);
            if (this.activeLab == this.sheetsLab) {
                newEvent.setNumber(1);
            } else if (this.activeLab == this.reportsLab) {
                if (this.reportsPanel == null) {
                    this.reportsPanel = new ReportsPanel();
                    this.addMenuListener((MenuListener)this.reportsPanel);
                }
                newEvent.setNumber(2);
            } else if (this.activeLab == this.profileLab) {
                if (this.profilePanel == null) {
                    this.profilePanel = new ProfilePanel();
                    this.addChangeListener((ChangeHandler)this.profilePanel);
                    this.addMenuListener((MenuListener)this.profilePanel);
                }
                newEvent.setNumber(3);
            }
            this.fireMenuChangeEvent(newEvent);
        } else {
            ProjectTrackerEntryPoint.outputBox((String)"Please first log in!");
        }
    }

    public void addMenuListener(MenuListener l) {
        this.listener.add(l);
    }

    public void removeMenuListener(MenuListener l) {
        this.listener.remove(l);
    }

    public void fireMenuChangeEvent(MenuEvent e) {
        for (MenuListener l : this.listener) {
            l.menuChangeEvent(e);
        }
    }

    public void addChangeListener(ChangeHandler l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeHandler l) {
        this.changeListeners.remove(l);
    }

    public void fireChangeEvent(ChangeEvent e) {
        for (ChangeHandler l : this.changeListeners) {
            l.onChange(e);
        }
    }

    public void setLoggedIn(boolean loggedIn, String user) {
        this.loginPanel.setLoggedIn(loggedIn, user);
        if (!loggedIn) {
            this.activeLab = this.sheetsLab;
            this.setActiveLab();
        } else {
            this.loggedIn = true;
        }
        this.profilePanel = null;
    }

    public void setGravatar(String url) {
        this.loginPanel.setGravatar(url);
    }

    public void onChange(ChangeEvent event) {
        ProjectTrackerEntryPoint.getInstance().setStaff(this.getSelectedStaff());
        MenuEvent e = new MenuEvent();
        e.setSource((Object)this);
        this.fireMenuChangeEvent(e);
        this.fireChangeEvent(event);
    }

    private StaffDTO getSelectedStaff() {
        try {
            long value = Long.parseLong(this.user.getValue(this.user.getSelectedIndex()));
            for (StaffDTO staff : this.userList) {
                if (staff.getId() != value) continue;
                return staff;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public void removeUserList() {
        this.userPanel.remove((Widget)this.user);
    }

    static /* synthetic */ ListBox access$000(TopPanel x0) {
        return x0.user;
    }

    static /* synthetic */ List access$102(TopPanel x0, List x1) {
        x0.userList = x1;
        return x0.userList;
    }
}

