/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.utilities;

import com.google.gwt.user.client.rpc.AsyncCallback;
import de.cismet.projecttracker.client.ProjectTrackerEntryPoint;
import de.cismet.projecttracker.client.common.ui.TaskNotice;
import de.cismet.projecttracker.client.common.ui.TaskStory;
import de.cismet.projecttracker.client.common.ui.event.TaskStoryEvent;
import de.cismet.projecttracker.client.common.ui.listener.TaskStoryListener;
import de.cismet.projecttracker.client.dto.ActivityDTO;
import de.cismet.projecttracker.client.dto.ContractDTO;
import de.cismet.projecttracker.client.exceptions.InvalidInputValuesException;
import de.cismet.projecttracker.client.utilities.IllnessChecker;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IllnessChecker
implements TaskStoryListener {
    private TaskStory story;

    public IllnessChecker(TaskStory story) {
        this.story = story;
    }

    public void taskNoticeCreated(TaskStoryEvent e) {
        this.checkIllnesConstraints(e.getTaskNotice());
    }

    public void taskNoticeChanged(TaskStoryEvent e) {
        this.checkIllnesConstraints(e.getTaskNotice());
    }

    public void taskNoticeDeleted(TaskStoryEvent e) {
        this.checkIllnesConstraints(e.getTaskNotice());
    }

    private void checkIllnesConstraints(TaskNotice taskNotice) {
        ActivityDTO newActivity = taskNotice.getActivity();
        Date day = newActivity.getDay();
        1 cb = new /* Unavailable Anonymous Inner Class!! */;
        ProjectTrackerEntryPoint.getProjectService((boolean)true).isDayLocked(day, newActivity.getStaff(), (AsyncCallback)cb);
    }

    private void performIllnessCheck(TaskNotice taskNotice) {
        ActivityDTO newActivity = taskNotice.getActivity();
        Date day = newActivity.getDay();
        List tasks = this.story.getTasksForDay(day.getDay());
        try {
            ContractDTO contract = ProjectTrackerEntryPoint.getInstance().getContractForStaff(day);
            if (contract == null) {
                Logger.getLogger(IllnessChecker.class.getName()).log(Level.SEVERE, "Could not get valid Contract for Staff " + ProjectTrackerEntryPoint.getInstance().getStaff() + " and date" + day.toString());
                return;
            }
            double whow = contract.getWhow() / 5.0;
            double whNonIllnes = 0.0;
            LinkedList<TaskNotice> illnessAct = new LinkedList<TaskNotice>();
            boolean needed = false;
            for (TaskNotice tn : tasks) {
                if (tn.getActivity().getWorkPackage() == null) continue;
                if (tn.getActivity().getWorkPackage().getId() == 410L) {
                    illnessAct.add(tn);
                    continue;
                }
                if (tn.getActivity().getWorkPackage().getId() == 408L) continue;
                needed = true;
                whNonIllnes += tn.getActivity().getWorkinghours();
            }
            int illnessActCount = illnessAct.size();
            if (illnessActCount >= 1 && needed) {
                double time = (whow - whNonIllnes) / (double)illnessActCount;
                boolean hasChanged = false;
                for (TaskNotice tn : illnessAct) {
                    if (time > 0.0) {
                        if (Math.abs(tn.getActivity().getWorkinghours() - time) > 0.01) {
                            hasChanged = true;
                        }
                        tn.getActivity().setWorkinghours(time);
                    } else {
                        if (tn.getActivity().getWorkinghours() != -1.0) {
                            hasChanged = true;
                        }
                        tn.getActivity().setWorkinghours(-1.0);
                    }
                    if (!hasChanged) continue;
                    2 cb = new /* Unavailable Anonymous Inner Class!! */;
                    ProjectTrackerEntryPoint.getProjectService((boolean)true).saveActivity(tn.getActivity(), (AsyncCallback)cb);
                }
            }
        }
        catch (InvalidInputValuesException ex) {
            Logger.getLogger(IllnessChecker.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static /* synthetic */ void access$000(IllnessChecker x0, TaskNotice x1) {
        x0.performIllnessCheck(x1);
    }
}

