/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.utilities;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import de.cismet.projecttracker.client.ProjectTrackerEntryPoint;
import de.cismet.projecttracker.client.dto.ActivityDTO;
import de.cismet.projecttracker.client.dto.ContractDTO;
import de.cismet.projecttracker.client.dto.StaffDTO;
import de.cismet.projecttracker.client.exceptions.InvalidInputValuesException;
import de.cismet.projecttracker.client.utilities.TimeCalculator;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class TimeCalculator {
    public static double getWorkingHoursForActivity(ActivityDTO act, boolean calculatePause) {
        double hours = 0.0;
        double dhow = 0.0;
        ContractDTO contract = null;
        if (act.getStaff() == null) {
            try {
                contract = ProjectTrackerEntryPoint.getInstance().getContractForStaff(act.getDay());
            }
            catch (InvalidInputValuesException ex) {
                Logger.getLogger(TimeCalculator.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            contract = TimeCalculator.getContractForDay((StaffDTO)act.getStaff(), (Date)act.getDay());
        }
        if (contract != null) {
            dhow = contract.getWhow() / 5.0;
        }
        if (calculatePause && act.getWorkCategory() != null && act.getWorkPackage().getId() == 408L) {
            return act.getWorkinghours();
        }
        if (act.getKindofactivity() == -1) {
            hours += dhow;
        } else if (act.getKindofactivity() == -2) {
            hours += dhow / 2.0;
        } else if (act.getWorkPackage() != null && act.getWorkPackage().getId() != 408L) {
            if (act.getWorkPackage().getId() == 409L || act.getWorkPackage().getId() == 419L) {
                hours = act.getWorkinghours() == 0.0 && dhow > 0.0 ? (hours += dhow) : (hours += act.getWorkinghours());
            } else if (act.getWorkPackage().getId() == 410L) {
                if (act.getWorkinghours() == 0.0 && dhow > 0.0) {
                    hours += dhow;
                } else if (act.getWorkinghours() != -1.0) {
                    hours += act.getWorkinghours();
                }
            } else {
                hours += act.getWorkinghours();
            }
        }
        return hours;
    }

    public static double getBillableWorkingHoursForActivity(ActivityDTO act) {
        if (act.getWorkPackage() != null && act.getWorkPackage().getCostCategory() != null && act.getWorkPackage().getCostCategory().getName().equalsIgnoreCase("fakturierbar")) {
            return act.getWorkinghours();
        }
        return 0.0;
    }

    public static double getWorkingHoursForActivity(ActivityDTO act) {
        return TimeCalculator.getWorkingHoursForActivity((ActivityDTO)act, (boolean)false);
    }

    public static void getWorkingHoursForWeek(int year, int week, StaffDTO s, Label l, String prefix) {
        1 callback = new /* Unavailable Anonymous Inner Class!! */;
        ProjectTrackerEntryPoint.getProjectService((boolean)true).getActivityDataByWeek(s, year, week, (AsyncCallback)callback);
    }

    public static void getWorkingBalanceForWeek(int year, int week, StaffDTO s, Label l, String prefix) {
        2 callback = new /* Unavailable Anonymous Inner Class!! */;
        ProjectTrackerEntryPoint.getProjectService((boolean)true).getActivityDataByWeek(ProjectTrackerEntryPoint.getInstance().getStaff(), year, week, (AsyncCallback)callback);
    }

    public static ContractDTO getContractForDay(StaffDTO s, Date d) {
        if (s != null && s.getContracts() != null && !s.getContracts().isEmpty()) {
            for (ContractDTO contract : s.getContracts()) {
                if (!contract.getFromdate().before(d) || contract.getTodate() != null && !contract.getTodate().after(d)) continue;
                return contract;
            }
        }
        return null;
    }
}

