/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.server;

import de.cismet.projecttracker.client.exceptions.DataRetrievalException;
import de.cismet.projecttracker.client.exceptions.LoginFailedException;
import de.cismet.projecttracker.client.exceptions.NoSessionException;
import de.cismet.projecttracker.client.exceptions.PermissionDenyException;
import de.cismet.projecttracker.report.db.entities.Staff;
import de.cismet.projecttracker.report.db.entities.StaffExtern;
import de.cismet.projecttracker.report.query.DBManager;
import de.cismet.projecttracker.server.SessionInformation;
import de.cismet.projecttracker.utilities.LanguageBundle;
import java.security.MessageDigest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class BasicServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(BasicServlet.class);

    protected void checkAdminPermission(HttpServletRequest request) throws PermissionDenyException, NoSessionException {
        try {
            SessionInformation sessionInfo = this.getCurrentSession(request);
            if (!sessionInfo.isAdmin()) {
                throw new PermissionDenyException(LanguageBundle.ONLY_ALLOWED_FOR_ADMIN);
            }
        }
        catch (NoSessionException e) {
            throw e;
        }
        catch (Throwable th) {
            throw new PermissionDenyException(LanguageBundle.ONLY_ALLOWED_FOR_ADMIN);
        }
    }

    protected SessionInformation getCurrentSession(HttpServletRequest request) throws NoSessionException {
        if (request.getSession() == null) {
            throw new NoSessionException();
        }
        SessionInformation sessionInfo = (SessionInformation)request.getSession().getAttribute("sessionInfo");
        if (sessionInfo == null) {
            throw new NoSessionException();
        }
        return sessionInfo;
    }

    public Object checklogin(String username, String pasword, HttpSession session, DBManager dbManager) throws LoginFailedException, DataRetrievalException {
        try {
            Session hibernateSession = dbManager.getSession();
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(pasword.getBytes());
            byte[] sha1 = md.digest();
            Staff staff = (Staff)hibernateSession.createCriteria(Staff.class).add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"username", (Object)username), (Criterion)Restrictions.eq((String)"password", (Object)sha1))).uniqueResult();
            if (staff == null) {
                StaffExtern staffExtern = (StaffExtern)hibernateSession.createCriteria(StaffExtern.class).add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"username", (Object)username), (Criterion)Restrictions.eq((String)"password", (Object)sha1))).uniqueResult();
                return staffExtern;
            }
            return staff;
        }
        catch (Throwable t) {
            logger.error((Object)"Error:", t);
            throw new DataRetrievalException(t.getMessage(), t);
        }
    }
}

