/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.server;

import de.cismet.projecttracker.client.exceptions.DataRetrievalException;
import de.cismet.projecttracker.client.exceptions.InvalidInputValuesException;
import de.cismet.projecttracker.client.exceptions.NoSessionException;
import de.cismet.projecttracker.client.exceptions.PermissionDenyException;
import de.cismet.projecttracker.report.db.entities.ContractDocument;
import de.cismet.projecttracker.report.db.entities.TravelDocument;
import de.cismet.projecttracker.report.query.DBManager;
import de.cismet.projecttracker.server.BasicServlet;
import de.cismet.projecttracker.server.ConfigurationManager;
import de.cismet.projecttracker.utilities.LanguageBundle;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DocumentDownload
extends BasicServlet {
    private static final Logger logger = Logger.getLogger(DocumentDownload.class);
    private static final String HTML_TEMPLATE = "<html><head></head><body>%s</body></html>";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String urlExtension = null;
        String id = request.getParameter("id");
        String docType = request.getParameter("docType");
        response.setContentType("text/html;charset=UTF-8");
        try {
            this.checkAdminPermission(request);
            if (request.getPathInfo() != null) {
                urlExtension = request.getPathInfo().substring(1);
            }
            if (urlExtension == null || urlExtension.equals("")) {
                this.redirect(id, request.getRequestURI(), response, docType);
            } else {
                this.returnFile(id, response, docType);
            }
        }
        catch (PermissionDenyException e) {
            PrintWriter out = response.getWriter();
            out.print("permission deny");
            out.close();
        }
        catch (NoSessionException e) {
            PrintWriter out = response.getWriter();
            out.print("session expired");
            out.close();
        }
        catch (Exception e) {
            PrintWriter out = response.getWriter();
            out.println(String.format(HTML_TEMPLATE, e.getMessage()));
            out.close();
        }
    }

    private void redirect(String id, String uri, HttpServletResponse response, String docType) throws IOException, DataRetrievalException, InvalidInputValuesException {
        String docName;
        if (docType.equals("contract")) {
            docName = this.getContractDocument(id).getDocumentname();
        } else if (docType.equals("travel")) {
            docName = this.getTravelDocument(id).getDocumentname();
        } else {
            throw new InvalidInputValuesException(LanguageBundle.DOCUMENT_NOT_FOUND);
        }
        String newUrl = uri + "/" + docName + "?id=" + id + "&docType=" + docType;
        response.sendRedirect(response.encodeRedirectURL(newUrl));
    }

    private ContractDocument getContractDocument(String id) throws DataRetrievalException {
        DBManager dbManager = new DBManager(ConfigurationManager.getInstance().getConfBaseDir());
        try {
            ContractDocument doc = (ContractDocument)dbManager.getObject(ContractDocument.class, new Long(id).longValue());
            if (doc != null) {
                ContractDocument contractDocument = doc;
                return contractDocument;
            }
            try {
                throw new DataRetrievalException(LanguageBundle.DOCUMENT_NOT_FOUND);
            }
            catch (Throwable t) {
                logger.error((Object)t.getMessage(), t);
                throw new DataRetrievalException(t.getMessage());
            }
        }
        finally {
            if (dbManager != null) {
                dbManager.closeSession();
            }
        }
    }

    private TravelDocument getTravelDocument(String id) throws DataRetrievalException {
        DBManager dbManager = new DBManager(ConfigurationManager.getInstance().getConfBaseDir());
        try {
            TravelDocument doc = (TravelDocument)dbManager.getObject(TravelDocument.class, new Long(id).longValue());
            if (doc != null) {
                TravelDocument travelDocument = doc;
                return travelDocument;
            }
            try {
                throw new DataRetrievalException(LanguageBundle.DOCUMENT_NOT_FOUND);
            }
            catch (Throwable t) {
                logger.error((Object)t.getMessage(), t);
                throw new DataRetrievalException(t.getMessage());
            }
        }
        finally {
            if (dbManager != null) {
                dbManager.closeSession();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnFile(String id, HttpServletResponse response, String docType) throws IOException, DataRetrievalException, InvalidInputValuesException {
        byte[] document;
        String mimeType;
        ContractDocument doc;
        ServletOutputStream out = response.getOutputStream();
        if (docType.equals("contract")) {
            doc = this.getContractDocument(id);
            mimeType = doc.getMimetype();
            document = doc.getDocument();
        } else if (docType.equals("travel")) {
            doc = this.getTravelDocument(id);
            mimeType = doc.getMimetype();
            document = doc.getDocument();
        } else {
            throw new InvalidInputValuesException(LanguageBundle.DOCUMENT_NOT_FOUND);
        }
        if (mimeType != null) {
            response.setContentType(mimeType);
        }
        try {
            out.write(document);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            out.close();
        }
    }
}

