/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.server;

import de.cismet.projecttracker.client.exceptions.NoSessionException;
import de.cismet.projecttracker.client.exceptions.PermissionDenyException;
import de.cismet.projecttracker.client.exceptions.PersistentLayerException;
import de.cismet.projecttracker.report.db.entities.Contract;
import de.cismet.projecttracker.report.db.entities.ContractDocument;
import de.cismet.projecttracker.report.db.entities.Travel;
import de.cismet.projecttracker.report.db.entities.TravelDocument;
import de.cismet.projecttracker.report.query.DBManager;
import de.cismet.projecttracker.server.BasicServlet;
import de.cismet.projecttracker.server.ConfigurationManager;
import de.cismet.projecttracker.server.UploadDocumentType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.Logger;

public class DocumentUpload
extends BasicServlet {
    private static final Logger logger = Logger.getLogger(DocumentUpload.class);
    private static final ResourceBundle CONFIG = ResourceBundle.getBundle("de.cismet.projecttracker.MIMETypeMapping");

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        try {
            this.checkAdminPermission(request);
            if (request.getMethod().equals("POST")) {
                UploadDocumentType uploadDoc = this.getFileContent(request);
                String errors = uploadDoc.getErrors();
                if (errors == null) {
                    if (uploadDoc.getDocType().equals("contract")) {
                        this.saveContractDocument(uploadDoc);
                    } else if (uploadDoc.getDocType().equals("travel")) {
                        this.saveTravelDocument(uploadDoc);
                    }
                } else {
                    logger.error((Object)errors);
                    out.print(errors);
                }
            } else {
                logger.error((Object)"wrong method");
                out.print("wrong method");
            }
        }
        catch (PermissionDenyException e) {
            out.print("permission deny");
        }
        catch (NoSessionException e) {
            out.print("session expired");
        }
        catch (Exception e) {
            out.append(e.getMessage());
        }
        finally {
            out.close();
        }
    }

    private UploadDocumentType getFileContent(HttpServletRequest request) throws Exception {
        UploadDocumentType uploadDocument = new UploadDocumentType();
        DiskFileItemFactory itemFactory = new DiskFileItemFactory();
        ServletFileUpload fileUpload = new ServletFileUpload((FileItemFactory)itemFactory);
        List list = fileUpload.parseRequest(request);
        ByteArrayOutputStream fileContent = null;
        for (Object tmp : list) {
            if (!(tmp instanceof DiskFileItem)) continue;
            DiskFileItem item = (DiskFileItem)tmp;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("fieldName: " + item.getFieldName()));
            }
            if (item.getFieldName().equals("filePayload")) {
                int count;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"file payload found: ");
                }
                InputStream stream = item.getInputStream();
                byte[] buffer = new byte[256];
                fileContent = new ByteArrayOutputStream();
                while ((count = stream.read(buffer, 0, buffer.length)) != -1) {
                    fileContent.write(buffer, 0, count);
                }
                uploadDocument.setContent(fileContent.toByteArray());
                uploadDocument.setFileName(item.getName());
                uploadDocument.setMimeType(this.getMIMEType(item));
                continue;
            }
            if (item.getFieldName().equals("parentId")) {
                uploadDocument.setParentId(Long.parseLong(item.getString()));
                continue;
            }
            if (!item.getFieldName().equals("docType")) continue;
            uploadDocument.setDocType(item.getString());
        }
        return uploadDocument;
    }

    private String getMIMEType(DiskFileItem item) {
        String contentType = null;
        String fileName = item.getName();
        if (fileName.lastIndexOf(".") != -1 && !fileName.endsWith(".")) {
            String fileExtension = fileName.substring(fileName.lastIndexOf(".") + 1);
            try {
                contentType = CONFIG.getString(fileExtension);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (contentType == null) {
            contentType = item.getContentType();
        }
        return contentType;
    }

    private void saveContractDocument(UploadDocumentType uploadDoc) throws PersistentLayerException {
        DBManager dbManager = new DBManager(ConfigurationManager.getInstance().getConfBaseDir());
        ContractDocument doc = new ContractDocument();
        Contract tmpContract = new Contract();
        tmpContract.setId(uploadDoc.getParentId());
        doc.setDocument(uploadDoc.getContent());
        doc.setDocumentname(uploadDoc.getFileName());
        doc.setMimetype(uploadDoc.getMimeType());
        doc.setContract(tmpContract);
        try {
            dbManager.saveObject((Object)doc);
        }
        catch (Exception t) {
            logger.error((Object)"Error", (Throwable)t);
            throw new PersistentLayerException(t.getMessage(), (Throwable)t);
        }
        finally {
            dbManager.closeSession();
        }
    }

    private void saveTravelDocument(UploadDocumentType uploadDoc) throws PersistentLayerException {
        DBManager dbManager = new DBManager(ConfigurationManager.getInstance().getConfBaseDir());
        TravelDocument doc = new TravelDocument();
        Travel tmpTravel = new Travel();
        tmpTravel.setId(uploadDoc.getParentId());
        doc.setDocument(uploadDoc.getContent());
        doc.setDocumentname(uploadDoc.getFileName());
        doc.setMimetype(uploadDoc.getMimeType());
        doc.setTravel(tmpTravel);
        try {
            dbManager.saveObject((Object)doc);
        }
        catch (Exception t) {
            logger.error((Object)"Error", (Throwable)t);
            throw new PersistentLayerException(t.getMessage(), (Throwable)t);
        }
        finally {
            dbManager.closeSession();
        }
    }
}

