/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.server;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import de.cismet.projecttracker.report.db.entities.Activity;
import de.cismet.projecttracker.report.db.entities.Staff;
import de.cismet.projecttracker.report.db.entities.WorkPackage;
import de.cismet.projecttracker.report.query.DBManager;
import de.cismet.projecttracker.server.BasicServlet;
import de.cismet.projecttracker.server.ConfigurationManager;
import de.cismet.projecttracker.utilities.DevProperties;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class HoursOnClosedIssues
extends BasicServlet {
    private static final Logger LOG = Logger.getLogger(HoursOnClosedIssues.class);
    private static final String GIT_CLOSED_ISSUES_URL = "https://api.github.com/repos/cismet/wupp/issues?state=closed&milestone=%1s&per_page=1000";
    private final Map<Integer, String> issueMap = new HashMap();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.addHeader("Access-Control-Allow-Origin", "*");
        resp.addHeader("Access-Control-Allow-Methods", "GET, POST, DELETE, PUT, OPTIONS");
        resp.addHeader("Access-Control-Allow-Headers", "Content-Type, Authorization");
        super.service(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Iterator iterator;
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        String milestone = request.getParameter("milestone");
        String workpackage = request.getParameter("workpackage");
        DBManager dbManager = new DBManager(ConfigurationManager.getInstance().getConfBaseDir());
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        double finalHours = 0.0;
        try {
            WorkPackage wp;
            Session hibernateSession;
            Object staff = this.checklogin(username, password, request.getSession(), dbManager);
            if (staff instanceof Staff) {
                boolean isAdmin;
                boolean bl = isAdmin = (((Staff)staff).getPermissions() & 1) == 1;
                if (!isAdmin) {
                    response.setStatus(403);
                    LOG.warn((Object)"invalid permission");
                    out.print("forbidden");
                    return;
                }
                if (milestone == null) {
                    response.setStatus(400);
                    LOG.warn((Object)"milestone is not set");
                    out.print("milestone not set");
                    return;
                }
                URL url = new URL(String.format(this.getGitQuery(), milestone));
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Authorization", "Bearer " + this.getToken());
                InputStream is = connection.getInputStream();
                ObjectMapper mapper = new ObjectMapper(new JsonFactory());
                JsonNode node = mapper.readTree(is);
                if (!node.isArray()) {
                    response.setStatus(400);
                    LOG.warn((Object)"invalid response from github");
                    out.print("invalid response from github");
                    return;
                }
                for (JsonNode tmpNode : node) {
                    int number = tmpNode.get("number").asInt();
                    String title = tmpNode.get("title").asText();
                    this.issueMap.put(number, title);
                }
                hibernateSession = dbManager.getSession();
                wp = null;
                if (workpackage != null && (wp = (WorkPackage)hibernateSession.createCriteria(WorkPackage.class).add((Criterion)Restrictions.eq((String)"name", (Object)workpackage)).uniqueResult()) == null) {
                    response.setStatus(400);
                    LOG.warn((Object)("Workpackage is not valid: " + workpackage));
                    out.print("workpackage is not valid");
                    return;
                }
            } else {
                response.setStatus(400);
                out.print("The username/password is not correct.");
                return;
            }
            Criteria crit = hibernateSession.createCriteria(Activity.class).add((Criterion)Restrictions.eq((String)"workPackage.id", (Object)wp.getId()));
            ArrayList result = new ArrayList();
            result.addAll(crit.list());
            iterator = result.iterator();
        }
        catch (Exception e) {
            LOG.error((Object)"login error", (Throwable)e);
            e.printStackTrace();
            response.setStatus(400);
            out.print(e.getMessage());
            return;
        }
        finally {
            dbManager.closeSession();
            out.close();
        }
        while (true) {
            if (!iterator.hasNext()) {
                out.print("{\"hours\":" + finalHours + "}");
                return;
            }
            Activity a = (Activity)iterator.next();
            if (a.getDescription() == null || !a.getDescription().contains("#")) continue;
            String desc = a.getDescription();
            String issue = this.getIssue(desc);
            int issueNumber = -1;
            if (issue.startsWith("#")) {
                issue = issue.substring(1);
            }
            try {
                issueNumber = Integer.parseInt(issue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (issueNumber == -1 || !this.issueMap.containsKey(issueNumber)) continue;
            finalHours += a.getWorkinghours();
        }
    }

    private String getToken() {
        ServletContext context = this.getServletContext();
        FileReader input = null;
        Properties apiConfig = new Properties();
        try {
            input = new FileReader(context.getInitParameter("confBaseDir") + System.getProperty("file.separator") + "api.properties");
            apiConfig.load(input);
            return apiConfig.getProperty("token");
        }
        catch (IOException e) {
            LOG.error((Object)"Cannot open and load dev.properties file. Setting developing mode to false", (Throwable)e);
            DevProperties.getInstance().setDevMode(false);
            return null;
        }
    }

    protected String getGitQuery() {
        return GIT_CLOSED_ISSUES_URL;
    }

    private String getIssue(String desc) {
        RegExp regExp = RegExp.compile((String)"#(\\d+)", (String)"g");
        MatchResult matcher = regExp.exec(desc);
        boolean lastIndex = false;
        String issueNumber = null;
        if (matcher != null) {
            for (int i = 0; i < matcher.getGroupCount(); ++i) {
                String groupStr = matcher.getGroup(i);
                if (!groupStr.startsWith("#")) continue;
                issueNumber = groupStr.substring(0);
                break;
            }
        }
        return issueNumber;
    }
}

