/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.server;

import de.cismet.projecttracker.client.exceptions.DataRetrievalException;
import de.cismet.projecttracker.client.exceptions.LoginFailedException;
import de.cismet.projecttracker.report.db.entities.Staff;
import de.cismet.projecttracker.server.BasicServlet;
import de.cismet.projecttracker.server.SessionInformation;
import de.cismet.projecttracker.utilities.DBManagerWrapper;
import de.cismet.projecttracker.utilities.LanguageBundle;
import java.io.IOException;
import java.security.MessageDigest;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class LoginServlet
extends BasicServlet {
    private static final Logger logger = Logger.getLogger(LoginServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        try {
            this.login(username, password, request.getSession());
        }
        catch (Exception e) {
            logger.error((Object)"login error", (Throwable)e);
        }
        response.sendRedirect(response.encodeRedirectURL("ProjectTracker.html"));
    }

    public void login(String username, String pasword, HttpSession session) throws LoginFailedException, DataRetrievalException {
        block7: {
            Session hibernateSession = null;
            DBManagerWrapper dbManager = new DBManagerWrapper();
            try {
                hibernateSession = dbManager.getSession();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(username + " sends login request"));
                }
                MessageDigest md = MessageDigest.getInstance("SHA1");
                md.update(pasword.getBytes());
                Staff staff = (Staff)hibernateSession.createCriteria(Staff.class).add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"username", (Object)username), (Criterion)Restrictions.eq((String)"password", (Object)md.digest()))).uniqueResult();
                if (staff != null) {
                    SessionInformation sessionInfo = new SessionInformation();
                    sessionInfo.setCurrentUser(staff);
                    session.setAttribute("sessionInfo", (Object)sessionInfo);
                    break block7;
                }
                throw new LoginFailedException(LanguageBundle.LOGIN_FAILED);
            }
            catch (Throwable t) {
                logger.error((Object)"Error:", t);
                throw new DataRetrievalException(t.getMessage(), t);
            }
            finally {
                dbManager.closeSession();
            }
        }
    }
}

