/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import de.cismet.projecttracker.client.exceptions.DataRetrievalException;
import de.cismet.projecttracker.client.exceptions.InvalidInputValuesException;
import de.cismet.projecttracker.client.exceptions.NoSessionException;
import de.cismet.projecttracker.client.exceptions.PermissionDenyException;
import de.cismet.projecttracker.report.db.entities.Staff;
import de.cismet.projecttracker.report.db.entities.StaffExtern;
import de.cismet.projecttracker.report.db.entities.WorkPackage;
import de.cismet.projecttracker.report.query.DBManager;
import de.cismet.projecttracker.server.BasicServlet;
import de.cismet.projecttracker.server.ConfigurationManager;
import de.cismet.projecttracker.utilities.DTOManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class Lookup
extends BasicServlet {
    private static final Logger logger = Logger.getLogger(Lookup.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.addHeader("Access-Control-Allow-Origin", "*");
        resp.addHeader("Access-Control-Allow-Methods", "GET, POST, DELETE, PUT, OPTIONS");
        resp.addHeader("Access-Control-Allow-Headers", "Content-Type, Authorization");
        super.service(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        String operation = request.getParameter("operation");
        DBManager dbManager = new DBManager(ConfigurationManager.getInstance().getConfBaseDir());
        PrintWriter out = response.getWriter();
        try {
            Object staff = this.checklogin(username, password, request.getSession(), dbManager);
            if (staff != null) {
                if (operation.equalsIgnoreCase("searchableWorkPackages")) {
                    ArrayList wpList = null;
                    DTOManager dtoManager = new DTOManager();
                    wpList = staff instanceof StaffExtern ? new ArrayList(((StaffExtern)staff).getWorkpackages()) : this.getAllWorkPackages((Staff)staff, dbManager);
                    response.setCharacterEncoding("UTF-8");
                    ObjectMapper mapper = new ObjectMapper();
                    ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
                    String json = writer.writeValueAsString((Object)dtoManager.clone(wpList));
                    out.print(json);
                } else {
                    response.setStatus(400);
                    out.print("no valid operation");
                }
            } else {
                response.setStatus(400);
                out.print("The username/password is not correct.");
            }
        }
        catch (Exception e) {
            logger.error((Object)"login error", (Throwable)e);
            e.printStackTrace();
            response.setStatus(400);
            out.print(e.getMessage());
        }
        finally {
            dbManager.closeSession();
            out.close();
        }
    }

    private List<WorkPackage> getAllWorkPackages(Staff user, DBManager dbManager) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get workpackages: ");
        }
        try {
            List result = dbManager.getAllObjects(WorkPackage.class);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(result.size() + " workpackages found"));
            }
            return result;
        }
        catch (Exception e) {
            logger.error((Object)"Error while retrieving workpackages");
            return new ArrayList<WorkPackage>();
        }
    }
}

