/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.server;

import de.cismet.projecttracker.report.db.entities.Staff;
import de.cismet.projecttracker.report.query.DBManager;
import de.cismet.projecttracker.server.BasicServlet;
import de.cismet.projecttracker.server.ConfigurationManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.GregorianCalendar;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class OverviewWorkinghours
extends BasicServlet {
    private static final Logger LOG = Logger.getLogger(OverviewWorkinghours.class);
    private static final String QUERY = "select\n  \tEXTRACT(YEAR FROM a.day) as jahr,\n\ts.\"name\",\n\ts.firstname,\n\tcase when p.\"name\" ilike 'MV' then 'MV' when p.name ilike 'Wuppertal' then 'Wuppertal' else 'sonstige' end as projekt,\n\tcase when cc.\"name\" = 'fakturierbar' then true else false end as fakturierbar,\n\tsum(case when  (wp.name ilike 'Urlaub' or p.name ilike 'Urlaub') and a.workinghours = 0.0 then 8.0 else a.workinghours end) as Stunden \nfrom\n\tactivity a\t\n\tjoin staff s on (a.staffid  = s.id)\n\tjoin work_package wp on (a.workpackageid = wp.id)\n\tjoin project p on (wp.project = p.id)\n\tjoin cost_category cc on (wp.costcategoryid = cc.id)\nwhere a.\"day\" >= '%1s-01-01' and a.\"day\"::DATE <= '%2s'::DATE and s.firstname <> 'Auftrag und Korrektur'\n\tand wp.name not in ('Kinderkrankenschein', 'Sonderurlaub', 'krank', '*Freizeitausgleich', '*Pause', 'Freistellung', 'Elternzeit')\n\tand p.name not in ('Sonderurlaub', '*Freizeitausgleich', '*Pause', 'Krank', 'bitte pr\u00fcfen', 'Abgleich Zeitkonto')\n\tand s.name not in ('Admin')\n\tand exists (select st.id, sum(workinghours) from activity ac join staff st on (ac.staffid  = st.id) join work_package wp on (ac.workpackageid = wp.id) join cost_category cca on (wp.costcategoryid = cca.id) where st.id = s.id and cca.\"name\" = 'fakturierbar' and EXTRACT(YEAR FROM ac.day) = EXTRACT(YEAR FROM a.day) group by 1 having sum(workinghours) > 1)\ngroup by 1, 2, 3, 4, 5\nhaving sum(case when (wp.name ilike 'Urlaub' or p.name ilike 'Urlaub') and a.workinghours = 0.0 then 8.0 else a.workinghours end)  > 1\norder by 1, 2, 3, 4";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.addHeader("Access-Control-Allow-Origin", "*");
        resp.addHeader("Access-Control-Allow-Methods", "GET, POST, DELETE, PUT, OPTIONS");
        resp.addHeader("Access-Control-Allow-Headers", "Content-Type, Authorization");
        super.service(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        String startYear = request.getParameter("from");
        String till = request.getParameter("till");
        DBManager dbManager = new DBManager(ConfigurationManager.getInstance().getConfBaseDir());
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        double finalHours = 0.0;
        Connection con = null;
        if (startYear == null) {
            startYear = "2020";
        } else {
            try {
                Integer.parseInt(startYear);
            }
            catch (NumberFormatException e) {
                startYear = "2020";
            }
        }
        if (till == null) {
            GregorianCalendar now = new GregorianCalendar();
            till = now.get(1) + "-" + (now.get(2) + 1) + "-" + now.get(5);
        }
        try {
            Object staff = this.checklogin(username, password, request.getSession(), dbManager);
            if (staff != null) {
                boolean isAdmin;
                boolean bl = isAdmin = (((Staff)staff).getPermissions() & 1) == 1;
                if (!isAdmin) {
                    response.setStatus(403);
                    LOG.warn((Object)"invalid permission");
                    out.print("forbidden");
                    return;
                }
                con = dbManager.getDatabaseConnection();
                Statement statement = con.createStatement();
                ResultSet rs = statement.executeQuery(String.format(QUERY, startYear, till));
                out.println("\"jahr\";\"name\",\"firstname\";\"projekt\";\"fakturierbar\";\"stunden\"");
                if (rs != null) {
                    while (rs.next()) {
                        Integer year = rs.getInt(1);
                        String name = rs.getString(2);
                        String firstName = rs.getString(3);
                        String project = rs.getString(4);
                        boolean fac = rs.getBoolean(5);
                        Double hours = rs.getDouble(6);
                        StringBuilder sb = new StringBuilder(year != null ? year.toString() : "");
                        sb.append(";").append(name).append(";").append(firstName).append(";").append(project).append(";").append(fac).append(";").append(hours);
                        out.println(sb.toString());
                    }
                }
            } else {
                response.setStatus(400);
                out.print("The username/password is not correct.");
            }
        }
        catch (Exception e) {
            LOG.error((Object)"login error", (Throwable)e);
            e.printStackTrace();
            response.setStatus(400);
            out.print(e.getMessage());
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException ex) {
                    LOG.error((Object)"Cannot close db connection", (Throwable)ex);
                }
            }
            dbManager.closeSession();
            out.close();
        }
    }
}

