/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import de.cismet.projecttracker.client.ProjectService;
import de.cismet.projecttracker.client.common.ui.FavouriteTaskStory;
import de.cismet.projecttracker.client.dto.ActivityDTO;
import de.cismet.projecttracker.client.dto.BasicDTO;
import de.cismet.projecttracker.client.dto.CompanyDTO;
import de.cismet.projecttracker.client.dto.ContractDTO;
import de.cismet.projecttracker.client.dto.ContractDocumentDTO;
import de.cismet.projecttracker.client.dto.CostCategoryDTO;
import de.cismet.projecttracker.client.dto.EstimatedComponentCostDTO;
import de.cismet.projecttracker.client.dto.EstimatedComponentCostMonthDTO;
import de.cismet.projecttracker.client.dto.FundingDTO;
import de.cismet.projecttracker.client.dto.ProfileDTO;
import de.cismet.projecttracker.client.dto.ProjectBodyDTO;
import de.cismet.projecttracker.client.dto.ProjectCategoryDTO;
import de.cismet.projecttracker.client.dto.ProjectComponentTagDTO;
import de.cismet.projecttracker.client.dto.ProjectCostsDTO;
import de.cismet.projecttracker.client.dto.ProjectDTO;
import de.cismet.projecttracker.client.dto.ProjectPeriodDTO;
import de.cismet.projecttracker.client.dto.ProjectShortDTO;
import de.cismet.projecttracker.client.dto.RealOverheadDTO;
import de.cismet.projecttracker.client.dto.ReportDTO;
import de.cismet.projecttracker.client.dto.StaffDTO;
import de.cismet.projecttracker.client.dto.TravelDTO;
import de.cismet.projecttracker.client.dto.TravelDocumentDTO;
import de.cismet.projecttracker.client.dto.WorkCategoryDTO;
import de.cismet.projecttracker.client.dto.WorkPackageDTO;
import de.cismet.projecttracker.client.dto.WorkPackagePeriodDTO;
import de.cismet.projecttracker.client.exceptions.DataRetrievalException;
import de.cismet.projecttracker.client.exceptions.FullStopException;
import de.cismet.projecttracker.client.exceptions.InvalidInputValuesException;
import de.cismet.projecttracker.client.exceptions.LoginFailedException;
import de.cismet.projecttracker.client.exceptions.NoSessionException;
import de.cismet.projecttracker.client.exceptions.PermissionDenyException;
import de.cismet.projecttracker.client.exceptions.PersistentLayerException;
import de.cismet.projecttracker.client.exceptions.ReportNotFoundException;
import de.cismet.projecttracker.client.types.ActivityResponseType;
import de.cismet.projecttracker.client.types.HolidayType;
import de.cismet.projecttracker.client.types.ReportType;
import de.cismet.projecttracker.client.types.TimePeriod;
import de.cismet.projecttracker.report.ProjectTrackerReport;
import de.cismet.projecttracker.report.ReportManager;
import de.cismet.projecttracker.report.commons.HolidayEvaluator;
import de.cismet.projecttracker.report.db.entities.Activity;
import de.cismet.projecttracker.report.db.entities.BasicHibernateEntity;
import de.cismet.projecttracker.report.db.entities.Company;
import de.cismet.projecttracker.report.db.entities.Contract;
import de.cismet.projecttracker.report.db.entities.ContractDocument;
import de.cismet.projecttracker.report.db.entities.CostCategory;
import de.cismet.projecttracker.report.db.entities.EstimatedComponentCost;
import de.cismet.projecttracker.report.db.entities.EstimatedComponentCostMonth;
import de.cismet.projecttracker.report.db.entities.Funding;
import de.cismet.projecttracker.report.db.entities.Profile;
import de.cismet.projecttracker.report.db.entities.Project;
import de.cismet.projecttracker.report.db.entities.ProjectBody;
import de.cismet.projecttracker.report.db.entities.ProjectCategory;
import de.cismet.projecttracker.report.db.entities.ProjectCosts;
import de.cismet.projecttracker.report.db.entities.RealOverhead;
import de.cismet.projecttracker.report.db.entities.Report;
import de.cismet.projecttracker.report.db.entities.Staff;
import de.cismet.projecttracker.report.db.entities.Travel;
import de.cismet.projecttracker.report.db.entities.TravelDocument;
import de.cismet.projecttracker.report.db.entities.WorkCategory;
import de.cismet.projecttracker.report.db.entities.WorkPackage;
import de.cismet.projecttracker.report.exceptions.UserNotFoundException;
import de.cismet.projecttracker.report.helper.CalendarHelper;
import de.cismet.projecttracker.report.timetracker.TimetrackerQuery;
import de.cismet.projecttracker.server.ConfigurationManager;
import de.cismet.projecttracker.server.SessionInformation;
import de.cismet.projecttracker.server.WarningSystem;
import de.cismet.projecttracker.utilities.DBManagerWrapper;
import de.cismet.projecttracker.utilities.DTOManager;
import de.cismet.projecttracker.utilities.DevProperties;
import de.cismet.projecttracker.utilities.EmailTaskNotice;
import de.cismet.projecttracker.utilities.LanguageBundle;
import de.cismet.projecttracker.utilities.Utilities;
import de.cismet.web.timetracker.types.HoursOfWork;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProjectServiceImpl
extends RemoteServiceServlet
implements ProjectService {
    private static final org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(ProjectServiceImpl.class);
    private static final Properties PROJECT_URLS = new Properties();
    private static final String RECENT_ACTIVITIES_QUERY = "select max(id), workpackageid, description from activity where staffid = %1$s and kindofactivity = %2$s group by workpackageid, description having workpackageid <> 408 order by max(id) desc limit 30;";
    private static final String FAVOURITE_ACTIVITIES_QUERY = "select max(id), workpackageid, description from activity where staffid = %1$s and day is null group by workpackageid, description";
    private static final String RECENT_ACTIVITIES_EX_QUERY = "select max(id), workpackageid, description from activity where staffid <> %1$s and kindofactivity = %2$s group by workpackageid, description having workpackageid <> 408 order by max(id) desc limit 30;";
    private static final String REAL_WORKING_TIME_QUERY = "SELECT sum(workinghours)  FROM activity WHERE staffid = %2$s AND date_trunc('day', day) >= '%3$s' AND date_trunc('day', day) < '%4$s' AND workpackageid NOT IN (234, 407,408 ,409, 410,411,414, 419);";
    private static final String REAL_WORKING_TIME_ILLNESS_AND_HOLIDAY = "SELECT sum(case workinghours  when -1 then 0 when 0 then %1$s else workinghours end)  FROM activity WHERE staffid = %2$s AND date_trunc('day', day) >= '%3$s' AND date_trunc('day', day) < '%4$s' AND workpackageid IN (409,410,411,419);";
    private static final String FAVOURITE_EXISTS_QUERY = "select description, staffid, workpackageid from activity where staffid=%1$s and day is null and workpackageid = %2$s and case when description is null then true else description = '%3$s' end";
    private static final String CHECK_BEGIN_OF_DAY_QUERY = "select max(day) from activity where staffid = %1$s and date_trunc('day', day) = '%2$s' and kindofactivity=1";
    private static final String CHECK_KIND_OF_LAST_ACTIVITY = "select kindofactivity, day from activity where staffid = %1$s and day = (select max(day) from activity where staffid = %1$s and date_trunc('day',day) ='%2$s')";
    private static final String COUNT_VACATION_DAYS = "select * from activity where staffid=%1$s and workpackageid = 409 and day>='%2$s' and day <='%3$s'";
    private static final String UNLOCKED_DAYS = "select distinct(date_trunc('day',day))  from \"public\".activity  where staffid = %1$s and day>='01-03-2012' except select distinct(date_trunc('day',day)) from \"public\".activity where staffid=%1$s and day>='01-03-2012' and kindofactivity = 3 order by date_trunc desc;";
    private static ReportManager reportManager;
    private static WarningSystem warningSystem;
    private static boolean initialised;
    private static DTOManager dtoManager;
    private static final GregorianCalendar accountBalanceDueDate;
    private static String JSON_LOG_BASE_DIR;
    private static Timer refreshConfigTimer;

    public void init() throws ServletException {
        super.init();
        ServletContext context = this.getServletContext();
        ConfigurationManager.getInstance().setContext(context);
        if (!initialised) {
            initialised = true;
            Utilities.initLogger((String)this.getServletContext().getRealPath("/"));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"init PersistentBeanManager");
            }
            warningSystem = new WarningSystem();
            try {
                LanguageBundle.class.newInstance();
            }
            catch (Exception e) {
                logger.error((Object)"the language resource bundle is not complete.", (Throwable)e);
            }
            reportManager = new ReportManager(this.getServletContext().getRealPath("/"), ConfigurationManager.getInstance().getConfBaseDir());
            FileReader input = null;
            Properties jsonConfig = new Properties();
            try {
                input = new FileReader(context.getInitParameter("confBaseDir") + System.getProperty("file.separator") + "json_log.properties");
                jsonConfig.load(input);
                JSON_LOG_BASE_DIR = jsonConfig.getProperty("base_dir");
            }
            catch (IOException e) {
                logger.error((Object)"Cannot open and load json_log properties file.", (Throwable)e);
            }
            ProjectServiceImpl.fetchProjectUrlConfig();
            Properties developerConfig = new Properties();
            try {
                input = new FileReader(context.getInitParameter("confBaseDir") + System.getProperty("file.separator") + "dev.properties");
                developerConfig.load(input);
                boolean devMode = Boolean.parseBoolean(developerConfig.getProperty("devMode"));
                DevProperties.getInstance().setDevMode(devMode);
            }
            catch (IOException e) {
                logger.error((Object)"Cannot open and load dev.properties file. Setting developing mode to false", (Throwable)e);
                DevProperties.getInstance().setDevMode(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fetchProjectUrlConfig() {
        Properties properties = PROJECT_URLS;
        synchronized (properties) {
            try {
                FileInputStream input = new FileInputStream(ConfigurationManager.getInstance().getConfBaseDir() + System.getProperty("file.separator") + "projectUrl.properties");
                PROJECT_URLS.load(input);
            }
            catch (IOException e) {
                logger.error((Object)"Cannot open and load the projectUrl server properties file.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ProjectShortDTO> getAllOngoingProjects() throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        this.checkAdminPermission();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get all ongoing projects");
        }
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            List result = dbManager.getObjectsByAttribute("select proj from Project as proj left join proj.projectPeriods as period where period.id in (Select pp.id from ProjectPeriod as pp where pp.asof in (select max(pper.asof) as masof from ProjectPeriod as pper group by pper.project)) and (period.todate=null or period.todate>current_timestamp) or period=null");
            ArrayList<ProjectShortDTO> clonedList = new ArrayList<ProjectShortDTO>();
            for (Project o : result) {
                ProjectDTO pro = (ProjectDTO)dtoManager.clone((BasicHibernateEntity)o);
                clonedList.add(pro.toShortVersion());
            }
            ArrayList<ProjectShortDTO> arrayList = clonedList;
            return arrayList;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ProjectShortDTO> getAllCompletedProjects() throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        this.checkAdminPermission();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get all completed projects");
        }
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            List result = dbManager.getObjectsByAttribute("select proj from Project as proj left join proj.projectPeriods as period where period.id in (Select pp.id from ProjectPeriod as pp where pp.asof in (select max(pper.asof) as masof from ProjectPeriod as pper group by pper.project)) and period.todate<current_timestamp");
            ArrayList<ProjectShortDTO> clonedList = new ArrayList<ProjectShortDTO>();
            for (Project o : result) {
                ProjectDTO pro = (ProjectDTO)dtoManager.clone((BasicHibernateEntity)o);
                clonedList.add(pro.toShortVersion());
            }
            ArrayList<ProjectShortDTO> arrayList = clonedList;
            return arrayList;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<StaffDTO> getCurrentEmployees() throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        this.checkSession();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get current employees");
        }
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            List result = dbManager.getObjectsByAttribute("select distinct staff from Staff as staff left join staff.contracts as contract where contract.todate=null or contract.todate>current_timestamp");
            ArrayList arrayList = dtoManager.clone(result);
            return arrayList;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<StaffDTO> getAllFormerEmployees() throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        this.checkSession();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get all former employees");
        }
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            List result = dbManager.getObjectsByAttribute("select distinct staff from Staff as staff left join staff.contracts as contract where contract.todate!=null and contract.todate<=current_timestamp and staff.id not in (select staff1.id from Staff as staff1 left join staff1.contracts as contract1 where contract1.todate=null or contract1.todate>current_timestamp)");
            ArrayList arrayList = dtoManager.clone(result);
            return arrayList;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<StaffDTO> getAllEmployees() throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        this.checkSession();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get alle mployees");
        }
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            List result = dbManager.getAllObjects(Staff.class);
            ArrayList arrayList = dtoManager.clone(result);
            return arrayList;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ProjectShortDTO> getAllProjects() throws InvalidInputValuesException, DataRetrievalException, NoSessionException {
        this.checkSession();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get all projects");
        }
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            List result = dbManager.getAllObjects(Project.class);
            ArrayList<ProjectShortDTO> clonedList = new ArrayList<ProjectShortDTO>();
            for (Project o : result) {
                ProjectDTO pro = (ProjectDTO)dtoManager.clone((BasicHibernateEntity)o);
                clonedList.add(pro.toShortVersion());
            }
            ArrayList<ProjectShortDTO> arrayList = clonedList;
            return arrayList;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ProjectCategoryDTO> getAllProjectCategories() throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        this.checkAdminPermission();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get all project categories");
        }
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            List result = dbManager.getAllObjects(ProjectCategory.class);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(result.size() + " project categories found"));
            }
            ArrayList arrayList = dtoManager.clone(result);
            return arrayList;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ProjectDTO> getAllProjectsFull() throws InvalidInputValuesException, DataRetrievalException, NoSessionException {
        this.checkSession();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get all projects full");
        }
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            List result = dbManager.getAllObjects(Project.class);
            ArrayList arrayList = dtoManager.clone(result);
            return arrayList;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProject(long id) throws InvalidInputValuesException, PersistentLayerException, DataRetrievalException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"delete project");
        }
        this.checkAdminPermission();
        Project project = null;
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            project = (Project)dbManager.getObject(Project.class, id);
            Query query = dbManager.getSession().createQuery("select proj from Project as proj inner join proj.workPackages as wp inner join wp.activityWorkPackages as activity where proj.id=" + id);
            Object result = query.setMaxResults(1).uniqueResult();
            if (result != null) {
                throw new PersistentLayerException(LanguageBundle.EXISTING_ACTIVITIES_FOR_PC_FOUND);
            }
            if (project != null) {
                dbManager.deleteObject((BasicHibernateEntity)project);
            }
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectDTO getProject(long projectId) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get project with id " + projectId));
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            Project result = (Project)dbManager.getObject(Project.class, projectId);
            ProjectDTO projectDTO = (ProjectDTO)dtoManager.clone((BasicHibernateEntity)result);
            return projectDTO;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectDTO saveProject(ProjectDTO project) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"save project");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            Project projectHib;
            ProjectPeriodDTO projectPeriod;
            if (project.getProjectPeriods() != null) {
                for (ProjectPeriodDTO pp : project.getProjectPeriods()) {
                    if (pp.getAsof() != null) continue;
                    pp.setAsof(new Date());
                }
            }
            if ((projectPeriod = project.determineMostRecentPeriod()) != null) {
                for (WorkPackageDTO tmp : project.getWorkPackages()) {
                    WorkPackagePeriodDTO period = tmp.determineMostRecentPeriod();
                    if (period == null) continue;
                    if (period.getFromdate().before(projectPeriod.getFromdate())) {
                        throw new InvalidInputValuesException(LanguageBundle.PROJECT_START_BEFORE_PROJECT_COMPONENT_START + " " + tmp.getAbbreviation());
                    }
                    if (period.getTodate() == null || projectPeriod.getTodate() == null || !period.getTodate().after(projectPeriod.getTodate())) continue;
                    throw new InvalidInputValuesException(LanguageBundle.PROJECT_END_AFTER_PROJECT_COMPONENT_END + " " + tmp.getAbbreviation());
                }
            }
            if ((projectHib = (Project)dtoManager.merge((BasicDTO)project)).getProject() != null && projectHib.getProject().getId() == 0L) {
                System.out.println("projectHib.setProject(null); wird ben\u00f6tigt");
                projectHib.setProject(null);
            }
            dbManager.saveObject((BasicHibernateEntity)projectHib);
            ProjectDTO projectDTO = (ProjectDTO)dtoManager.clone((BasicHibernateEntity)projectHib);
            return projectDTO;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectShortDTO createProject() throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create project");
        }
        this.checkAdminPermission();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create new project");
        }
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            Project project = new Project();
            project.setName("Project" + new Date().getTime());
            ProjectBody body = this.getAnyProjectBody(dbManager);
            if (body == null) {
                body = new ProjectBody();
                body.setName("dummyBody");
                HashSet<Project> projects = new HashSet<Project>();
                projects.add(project);
                body.setProjects(projects);
                long id = (Long)dbManager.createObject((BasicHibernateEntity)body);
                body.setId(id);
            }
            project.setProjectBody(body);
            long projectId = (Long)dbManager.createObject((BasicHibernateEntity)project);
            project.setId(projectId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("project id of the new project: " + projectId));
            }
            ProjectDTO newProject = (ProjectDTO)dtoManager.clone((BasicHibernateEntity)project);
            ProjectShortDTO projectShortDTO = newProject.toShortVersion();
            return projectShortDTO;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkPackageDTO getWorkpackageData(long workpackageId) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        this.checkAdminPermission();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getProjectData for project id: " + workpackageId));
        }
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            WorkPackage result = (WorkPackage)dbManager.getObject(WorkPackage.class, workpackageId);
            WorkPackageDTO workPackageDTO = (WorkPackageDTO)dtoManager.clone((BasicHibernateEntity)result);
            return workPackageDTO;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkPackageDTO saveWorkPackage(WorkPackageDTO workpackage) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"save work package");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            if (workpackage.getWorkPackagePeriods() != null) {
                for (WorkPackagePeriodDTO tmp : workpackage.getWorkPackagePeriods()) {
                    if (tmp.getAsof() != null) continue;
                    ProjectPeriodDTO period = workpackage.getProject().determineMostRecentPeriod();
                    tmp.setAsof(new Date());
                    if (period != null && tmp.getFromdate().before(period.getFromdate())) {
                        throw new InvalidInputValuesException(LanguageBundle.WORK_PACKAGE_START_BEFORE_PROJECT_START);
                    }
                    if (period == null || period.getTodate() == null || tmp.getTodate() == null || !tmp.getTodate().after(period.getTodate())) continue;
                    throw new InvalidInputValuesException(LanguageBundle.WORK_PACKAGE_END_AFTER_PROJECT_END);
                }
            }
            if (workpackage.getWorkPackageProgresses() != null) {
                for (WorkPackagePeriodDTO tmp : workpackage.getWorkPackageProgresses()) {
                    if (tmp.getTime() != null) continue;
                    tmp.setTime(new Date());
                }
            }
            WorkPackagePeriodDTO period = workpackage.determineMostRecentPeriod();
            WorkPackage wp = (WorkPackage)dtoManager.merge((BasicDTO)workpackage);
            Object expression = period.getTodate() != null ? Restrictions.or((Criterion)Restrictions.gt((String)"day", (Object)period.getTodate()), (Criterion)Restrictions.lt((String)"day", (Object)period.getFromdate())) : Restrictions.lt((String)"day", (Object)period.getFromdate());
            Criteria crit = dbManager.getSession().createCriteria(Activity.class).add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"workPackage", (Object)wp), (Criterion)expression)).setMaxResults(1);
            Activity act = (Activity)crit.uniqueResult();
            if (act != null) {
                if (act.getDay().before(period.getFromdate())) {
                    throw new InvalidInputValuesException(LanguageBundle.ACTIVITY_BEFORE_PERIOD_START);
                }
                throw new InvalidInputValuesException(LanguageBundle.ACTIVITY_AFTER_PERIOD_END);
            }
            dbManager.saveObject((BasicHibernateEntity)wp);
            WorkPackageDTO workPackageDTO = (WorkPackageDTO)dtoManager.clone((BasicHibernateEntity)wp);
            return workPackageDTO;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkPackageDTO createWorkPackage(WorkPackageDTO workpackage) throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create work package");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            WorkPackage wp = (WorkPackage)dtoManager.merge((BasicDTO)workpackage);
            if (wp.getCostCategory() == null) {
                wp.setCostCategory(this.getAnyCostCategory(wp.getProject(), dbManager));
            }
            long id = (Long)dbManager.createObject((BasicHibernateEntity)wp);
            wp.setId(id);
            WorkPackageDTO workPackageDTO = workpackage = (WorkPackageDTO)dtoManager.clone((BasicHibernateEntity)wp);
            return workPackageDTO;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWorkPackage(WorkPackageDTO object) throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"delete work package");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            WorkPackage wp = (WorkPackage)dbManager.getObject(WorkPackage.class, object.getId());
            if (wp.getActivityWorkPackages() != null && wp.getActivityWorkPackages().size() > 0) {
                throw new PersistentLayerException(LanguageBundle.EXISTING_ACTIVITIES_FOR_PC_FOUND);
            }
            dbManager.deleteObject((BasicHibernateEntity)wp);
        }
        finally {
            dbManager.closeSession();
        }
    }

    private CostCategory getAnyCostCategory(Project project, DBManagerWrapper dbManager) throws DataRetrievalException, PersistentLayerException {
        if (project != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"get any cost category");
            }
            CostCategory result = (CostCategory)dbManager.getObjectByAttribute(CostCategory.class, "project", (Object)project);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)((result == null ? "no" : "any") + " cost category found"));
            }
            if (result == null) {
                result = new CostCategory();
                result.setProject(project);
                result.setName("dummy");
                result.setFundingrate(0.0);
                dbManager.createObject((BasicHibernateEntity)result);
            }
            return result;
        }
        logger.error((Object)"Project argument of method getRandomCostCategory is null. This should never happen");
        return null;
    }

    private ProjectBody getAnyProjectBody(DBManagerWrapper dbManager) throws DataRetrievalException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get any project body");
        }
        ProjectBody result = (ProjectBody)dbManager.getAnyObjectByClass(ProjectBody.class);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)((result == null ? "no" : "any") + " project body found"));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createStaff(StaffDTO staff) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create staff");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            long id;
            long l = id = ((Long)dbManager.createObject(dtoManager.merge((BasicDTO)staff))).longValue();
            return l;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StaffDTO saveStaff(StaffDTO staff) throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException {
        Staff staffHib;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"save staff");
        }
        this.checkUserOrAdminPermission(staff.getId());
        try {
            Staff user = this.getStaffByUsername(staff.getUsername());
            SessionInformation sessionInfo = this.getCurrentSession();
            if (user != null && user.getId() != staff.getId()) {
                throw new PersistentLayerException(LanguageBundle.USERNAME_ALREADY_EXISTS);
            }
            if (!sessionInfo.isAdmin()) {
                staff.setPermissions(sessionInfo.getCurrentUser().getPermissions());
            }
        }
        catch (DataRetrievalException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new PersistentLayerException(e.getMessage());
        }
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            for (ContractDTO c : staff.getContracts()) {
                if (c.getId() != 0L) {
                    dbManager.saveObject(dtoManager.merge((BasicDTO)c));
                    continue;
                }
                Contract contract = (Contract)dtoManager.merge((BasicDTO)c);
                long id = (Long)dbManager.createObject((BasicHibernateEntity)contract);
                c.setId(id);
            }
            staffHib = (Staff)dtoManager.merge((BasicDTO)staff);
            Staff original = this.getStaffById(staff.getId());
            staffHib.setPassword(original.getPassword());
            if (staff.getProfile() != null) {
                if (staff.getProfile().getId() != 0L) {
                    dbManager.saveObject(dtoManager.merge((BasicDTO)staff.getProfile()));
                } else {
                    Profile p = (Profile)dtoManager.merge((BasicDTO)staff.getProfile());
                    long id = (Long)dbManager.createObject((BasicHibernateEntity)p);
                    p.setId(id);
                    staffHib.setProfile(p);
                }
            }
            dbManager.saveObject((BasicHibernateEntity)staffHib);
        }
        finally {
            dbManager.closeSession();
        }
        return (StaffDTO)dtoManager.clone((BasicHibernateEntity)staffHib);
    }

    public void deleteStaff(StaffDTO staff) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"delete staff");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            dbManager.deleteObject(dtoManager.merge((BasicDTO)staff));
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TravelDTO createTravelExpenseReport(TravelDTO travel) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create travel expense report");
        }
        this.checkUserOrAdminPermission(travel.getStaff().getId());
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            travel.setDate(new Date());
            Travel travelHib = (Travel)dtoManager.merge((BasicDTO)travel);
            dbManager.createObject((BasicHibernateEntity)travelHib);
            TravelDTO travelDTO = (TravelDTO)dtoManager.clone((BasicHibernateEntity)travelHib);
            return travelDTO;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TravelDTO saveTravelExpenseReport(TravelDTO travel) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"save travel expense report");
        }
        this.checkUserOrAdminPermission(travel.getStaff().getId());
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            Travel travelHib = (Travel)dtoManager.merge((BasicDTO)travel);
            dbManager.saveObject((BasicHibernateEntity)travelHib);
            TravelDTO travelDTO = (TravelDTO)dtoManager.clone((BasicHibernateEntity)travelHib);
            return travelDTO;
        }
        finally {
            dbManager.closeSession();
        }
    }

    public void deleteTravelExpenseReport(TravelDTO travel) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"delete travel expense report");
        }
        this.checkUserOrAdminPermission(travel.getStaff().getId());
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            if (travel.getPaymentdate() != null) {
                throw new PersistentLayerException(LanguageBundle.TRAVEL_IS_ALREADY_PAYED);
            }
            dbManager.deleteObject(dtoManager.merge((BasicDTO)travel));
        }
        finally {
            dbManager.closeSession();
        }
    }

    public void changePassword(StaffDTO staff, String newPassword) throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"change password");
        }
        this.checkUserOrAdminPermission(staff.getId());
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            Staff staffHib = this.getStaffById(staff.getId());
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(newPassword.getBytes());
            staffHib.setPassword(md.digest());
            dbManager.saveObject((BasicHibernateEntity)staffHib);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PersistentLayerException("Cannot find the SHA1 algorithm.", (Throwable)e);
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<CompanyDTO> getCompanies() throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        this.checkSession();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get companies");
        }
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            List result = dbManager.getAllObjects(Company.class);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(result.size() + " companies found"));
            }
            ArrayList arrayList = dtoManager.clone(result);
            return arrayList;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<EstimatedComponentCostDTO> getEstimatedWorkPackageCostForWP(WorkPackageDTO workPackage) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        this.checkAdminPermission();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get estimated work package cost");
        }
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            List result = dbManager.getObjectsByAttribute(EstimatedComponentCost.class, "workPackage", (Object)dtoManager.merge((BasicDTO)workPackage));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(result.size() + " estimations found"));
            }
            ArrayList arrayList = dtoManager.clone(result);
            return arrayList;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EstimatedComponentCostMonthDTO saveEstimatedWorkPackageCostMonth(EstimatedComponentCostMonthDTO estimation) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"save estimation month");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            EstimatedComponentCostMonth est = (EstimatedComponentCostMonth)dtoManager.merge((BasicDTO)estimation);
            dbManager.saveObject((BasicHibernateEntity)est);
            EstimatedComponentCostMonthDTO estimatedComponentCostMonthDTO = (EstimatedComponentCostMonthDTO)dtoManager.clone((BasicHibernateEntity)est);
            return estimatedComponentCostMonthDTO;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EstimatedComponentCostMonthDTO createEstimatedWorkPackageCostMonth(EstimatedComponentCostMonthDTO estimation) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create estimation month");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            EstimatedComponentCostMonth est = (EstimatedComponentCostMonth)dtoManager.merge((BasicDTO)estimation);
            long id = (Long)dbManager.createObject((BasicHibernateEntity)est);
            est.setId(id);
            EstimatedComponentCostMonthDTO estimatedComponentCostMonthDTO = (EstimatedComponentCostMonthDTO)dtoManager.clone((BasicHibernateEntity)est);
            return estimatedComponentCostMonthDTO;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EstimatedComponentCostDTO createEstimatedWorkPackageCost(EstimatedComponentCostDTO estimation) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create estimation");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            estimation.setCreationtime(new Date());
            EstimatedComponentCost est = (EstimatedComponentCost)dtoManager.merge((BasicDTO)estimation);
            long id = (Long)dbManager.createObject((BasicHibernateEntity)est);
            est.setId(id);
            EstimatedComponentCostDTO estimatedComponentCostDTO = (EstimatedComponentCostDTO)dtoManager.clone((BasicHibernateEntity)est);
            return estimatedComponentCostDTO;
        }
        finally {
            dbManager.closeSession();
        }
    }

    public void deleteEstimatedWorkPackageCost(EstimatedComponentCostDTO estimation) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"delete estimation");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            dbManager.deleteObject(dtoManager.merge((BasicDTO)estimation));
        }
        finally {
            dbManager.closeSession();
        }
    }

    public void deleteContract(ContractDTO contract) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"delete contract");
        }
        this.checkUserOrAdminPermission(contract.getStaff().getId());
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            dbManager.deleteObject(dtoManager.merge((BasicDTO)contract));
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createCompany(CompanyDTO company) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create company");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            long id;
            long l = id = ((Long)dbManager.createObject(dtoManager.merge((BasicDTO)company))).longValue();
            return l;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompanyDTO saveCompany(CompanyDTO company) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"save company");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            Company comp = (Company)dtoManager.merge((BasicDTO)company);
            for (RealOverhead overhead : comp.getRealOverheads()) {
                if (overhead.getId() != 0L) {
                    dbManager.saveObject((BasicHibernateEntity)overhead);
                    continue;
                }
                long id = (Long)dbManager.createObject((BasicHibernateEntity)overhead);
                overhead.setId(id);
            }
            dbManager.saveObject((BasicHibernateEntity)comp);
            CompanyDTO companyDTO = (CompanyDTO)dtoManager.clone((BasicHibernateEntity)comp);
            return companyDTO;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCompany(CompanyDTO company) throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException {
        block5: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"delete company");
            }
            this.checkAdminPermission();
            DBManagerWrapper dbManager = new DBManagerWrapper();
            try {
                Company comp = (Company)dbManager.getObject(Company.class, company.getId());
                if (comp.getContracts() == null || comp.getContracts().size() == 0) {
                    dbManager.deleteObject((BasicHibernateEntity)comp);
                    break block5;
                }
                throw new PersistentLayerException(LanguageBundle.THERE_ARE_STILL_CONTRACTS_ASSIGNED_TO_THE_COMPANY);
            }
            finally {
                dbManager.closeSession();
            }
        }
    }

    public void deleteRealOverhead(RealOverheadDTO overhead) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"delete real overhead");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            dbManager.deleteObject(dtoManager.merge((BasicDTO)overhead));
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ProjectBodyDTO> getProjectBodies() throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get project bodies");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            List result = dbManager.getAllObjects(ProjectBody.class);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(result.size() + " project bodies found"));
            }
            ArrayList arrayList = dtoManager.clone(result);
            return arrayList;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createProjectBody(ProjectBodyDTO projectBody) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create project bodies");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            long id;
            long l = id = ((Long)dbManager.createObject(dtoManager.merge((BasicDTO)projectBody))).longValue();
            return l;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectBodyDTO saveProjectBody(ProjectBodyDTO projectBody) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"save project bodies");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            ProjectBody body = (ProjectBody)dtoManager.merge((BasicDTO)projectBody);
            dbManager.saveObject((BasicHibernateEntity)body);
            ProjectBodyDTO projectBodyDTO = (ProjectBodyDTO)dtoManager.clone((BasicHibernateEntity)body);
            return projectBodyDTO;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProjectBody(ProjectBodyDTO projectBody) throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"delete project bodies");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            ProjectBody body = (ProjectBody)dtoManager.merge((BasicDTO)projectBody);
            Project pro = (Project)dbManager.getObjectByAttribute(Project.class, "projectBody", (Object)body);
            if (pro != null) {
                throw new PersistentLayerException(LanguageBundle.CANNOT_DELETE_PROJECT_BODY);
            }
            dbManager.deleteObject((BasicHibernateEntity)body);
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createCostCategory(CostCategoryDTO costCategory) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create cost category");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            long id;
            long l = id = ((Long)dbManager.createObject(dtoManager.merge((BasicDTO)costCategory))).longValue();
            return l;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CostCategoryDTO saveCostCategory(CostCategoryDTO costCategory) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"save cost category");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            CostCategory cat = (CostCategory)dtoManager.merge((BasicDTO)costCategory);
            dbManager.saveObject((BasicHibernateEntity)cat);
            CostCategoryDTO costCategoryDTO = (CostCategoryDTO)dtoManager.clone((BasicHibernateEntity)cat);
            return costCategoryDTO;
        }
        finally {
            dbManager.closeSession();
        }
    }

    public void deleteCostCategory(CostCategoryDTO costCategory) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"delete cost category");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            dbManager.deleteObject(dtoManager.merge((BasicDTO)costCategory));
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createProjectComponentTag(ProjectComponentTagDTO tag) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create project component tag");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            long id;
            long l = id = ((Long)dbManager.createObject(dtoManager.merge((BasicDTO)tag))).longValue();
            return l;
        }
        finally {
            dbManager.closeSession();
        }
    }

    public void deleteProjectComponentTag(ProjectComponentTagDTO tag) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"delete project component tag");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            dbManager.deleteObject(dtoManager.merge((BasicDTO)tag));
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createProjectCosts(ProjectCostsDTO projectCosts) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create project costs");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            long id;
            long l = id = ((Long)dbManager.createObject(dtoManager.merge((BasicDTO)projectCosts))).longValue();
            return l;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectCostsDTO saveProjectCosts(ProjectCostsDTO projectCosts) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"save project costs");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            ProjectCosts costs = (ProjectCosts)dtoManager.merge((BasicDTO)projectCosts);
            dbManager.saveObject((BasicHibernateEntity)costs);
            ProjectCostsDTO projectCostsDTO = (ProjectCostsDTO)dtoManager.clone((BasicHibernateEntity)costs);
            return projectCostsDTO;
        }
        finally {
            dbManager.closeSession();
        }
    }

    public void deleteProjectCosts(ProjectCostsDTO projectCosts) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"delete project costs");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            dbManager.deleteObject(dtoManager.merge((BasicDTO)projectCosts));
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ProjectCostsDTO> getProjectCostsByProject(ProjectDTO project) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get project costs");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            List result = dbManager.getObjectsByAttribute(ProjectCosts.class, "project", (Object)dtoManager.merge((BasicDTO)project));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(result.size() + " project costs found"));
            }
            ArrayList arrayList = dtoManager.clone(result);
            return arrayList;
        }
        finally {
            dbManager.closeSession();
        }
    }

    public ArrayList<ActivityDTO> getActivitiesByWeek(StaffDTO staff, int year, int week) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get activities by week: " + year + "-" + week));
        }
        Session hibernateSession = null;
        Staff user = staff == null ? this.getStaffById(this.getUserId()) : (Staff)dtoManager.merge((BasicDTO)staff);
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            GregorianCalendar from = this.getFirstDayOfWeek(year, week);
            GregorianCalendar till = this.getLastDayOfWeek(year, week);
            till.add(5, 1);
            hibernateSession = dbManager.getSession();
            List res = hibernateSession.createCriteria(Activity.class).add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"staff", (Object)user), (Criterion)Restrictions.between((String)"day", (Object)from.getTime(), (Object)till.getTime()))).list();
            ArrayList<Activity> result = new ArrayList<Activity>();
            for (Activity tmp : res) {
                if (tmp.getKindofactivity() == 0) {
                    if (ProjectServiceImpl.isSameDay((Date)tmp.getDay(), (Date)till.getTime())) continue;
                    result.add(tmp);
                    continue;
                }
                if (ProjectServiceImpl.isSameDay((Date)tmp.getDay(), (Date)from.getTime())) {
                    if (tmp.getDay().getHours() < 4) continue;
                    result.add(tmp);
                    continue;
                }
                if (ProjectServiceImpl.isSameDay((Date)tmp.getDay(), (Date)till.getTime())) {
                    if (tmp.getDay().getHours() >= 4) continue;
                    result.add(tmp);
                    continue;
                }
                result.add(tmp);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(result.size() + " activities found!!"));
            }
            ArrayList arrayList = dtoManager.clone(result);
            return arrayList;
        }
        catch (Throwable t) {
            logger.error((Object)"Error:", t);
            throw new DataRetrievalException(t.getMessage(), t);
        }
        finally {
            dbManager.closeSession();
        }
    }

    public ActivityResponseType getActivityDataByWeek(StaffDTO staff, int year, int week) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get activities by week: " + year + "-" + week));
        }
        Session hibernateSession = null;
        Staff user = staff == null ? this.getStaffById(this.getUserId()) : this.getStaffById(staff.getId());
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            GregorianCalendar from = this.getFirstDayOfWeek(year, week);
            GregorianCalendar till = this.getLastDayOfWeek(year, week);
            till.add(5, 1);
            hibernateSession = dbManager.getSession();
            List res = hibernateSession.createCriteria(Activity.class).add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"staff", (Object)user), (Criterion)Restrictions.between((String)"day", (Object)from.getTime(), (Object)till.getTime()))).list();
            ArrayList<Activity> result = new ArrayList<Activity>();
            for (Activity tmp : res) {
                if (tmp.getKindofactivity() == 0) {
                    if (ProjectServiceImpl.isSameDay((Date)tmp.getDay(), (Date)till.getTime())) continue;
                    result.add(tmp);
                    continue;
                }
                if (ProjectServiceImpl.isSameDay((Date)tmp.getDay(), (Date)from.getTime())) {
                    if (tmp.getDay().getHours() < 4) continue;
                    result.add(tmp);
                    continue;
                }
                if (ProjectServiceImpl.isSameDay((Date)tmp.getDay(), (Date)till.getTime())) {
                    if (tmp.getDay().getHours() >= 4) continue;
                    result.add(tmp);
                    continue;
                }
                result.add(tmp);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(result.size() + " activities found!!"));
            }
            ActivityResponseType resp = new ActivityResponseType();
            resp.setActivities((List)dtoManager.clone(result));
            resp.setHolidays(this.getHolidaysByWeek(year, week));
            for (HolidayType tmp : resp.getHolidays()) {
                if (tmp.isHalfHoliday()) {
                    tmp.setHours(this.getHoursOfWorkPerWeek(user, tmp.getDate()) / 10.0);
                    continue;
                }
                tmp.setHours(this.getHoursOfWorkPerWeek(user, tmp.getDate()) / 5.0);
            }
            ActivityResponseType activityResponseType = resp;
            return activityResponseType;
        }
        catch (Throwable t) {
            logger.error((Object)"Error:", t);
            throw new DataRetrievalException(t.getMessage(), t);
        }
        finally {
            dbManager.closeSession();
        }
    }

    public ActivityResponseType getActivityDataByWeek(StaffDTO staff, Date firstDayOfWeek, Date lastDayOfweek) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get activities by week: " + firstDayOfWeek.toString() + "-" + lastDayOfweek.toString()));
        }
        Session hibernateSession = null;
        Staff user = staff == null ? this.getStaffById(this.getUserId()) : this.getStaffById(staff.getId());
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            GregorianCalendar from = new GregorianCalendar();
            from.setTime(firstDayOfWeek);
            GregorianCalendar till = new GregorianCalendar();
            till.setTime(lastDayOfweek);
            till.add(5, 1);
            till.set(11, 5);
            hibernateSession = dbManager.getSession();
            List res = hibernateSession.createCriteria(Activity.class).add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"staff", (Object)user), (Criterion)Restrictions.between((String)"day", (Object)from.getTime(), (Object)till.getTime()))).list();
            ArrayList<Activity> result = new ArrayList<Activity>();
            for (Activity tmp : res) {
                if (tmp.getKindofactivity() == 0) {
                    if (ProjectServiceImpl.isSameDay((Date)tmp.getDay(), (Date)till.getTime())) continue;
                    result.add(tmp);
                    continue;
                }
                if (ProjectServiceImpl.isSameDay((Date)tmp.getDay(), (Date)from.getTime())) {
                    if (tmp.getDay().getHours() < 4) continue;
                    result.add(tmp);
                    continue;
                }
                if (ProjectServiceImpl.isSameDay((Date)tmp.getDay(), (Date)till.getTime())) {
                    if (tmp.getDay().getHours() >= 4) continue;
                    result.add(tmp);
                    continue;
                }
                result.add(tmp);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(result.size() + " activities found!!"));
            }
            ActivityResponseType resp = new ActivityResponseType();
            resp.setActivities((List)dtoManager.clone(result));
            resp.setHolidays(this.getHolidaysByWeek(firstDayOfWeek));
            for (HolidayType tmp : resp.getHolidays()) {
                if (tmp.isHalfHoliday()) {
                    tmp.setHours(this.getHoursOfWorkPerWeek(user, tmp.getDate()) / 10.0);
                    continue;
                }
                tmp.setHours(this.getHoursOfWorkPerWeek(user, tmp.getDate()) / 5.0);
            }
            ActivityResponseType activityResponseType = resp;
            return activityResponseType;
        }
        catch (Throwable t) {
            logger.error((Object)"Error:", t);
            throw new DataRetrievalException(t.getMessage(), t);
        }
        finally {
            dbManager.closeSession();
        }
    }

    private double getHoursOfWorkPerWeek(Staff user, Date day) {
        Set c = user.getContracts();
        if (c != null) {
            for (Contract tmp : c) {
                if (tmp.getTodate() != null && !ProjectServiceImpl.isDateLessOrEqual((Date)day, (Date)tmp.getTodate()) || !ProjectServiceImpl.isDateLessOrEqual((Date)tmp.getFromdate(), (Date)day)) continue;
                return tmp.getWhow();
            }
        }
        return 40.0;
    }

    public ActivityDTO getLastActivityForUser(StaffDTO staff) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get last activity");
        }
        Session hibernateSession = null;
        Staff user = staff == null ? this.getStaffById(this.getUserId()) : (Staff)dtoManager.merge((BasicDTO)staff);
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            hibernateSession = dbManager.getSession();
            Activity result = (Activity)hibernateSession.createCriteria(Activity.class).add((Criterion)Restrictions.eq((String)"staff", (Object)user)).addOrder(Order.desc((String)"day")).setMaxResults(1).uniqueResult();
            if (result != null && logger.isDebugEnabled()) {
                logger.debug((Object)("activity with id " + result.getId() + " is last activity"));
            }
            if (result != null) {
                ActivityDTO activityDTO = (ActivityDTO)dtoManager.clone((BasicHibernateEntity)result);
                return activityDTO;
            }
            ActivityDTO activityDTO = null;
            return activityDTO;
        }
        catch (Throwable t) {
            logger.error((Object)"Error:", t);
            throw new DataRetrievalException(t.getMessage(), t);
        }
        finally {
            dbManager.closeSession();
        }
    }

    public List<ActivityDTO> getLastActivitiesForUser(StaffDTO staff) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get last activities");
        }
        ArrayList<Activity> result = new ArrayList<Activity>();
        long userId = staff == null ? this.getUserId() : staff.getId();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            Statement s = dbManager.getDatabaseConnection().createStatement();
            ResultSet rs = s.executeQuery(String.format("select max(id), workpackageid, description from activity where staffid = %1$s and kindofactivity = %2$s group by workpackageid, description having workpackageid <> 408 order by max(id) desc limit 30;", userId, 0));
            if (rs != null) {
                while (rs.next()) {
                    long id = rs.getLong(1);
                    result.add((Activity)dbManager.getObject(Activity.class, id));
                }
            }
            ArrayList arrayList = dtoManager.clone(result);
            return arrayList;
        }
        catch (Throwable t) {
            logger.error((Object)"Error:", t);
            throw new DataRetrievalException(t.getMessage(), t);
        }
        finally {
            dbManager.closeSession();
        }
    }

    public List<ActivityDTO> getLastActivitiesExceptForUser(StaffDTO staff) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get last activities ex");
        }
        ArrayList<Activity> result = new ArrayList<Activity>();
        long userId = staff == null ? this.getUserId() : staff.getId();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            Statement s = dbManager.getDatabaseConnection().createStatement();
            ResultSet rs = s.executeQuery(String.format("select max(id), workpackageid, description from activity where staffid <> %1$s and kindofactivity = %2$s group by workpackageid, description having workpackageid <> 408 order by max(id) desc limit 30;", userId, 0));
            if (rs != null) {
                while (rs.next()) {
                    long id = rs.getLong(1);
                    result.add((Activity)dbManager.getObject(Activity.class, id));
                }
            }
            ArrayList arrayList = dtoManager.clone(result);
            return arrayList;
        }
        catch (Throwable t) {
            logger.error((Object)"Error:", t);
            throw new DataRetrievalException(t.getMessage(), t);
        }
        finally {
            dbManager.closeSession();
        }
    }

    public ArrayList<ActivityDTO> getActivitiesByProject(StaffDTO staff, ProjectDTO project) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get activities by project: " + project.getName()));
        }
        return this.getActivitiesByCriteria(staff, (Object)project);
    }

    public ArrayList<ActivityDTO> getActivitiesByWorkPackage(StaffDTO staff, WorkPackageDTO workPackage) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get activities by workPackage: " + workPackage.getName()));
        }
        return this.getActivitiesByCriteria(staff, (Object)workPackage);
    }

    public ArrayList<ActivityDTO> getActivitiesByWorkCategory(StaffDTO staff, WorkCategoryDTO workCategory) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get activities by WorkCategory: " + workCategory.getName()));
        }
        return this.getActivitiesByCriteria(staff, (Object)workCategory);
    }

    private ArrayList<ActivityDTO> getActivitiesByCriteria(StaffDTO staff, Object criteria) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get activities: " + criteria.getClass().getName()));
        }
        Session hibernateSession = null;
        Staff user = staff == null ? this.getStaffById(this.getUserId()) : (Staff)dtoManager.merge((BasicDTO)staff);
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            hibernateSession = dbManager.getSession();
            Criteria crit = hibernateSession.createCriteria(Activity.class).add((Criterion)Restrictions.eq((String)"staff", (Object)user));
            if (criteria instanceof BasicDTO) {
                criteria = dtoManager.merge((BasicDTO)criteria);
            }
            if (criteria instanceof Project) {
                crit.createCriteria("workPackage").add((Criterion)Restrictions.eq((String)"project", (Object)criteria));
            } else if (criteria instanceof WorkPackage) {
                crit.add((Criterion)Restrictions.eq((String)"workPackage", (Object)criteria));
            } else if (criteria instanceof WorkCategory) {
                crit.add((Criterion)Restrictions.eq((String)"workCategory", (Object)criteria));
            } else {
                throw new DataRetrievalException("The criteria has a not supported type");
            }
            List result = crit.list();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(result.size() + " activities found"));
            }
            ArrayList arrayList = dtoManager.clone(result);
            return arrayList;
        }
        catch (Throwable t) {
            logger.error((Object)"Error:", t);
            throw new DataRetrievalException(t.getMessage(), t);
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createActivity(ActivityDTO activity) throws FullStopException, InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException {
        Activity act;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create activity");
        }
        if (activity.getKindofactivity() == 2 || activity.getKindofactivity() == 1) {
            boolean consistent;
            GregorianCalendar day = new GregorianCalendar();
            day.setTime(activity.getDay());
            if (day.get(11) < 4) {
                day.add(5, -1);
            }
            if (!(consistent = this.isBeginEndConsistent(activity.getStaff(), day.getTime(), activity, false, true))) {
                throw new PersistentLayerException(LanguageBundle.TIME_SLOT_INVALID);
            }
        }
        if ((act = (Activity)dtoManager.merge((BasicDTO)activity)).getStaff() == null) {
            act.setStaff(this.getStaffById(this.getUserId()));
        }
        this.checkUserOrAdminPermission(act.getStaff().getId());
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            if (activity.getKindofactivity() != 1 && activity.getKindofactivity() != 2 && activity.getKindofactivity() != 3 && activity.getWorkPackage() == null) {
                throw new DataRetrievalException(LanguageBundle.ACTIVITY_MUST_HAVE_A_PROJECTCOMPONENT);
            }
            if (act.getKindofactivity() == 3) {
                this.writeJsonLogFile(activity);
            }
            if (act.getWorkCategory() == null) {
                act.setWorkCategory((WorkCategory)dbManager.getObject(WorkCategory.class, 3L));
            }
            List actList = this.checkForMultiActivity(act.getDescription(), act);
            for (Activity tmp : actList) {
                dbManager.createObject((BasicHibernateEntity)act);
            }
            warningSystem.addActivity(act);
            long id = (Long)dbManager.createObject((BasicHibernateEntity)act);
            if (act.getStaff() != null && act.getStaff().getId() != this.getUserId() && act.getDay() != null) {
                this.sendChangedActivityEmail(act, null, act.getStaff().getEmail());
            }
            long l = id;
            return l;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJsonLogFile(ActivityDTO act) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(act.getDay());
        cal.set(11, 0);
        ArrayList userActs = this.getActivityByDay(act.getStaff(), cal.getTime());
        BufferedWriter bfw = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            try {
                ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
                String json = writer.writeValueAsString((Object)userActs);
                String logDir = JSON_LOG_BASE_DIR + System.getProperty("file.separator") + act.getStaff().getUsername();
                if (!new File(logDir).exists()) {
                    new File(logDir).mkdirs();
                }
                StringBuilder fileNameBuilder = new StringBuilder();
                fileNameBuilder.append(logDir);
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                String date = df.format(act.getDay());
                fileNameBuilder.append(System.getProperty("file.separator"));
                fileNameBuilder.append(date);
                File[] files = new File(logDir).listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
                if (files.length > 0) {
                    fileNameBuilder.append("#");
                    fileNameBuilder.append(files.length);
                }
                File logFile = new File(fileNameBuilder.toString());
                bfw = new BufferedWriter(new FileWriter(logFile));
                bfw.write(json, 0, json.length());
            }
            catch (JsonProcessingException ex) {
                logger.error((Object)("Cannot create json object for activity " + act.toString()), (Throwable)ex);
            }
            finally {
                if (bfw != null) {
                    bfw.close();
                }
            }
        }
        catch (IOException ex) {
            logger.error((Object)"Cannot write the json object to file.", (Throwable)ex);
        }
    }

    private List<Activity> checkForMultiActivity(String description, Activity act) {
        ArrayList<Activity> acts = new ArrayList<Activity>();
        if (description == null) {
            return acts;
        }
        try {
            if (description.indexOf("(@") != -1) {
                String substr = description.substring(description.indexOf("(@") + 1);
                substr = substr.substring(0, substr.indexOf(")"));
                StringTokenizer st = new StringTokenizer(substr, "@, ");
                while (st.hasMoreTokens()) {
                    Staff s = this.getStaffByUsername(st.nextToken());
                    if (s == null) continue;
                    Activity newAct = new Activity();
                    newAct.setDay(act.getDay());
                    newAct.setDescription(act.getDescription());
                    newAct.setKindofactivity(act.getKindofactivity());
                    newAct.setWorkPackage(act.getWorkPackage());
                    newAct.setWorkinghours(act.getWorkinghours());
                    newAct.setWorkCategory(act.getWorkCategory());
                    newAct.setStaff(s);
                    acts.add(newAct);
                }
            }
        }
        catch (Throwable t) {
            logger.error((Object)("Error during parsing of " + description), t);
        }
        return acts;
    }

    private void checkActivityDate(ActivityDTO activity) throws InvalidInputValuesException {
        WorkPackagePeriodDTO period;
        if (activity.getWorkPackage() != null && (period = activity.getWorkPackage().determineMostRecentPeriod()) != null) {
            if (!ProjectServiceImpl.isDateLessOrEqual((Date)period.getFromdate(), (Date)activity.getDay())) {
                throw new InvalidInputValuesException(LanguageBundle.ACTIVITY_BEFORE_START_OF_THE_PROJECT_COMPONENT);
            }
            if (period.getTodate() != null && !ProjectServiceImpl.isDateLessOrEqual((Date)activity.getDay(), (Date)period.getTodate())) {
                throw new InvalidInputValuesException(LanguageBundle.ACTIVITY_AFTER_END_OF_THE_PROJECT_COMPONENT);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityDTO saveActivity(ActivityDTO activity) throws FullStopException, InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException {
        Activity activityHib;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"save activity");
        }
        if ((activityHib = (Activity)dtoManager.merge((BasicDTO)activity)).getKindofactivity() == 2 || activityHib.getKindofactivity() == 1) {
            boolean consistent;
            ActivityDTO act = (ActivityDTO)dtoManager.clone((BasicHibernateEntity)activityHib);
            GregorianCalendar day = new GregorianCalendar();
            day.setTime(activity.getDay());
            if (day.get(11) < 4) {
                day.add(5, -1);
            }
            if (!(consistent = this.isBeginEndConsistent(act.getStaff(), day.getTime(), act, true, true))) {
                throw new PersistentLayerException(LanguageBundle.TIME_SLOT_INVALID);
            }
        }
        if (activityHib.getStaff() == null) {
            activityHib.setStaff(this.getStaffById(this.getUserId()));
        }
        this.checkUserOrAdminPermission(activityHib.getStaff().getId());
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            warningSystem.saveActivity(activityHib);
            Activity act = (Activity)dbManager.getObject(Activity.class, new Long(activityHib.getId()).longValue());
            ActivityDTO tmp = (ActivityDTO)dtoManager.clone((BasicHibernateEntity)act);
            Activity origAct = (Activity)dtoManager.merge((BasicDTO)tmp.createCopy());
            if (act.getCommitted()) {
                try {
                    this.checkAdminPermission();
                }
                catch (PermissionDenyException e) {
                    throw new PersistentLayerException(LanguageBundle.CANNOT_CHANGE_ACTIVITY);
                }
            }
            String actText = act.toString();
            activityHib.setReports(act.getReports());
            if (activityHib.getWorkCategory() == null) {
                activityHib.setWorkCategory((WorkCategory)dbManager.getObject(WorkCategory.class, 3L));
            }
            dbManager.closeSession();
            dbManager = new DBManagerWrapper();
            dbManager.saveObject((BasicHibernateEntity)activityHib);
            if (activityHib.getStaff().getId() != this.getUserId() && activityHib.getDay() != null) {
                this.sendChangedActivityEmail(activityHib, origAct, activityHib.getStaff().getEmail());
            }
            ActivityDTO activityDTO = activity;
            return activityDTO;
        }
        finally {
            dbManager.closeSession();
        }
    }

    private void sendChangedActivityEmail(Activity activity, Activity origActivity, String email) {
        try {
            if (!DevProperties.getInstance().isDevMode() && email != null) {
                Staff s = this.getStaffById(this.getUserId());
                String text = "<div class=\"container\"><div style=\"margin-bottom:15px\">";
                if (activity == null) {
                    text = text + s.getFirstname() + " " + s.getName() + " has <b>deleted</b> the following actvitiy:</div>";
                    text = text + "<div style=\"float:left\">";
                    EmailTaskNotice tn = new EmailTaskNotice(origActivity);
                    text = text + tn.toString();
                    text = text + "</div>";
                } else if (origActivity != null) {
                    text = text + s.getFirstname() + " " + s.getName() + " has <b>changed</b> the following actvitiy:</div>";
                    text = text + "<div style=\"float:left\"><div>from</div>";
                    EmailTaskNotice origTN = new EmailTaskNotice(origActivity);
                    text = text + origTN.toString();
                    text = text + "</div>";
                    text = text + "<div style=\"float:right\"><div>to</div>";
                    EmailTaskNotice updatedTN = new EmailTaskNotice(activity);
                    text = text + updatedTN.toString();
                    text = text + "</div>";
                } else {
                    text = text + s.getFirstname() + " " + s.getName() + " has <b>added</b> the following actvitiy:</div>";
                    text = text + "<div style=\"float:left\">";
                    EmailTaskNotice tn = new EmailTaskNotice(activity);
                    text = text + tn.toString();
                    text = text + "</div>";
                }
                text = text + "</div>";
                Utilities.sendCollectedEmail((String)email, (String)"Activity changed", (String)text);
            } else {
                logger.warn((Object)"Cannot send the email, because there is no email address");
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while sending email.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteActivity(ActivityDTO activity) throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"delete activity");
        }
        DBManagerWrapper dbManager = new DBManagerWrapper();
        Activity deletedActivity = (Activity)dtoManager.merge((BasicDTO)activity.createCopy());
        if (activity.getKindofactivity() == 2 || activity.getKindofactivity() == 1) {
            boolean consistent;
            GregorianCalendar day = new GregorianCalendar();
            day.setTime(activity.getDay());
            if (day.get(11) < 4) {
                day.add(5, -1);
            }
            if (!(consistent = this.isBeginEndConsistent(activity.getStaff(), day.getTime(), activity, true, false))) {
                throw new PersistentLayerException(LanguageBundle.TIME_SLOT_INVALID);
            }
        }
        try {
            Activity act = (Activity)dbManager.getObject(Activity.class, new Long(activity.getId()).longValue());
            this.checkUserOrAdminPermission(act.getStaff().getId());
            if (act.getCommitted()) {
                try {
                    this.checkAdminPermission();
                }
                catch (PermissionDenyException e) {
                    throw new PersistentLayerException(LanguageBundle.CANNOT_CHANGE_ACTIVITY);
                }
            }
            String actText = null;
            Staff st = null;
            Date day = null;
            if (act.getDay() != null) {
                actText = act.toString();
                st = act.getStaff();
                day = act.getDay();
            }
            dbManager.deleteObject((BasicHibernateEntity)act);
            if (st != null && st.getId() != this.getUserId() && day != null) {
                this.sendChangedActivityEmail(null, deletedActivity, st.getEmail());
            }
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReportDTO> getReportsForActivities(List<ActivityDTO> activityList) throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getReportsForActivities");
        }
        DBManagerWrapper dbManager = new DBManagerWrapper();
        ArrayList<ReportDTO> reports = new ArrayList<ReportDTO>();
        try {
            for (ActivityDTO activity : activityList) {
                Activity act = (Activity)dbManager.getObject(Activity.class, new Long(activity.getId()).longValue());
                if (act == null) continue;
                this.checkUserOrAdminPermission(act.getStaff().getId());
                Set reportSet = act.getReports();
                ArrayList tmpReports = dtoManager.clone(new ArrayList(reportSet));
                for (ReportDTO rep : tmpReports) {
                    if (reports.contains(rep)) continue;
                    reports.add(rep);
                }
            }
            ArrayList<ReportDTO> arrayList = reports;
            return arrayList;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReportDTO> getReportsForActivity(ActivityDTO activity) throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getReportsForActivity");
        }
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            ArrayList reports;
            Activity act = (Activity)dbManager.getObject(Activity.class, new Long(activity.getId()).longValue());
            this.checkUserOrAdminPermission(act.getStaff().getId());
            Set reportSet = act.getReports();
            ArrayList arrayList = reports = dtoManager.clone(new ArrayList(reportSet));
            return arrayList;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectCategoryDTO saveProjectCategory(ProjectCategoryDTO projectCategory) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"save project category");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            ProjectCategory cat = (ProjectCategory)dtoManager.merge((BasicDTO)projectCategory);
            dbManager.saveObject((BasicHibernateEntity)cat);
            ProjectCategoryDTO projectCategoryDTO = (ProjectCategoryDTO)dtoManager.clone((BasicHibernateEntity)cat);
            return projectCategoryDTO;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createProjectCategory(ProjectCategoryDTO projectCategory) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create project category");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            long id;
            long l = id = ((Long)dbManager.createObject(dtoManager.merge((BasicDTO)projectCategory))).longValue();
            return l;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProjectCategory(ProjectCategoryDTO projectCategory) throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"delete project category");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            ProjectCategory cat = (ProjectCategory)dtoManager.merge((BasicDTO)projectCategory);
            Project p = (Project)dbManager.getObjectByAttribute(Project.class, "projectCategory", (Object)cat);
            if (p != null) {
                throw new PersistentLayerException(LanguageBundle.CANNOT_REMOVE_PROJECT_CATEGORY);
            }
            dbManager.deleteObject((BasicHibernateEntity)cat);
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkCategoryDTO saveWorkCategory(WorkCategoryDTO workCategory) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"save work category");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            WorkCategory cat = (WorkCategory)dtoManager.merge((BasicDTO)workCategory);
            dbManager.saveObject((BasicHibernateEntity)cat);
            WorkCategoryDTO workCategoryDTO = (WorkCategoryDTO)dtoManager.clone((BasicHibernateEntity)cat);
            return workCategoryDTO;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createWorkCategory(WorkCategoryDTO workCategory) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create work category");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            long id;
            long l = id = ((Long)dbManager.createObject(dtoManager.merge((BasicDTO)workCategory))).longValue();
            return l;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWorkCategory(WorkCategoryDTO workCategory) throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException {
        block5: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"delete work category");
            }
            this.checkAdminPermission();
            DBManagerWrapper dbManager = new DBManagerWrapper();
            try {
                WorkCategory wc = (WorkCategory)dtoManager.merge((BasicDTO)workCategory);
                Activity act = (Activity)dbManager.getObjectByAttribute(Activity.class, "workCategory", (Object)wc);
                if (act == null) {
                    dbManager.deleteObject((BasicHibernateEntity)wc);
                    break block5;
                }
                throw new PersistentLayerException(LanguageBundle.THE_WORK_CATEGORY_IS_USED_BY_ACTIVITIES);
            }
            finally {
                dbManager.closeSession();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<WorkCategoryDTO> getWorkCategories() throws InvalidInputValuesException, DataRetrievalException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get work categories");
        }
        this.checkSession();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            List result = dbManager.getAllObjects(WorkCategory.class);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(result.size() + " work categories found"));
            }
            ArrayList arrayList = dtoManager.clone(result);
            return arrayList;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkCategoryDTO getWorkCategory(long id) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get work category");
        }
        this.checkSession();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            WorkCategory result = (WorkCategory)dbManager.getObject(WorkCategory.class, id);
            WorkCategoryDTO workCategoryDTO = (WorkCategoryDTO)dtoManager.clone((BasicHibernateEntity)result);
            return workCategoryDTO;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ContractDocumentDTO> getContractDocuments(ContractDTO contract) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get contract documents");
        }
        this.checkUserOrAdminPermission(contract.getStaff().getId());
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            List result = dbManager.getObjectsByAttribute(ContractDocument.class, "contract", (Object)dtoManager.merge((BasicDTO)contract));
            ArrayList arrayList = dtoManager.clone(result);
            return arrayList;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<TravelDocumentDTO> getTravelDocuments(TravelDTO travel) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get contract documents");
        }
        this.checkUserOrAdminPermission(travel.getStaff().getId());
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            List result = dbManager.getObjectsByAttribute(TravelDocument.class, "travel", (Object)dtoManager.merge((BasicDTO)travel));
            ArrayList arrayList = dtoManager.clone(result);
            return arrayList;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FundingDTO createFunding(FundingDTO funding) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create funding");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            Funding fund = (Funding)dtoManager.merge((BasicDTO)funding);
            long id = (Long)dbManager.createObject((BasicHibernateEntity)fund);
            fund.setId(id);
            FundingDTO fundingDTO = (FundingDTO)dtoManager.clone((BasicHibernateEntity)fund);
            return fundingDTO;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FundingDTO saveFunding(FundingDTO funding) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"save funding");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            Funding fund = (Funding)dtoManager.merge((BasicDTO)funding);
            dbManager.saveObject((BasicHibernateEntity)fund);
            FundingDTO fundingDTO = (FundingDTO)dtoManager.clone((BasicHibernateEntity)fund);
            return fundingDTO;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<FundingDTO> getFundingsForCompany(CompanyDTO company) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get fundings");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            List result = dbManager.getObjectsByAttribute(Funding.class, "company", (Object)dtoManager.merge((BasicDTO)company));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("fundings found " + result.size()));
            }
            ArrayList arrayList = dtoManager.clone(result);
            return arrayList;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ReportDTO> getAllCreatedReports(String reportGenerator, StaffDTO staff, int year) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get all created reports");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            Session hibernateSession = dbManager.getSession();
            Criteria crit = hibernateSession.createCriteria(Report.class).add((Criterion)Restrictions.eq((String)"generatorname", (Object)reportGenerator));
            if (staff != null) {
                crit.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"staff", (Object)dtoManager.merge((BasicDTO)staff)), (Criterion)Restrictions.isNull((String)"staff")));
            }
            if (year != 0) {
                int dateObjectYear = year - 1900;
                crit.add(Restrictions.between((String)"creationtime", (Object)new Date(dateObjectYear, 0, 1), (Object)new Date(dateObjectYear, 11, 31, 23, 59, 59)));
            }
            List result = crit.list();
            ArrayList arrayList = dtoManager.clone(result);
            return arrayList;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ReportType> getAllAvailableReports() throws PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get all available report plugins");
        }
        this.checkAdminPermission();
        ArrayList<ReportType> reports = new ArrayList<ReportType>();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            ProjectTrackerReport[] reportArray;
            for (ProjectTrackerReport tmp : reportArray = reportManager.getAvailableReports()) {
                reports.add(new ReportType(tmp.getReportName(), tmp.supportUserSpecificreportGeneration(), tmp.supportUserUnspecificreportGeneration()));
            }
            ArrayList<ReportType> arrayList = reports;
            return arrayList;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<TravelDTO> getAllTravels(long staffId, long projectId, int year) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get all travels");
        }
        if (staffId == 0L) {
            this.checkAdminPermission();
        } else {
            this.checkUserOrAdminPermission(staffId);
        }
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            Session hibernateSession = dbManager.getSession();
            Criteria crit = hibernateSession.createCriteria(Travel.class);
            if (staffId != 0L) {
                Staff st = new Staff();
                st.setId(staffId);
                crit.add((Criterion)Restrictions.eq((String)"staff", (Object)st));
            }
            if (projectId != 0L) {
                Project pro = new Project();
                pro.setId(projectId);
                crit.add((Criterion)Restrictions.eq((String)"project", (Object)pro));
            }
            if (year != 0) {
                int dateObjectYear = year - 1900;
                crit.add(Restrictions.between((String)"date", (Object)new Date(dateObjectYear, 0, 1), (Object)new Date(dateObjectYear, 11, 31, 23, 59, 59)));
            }
            List result = crit.list();
            ArrayList arrayList = dtoManager.clone(result);
            return arrayList;
        }
        finally {
            dbManager.closeSession();
        }
    }

    public ReportDTO createReport(String name, Date start, Date end, long staffID, String reportName) throws InvalidInputValuesException, ReportNotFoundException, PersistentLayerException, DataRetrievalException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create report");
        }
        this.checkAdminPermission();
        GregorianCalendar startDate = new GregorianCalendar();
        GregorianCalendar endDate = new GregorianCalendar();
        startDate.setTimeInMillis(start.getTime());
        endDate.setTimeInMillis(end.getTime());
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            long id = reportManager.createReport(name, startDate, endDate, staffID, reportName);
            Report clientReport = (Report)dbManager.getObject(Report.class, id);
            ReportDTO reportDTO = (ReportDTO)dtoManager.clone((BasicHibernateEntity)clientReport);
            return reportDTO;
        }
        catch (de.cismet.projecttracker.report.exceptions.DataRetrievalException e) {
            throw new DataRetrievalException((Throwable)e);
        }
        catch (de.cismet.projecttracker.report.exceptions.ReportNotFoundException e) {
            throw new ReportNotFoundException((Throwable)e);
        }
        finally {
            dbManager.closeSession();
        }
    }

    public String checkReport(Date start, Date end, long staffID, String reportName) throws ReportNotFoundException, DataRetrievalException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"check report");
        }
        this.checkAdminPermission();
        if (end.before(start)) {
            throw new DataRetrievalException(LanguageBundle.END_IS_BEFORE_START);
        }
        ProjectTrackerReport report = reportManager.getReportByName(reportName);
        if (report != null) {
            GregorianCalendar startDate = new GregorianCalendar();
            GregorianCalendar endDate = new GregorianCalendar();
            startDate.setTimeInMillis(start.getTime());
            endDate.setTimeInMillis(end.getTime());
            try {
                if (staffID == 0L) {
                    return report.checkForReport(startDate, endDate);
                }
                return report.checkForReport(startDate, endDate, staffID);
            }
            catch (de.cismet.projecttracker.report.exceptions.DataRetrievalException e) {
                throw new DataRetrievalException((Throwable)e);
            }
        }
        throw new ReportNotFoundException(LanguageBundle.REPORT_PLUGIN_NOT_FOUND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteReport(ReportDTO report) throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"delete report");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            Report result = (Report)dbManager.getObject(Report.class, report.getId());
            dbManager.deleteObject((BasicHibernateEntity)result);
        }
        finally {
            dbManager.closeSession();
        }
    }

    public void deleteContractDocument(ContractDocumentDTO document) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"delete contract document");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            dbManager.deleteObject(dtoManager.merge((BasicDTO)document));
        }
        finally {
            dbManager.closeSession();
        }
    }

    public void deleteTravelDocument(TravelDocumentDTO document) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"delete travel document");
        }
        this.checkAdminPermission();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            dbManager.deleteObject(dtoManager.merge((BasicDTO)document));
        }
        finally {
            dbManager.closeSession();
        }
    }

    public StaffDTO login(String username, String pasword) throws LoginFailedException, DataRetrievalException {
        Session hibernateSession = null;
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            hibernateSession = dbManager.getSession();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(username + " sends login request"));
            }
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(pasword.getBytes());
            Staff staff = DevProperties.getInstance().isDevMode() ? (Staff)hibernateSession.createCriteria(Staff.class).add((Criterion)Restrictions.eq((String)"username", (Object)username)).uniqueResult() : (Staff)hibernateSession.createCriteria(Staff.class).add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"username", (Object)username), (Criterion)Restrictions.eq((String)"password", (Object)md.digest()))).uniqueResult();
            if (staff != null) {
                HttpSession session = this.getThreadLocalRequest().getSession();
                SessionInformation sessionInfo = new SessionInformation();
                sessionInfo.setCurrentUser(staff);
                session.setAttribute("sessionInfo", (Object)sessionInfo);
                Cookie sessionCookie = new Cookie("JSESSIONID", this.getThreadLocalRequest().getSession().getId());
                sessionCookie.setMaxAge(8640000);
                sessionCookie.setPath(this.getThreadLocalRequest().getContextPath());
                this.getThreadLocalResponse().addCookie(sessionCookie);
                StaffDTO staffDTO = (StaffDTO)dtoManager.clone((BasicHibernateEntity)staff);
                return staffDTO;
            }
            try {
                throw new LoginFailedException(LanguageBundle.LOGIN_FAILED);
            }
            catch (Throwable t) {
                logger.error((Object)"Error:", t);
                throw new DataRetrievalException(t.getMessage(), t);
            }
        }
        finally {
            dbManager.closeSession();
        }
    }

    public StaffDTO checkLogin() throws DataRetrievalException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionInformation sessionInfo = (SessionInformation)session.getAttribute("sessionInfo");
            if (sessionInfo != null) {
                return (StaffDTO)dtoManager.clone((BasicHibernateEntity)sessionInfo.getCurrentUser());
            }
            return null;
        }
        catch (Throwable t) {
            logger.error((Object)"Error:", t);
            throw new DataRetrievalException(t.getMessage(), t);
        }
    }

    public void logout() {
        block3: {
            try {
                HttpSession session = this.getThreadLocalRequest().getSession();
                if (session != null) {
                    session.invalidate();
                }
            }
            catch (Throwable th) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug((Object)"error during the logout", th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getFirstReportYear() throws DataRetrievalException {
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            Object result = dbManager.getObject("select min(fromdate) from Report as rep");
            if (result != null && result instanceof Timestamp) {
                GregorianCalendar gc = new GregorianCalendar();
                gc.setTimeInMillis(((Timestamp)result).getTime());
                Integer n = gc.get(1);
                return n;
            }
            Integer n = new GregorianCalendar().get(1);
            return n;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getFirstTravelYear() throws DataRetrievalException {
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            Object result = dbManager.getObject("select min(date) from Travel as trav");
            if (result != null && result instanceof Timestamp) {
                GregorianCalendar gc = new GregorianCalendar();
                gc.setTimeInMillis(((Timestamp)result).getTime());
                Integer n = gc.get(1);
                return n;
            }
            Integer n = new GregorianCalendar().get(1);
            return n;
        }
        finally {
            dbManager.closeSession();
        }
    }

    public Double getHoursOfWork(StaffDTO staff, Date day) throws DataRetrievalException, NoSessionException, InvalidInputValuesException, PermissionDenyException {
        Staff user = staff == null ? this.getStaffById(this.getUserId()) : (Staff)dtoManager.merge((BasicDTO)staff);
        if (user.getId() != this.getUserId()) {
            this.checkAdminPermission();
        }
        TimetrackerQuery query = new TimetrackerQuery(ConfigurationManager.getInstance().getConfBaseDir());
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(day.getTime());
        try {
            HoursOfWork how = query.getHoursOfWork(user, cal);
            if (how != null) {
                return how.getHours();
            }
            return 0.0;
        }
        catch (UserNotFoundException e) {
            return 0.0;
        }
    }

    public Date getStartOfWork(StaffDTO staff, Date day) throws DataRetrievalException, NoSessionException, InvalidInputValuesException, PermissionDenyException {
        Staff user = staff == null ? this.getStaffById(this.getUserId()) : (Staff)dtoManager.merge((BasicDTO)staff);
        if (user.getId() != this.getUserId()) {
            this.checkAdminPermission();
        }
        TimetrackerQuery query = new TimetrackerQuery(ConfigurationManager.getInstance().getConfBaseDir());
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(day.getTime());
        try {
            GregorianCalendar res = query.getStartOfWork(user, cal);
            if (res != null) {
                return res.getTime();
            }
            return null;
        }
        catch (UserNotFoundException e) {
            return null;
        }
    }

    public TimePeriod getStartEndOfWork(StaffDTO staff, Date day) throws DataRetrievalException, NoSessionException, InvalidInputValuesException, PermissionDenyException {
        TimePeriod result = new TimePeriod();
        Staff user = staff == null ? this.getStaffById(this.getUserId()) : (Staff)dtoManager.merge((BasicDTO)staff);
        if (user.getId() != this.getUserId()) {
            this.checkAdminPermission();
        }
        TimetrackerQuery query = new TimetrackerQuery(ConfigurationManager.getInstance().getConfBaseDir());
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(day.getTime());
        try {
            Date now;
            GregorianCalendar res = query.getStartOfWork(user, cal);
            if (res != null) {
                result.setStart(res.getTime());
            }
            if (!ProjectServiceImpl.isSameDay((Date)day, (Date)(now = new Date())) && (res = query.getEndOfWork(user, cal)) != null) {
                result.setEnd(res.getTime());
            }
        }
        catch (UserNotFoundException e) {
            return result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDataChanged() throws DataRetrievalException, NoSessionException, InvalidInputValuesException, PermissionDenyException, PersistentLayerException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getStaffById");
        }
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            Staff s = (Staff)dbManager.getObject(Staff.class, this.getUserId());
            if (s.getLastmodification() != null) {
                s.setLastmodification(null);
                this.saveStaff((StaffDTO)dtoManager.clone((BasicHibernateEntity)s));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            dbManager.closeSession();
        }
    }

    private static boolean isSameDay(Date date, Date otherDate) {
        if (date == null && otherDate == null) {
            return true;
        }
        if (date == null || otherDate == null) {
            return false;
        }
        return date.getYear() == otherDate.getYear() && date.getMonth() == otherDate.getMonth() && date.getDate() == otherDate.getDate();
    }

    private static boolean isDateLessOrEqual(Date date1, Date date2) {
        int secondDate;
        int firstDate = (date1.getYear() + 1900) * 10000 + date1.getMonth() * 100 + date1.getDate();
        return firstDate <= (secondDate = (date2.getYear() + 1900) * 10000 + date2.getMonth() * 100 + date2.getDate());
    }

    public List<HolidayType> getHolidaysByWeek(int year, int week) throws InvalidInputValuesException, DataRetrievalException {
        GregorianCalendar cal = this.getFirstDayOfWeek(year, week);
        HolidayEvaluator eval = new HolidayEvaluator();
        ArrayList<HolidayType> holidays = new ArrayList<HolidayType>();
        do {
            int holTmp;
            if ((holTmp = eval.isHoliday(cal)) != -1) {
                HolidayType holiday = new HolidayType();
                holiday.setDate(cal.getTime());
                holiday.setHalfHoliday(holTmp == 1);
                holiday.setName(eval.getNameOfHoliday(cal));
                holidays.add(holiday);
            }
            cal.add(5, 1);
        } while (cal.get(7) != 7);
        return holidays;
    }

    public List<HolidayType> getHolidaysByWeek(Date firstDayOfWeek) throws InvalidInputValuesException, DataRetrievalException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(firstDayOfWeek);
        HolidayEvaluator eval = new HolidayEvaluator();
        ArrayList<HolidayType> holidays = new ArrayList<HolidayType>();
        do {
            int holTmp;
            if ((holTmp = eval.isHoliday(cal)) != -1) {
                HolidayType holiday = new HolidayType();
                holiday.setDate(cal.getTime());
                holiday.setHalfHoliday(holTmp == 1);
                holiday.setName(eval.getNameOfHoliday(cal));
                holidays.add(holiday);
            }
            cal.add(5, 1);
        } while (cal.get(7) != 7);
        return holidays;
    }

    private void checkAdminPermission() throws PermissionDenyException, NoSessionException {
        try {
            SessionInformation sessionInfo = this.getCurrentSession();
            if (!sessionInfo.isAdmin()) {
                throw new PermissionDenyException(LanguageBundle.ONLY_ALLOWED_FOR_ADMIN);
            }
        }
        catch (NoSessionException e) {
            throw e;
        }
        catch (Throwable th) {
            throw new PermissionDenyException(LanguageBundle.ONLY_ALLOWED_FOR_ADMIN);
        }
    }

    private void checkUserOrAdminPermission(long userId) throws PermissionDenyException, NoSessionException {
        try {
            long signedUser = this.getUserId();
            SessionInformation sessionInfo = this.getCurrentSession();
            if (signedUser != userId && !sessionInfo.isAdmin()) {
                throw new PermissionDenyException(LanguageBundle.ONLY_ALLOWED_FOR_ADMIN);
            }
        }
        catch (NoSessionException e) {
            throw e;
        }
        catch (Throwable th) {
            throw new PermissionDenyException(LanguageBundle.ONLY_ALLOWED_FOR_ADMIN);
        }
    }

    private void checkSession() throws NoSessionException {
        this.getCurrentSession();
    }

    private long getUserId() throws NoSessionException {
        SessionInformation sessionInfo = this.getCurrentSession();
        return sessionInfo.getCurrentUser().getId();
    }

    private SessionInformation getCurrentSession() throws NoSessionException {
        HttpSession session = this.getThreadLocalRequest().getSession(false);
        if (session == null) {
            throw new NoSessionException();
        }
        SessionInformation sessionInfo = (SessionInformation)session.getAttribute("sessionInfo");
        if (sessionInfo == null) {
            throw new NoSessionException();
        }
        return sessionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Staff getStaffById(long id) throws DataRetrievalException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getStaffById");
        }
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            Staff result;
            Staff staff = result = (Staff)dbManager.getObject(Staff.class, id);
            return staff;
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Staff getStaffByUsername(String username) throws DataRetrievalException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getStaffByUsername");
        }
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            Staff result;
            Staff staff = result = (Staff)dbManager.getObjectByAttribute(Staff.class, "username", (Object)username);
            return staff;
        }
        finally {
            dbManager.closeSession();
        }
    }

    private GregorianCalendar getFirstDayOfWeek(int year, int week) {
        GregorianCalendar from = new GregorianCalendar(year, 0, 1, 0, 0, 0);
        from.setMinimalDaysInFirstWeek(4);
        from.setFirstDayOfWeek(2);
        from.set(7, 2);
        from.set(3, week);
        String time = CalendarHelper.toDateString((GregorianCalendar)from);
        return from;
    }

    private GregorianCalendar getLastDayOfWeek(int year, int week) {
        GregorianCalendar till = new GregorianCalendar(year, 0, 1, 23, 59, 59);
        till.setMinimalDaysInFirstWeek(4);
        till.setFirstDayOfWeek(2);
        till.set(7, 1);
        till.set(3, week);
        String time = CalendarHelper.toDateString((GregorianCalendar)till);
        return till;
    }

    protected boolean shouldCompressResponse(HttpServletRequest request, HttpServletResponse response, String responsePayload) {
        return true;
    }

    public Double getAccountBalance(StaffDTO staff) throws DataRetrievalException, NoSessionException, PermissionDenyException {
        double realWorkingTime = 0.0;
        double nominalWorkingTime = 0.0;
        long nominalWorkingDays = 0L;
        DBManagerWrapper dbManager = new DBManagerWrapper();
        this.checkUserOrAdminPermission(staff.getId());
        try {
            Session hibernateSession = dbManager.getSession();
            List contracts = hibernateSession.createCriteria(Contract.class).add((Criterion)Restrictions.eq((String)"staff.id", (Object)staff.getId())).list();
            for (Contract contract : contracts) {
                if (contract.getCompany().getId() == 3L) continue;
                GregorianCalendar contractToDateCal = new GregorianCalendar();
                GregorianCalendar contractFromDateCal = new GregorianCalendar();
                if (contract.getTodate() != null && contract.getTodate().getTime() < contractToDateCal.getTimeInMillis()) {
                    contractToDateCal.setTime(contract.getTodate());
                }
                if (contractToDateCal.getTime().before(accountBalanceDueDate.getTime())) continue;
                if (contract.getFromdate().before(accountBalanceDueDate.getTime())) {
                    contractFromDateCal.setTime(accountBalanceDueDate.getTime());
                } else {
                    contractFromDateCal.setTime(contract.getFromdate());
                }
                contractToDateCal.set(11, 0);
                contractToDateCal.set(12, 0);
                contractToDateCal.set(13, 0);
                contractFromDateCal.set(11, 0);
                contractFromDateCal.set(12, 0);
                contractFromDateCal.set(13, 0);
                double whow = contract.getWhow();
                SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
                Statement s = dbManager.getDatabaseConnection().createStatement();
                ResultSet rs = s.executeQuery(String.format("SELECT sum(workinghours)  FROM activity WHERE staffid = %2$s AND date_trunc('day', day) >= '%3$s' AND date_trunc('day', day) < '%4$s' AND workpackageid NOT IN (234, 407,408 ,409, 410,411,414, 419);", "" + whow / 5.0, "" + staff.getId(), dateFormatter.format(contractFromDateCal.getTime()), dateFormatter.format(contractToDateCal.getTime())));
                if (rs != null) {
                    while (rs.next()) {
                        realWorkingTime += rs.getDouble(1);
                    }
                }
                if ((rs = s.executeQuery(String.format("SELECT sum(case workinghours  when -1 then 0 when 0 then %1$s else workinghours end)  FROM activity WHERE staffid = %2$s AND date_trunc('day', day) >= '%3$s' AND date_trunc('day', day) < '%4$s' AND workpackageid IN (409,410,411,419);", "" + whow / 5.0, "" + staff.getId(), dateFormatter.format(contractFromDateCal.getTime()), dateFormatter.format(contractToDateCal.getTime())))) != null) {
                    while (rs.next()) {
                        realWorkingTime += rs.getDouble(1);
                    }
                }
                nominalWorkingDays = this.calculateNominalWorkingDays(contractFromDateCal, contractToDateCal);
                nominalWorkingTime += whow / 5.0 * (double)nominalWorkingDays;
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"Error during determining Real_Working_Time. AccountBalance may not be correct", (Throwable)ex);
            throw new DataRetrievalException(ex.getMessage());
        }
        finally {
            dbManager.closeSession();
        }
        Double result = realWorkingTime - nominalWorkingTime;
        return result;
    }

    private int calculateNominalWorkingDays(GregorianCalendar from, GregorianCalendar to) {
        GregorianCalendar fromDay = (GregorianCalendar)from.clone();
        int days = 0;
        while (CalendarHelper.isDateLess((GregorianCalendar)fromDay, (GregorianCalendar)to)) {
            days = (int)((double)days + CalendarHelper.isWorkingDayExactly((GregorianCalendar)fromDay));
            fromDay.add(5, 1);
        }
        return days;
    }

    public List<ActivityDTO> getFavouriteActivities(StaffDTO staff) throws NoSessionException, DataRetrievalException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get favourite activities");
        }
        ArrayList<Activity> result = new ArrayList<Activity>();
        long userId = staff == null ? this.getUserId() : staff.getId();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            Statement s = dbManager.getDatabaseConnection().createStatement();
            ResultSet rs = s.executeQuery(String.format("select max(id), workpackageid, description from activity where staffid = %1$s and day is null group by workpackageid, description", userId));
            if (rs != null) {
                while (rs.next()) {
                    long id = rs.getLong(1);
                    result.add((Activity)dbManager.getObject(Activity.class, id));
                }
            }
            ArrayList arrayList = dtoManager.clone(result);
            return arrayList;
        }
        catch (Throwable t) {
            logger.error((Object)"Error:", t);
            throw new DataRetrievalException(t.getMessage(), t);
        }
        finally {
            dbManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isExisitingFavouriteTask(ActivityDTO activity) {
        DBManagerWrapper dbManager = new DBManagerWrapper();
        try {
            Statement s = dbManager.getDatabaseConnection().createStatement();
            ResultSet rs = s.executeQuery(String.format("select description, staffid, workpackageid from activity where staffid=%1$s and day is null and workpackageid = %2$s and case when description is null then true else description = '%3$s' end", "" + activity.getStaff().getId(), "" + activity.getWorkPackage().getId(), activity.getDescription()));
            if (rs != null && !rs.first()) {
                Boolean bl = false;
                return bl;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(FavouriteTaskStory.class.getName()).log(Level.SEVERE, "Error while checking if facourite task already exists. Drop action cancelled", ex);
        }
        finally {
            dbManager.closeSession();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean checkBeginOfDayActivityExists(StaffDTO staff) {
        block10: {
            DBManagerWrapper dbManager = new DBManagerWrapper();
            try {
                Statement s = dbManager.getDatabaseConnection().createStatement();
                SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
                String query = String.format("select max(day) from activity where staffid = %1$s and date_trunc('day', day) = '%2$s' and kindofactivity=1", staff.getId(), dateFormatter.format(new Date()));
                ResultSet rs = s.executeQuery(query);
                if (rs != null) {
                    while (rs.next()) {
                        if (rs.getDate(1) != null) continue;
                        Boolean bl = false;
                        return bl;
                    }
                }
                if ((rs = s.executeQuery(String.format("select kindofactivity, day from activity where staffid = %1$s and day = (select max(day) from activity where staffid = %1$s and date_trunc('day',day) ='%2$s')", staff.getId(), dateFormatter.format(new Date())))) == null) break block10;
                while (rs.next()) {
                    if (rs.getInt(1) != 2) continue;
                    Date helper = new Date();
                    Date now = new Date(helper.getYear(), helper.getMonth(), helper.getDate(), helper.getHours(), helper.getMinutes());
                    Timestamp endOfDay = rs.getTimestamp("day");
                    if (!endOfDay.before(now)) continue;
                    Boolean bl = false;
                    return bl;
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(ProjectServiceImpl.class.getName()).log(Level.SEVERE, "Error while checking if begin_of_day activity exists", ex);
            }
            finally {
                dbManager.closeSession();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isDayLocked(Date day, StaffDTO s) {
        DBManagerWrapper dbManager = new DBManagerWrapper();
        if (day == null) {
            return false;
        }
        Date d = new Date(day.getTime());
        d.setHours(5);
        d.setMinutes(0);
        d.setSeconds(0);
        Activity lockedDayActivity = null;
        Criteria crit = null;
        try {
            crit = dbManager.getSession().createCriteria(Activity.class).add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"staff", (Object)dtoManager.merge((BasicDTO)s)), (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"kindofactivity", (Object)3), (Criterion)Restrictions.eq((String)"day", (Object)d)))).setMaxResults(1);
            lockedDayActivity = (Activity)crit.uniqueResult();
        }
        catch (InvalidInputValuesException ex) {
            Logger.getLogger(ProjectServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            dbManager.closeSession();
        }
        if (lockedDayActivity != null) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ActivityDTO> getActivityByDay(StaffDTO staff, Date day) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        ArrayList<ActivityDTO> resultList = new ArrayList<ActivityDTO>();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        Criteria crit = null;
        try {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(day);
            cal.add(6, 1);
            LogicalExpression dateRestriction = Restrictions.and((Criterion)Restrictions.ge((String)"day", (Object)day), (Criterion)Restrictions.lt((String)"day", (Object)cal.getTime()));
            crit = dbManager.getSession().createCriteria(Activity.class).add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"staff", (Object)dtoManager.merge((BasicDTO)staff)), (Criterion)dateRestriction));
            crit.addOrder(Order.asc((String)"day"));
            List list = crit.list();
            for (Activity activity : list) {
                resultList.add((ActivityDTO)dtoManager.clone((BasicHibernateEntity)activity));
            }
        }
        catch (InvalidInputValuesException ex) {
            Logger.getLogger(ProjectServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            dbManager.closeSession();
        }
        return resultList;
    }

    public Double getVacationDaysTaken(Date d, StaffDTO staff) {
        Date firstDayInYear = new Date(d.getYear(), 0, 1);
        return this.getVacationDays(firstDayInYear, d, staff);
    }

    public Double getVacationDaysPlanned(Date d, StaffDTO staff) {
        Date lastDayInYear = new Date(d.getYear(), 11, 31);
        return this.getVacationDays(d, lastDayInYear, staff);
    }

    private ArrayList<ContractDTO> getContractforIntervall(Date from, Date to, StaffDTO staff) {
        ArrayList<ContractDTO> result = new ArrayList<ContractDTO>();
        ArrayList contracts = staff.getContracts();
        for (ContractDTO c : contracts) {
            if (c.getFromdate().compareTo(from) >= 0 && c.getFromdate().compareTo(to) < 0) {
                result.add(c);
                continue;
            }
            if (c.getTodate() == null || c.getTodate().after(to)) {
                if (c.getFromdate().compareTo(from) > 0) continue;
                result.add(c);
                break;
            }
            if (c.getTodate() == null || !c.getTodate().after(from) || c.getTodate().compareTo(to) > 0) continue;
            result.add(c);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Double getVacationDays(Date from, Date to, StaffDTO staff) {
        DBManagerWrapper dbManager = new DBManagerWrapper();
        ArrayList contracts = this.getContractforIntervall(from, to, staff);
        double result = 0.0;
        for (ContractDTO c : contracts) {
            Date t;
            Date f;
            double whPerWeek = c.getWhow();
            if (c.getFromdate().before(from)) {
                if (c.getTodate() != null && c.getTodate().before(to)) {
                    f = from;
                    t = c.getTodate();
                } else {
                    f = from;
                    t = to;
                }
            } else if (c.getFromdate().before(to) && c.getTodate() != null && c.getTodate().before(to)) {
                f = c.getFromdate();
                t = c.getTodate();
            } else {
                f = c.getFromdate();
                t = to;
            }
            try {
                Statement s = dbManager.getDatabaseConnection().createStatement();
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                ResultSet rs = s.executeQuery(String.format("select * from activity where staffid=%1$s and workpackageid = 409 and day>='%2$s' and day <='%3$s'", staff.getId(), df.format(f), df.format(t)));
                if (rs == null) continue;
                while (rs.next()) {
                    double wh = rs.getDouble("workinghours");
                    if (wh == 0.0) {
                        result += 1.0;
                        continue;
                    }
                    result += wh / (whPerWeek / 5.0);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(ProjectServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                dbManager.closeSession();
            }
        }
        return Math.rint(result * 2.0) / 2.0;
    }

    private double getPartialVacationDays(Date from, Date to, ContractDTO contract) {
        long difference = to.getTime() - from.getTime();
        double days = difference / 1000L / 60L / 60L / 24L;
        double vacationDaysPerYear = contract.getVacation();
        return days * vacationDaysPerYear / 365.0;
    }

    private double getTotalVacationDaysForYear(Date year, StaffDTO staff) {
        Date firstDayYearBefore = new Date(year.getYear(), 0, 1);
        Date lastDayYearBefore = new Date(year.getYear(), 11, 31);
        ArrayList contracts = this.getContractforIntervall(firstDayYearBefore, lastDayYearBefore, staff);
        double totalVacationDays = 0.0;
        if (contracts.size() > 1) {
            for (ContractDTO c : contracts) {
                if (c.getFromdate().before(firstDayYearBefore)) {
                    totalVacationDays += this.getPartialVacationDays(firstDayYearBefore, c.getTodate(), c);
                    continue;
                }
                if (c.getTodate() != null && c.getTodate().before(lastDayYearBefore)) {
                    totalVacationDays += this.getPartialVacationDays(c.getFromdate(), c.getTodate(), c);
                    continue;
                }
                totalVacationDays += this.getPartialVacationDays(c.getFromdate(), lastDayYearBefore, c);
            }
        } else if (contracts.size() == 1) {
            totalVacationDays = ((ContractDTO)contracts.get(0)).getVacation();
        }
        return Math.rint(totalVacationDays * 2.0) / 2.0;
    }

    public Double getVacationCarryOver(Date year, StaffDTO staff) {
        Date firstDayYearBefore = new Date(year.getYear() - 1, 0, 1);
        Date lastDayYearBefore = new Date(year.getYear() - 1, 11, 31);
        double totalVacationDays = this.getTotalVacationDaysForYear(new Date(year.getYear() - 1, 0, 1), staff);
        if (year.getYear() + 1900 - 1 == 2012) {
            ProfileDTO profile = staff.getProfile();
            if (profile != null) {
                totalVacationDays += profile.getResidualVacation();
            }
        } else {
            totalVacationDays += this.getVacationCarryOver(new Date(year.getYear() - 1, year.getMonth(), year.getDate()), staff).doubleValue();
        }
        return totalVacationDays - this.getVacationDays(firstDayYearBefore, lastDayYearBefore, staff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Date> getUnlockedDays(StaffDTO staff) {
        DBManagerWrapper dbManager = new DBManagerWrapper();
        ArrayList<Date> result = new ArrayList<Date>();
        try {
            Statement s = dbManager.getDatabaseConnection().createStatement();
            SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy");
            ResultSet rs = s.executeQuery(String.format("select distinct(date_trunc('day',day))  from \"public\".activity  where staffid = %1$s and day>='01-03-2012' except select distinct(date_trunc('day',day)) from \"public\".activity where staffid=%1$s and day>='01-03-2012' and kindofactivity = 3 order by date_trunc desc;", staff.getId()));
            if (rs != null) {
                while (rs.next()) {
                    java.sql.Date d = rs.getDate(1);
                    result.add(d);
                }
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(ProjectServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            dbManager.closeSession();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ActivityDTO> getVacationActivitiesTaken(Date d, StaffDTO staff) {
        DBManagerWrapper dbManager = new DBManagerWrapper();
        Session hibernateSession = null;
        try {
            hibernateSession = dbManager.getSession();
            WorkPackage wp = (WorkPackage)dbManager.getObject(WorkPackage.class, 409L);
            WorkPackageDTO wpDTO = (WorkPackageDTO)dtoManager.clone((BasicHibernateEntity)wp);
            LogicalExpression dateRestriction = Restrictions.and((Criterion)Restrictions.ge((String)"day", (Object)new Date(d.getYear(), 0, 1)), (Criterion)Restrictions.le((String)"day", (Object)d));
            LogicalExpression wpRestriction = Restrictions.and((Criterion)Restrictions.eq((String)"staff.id", (Object)staff.getId()), (Criterion)Restrictions.eq((String)"workPackage.id", (Object)wpDTO.getId()));
            Criteria crit = hibernateSession.createCriteria(Activity.class).add((Criterion)Restrictions.and((Criterion)wpRestriction, (Criterion)dateRestriction));
            crit.addOrder(Property.forName((String)"day").asc());
            List result = crit.list();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(result.size() + " activities found"));
            }
            ArrayList arrayList = dtoManager.clone(result);
            return arrayList;
        }
        catch (DataRetrievalException ex) {
            Logger.getLogger(ProjectServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvalidInputValuesException ex) {
            Logger.getLogger(ProjectServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            dbManager.closeSession();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ActivityDTO> getVacationActivitiesPlanned(Date d, StaffDTO staff) {
        DBManagerWrapper dbManager = new DBManagerWrapper();
        Session hibernateSession = null;
        try {
            hibernateSession = dbManager.getSession();
            WorkPackage wp = (WorkPackage)dbManager.getObject(WorkPackage.class, 409L);
            WorkPackageDTO wpDTO = (WorkPackageDTO)dtoManager.clone((BasicHibernateEntity)wp);
            LogicalExpression dateRestriction = Restrictions.and((Criterion)Restrictions.ge((String)"day", (Object)d), (Criterion)Restrictions.le((String)"day", (Object)new Date(d.getYear(), 11, 31)));
            LogicalExpression wpRestriction = Restrictions.and((Criterion)Restrictions.eq((String)"staff.id", (Object)staff.getId()), (Criterion)Restrictions.eq((String)"workPackage.id", (Object)wpDTO.getId()));
            Criteria crit = hibernateSession.createCriteria(Activity.class).add((Criterion)Restrictions.and((Criterion)wpRestriction, (Criterion)dateRestriction));
            List result = crit.list();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(result.size() + " activities found"));
            }
            ArrayList arrayList = dtoManager.clone(result);
            return arrayList;
        }
        catch (DataRetrievalException ex) {
            Logger.getLogger(ProjectServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvalidInputValuesException ex) {
            Logger.getLogger(ProjectServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            dbManager.closeSession();
        }
        return null;
    }

    public double getTotalVacationForYear(StaffDTO staff, Date year) {
        return this.getTotalVacationDaysForYear(year, staff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ActivityDTO> getActivites(List<WorkPackageDTO> workpackages, List<StaffDTO> staff, Date from, Date til, String description) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        ArrayList<ActivityDTO> result = new ArrayList<ActivityDTO>();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        Session hibernateSession = null;
        Transaction tx = null;
        Conjunction conjuction = Restrictions.conjunction();
        if (workpackages != null && !workpackages.isEmpty()) {
            ArrayList<Long> wpIds = new ArrayList<Long>();
            for (WorkPackageDTO wp : workpackages) {
                wpIds.add(wp.getId());
            }
            conjuction.add(Restrictions.in((String)"workPackage.id", wpIds));
        }
        if (staff != null && !staff.isEmpty()) {
            ArrayList<Long> staffIds = new ArrayList<Long>();
            for (StaffDTO s : staff) {
                staffIds.add(s.getId());
            }
            conjuction.add(Restrictions.in((String)"staff.id", staffIds));
        }
        conjuction.add(Restrictions.isNotNull((String)"day"));
        if (from != null && til != null && from.compareTo(til) < 0) {
            conjuction.add((Criterion)Restrictions.ge((String)"day", (Object)from));
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(til);
            cal.set(11, 4);
            conjuction.add((Criterion)Restrictions.le((String)"day", (Object)cal.getTime()));
        }
        if (description != null && !description.isEmpty()) {
            conjuction.add(Restrictions.ilike((String)"description", (String)description.trim(), (MatchMode)MatchMode.ANYWHERE));
        }
        try {
            hibernateSession = dbManager.getSession();
            tx = hibernateSession.beginTransaction();
            Criteria crit = hibernateSession.createCriteria(Activity.class).add((Criterion)conjuction);
            crit.addOrder(Order.desc((String)"day"));
            result.addAll(dtoManager.clone(crit.list()));
            tx.commit();
        }
        catch (Exception ex) {
            Logger.getLogger(ProjectServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            tx.rollback();
        }
        finally {
            dbManager.closeSession();
        }
        return result;
    }

    public Double getHoursSumForActivites(List<WorkPackageDTO> workpackages, List<StaffDTO> staff, Date from, Date til, String description) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        return this.getHoursSumForActivites(workpackages, staff, from, til, description, null);
    }

    public Double getHoursSumForActivites(List<WorkPackageDTO> workpackages, List<StaffDTO> staff, Date from, Date til, String description, ActivityDTO activity) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        return this.getHoursSumForActivites(workpackages, staff, from, til, description, activity, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getHoursSumForActivites(List<WorkPackageDTO> workpackages, List<StaffDTO> staff, Date from, Date til, String description, ActivityDTO activity, boolean onlyIssues) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        ArrayList result = new ArrayList();
        DBManagerWrapper dbManager = new DBManagerWrapper();
        Session hibernateSession = null;
        Transaction tx = null;
        double sum = 0.0;
        Conjunction conjuction = Restrictions.conjunction();
        if (workpackages != null && !workpackages.isEmpty()) {
            ArrayList<Long> wpIds = new ArrayList<Long>();
            for (WorkPackageDTO wp : workpackages) {
                wpIds.add(wp.getId());
            }
            conjuction.add(Restrictions.in((String)"workPackage.id", wpIds));
        }
        if (staff != null && !staff.isEmpty()) {
            ArrayList<Long> staffIds = new ArrayList<Long>();
            for (StaffDTO s : staff) {
                staffIds.add(s.getId());
            }
            conjuction.add(Restrictions.in((String)"staff.id", staffIds));
        }
        conjuction.add(Restrictions.isNotNull((String)"day"));
        if (from != null && til != null && from.compareTo(til) < 0) {
            conjuction.add((Criterion)Restrictions.ge((String)"day", (Object)from));
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(til);
            cal.set(11, 4);
            conjuction.add((Criterion)Restrictions.le((String)"day", (Object)cal.getTime()));
        }
        if (description != null && !description.isEmpty()) {
            conjuction.add(Restrictions.ilike((String)"description", (String)description.trim(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (activity != null && activity.getId() > 0L) {
            conjuction.add((Criterion)Restrictions.ne((String)"id", (Object)activity.getId()));
        }
        try {
            hibernateSession = dbManager.getSession();
            tx = hibernateSession.beginTransaction();
            Criteria crit = hibernateSession.createCriteria(Activity.class).add((Criterion)conjuction);
            result.addAll(dtoManager.clone(crit.list()));
            tx.commit();
            for (ActivityDTO a : result) {
                if (!onlyIssues || a.getDescription() != null && a.getDescription().contains("#") && a.getDescription().indexOf("#") == a.getDescription().lastIndexOf("#")) {
                    sum += a.getWorkinghours();
                    continue;
                }
                if (!onlyIssues || a.getDescription() == null || !a.getDescription().contains("#") || a.getDescription().indexOf("#") == a.getDescription().lastIndexOf("#")) continue;
                String desc = a.getDescription();
                int matches = 0;
                for (int i = 0; i < desc.length(); ++i) {
                    if (desc.charAt(i) != '#' || i + 1 >= desc.length() || !Character.isDigit(desc.charAt(i + 1))) continue;
                    ++matches;
                }
                if (matches <= 0) continue;
                sum += a.getWorkinghours() / (double)matches;
            }
        }
        catch (Exception ex) {
            Logger.getLogger(ProjectServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            tx.rollback();
        }
        finally {
            dbManager.closeSession();
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, String> getProjectUrls() throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        Properties properties = PROJECT_URLS;
        synchronized (properties) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : PROJECT_URLS.stringPropertyNames()) {
                map.put(key, PROJECT_URLS.getProperty(key));
            }
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBeginEndConsistent(StaffDTO staff, Date day, ActivityDTO newActivity, boolean delete, boolean create) {
        DBManagerWrapper dbManager = new DBManagerWrapper();
        ArrayList<ActivityDTO> result = new ArrayList<ActivityDTO>();
        Session hibernateSession = null;
        Transaction tx = null;
        Conjunction conjuction = Restrictions.conjunction();
        conjuction.add((Criterion)Restrictions.eq((String)"staff.id", (Object)staff.getId()));
        Object[] kindofArr = new Integer[]{new Integer(1), new Integer(2)};
        conjuction.add(Restrictions.in((String)"kindofactivity", (Object[])kindofArr));
        GregorianCalendar from = new GregorianCalendar();
        from.setTime(day);
        GregorianCalendar to = new GregorianCalendar();
        to.setTime(day);
        from.set(11, 4);
        from.set(12, 0);
        from.set(13, 0);
        to.add(5, 1);
        to.set(11, 4);
        to.set(12, 0);
        to.set(13, 0);
        LogicalExpression dateRestriction = Restrictions.and((Criterion)Restrictions.ge((String)"day", (Object)from.getTime()), (Criterion)Restrictions.lt((String)"day", (Object)to.getTime()));
        conjuction.add((Criterion)dateRestriction);
        try {
            hibernateSession = dbManager.getSession();
            tx = hibernateSession.beginTransaction();
            Criteria crit = hibernateSession.createCriteria(Activity.class).add((Criterion)conjuction);
            crit.addOrder(Order.asc((String)"day"));
            result.addAll(dtoManager.clone(crit.list()));
            tx.commit();
            if (delete) {
                ActivityDTO actToDelete = null;
                for (ActivityDTO act : result) {
                    if (act.getId() != newActivity.getId()) continue;
                    actToDelete = act;
                    break;
                }
                if (actToDelete != null) {
                    result.remove(actToDelete);
                }
            }
            if (create && newActivity != null) {
                result.add(newActivity);
            }
            Collections.sort(result);
            for (int i = 0; i < result.size(); ++i) {
                ActivityDTO act = (ActivityDTO)result.get(i);
                if (i == result.size() - 1) continue;
                if (i % 2 == 0) {
                    if (act.getKindofactivity() == 1) continue;
                    boolean bl = false;
                    return bl;
                }
                if (act.getKindofactivity() == 2) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (HibernateException ex) {
            logger.error((Object)("Error durin checking begin and end times for user " + staff.getUsername() + " and day " + day), (Throwable)ex);
            tx.rollback();
        }
        catch (InvalidInputValuesException ex) {
            logger.error((Object)("Error durin checking begin and end times for user " + staff.getUsername() + " and day " + day), (Throwable)ex);
            tx.rollback();
        }
        finally {
            dbManager.closeSession();
        }
        return true;
    }

    static /* synthetic */ void access$000() {
        ProjectServiceImpl.fetchProjectUrlConfig();
    }

    static {
        initialised = false;
        dtoManager = new DTOManager();
        accountBalanceDueDate = new GregorianCalendar(2012, 2, 1);
        refreshConfigTimer = new Timer(true);
        refreshConfigTimer.schedule((TimerTask)new /* Unavailable Anonymous Inner Class!! */, 60000L, 60000L);
    }
}

