/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.server;

import de.cismet.projecttracker.client.exceptions.DataRetrievalException;
import de.cismet.projecttracker.client.exceptions.LoginFailedException;
import de.cismet.projecttracker.report.db.entities.Activity;
import de.cismet.projecttracker.report.db.entities.Staff;
import de.cismet.projecttracker.report.query.DBManager;
import de.cismet.projecttracker.server.BasicServlet;
import de.cismet.projecttracker.server.ConfigurationManager;
import java.io.IOException;
import java.io.Serializable;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class QuickBooking
extends BasicServlet {
    private static final org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(QuickBooking.class);
    private static final String PRESENT_RESPONSE = "anwesend";
    private static final String ABSENT_RESPONSE = "abwesend";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.addHeader("Access-Control-Allow-Origin", "*");
        resp.addHeader("Access-Control-Allow-Methods", "GET, POST, DELETE, PUT, OPTIONS");
        resp.addHeader("Access-Control-Allow-Headers", "Content-Type, Authorization");
        super.service(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        String operation = request.getParameter("operation");
        DBManager dbManager = new DBManager(ConfigurationManager.getInstance().getConfBaseDir());
        ServletOutputStream out = response.getOutputStream();
        try {
            Staff staff = this.checklogin(username, password, request.getSession(), dbManager);
            if (staff != null) {
                if (operation.equals("changeStatus")) {
                    this.changeStatus(staff, dbManager);
                } else if (operation.toLowerCase().equals("kommen")) {
                    this.addCome(staff, dbManager, response);
                } else if (operation.toLowerCase().equals("gehen")) {
                    this.addGo(staff, dbManager, response);
                } else if (operation.toLowerCase().equals("status")) {
                    String status = this.status(staff, dbManager);
                    if (status != null) {
                        out.print(status);
                    } else {
                        out.print(ABSENT_RESPONSE);
                    }
                } else if (operation.toLowerCase().equals("addslot")) {
                    String von = request.getParameter("von");
                    String bis = request.getParameter("bis");
                    if (von != null && bis != null) {
                        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                        Date from = formatter.parse(von);
                        Date until = formatter.parse(bis);
                        if (from.getYear() != until.getYear() || from.getMonth() != until.getMonth() || from.getDate() != until.getDate()) {
                            response.setStatus(400);
                            out.print("The 2 dates are on different days");
                            return;
                        }
                        this.addSlot(staff, from, until, dbManager, response);
                    } else {
                        response.setStatus(400);
                        out.print("von or bis parameter not found");
                    }
                } else {
                    response.setStatus(400);
                    out.print("No valid operation found.");
                }
            } else {
                response.setStatus(400);
                out.print("The username/password is not correct.");
            }
        }
        catch (Exception e) {
            logger.error((Object)"login error", (Throwable)e);
            e.printStackTrace();
            response.setStatus(400);
            out.print(e.getMessage());
        }
        finally {
            dbManager.closeSession();
            out.close();
        }
    }

    private void changeStatus(Staff staff, DBManager dbManager) {
        Object lastAct = dbManager.getSession().createCriteria(Activity.class).add((Criterion)Restrictions.eq((String)"staff", (Object)staff)).add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"kindofactivity", (Object)1), (Criterion)Restrictions.eq((String)"kindofactivity", (Object)2))).addOrder(Order.desc((String)"day")).setMaxResults(1).uniqueResult();
        if (lastAct instanceof Activity) {
            Activity act = new Activity();
            act.setKindofactivity(((Activity)lastAct).getKindofactivity() % 2 + 1);
            act.setStaff(staff);
            act.setDay(new Date());
            dbManager.createObject((Object)act);
            this.refreshModification(staff, dbManager);
        }
    }

    private void refreshModification(Staff staff, DBManager dbManager) {
        staff.setLastmodification(new Date());
        dbManager.saveObject((Object)staff);
    }

    private String status(Staff staff, DBManager dbManager) {
        Object lastAct = dbManager.getSession().createCriteria(Activity.class).add((Criterion)Restrictions.eq((String)"staff", (Object)staff)).add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"kindofactivity", (Object)1), (Criterion)Restrictions.eq((String)"kindofactivity", (Object)2))).addOrder(Order.desc((String)"day")).setMaxResults(1).uniqueResult();
        if (lastAct instanceof Activity) {
            if (((Activity)lastAct).getKindofactivity() == 1) {
                return PRESENT_RESPONSE;
            }
            return ABSENT_RESPONSE;
        }
        return null;
    }

    private void addSlot(Staff staff, Date from, Date until, DBManager dbManager, HttpServletResponse response) throws Exception {
        Activity actStart = new Activity();
        Activity actEnd = new Activity();
        Serializable idFrom = null;
        Serializable idUntil = null;
        try {
            actStart.setKindofactivity(1);
            actStart.setStaff(staff);
            actStart.setDay(from);
            actStart.setDescription("quickBooking");
            idFrom = dbManager.createObject((Object)actStart);
            actEnd.setKindofactivity(2);
            actEnd.setStaff(staff);
            actEnd.setDay(until);
            idUntil = dbManager.createObject((Object)actEnd);
        }
        catch (Exception e) {
            if (idFrom != null) {
                dbManager.deleteObject((Object)actStart);
            }
            if (idUntil != null) {
                dbManager.deleteObject((Object)actEnd);
            }
            throw new Exception("the time slot has a conflict with an existing slot.");
        }
        this.refreshModification(staff, dbManager);
    }

    public Boolean isDayLocked(DBManager dbManager, Date day, Staff staff) {
        if (day == null) {
            return false;
        }
        Date d = new Date(day.getTime());
        d.setHours(5);
        d.setMinutes(0);
        d.setSeconds(0);
        Criteria crit = dbManager.getSession().createCriteria(Activity.class).add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"staff", (Object)staff), (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"kindofactivity", (Object)3), (Criterion)Restrictions.eq((String)"day", (Object)d)))).setMaxResults(1);
        Activity lockedDayActivity = (Activity)crit.uniqueResult();
        if (lockedDayActivity != null) {
            return true;
        }
        return false;
    }

    private void addCome(Staff staff, DBManager dbManager, HttpServletResponse response) {
        Object lastAct;
        String currStatus = this.status(staff, dbManager);
        if (currStatus.equals(ABSENT_RESPONSE) && (lastAct = dbManager.getSession().createCriteria(Activity.class).add((Criterion)Restrictions.eq((String)"staff", (Object)staff)).add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"kindofactivity", (Object)1), (Criterion)Restrictions.eq((String)"kindofactivity", (Object)2))).addOrder(Order.desc((String)"day")).setMaxResults(1).uniqueResult()) instanceof Activity) {
            Activity tmp = (Activity)lastAct;
            Date helper = new Date();
            Date d = new Date(helper.getYear(), helper.getMonth(), helper.getDate(), helper.getHours(), helper.getMinutes());
            if (tmp.getDay().before(d)) {
                Activity act = new Activity();
                act.setKindofactivity(1);
                act.setStaff(staff);
                act.setDay(new Date());
                dbManager.createObject((Object)act);
                this.refreshModification(staff, dbManager);
                return;
            }
        }
        response.setStatus(400);
        try {
            ServletOutputStream out = response.getOutputStream();
            out.print("The last activity is already a come booking.");
        }
        catch (IOException ex) {
            Logger.getLogger(QuickBooking.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void addGo(Staff staff, DBManager dbManager, HttpServletResponse response) {
        String stat = this.status(staff, dbManager);
        if (stat.equals(PRESENT_RESPONSE)) {
            Activity act = new Activity();
            act.setKindofactivity(2);
            act.setStaff(staff);
            act.setDay(new Date());
            dbManager.createObject((Object)act);
            this.refreshModification(staff, dbManager);
            return;
        }
        response.setStatus(400);
        try {
            ServletOutputStream out = response.getOutputStream();
            out.print("The last activity is already a go booking");
        }
        catch (IOException ex) {
            Logger.getLogger(QuickBooking.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Staff checklogin(String username, String pasword, HttpSession session, DBManager dbManager) throws LoginFailedException, DataRetrievalException {
        try {
            Session hibernateSession = dbManager.getSession();
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(pasword.getBytes());
            Staff staff = (Staff)hibernateSession.createCriteria(Staff.class).add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"username", (Object)username), (Criterion)Restrictions.eq((String)"password", (Object)md.digest()))).uniqueResult();
            return staff;
        }
        catch (Throwable t) {
            logger.error((Object)"Error:", t);
            throw new DataRetrievalException(t.getMessage(), t);
        }
    }
}

