/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.server;

import de.cismet.projecttracker.client.exceptions.NoSessionException;
import de.cismet.projecttracker.client.exceptions.PermissionDenyException;
import de.cismet.projecttracker.report.ProjectTrackerReport;
import de.cismet.projecttracker.report.ReportManager;
import de.cismet.projecttracker.report.db.entities.Report;
import de.cismet.projecttracker.report.query.DBManager;
import de.cismet.projecttracker.server.BasicServlet;
import de.cismet.projecttracker.server.ConfigurationManager;
import de.cismet.projecttracker.utilities.LanguageBundle;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ReportDownload
extends BasicServlet {
    private static final Logger logger = Logger.getLogger(ReportDownload.class);
    private ReportManager reportManager;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.reportManager = new ReportManager(config.getServletContext().getRealPath("/"), ConfigurationManager.getInstance().getConfBaseDir());
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String urlExtension = null;
        String id = request.getParameter("id");
        response.setContentType("text/html;charset=UTF-8");
        try {
            this.checkAdminPermission(request);
            if (request.getPathInfo() != null) {
                urlExtension = request.getPathInfo().substring(1);
            }
            if (urlExtension == null || urlExtension.equals("")) {
                String pluginName = request.getParameter("plugin");
                this.redirect(id, pluginName, request.getRequestURI(), response);
            } else {
                this.returnFile(id, response);
            }
        }
        catch (PermissionDenyException e) {
            PrintWriter out = response.getWriter();
            out.print("permission deny");
            out.close();
        }
        catch (NoSessionException e) {
            PrintWriter out = response.getWriter();
            out.print("session expired");
            out.close();
        }
    }

    private void redirect(String id, String pluginName, String uri, HttpServletResponse response) throws IOException {
        ProjectTrackerReport reportPlugin = this.reportManager.getReportByName(pluginName);
        String ext = "";
        if (reportPlugin != null) {
            ext = reportPlugin.getFileExtension();
        }
        String newUrl = uri + "/Report" + id + ext + "?id=" + id;
        response.sendRedirect(response.encodeRedirectURL(newUrl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnFile(String id, HttpServletResponse response) throws IOException {
        ServletOutputStream out = response.getOutputStream();
        DBManager dbManager = new DBManager(ConfigurationManager.getInstance().getConfBaseDir());
        try {
            long reportId = Long.parseLong(id);
            Report report = (Report)dbManager.getObject(Report.class, new Long(reportId).longValue());
            ProjectTrackerReport reportPlugin = this.reportManager.getReportByName(report.getGeneratorname());
            if (reportPlugin != null && report != null) {
                response.setContentType(reportPlugin.getMIMEType());
                out.write(report.getReportdocument());
            } else if (reportPlugin == null) {
                logger.error((Object)("report plugin with name " + report.getGeneratorname() + " not found"));
                out.println(LanguageBundle.REPORT_PLUGIN_NOT_FOUND);
            } else if (report == null) {
                logger.error((Object)("report with id " + reportId + " not found"));
                out.println(LanguageBundle.REPORT_NOT_FOUND);
            }
        }
        catch (Throwable t) {
            logger.error((Object)t.getMessage(), t);
        }
        finally {
            if (dbManager != null) {
                dbManager.closeSession();
            }
            out.close();
        }
    }
}

