/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.server;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.module.SimpleModule;
import de.cismet.projecttracker.client.dto.ActivityDTO;
import de.cismet.projecttracker.client.dto.ActivityExtDTO;
import de.cismet.projecttracker.client.exceptions.DataRetrievalException;
import de.cismet.projecttracker.client.exceptions.InvalidInputValuesException;
import de.cismet.projecttracker.client.exceptions.LoginFailedException;
import de.cismet.projecttracker.client.exceptions.NoSessionException;
import de.cismet.projecttracker.client.exceptions.PermissionDenyException;
import de.cismet.projecttracker.report.db.entities.Activity;
import de.cismet.projecttracker.report.db.entities.BasicHibernateEntity;
import de.cismet.projecttracker.report.db.entities.Project;
import de.cismet.projecttracker.report.db.entities.Staff;
import de.cismet.projecttracker.report.db.entities.StaffExtern;
import de.cismet.projecttracker.report.db.entities.WorkCategory;
import de.cismet.projecttracker.report.db.entities.WorkPackage;
import de.cismet.projecttracker.report.helper.CalendarHelper;
import de.cismet.projecttracker.report.query.DBManager;
import de.cismet.projecttracker.server.BasicServlet;
import de.cismet.projecttracker.server.ConfigurationManager;
import de.cismet.projecttracker.server.Search;
import de.cismet.projecttracker.utilities.DTOManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class Search
extends BasicServlet {
    private static final Logger logger = Logger.getLogger(Search.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.addHeader("Access-Control-Allow-Origin", "*");
        resp.addHeader("Access-Control-Allow-Methods", "GET, POST, DELETE, PUT, OPTIONS");
        resp.addHeader("Access-Control-Allow-Headers", "Content-Type, Authorization");
        super.service(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        String workpackage = request.getParameter("workpackage");
        String project = request.getParameter("project");
        String user = request.getParameter("user");
        String description = request.getParameter("description");
        String dateFilter = request.getParameter("datefilter");
        String details = request.getParameter("details");
        String fieldList = request.getParameter("fields");
        DBManager dbManager = new DBManager(ConfigurationManager.getInstance().getConfBaseDir());
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        try {
            Object staff = this.checklogin(username, password, request.getSession(), dbManager);
            if (staff != null) {
                List activities = null;
                Session hibernateSession = dbManager.getSession();
                Staff userObject = null;
                WorkPackage wp = null;
                Project pr = null;
                if (user != null && (userObject = (Staff)hibernateSession.createCriteria(Staff.class).add((Criterion)Restrictions.eq((String)"username", (Object)user)).uniqueResult()) == null) {
                    response.setStatus(400);
                    out.print("user is not valid");
                    return;
                }
                if (project != null && (pr = (Project)hibernateSession.createCriteria(Project.class).add((Criterion)Restrictions.eq((String)"name", (Object)project)).uniqueResult()) == null) {
                    response.setStatus(400);
                    out.print("workpackage is not valid");
                    logger.warn((Object)("Project is not valid " + project));
                    return;
                }
                if (workpackage != null && (wp = pr != null ? (WorkPackage)hibernateSession.createCriteria(WorkPackage.class).add((Criterion)Restrictions.eq((String)"name", (Object)workpackage)).add((Criterion)Restrictions.eq((String)"project", (Object)pr)).uniqueResult() : (WorkPackage)hibernateSession.createCriteria(WorkPackage.class).add((Criterion)Restrictions.eq((String)"name", (Object)workpackage)).uniqueResult()) == null) {
                    response.setStatus(400);
                    logger.warn((Object)("Workpackage is not valid: " + workpackage));
                    out.print("workpackage is not valid");
                    return;
                }
                if (wp == null) {
                    response.setStatus(400);
                    out.print("no valid workpackage");
                    return;
                }
                if (!this.isProjectValidForUser(staff, wp)) {
                    response.setStatus(400);
                    out.print("Permission denied");
                    return;
                }
                activities = this.getActivitiesByCriteria(userObject, (Object)wp, description, dbManager);
                ArrayList<ActivityExtDTO> validActivities = new ArrayList<ActivityExtDTO>();
                double totalTime = 0.0;
                DTOManager dtoManager = new DTOManager();
                if (dateFilter != null) {
                    if (!this.isDateFilterValid(dateFilter)) {
                        response.setStatus(400);
                        out.print("date filter is not valid.");
                        return;
                    }
                    Iterator fromDate = this.parseDate(dateFilter, true);
                    GregorianCalendar tillDate = this.parseDate(dateFilter, false);
                    for (Activity a : activities) {
                        GregorianCalendar d = new GregorianCalendar();
                        d.setTime(a.getDay());
                        if (!CalendarHelper.isDateLessOrEqual(fromDate, (GregorianCalendar)d) || !CalendarHelper.isDateLessOrEqual((GregorianCalendar)d, (GregorianCalendar)tillDate)) continue;
                        validActivities.add(new ActivityExtDTO((ActivityDTO)dtoManager.clone((BasicHibernateEntity)a)));
                    }
                } else {
                    for (Activity a : activities) {
                        validActivities.add(new ActivityExtDTO((ActivityDTO)dtoManager.clone((BasicHibernateEntity)a)));
                    }
                }
                for (ActivityExtDTO tmp : validActivities) {
                    totalTime += tmp.getWorkinghours();
                }
                if (details != null && details.equals("true")) {
                    JsonFactory f = new JsonFactory();
                    ObjectMapper mapper = new ObjectMapper();
                    SimpleModule regularModule = new SimpleModule("NOIOC", new Version(1, 0, 0, null, null, null));
                    regularModule.addSerializer((JsonSerializer)new DTOSerializer(this, fieldList));
                    mapper.registerModule((Module)regularModule);
                    ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
                    String json = writer.writeValueAsString(validActivities);
                    out.print(json);
                    return;
                }
                out.print(totalTime);
                return;
            }
            response.setStatus(400);
            out.print("The username/password is not correct.");
            return;
        }
        catch (Exception e) {
            logger.error((Object)"login error", (Throwable)e);
            e.printStackTrace();
            response.setStatus(400);
            out.print(e.getMessage());
            return;
        }
        finally {
            dbManager.closeSession();
            out.close();
        }
    }

    private boolean isDateFilterValid(String dateFilter) {
        return this.parseDate(dateFilter, true) != null;
    }

    private GregorianCalendar parseDate(String dateFilter, boolean returnFrom) {
        StringTokenizer st = new StringTokenizer(dateFilter, ":");
        if (st.countTokens() == 2) {
            String from = st.nextToken();
            String till = st.nextToken();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date fromDate = df.parse(from);
                Date tillDate = df.parse(till);
                GregorianCalendar result = new GregorianCalendar();
                if (returnFrom) {
                    result.setTime(fromDate);
                } else {
                    result.setTime(tillDate);
                }
                return result;
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    private boolean isProjectValidForUser(Object staff, WorkPackage pr) {
        if (staff instanceof Staff) {
            return true;
        }
        if (staff instanceof StaffExtern) {
            Set wps = ((StaffExtern)staff).getWorkpackages();
            return wps.contains(pr);
        }
        return false;
    }

    private List<Activity> getActivitiesByCriteria(Staff user, Object criteria, String description, DBManager dbManager) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get activities: " + criteria.getClass().getName()));
        }
        Session hibernateSession = null;
        try {
            hibernateSession = dbManager.getSession();
            Criteria crit = null;
            if (user != null) {
                crit = hibernateSession.createCriteria(Activity.class).add((Criterion)Restrictions.eq((String)"staff", (Object)user));
            }
            if (criteria instanceof Project) {
                if (crit != null) {
                    crit.createCriteria("workPackage").add((Criterion)Restrictions.eq((String)"project", (Object)criteria));
                } else {
                    crit = hibernateSession.createCriteria(Activity.class).add((Criterion)Restrictions.eq((String)"project", (Object)criteria));
                }
            } else if (criteria instanceof WorkPackage) {
                if (crit != null) {
                    crit.add((Criterion)Restrictions.eq((String)"workPackage", (Object)criteria));
                } else {
                    crit = hibernateSession.createCriteria(Activity.class).add((Criterion)Restrictions.eq((String)"workPackage", (Object)criteria));
                }
            } else if (criteria instanceof WorkCategory) {
                if (crit != null) {
                    crit.add((Criterion)Restrictions.eq((String)"workCategory", (Object)criteria));
                } else {
                    crit = hibernateSession.createCriteria(Activity.class).add((Criterion)Restrictions.eq((String)"workCategory", (Object)criteria));
                }
            } else {
                throw new DataRetrievalException("The criteria has a not supported type");
            }
            if (description != null) {
                crit.add(Restrictions.ilike((String)"description", (Object)("%" + description + "%")));
            }
            crit.add(Restrictions.isNotNull((String)"day")).addOrder(Order.asc((String)"day"));
            List result = crit.list();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(result.size() + " activities found"));
            }
            return result;
        }
        catch (Throwable t) {
            logger.error((Object)"Error:", t);
            throw new DataRetrievalException(t.getMessage(), t);
        }
    }

    public Object checklogin(String username, String pasword, HttpSession session, DBManager dbManager) throws LoginFailedException, DataRetrievalException {
        try {
            Session hibernateSession = dbManager.getSession();
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(pasword.getBytes());
            byte[] sha1 = md.digest();
            Staff staff = (Staff)hibernateSession.createCriteria(Staff.class).add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"username", (Object)username), (Criterion)Restrictions.eq((String)"password", (Object)sha1))).uniqueResult();
            if (staff == null) {
                StaffExtern staffExtern = (StaffExtern)hibernateSession.createCriteria(StaffExtern.class).add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"username", (Object)username), (Criterion)Restrictions.eq((String)"password", (Object)sha1))).uniqueResult();
                return staffExtern;
            }
            return staff;
        }
        catch (Throwable t) {
            logger.error((Object)"Error:", t);
            throw new DataRetrievalException(t.getMessage(), t);
        }
    }
}

