/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.server;

import de.cismet.projecttracker.client.exceptions.DataRetrievalException;
import de.cismet.projecttracker.client.exceptions.FullStopException;
import de.cismet.projecttracker.client.exceptions.PersistentLayerException;
import de.cismet.projecttracker.report.db.entities.Activity;
import de.cismet.projecttracker.report.db.entities.BasicHibernateEntity;
import de.cismet.projecttracker.report.db.entities.EstimatedComponentCost;
import de.cismet.projecttracker.report.db.entities.EstimatedComponentCostMonth;
import de.cismet.projecttracker.report.db.entities.Warning;
import de.cismet.projecttracker.report.db.entities.WorkPackage;
import de.cismet.projecttracker.report.helper.QueryHelper;
import de.cismet.projecttracker.utilities.DBManagerWrapper;
import de.cismet.projecttracker.utilities.DevProperties;
import de.cismet.projecttracker.utilities.LanguageBundle;
import de.cismet.projecttracker.utilities.Utilities;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class WarningSystem {
    private static final Logger logger = Logger.getLogger(WarningSystem.class);
    private static final int WARNING = 1;
    private static final int CRITICAL = 2;
    private static final int FULL_STOP = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addActivity(Activity activity) throws FullStopException {
        if (activity.getWorkPackage() != null) {
            long wpId = activity.getWorkPackage().getId();
            DBManagerWrapper dbManager = new DBManagerWrapper();
            try {
                Double estimatedHours = this.getEstimatedWpHours(wpId, dbManager);
                Double hours = this.getWpHours(wpId, dbManager);
                if (estimatedHours != null && hours != null) {
                    double percentage;
                    double warnLevel = activity.getWorkPackage().getWarnlevel();
                    double criticalLevel = activity.getWorkPackage().getCriticallevel();
                    double fullStopLevel = activity.getWorkPackage().getFullstoplevel();
                    if (warnLevel == 0.0) {
                        warnLevel = activity.getWorkPackage().getProject().getWarnlevel();
                    }
                    if (criticalLevel == 0.0) {
                        criticalLevel = activity.getWorkPackage().getProject().getCriticallevel();
                    }
                    if (fullStopLevel == 0.0) {
                        fullStopLevel = activity.getWorkPackage().getProject().getFullstoplevel();
                    }
                    if ((percentage = (hours + activity.getWorkinghours()) * 100.0 / estimatedHours) > fullStopLevel && fullStopLevel != 0.0) {
                        this.sendWarning(activity.getWorkPackage(), 3, dbManager);
                        throw new FullStopException(activity.getWorkPackage().getName());
                    }
                    if (percentage > criticalLevel && criticalLevel != 0.0) {
                        this.sendWarning(activity.getWorkPackage(), 2, dbManager);
                    } else if (percentage > warnLevel && warnLevel != 0.0) {
                        this.sendWarning(activity.getWorkPackage(), 1, dbManager);
                    }
                }
            }
            catch (DataRetrievalException e) {
                logger.error((Object)"DB Error. The warning system cannot work properly.", (Throwable)e);
            }
            catch (PersistentLayerException e) {
                logger.error((Object)"DB Error. The warning system cannot work properly.", (Throwable)e);
            }
            finally {
                dbManager.closeSession();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveActivity(Activity activity) throws FullStopException {
        if (activity.getWorkPackage() != null) {
            long wpId = activity.getWorkPackage().getId();
            DBManagerWrapper dbManager = new DBManagerWrapper();
            try {
                Activity originalActivity = (Activity)dbManager.getObject(Activity.class, activity.getId());
                Double estimatedHours = this.getEstimatedWpHours(wpId, dbManager);
                Double hours = this.getWpHours(wpId, dbManager);
                if (estimatedHours != null && hours != null && estimatedHours != 0.0) {
                    double additionalHours = 0.0;
                    double warnLevel = activity.getWorkPackage().getWarnlevel();
                    double criticalLevel = activity.getWorkPackage().getCriticallevel();
                    double fullStopLevel = activity.getWorkPackage().getFullstoplevel();
                    if (warnLevel == 0.0) {
                        warnLevel = activity.getWorkPackage().getProject().getWarnlevel();
                    }
                    if (criticalLevel == 0.0) {
                        criticalLevel = activity.getWorkPackage().getProject().getCriticallevel();
                    }
                    if (fullStopLevel == 0.0) {
                        fullStopLevel = activity.getWorkPackage().getProject().getFullstoplevel();
                    }
                    additionalHours = originalActivity.getWorkPackage().getId() != wpId ? activity.getWorkinghours() : activity.getWorkinghours() - originalActivity.getWorkinghours();
                    double percentage = hours * 100.0 / estimatedHours;
                    if (fullStopLevel != 0.0 && percentage > fullStopLevel) {
                        this.sendWarning(activity.getWorkPackage(), 3, dbManager);
                        if (additionalHours > 0.0) {
                            throw new FullStopException(activity.getWorkPackage().getName());
                        }
                    } else if (criticalLevel != 0.0 && percentage > criticalLevel) {
                        this.sendWarning(activity.getWorkPackage(), 2, dbManager);
                    } else if (warnLevel != 0.0 && percentage > warnLevel) {
                        this.sendWarning(activity.getWorkPackage(), 1, dbManager);
                    }
                }
            }
            catch (DataRetrievalException e) {
                logger.error((Object)"DB Error. The warning system cannot work properly.", (Throwable)e);
            }
            catch (PersistentLayerException e) {
                logger.error((Object)"DB Error. The warning system cannot work properly.", (Throwable)e);
            }
            finally {
                dbManager.closeSession();
            }
        }
    }

    private synchronized void sendWarning(WorkPackage wp, int level, DBManagerWrapper dbManager) throws DataRetrievalException, PersistentLayerException {
        if (!DevProperties.getInstance().isDevMode()) {
            List warns = dbManager.getObjectsByAttribute(Warning.class, "workPackage", (Object)wp);
            boolean messageAlreadySent = false;
            for (Warning warn : warns) {
                if (warn.getLevel() < level) continue;
                messageAlreadySent = true;
            }
            if (!messageAlreadySent) {
                String email = null;
                if (wp.getResponsiblestaff() != null) {
                    email = wp.getResponsiblestaff().getEmail();
                } else if (wp.getProject().getResponsiblestaff() != null) {
                    email = wp.getProject().getResponsiblestaff().getEmail();
                }
                if (email == null) {
                    logger.warn((Object)"Cannot send a warn email, because there was no responsible person found.");
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"send warning");
                    }
                    String subject = null;
                    subject = level == 1 ? String.format(LanguageBundle.WARN_EMAIL_SUBJECT, wp.getName()) : (level == 2 ? String.format(LanguageBundle.CRITICAL_WARN_EMAIL, wp.getName()) : String.format(LanguageBundle.FULL_STOP_EMAIL, wp.getName()));
                    Warning warning = new Warning();
                    warning.setWorkPackage(wp);
                    warning.setLevel(level);
                    warning.setTime(new Date());
                    dbManager.createObject((BasicHibernateEntity)warning);
                    Utilities.sendEmail((String)email, (String)subject, (String)LanguageBundle.EMAIL_BODY);
                }
            }
        }
    }

    private synchronized Double getWpHours(long wpId, DBManagerWrapper dbManager) throws DataRetrievalException {
        try {
            return (Double)dbManager.getObject("select sum(workinghours) from Activity act where act.workPackage = " + wpId + " AND workCategory.workpackagerelated=true");
        }
        catch (DataRetrievalException e) {
            logger.error((Object)("Cannot calculate the hours of work for the work package with the id " + wpId + ". The warning system cannot work properly."), (Throwable)e);
            throw e;
        }
    }

    private synchronized Double getEstimatedWpHours(long wpId, DBManagerWrapper dbManager) throws DataRetrievalException {
        try {
            WorkPackage wp = (WorkPackage)dbManager.getObject(WorkPackage.class, wpId);
            EstimatedComponentCost estimation = QueryHelper.getMostRecentEstimation((WorkPackage)wp);
            double hours = 0.0;
            if (estimation != null) {
                for (EstimatedComponentCostMonth tmp : estimation.getEstimatedWorkPackageCostMonth()) {
                    hours += tmp.getWorkinghours();
                }
            }
            return hours;
        }
        catch (DataRetrievalException e) {
            logger.error((Object)("Cannot find work package with the id " + wpId + ". The warning system cannot work properly."), (Throwable)e);
            throw e;
        }
    }
}

