/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.utilities;

import de.cismet.projecttracker.client.exceptions.PersistentLayerException;
import de.cismet.projecttracker.report.db.entities.BasicHibernateEntity;
import de.cismet.projecttracker.report.exceptions.DataRetrievalException;
import de.cismet.projecttracker.report.query.DBManager;
import de.cismet.projecttracker.server.ConfigurationManager;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;

public class DBManagerWrapper {
    DBManager manager = null;

    private void checkSession() {
        if (this.manager == null || !this.manager.isSessionOpen()) {
            this.manager = new DBManager(ConfigurationManager.getInstance().getConfBaseDir());
        }
    }

    public Connection getDatabaseConnection() {
        this.checkSession();
        return this.manager.getDatabaseConnection();
    }

    public Object getObject(Class cl, long id) throws de.cismet.projecttracker.client.exceptions.DataRetrievalException {
        try {
            this.checkSession();
            return this.manager.getObject(cl, id);
        }
        catch (DataRetrievalException e) {
            throw new de.cismet.projecttracker.client.exceptions.DataRetrievalException((Throwable)e);
        }
    }

    public Object getObject(String hqlQuery) throws de.cismet.projecttracker.client.exceptions.DataRetrievalException {
        try {
            this.checkSession();
            return this.manager.getObject(hqlQuery);
        }
        catch (DataRetrievalException e) {
            throw new de.cismet.projecttracker.client.exceptions.DataRetrievalException((Throwable)e);
        }
    }

    public List getAllObjects(Class cl) throws de.cismet.projecttracker.client.exceptions.DataRetrievalException {
        try {
            this.checkSession();
            return this.manager.getAllObjects(cl);
        }
        catch (DataRetrievalException e) {
            throw new de.cismet.projecttracker.client.exceptions.DataRetrievalException((Throwable)e);
        }
    }

    public Object getObjectByAttribute(Class cl, String attribute, Object value) throws de.cismet.projecttracker.client.exceptions.DataRetrievalException {
        try {
            this.checkSession();
            return this.manager.getObjectByAttribute(cl, attribute, value);
        }
        catch (DataRetrievalException e) {
            throw new de.cismet.projecttracker.client.exceptions.DataRetrievalException((Throwable)e);
        }
    }

    public List getObjectsByAttribute(Class cl, String attribute, Object value) throws de.cismet.projecttracker.client.exceptions.DataRetrievalException {
        try {
            this.checkSession();
            return this.manager.getObjectsByAttribute(cl, attribute, value);
        }
        catch (DataRetrievalException e) {
            throw new de.cismet.projecttracker.client.exceptions.DataRetrievalException((Throwable)e);
        }
    }

    public Object getAnyObjectByClass(Class cl) throws de.cismet.projecttracker.client.exceptions.DataRetrievalException {
        try {
            this.checkSession();
            return this.manager.getAnyObjectByClass(cl);
        }
        catch (DataRetrievalException e) {
            throw new de.cismet.projecttracker.client.exceptions.DataRetrievalException((Throwable)e);
        }
    }

    public List getObjectsByAttribute(String hqlQuery) throws de.cismet.projecttracker.client.exceptions.DataRetrievalException {
        try {
            this.checkSession();
            return this.manager.getObjectsByAttribute(hqlQuery);
        }
        catch (DataRetrievalException e) {
            throw new de.cismet.projecttracker.client.exceptions.DataRetrievalException((Throwable)e);
        }
    }

    public Serializable createObject(BasicHibernateEntity object) throws PersistentLayerException {
        try {
            this.checkSession();
            return this.manager.createObject((Object)object);
        }
        catch (HibernateException e) {
            throw new PersistentLayerException((Throwable)e);
        }
    }

    public void saveObject(BasicHibernateEntity object) throws PersistentLayerException {
        try {
            this.checkSession();
            this.manager.saveObject((Object)object);
        }
        catch (HibernateException e) {
            throw new PersistentLayerException((Throwable)e);
        }
    }

    public void deleteObject(BasicHibernateEntity object) throws PersistentLayerException {
        try {
            this.checkSession();
            this.manager.deleteObject((Object)object);
        }
        catch (HibernateException e) {
            throw new PersistentLayerException((Throwable)e);
        }
    }

    public void closeSession() {
        if (this.manager != null && this.manager.isSessionOpen()) {
            this.manager.closeSession();
        }
        this.manager = null;
    }

    public boolean isSessionOpen() {
        if (this.manager != null) {
            return this.manager.isSessionOpen();
        }
        return false;
    }

    public Session getSession() {
        this.checkSession();
        return this.manager.getSession();
    }

    protected void finalize() throws Throwable {
        this.closeSession();
    }
}

