/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.utilities;

import de.cismet.projecttracker.client.dto.BasicDTO;
import de.cismet.projecttracker.client.exceptions.InvalidInputValuesException;
import de.cismet.projecttracker.report.db.entities.BasicHibernateEntity;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class DTOManager {
    private static final Logger logger = Logger.getLogger(DTOManager.class);
    private static final String HIBERNATE_PACKAGE = "de.cismet.projecttracker.report.db.entities";
    private static final String DTO_PACKAGE = "de.cismet.projecttracker.client.dto";
    private static final int INITIAL_CAPACITY = 256;

    public Object clone(BasicHibernateEntity original) throws InvalidInputValuesException {
        BasicDTO result = null;
        long startTime = System.currentTimeMillis();
        HashMap convertedClasses = new HashMap(256);
        result = this.cloneInternal(original, convertedClasses);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("time to clone: " + (System.currentTimeMillis() - startTime) + "ms objects: " + convertedClasses.size()));
        }
        return result;
    }

    public ArrayList clone(List original) throws InvalidInputValuesException {
        long startTime = System.currentTimeMillis();
        ArrayList<BasicDTO> clonedList = new ArrayList<BasicDTO>(original.size());
        HashMap convertedClasses = new HashMap(256);
        for (Object o : original) {
            if (o instanceof BasicHibernateEntity) {
                clonedList.add(this.cloneInternal((BasicHibernateEntity)o, convertedClasses));
                continue;
            }
            logger.error((Object)("Only objects of the type " + BasicHibernateEntity.class.getName() + " can be cloned. The given object is of the type " + o.getClass().getName()));
            throw new InvalidInputValuesException("internal error");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("time to clone list: " + (System.currentTimeMillis() - startTime) + "ms objects: " + convertedClasses.size()));
        }
        return clonedList;
    }

    public BasicHibernateEntity merge(BasicDTO original) throws InvalidInputValuesException {
        BasicHibernateEntity result = null;
        long startTime = System.currentTimeMillis();
        HashMap convertedClasses = new HashMap(256);
        result = this.mergeInternal(original, convertedClasses);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("time to merge: " + (System.currentTimeMillis() - startTime) + "ms objects: " + convertedClasses.size()));
        }
        return result;
    }

    private BasicHibernateEntity mergeInternal(BasicDTO original, HashMap<Object, Object> convertedClasses) throws InvalidInputValuesException {
        try {
            BasicHibernateEntity result = (BasicHibernateEntity)convertedClasses.get(original);
            if (result == null && original != null) {
                Method[] methods;
                String dtoName = original.getClass().getName();
                dtoName = HIBERNATE_PACKAGE + dtoName.substring(DTO_PACKAGE.length(), dtoName.length() - 3);
                if (dtoName.endsWith("Short")) {
                    dtoName = dtoName.replace("Short", "");
                }
                result = (BasicHibernateEntity)Class.forName(dtoName).newInstance();
                result.setId(original.getId());
                convertedClasses.put(original, result);
                for (Method tmpMethod : methods = result.getClass().getMethods()) {
                    String name = tmpMethod.getName();
                    if (!name.startsWith("set")) continue;
                    try {
                        Method originalGetter = original.getClass().getMethod("g" + name.substring(1), new Class[0]);
                        Class<?>[] parameter = tmpMethod.getParameterTypes();
                        if (tmpMethod.isSynthetic() || parameter.length != 1 || originalGetter.getParameterTypes().length != 0) continue;
                        Class<?> declaredClass = parameter[0];
                        if (BasicHibernateEntity.class.isAssignableFrom(declaredClass) && BasicDTO.class.isAssignableFrom(originalGetter.getReturnType())) {
                            tmpMethod.invoke((Object)result, this.mergeInternal((BasicDTO)originalGetter.invoke((Object)original, new Object[0]), convertedClasses));
                            continue;
                        }
                        if (Set.class.isAssignableFrom(declaredClass) && ArrayList.class.isAssignableFrom(originalGetter.getReturnType())) {
                            HashSet<BasicHibernateEntity> newSet = new HashSet<BasicHibernateEntity>();
                            ArrayList origList = (ArrayList)originalGetter.invoke((Object)original, new Object[0]);
                            for (Object tmpObj : origList) {
                                newSet.add(this.mergeInternal((BasicDTO)tmpObj, convertedClasses));
                            }
                            tmpMethod.invoke((Object)result, newSet);
                            continue;
                        }
                        tmpMethod.invoke((Object)result, originalGetter.invoke((Object)original, new Object[0]));
                    }
                    catch (Exception e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("method not found " + original.getClass().getName() + "." + name));
                    }
                }
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
            throw new InvalidInputValuesException((Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)e);
            throw new InvalidInputValuesException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
            throw new InvalidInputValuesException((Throwable)e);
        }
    }

    private BasicDTO cloneInternal(BasicHibernateEntity original, HashMap<Object, Object> convertedClasses) throws InvalidInputValuesException {
        try {
            BasicDTO result = (BasicDTO)convertedClasses.get(original);
            if (result == null && original != null) {
                Method[] methods;
                String dtoName = original.getClass().getName();
                if (dtoName.indexOf("_$$_") != -1) {
                    dtoName = dtoName.substring(0, dtoName.indexOf("_$$_"));
                }
                dtoName = DTO_PACKAGE + dtoName.substring(HIBERNATE_PACKAGE.length()) + "DTO";
                result = (BasicDTO)Class.forName(dtoName).newInstance();
                result.setId(original.getId());
                convertedClasses.put(original, result);
                for (Method tmpMethod : methods = result.getClass().getMethods()) {
                    String name = tmpMethod.getName();
                    if (!name.startsWith("set")) continue;
                    try {
                        Method originalGetter = original.getClass().getMethod("g" + name.substring(1), new Class[0]);
                        Class<?>[] parameter = tmpMethod.getParameterTypes();
                        if (tmpMethod.isSynthetic() || parameter.length != 1 || originalGetter.getParameterTypes().length != 0) continue;
                        Class<?> declaredClass = parameter[0];
                        if (BasicDTO.class.isAssignableFrom(declaredClass) && BasicHibernateEntity.class.isAssignableFrom(originalGetter.getReturnType())) {
                            if (declaredClass.getName().endsWith("Short")) {
                                BasicDTO para = this.cloneInternal((BasicHibernateEntity)originalGetter.invoke((Object)original, new Object[0]), convertedClasses);
                                tmpMethod.invoke((Object)result, para.getClass().getMethod("toShortVersion", new Class[0]).invoke((Object)para, new Object[0]));
                                continue;
                            }
                            tmpMethod.invoke((Object)result, this.cloneInternal((BasicHibernateEntity)originalGetter.invoke((Object)original, new Object[0]), convertedClasses));
                            continue;
                        }
                        if (ArrayList.class.isAssignableFrom(declaredClass) && Set.class.isAssignableFrom(originalGetter.getReturnType())) {
                            ArrayList<BasicDTO> newSet = new ArrayList<BasicDTO>();
                            Set origSet = (Set)originalGetter.invoke((Object)original, new Object[0]);
                            for (Object tmpObj : origSet) {
                                newSet.add(this.cloneInternal((BasicHibernateEntity)tmpObj, convertedClasses));
                            }
                            tmpMethod.invoke((Object)result, newSet);
                            continue;
                        }
                        tmpMethod.invoke((Object)result, originalGetter.invoke((Object)original, new Object[0]));
                    }
                    catch (Exception e) {
                        System.out.println("method not found " + result.getClass().getName() + "." + name);
                        e.printStackTrace();
                    }
                }
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
            throw new InvalidInputValuesException((Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)e);
            throw new InvalidInputValuesException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
            throw new InvalidInputValuesException((Throwable)e);
        }
    }
}

