/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.utilities;

import de.cismet.projecttracker.client.exceptions.DataRetrievalException;
import de.cismet.projecttracker.client.exceptions.InvalidInputValuesException;
import de.cismet.projecttracker.report.db.entities.Activity;
import de.cismet.projecttracker.report.db.entities.Project;
import de.cismet.projecttracker.utilities.DBManagerWrapper;
import de.cismet.projecttracker.utilities.DTOManager;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class EmailTaskNotice {
    private static final String MAIN_STYLES = "alert alert-block timebox";
    private static final String[] ADDITIONAL_PROJECT_STYLES = new String[]{"proj1", "proj2", "proj3", "proj4", "proj5", "proj6", "proj7"};
    private static final HashMap<Long, Integer> projectStyle = new HashMap();
    protected Activity activity;
    private String styles;

    public EmailTaskNotice(Activity activity) {
        this.activity = activity;
        this.init();
    }

    private void init() {
        this.setColour();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setColour() {
        if (this.activity.getKindofactivity() >= 1) {
            this.styles = this.activity.getKindofactivity() == 1 ? "alert alert-block timebox beginOfDay" : (this.activity.getKindofactivity() == 2 ? "alert alert-block timebox endOfDay" : "alert alert-block timebox lockDay");
        } else if (this.activity.getWorkPackage() != null && this.activity.getWorkPackage().getProject() != null) {
            ArrayList proj = null;
            DBManagerWrapper dbManager = new DBManagerWrapper();
            try {
                List result = dbManager.getAllObjects(Project.class);
                proj = new DTOManager().clone(result);
            }
            catch (DataRetrievalException ex) {
                Logger.getLogger(EmailTaskNotice.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvalidInputValuesException ex) {
                Logger.getLogger(EmailTaskNotice.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                dbManager.closeSession();
            }
            if (proj != null) {
                long projectId = this.activity.getWorkPackage().getProject().getId();
                Integer index = (Integer)projectStyle.get(projectId);
                if (index == null) {
                    index = 6;
                }
                if (index < 0 || index >= ADDITIONAL_PROJECT_STYLES.length) {
                    index = ADDITIONAL_PROJECT_STYLES.length - 1;
                }
                this.styles = "alert alert-block timebox " + ADDITIONAL_PROJECT_STYLES[index];
            }
        }
    }

    protected String getTextFromActivity() {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd-hh-mm-ss");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yy-MM-dd");
        if (this.activity.getKindofactivity() != 0) {
            String text = "";
            if (this.activity.getKindofactivity() == 1) {
                text = "Begin of Work Activity";
                text = text + "<br/> at <br/>";
                text = text + dateTimeFormat.format(this.activity.getDay());
            } else if (this.activity.getKindofactivity() == 2) {
                text = "End of Work Activity";
                text = text + "<br/> at <br/>";
                text = text + dateTimeFormat.format(this.activity.getDay());
            } else {
                text = "Locked Day";
                text = text + "<br/> at <br/>";
                text = text + dateFormat.format(this.activity.getDay());
            }
            return text;
        }
        String desc = this.getDesccription(this.activity.getDescription());
        StringBuilder text = new StringBuilder();
        if (this.activity.getWorkCategory() != null && this.activity.getWorkCategory().getId() == 4L) {
            text.append("Travel: ").append(this.activity.getWorkPackage().getAbbreviation());
        } else {
            text.append(this.activity.getWorkPackage().getAbbreviation());
        }
        double hours = (double)Math.round(this.activity.getWorkinghours() * 100.0) / 100.0;
        text.append("<br />").append(desc);
        text.append("<br/> at <br/>");
        text.append(dateFormat.format(this.activity.getDay()));
        if (hours != 0.0) {
            text.append("<br />").append(this.doubleToHours(hours)).append(" hours");
        }
        return text.toString();
    }

    private String doubleToHours(double ihours) {
        double hours = Math.abs(ihours);
        int minutes = (int)Math.round((hours - (double)((int)hours)) * 60.0);
        if (minutes == 60) {
            hours += 1.0;
            minutes = 0;
        }
        return (ihours < 0.0 ? "-" : "") + (int)hours + ":" + EmailTaskNotice.IntToDoubleDigit((int)minutes);
    }

    private static String IntToDoubleDigit(int number) {
        if (number < 10) {
            return "0" + number;
        }
        return "" + number;
    }

    protected String getDesccription(String desc) {
        if (desc == null) {
            return "";
        }
        int i = desc.indexOf("(@");
        if (i != -1) {
            String result = desc.substring(0, i);
            return result;
        }
        return desc;
    }

    protected String getTooltipTextFromActivity() {
        if (this.activity.getKindofactivity() == 0) {
            StringBuilder text = new StringBuilder(this.activity.getWorkPackage().getProject().getName());
            text.append("\n").append(this.activity.getWorkPackage().getName());
            if (this.activity.getDescription() != null) {
                text.append("\n").append(this.activity.getDescription());
            }
            return text.toString();
        }
        return "";
    }

    public String toString() {
        String result = "<div  title=\"" + this.getTooltipTextFromActivity() + "\" class=\"" + this.styles + "\"><div title=\"" + this.getTooltipTextFromActivity() + "\">" + this.getTextFromActivity() + "</div></div>";
        return result;
    }

    static {
        projectStyle.put(1L, 0);
        projectStyle.put(2L, 1);
        projectStyle.put(18L, 2);
        projectStyle.put(21L, 3);
        projectStyle.put(20L, 4);
        projectStyle.put(10L, 5);
    }
}

