/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.utilities;

import de.cismet.projecttracker.server.ConfigurationManager;
import de.cismet.projecttracker.utilities.EMailContent;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utilities {
    private static final org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(Utilities.class);
    private static final String LOG4J_CONFIG_FILE = "WEB-INF/config/log4j.xml";
    private static final String ADMIN_MAIL_ADDRESS = "sabine.trier@cismet.de";
    private static Properties fMailServerConfig = new Properties();
    private static final Map<String, EMailContent> toSend = new Hashtable();
    private static final Timer sendTimer = new Timer(true);

    private static synchronized void checkCollectedEmails() {
        GregorianCalendar now = new GregorianCalendar();
        ArrayList keys = new ArrayList(toSend.keySet());
        for (String address : keys) {
            EMailContent c = (EMailContent)toSend.get(address);
            if (!c.getTimeToSend().before(now)) continue;
            Utilities.sendEmail((String)c.getAddress(), (String)c.getSubject(), (String)c.getBody());
            toSend.remove(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initLogger(String applicationPath) {
        InputStream configStream = null;
        try {
            configStream = new BufferedInputStream(new FileInputStream(applicationPath + "WEB-INF/config/log4j.xml"));
            ConfigurationSource source = new ConfigurationSource(configStream);
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            context.start((Configuration)new XmlConfiguration(context, source));
        }
        catch (Exception e) {
            System.out.println("Cannot configure logger");
        }
        finally {
            if (configStream != null) {
                try {
                    configStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void sendEmail(String address, String subject, String body) {
        Utilities.fetchConfig();
        Properties props = (Properties)fMailServerConfig.clone();
        String user = fMailServerConfig.getProperty("mail.user");
        String pwd = fMailServerConfig.getProperty("mail.password");
        Session session = user != null && pwd != null ? Session.getDefaultInstance((Properties)props, (Authenticator)new /* Unavailable Anonymous Inner Class!! */) : Session.getDefaultInstance((Properties)fMailServerConfig, null);
        MimeMessage message = new MimeMessage(session);
        try {
            message.addFrom((Address[])new InternetAddress[]{new InternetAddress(fMailServerConfig.getProperty("mail.from"))});
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(address));
            if (!address.equals("sabine.trier@cismet.de")) {
                message.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress("sabine.trier@cismet.de"));
            }
            message.setSubject(subject);
            message.setText(body);
            message.setContent((Object)body, "text/html");
            Transport.send((Message)message);
        }
        catch (MessagingException ex) {
            logger.error((Object)"Cannot send email.", (Throwable)ex);
        }
    }

    public static synchronized void sendCollectedEmail(String address, String subject, String body) {
        EMailContent mail = (EMailContent)toSend.get(address);
        GregorianCalendar time = new GregorianCalendar();
        time.add(12, 5);
        if (mail == null) {
            mail = new EMailContent();
            mail.setAddress(address);
            mail.setSubject(subject);
            mail.setText(body);
            toSend.put(address, mail);
        } else {
            mail.setText(mail.getText() + "\n\n\n" + body);
        }
        mail.setTimeToSend(new GregorianCalendar());
    }

    private static void fetchConfig() {
        FileInputStream input = null;
        try {
            input = new FileInputStream(ConfigurationManager.getInstance().getConfBaseDir() + System.getProperty("file.separator") + "EMail.properties");
            fMailServerConfig.load(input);
        }
        catch (IOException e) {
            logger.error((Object)"Cannot open and load mail server properties file.", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update("passwd".getBytes());
            StringBuffer hexString = new StringBuffer();
            for (byte b : md.digest()) {
                hexString.append(String.format("%02x", b));
            }
            System.out.println(hexString);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(Utilities.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static /* synthetic */ void access$000() {
        Utilities.checkCollectedEmails();
    }

    static {
        sendTimer.schedule((TimerTask)new /* Unavailable Anonymous Inner Class!! */, 300000L, 60000L);
    }
}

