/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.verdis.server.search;

import Sirius.server.middleware.interfaces.domainserver.MetaService;

import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.Collection;

import de.cismet.cids.server.search.AbstractCidsServerSearch;

import de.cismet.verdis.commons.constants.VerdisConstants;

/**
 * DOCUMENT ME!
 *
 * @author   thorsten
 * @version  $Revision$, $Date$
 */
public class KassenzeichenlistSearchStatement extends AbstractCidsServerSearch {

    //~ Static fields/initializers ---------------------------------------------

    /** LOGGER. */
    private static final transient Logger LOG = Logger.getLogger(KassenzeichenlistSearchStatement.class);

    //~ Instance fields --------------------------------------------------------

    private final String querySnippet;

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new KassenzeichenSearchStatement object.
     *
     * @param  querySnippet  DOCUMENT ME!
     */
    public KassenzeichenlistSearchStatement(final String querySnippet) {
        this.querySnippet = querySnippet; // NOI18N
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public Collection<Integer> performServerSearch() {
        try {
            final String sql = "SELECT " + VerdisConstants.MC.KASSENZEICHEN + "."
                        + VerdisConstants.PROP.KASSENZEICHEN.KASSENZEICHENNUMMER + " "
                        + "FROM " + VerdisConstants.MC.KASSENZEICHEN + " WHERE " + " "
                        + querySnippet;

            final MetaService ms = (MetaService)getActiveLocalServers().get(VerdisConstants.DOMAIN);

            final ArrayList<ArrayList> result = ms.performCustomSearch(sql);

            final ArrayList<Integer> aln = new ArrayList<Integer>();
            for (final ArrayList al : result) {
                final Integer kassenzeichennummer = (Integer)al.get(0);
                aln.add(kassenzeichennummer);
            }

            return aln;
        } catch (final Exception e) {
            LOG.error("problem during kassenzeichen search", e); // NOI18N

            return null;
        }
    }
}
