/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.json.aenderungsanfrage;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.cismet.verdis.server.json.AenderungsanfrageJson;
import de.cismet.verdis.server.json.FlaecheAenderungFlaechenartJson;
import de.cismet.verdis.server.json.FlaecheAenderungGroesseJson;
import de.cismet.verdis.server.json.FlaecheAnschlussgradJson;
import de.cismet.verdis.server.json.FlaecheFlaechenartJson;
import de.cismet.verdis.server.json.FlaechePruefungFlaechenartJson;
import de.cismet.verdis.server.json.FlaechePruefungGroesseJson;
import de.cismet.verdis.server.json.NachrichtAnhangJson;
import de.cismet.verdis.server.json.NachrichtEigentuemerJson;
import de.cismet.verdis.server.json.NachrichtParameterAnschlussgradJson;
import de.cismet.verdis.server.json.NachrichtParameterJson;
import de.cismet.verdis.server.json.NachrichtSachberarbeiterJson;
import de.cismet.verdis.server.json.NachrichtSystemJson;
import de.cismet.verdis.server.json.PruefungFlaechenartJson;
import de.cismet.verdis.server.json.PruefungGroesseJson;
import de.cismet.verdis.server.utils.AenderungsanfrageUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class AenderungsanfrageJsonTest {
    private static final String JSON_ANFRAGE_TEST = "de/cismet/verdis/server/json/aenderungsanfrage/anfrage_test.json";
    private static final String JSON_ANFRAGE_COMPLEX = "de/cismet/verdis/server/json/aenderungsanfrage/anfrage_complex.json";
    private static final String JSON_ANFRAGE_SIMPLE = "de/cismet/verdis/server/json/aenderungsanfrage/anfrage_simple.json";
    private static final String JSON_ANFRAGE_PROCESSING_ORIG = "de/cismet/verdis/server/json/aenderungsanfrage/anfrage_processing%d_orig.json";
    private static final String JSON_ANFRAGE_PROCESSING_CHANGE = "de/cismet/verdis/server/json/aenderungsanfrage/anfrage_processing%d_change.json";
    private static final String JSON_ANFRAGE_PROCESSING_PROCESSED = "de/cismet/verdis/server/json/aenderungsanfrage/anfrage_processing%d_processed.json";

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testTest() {
        try {
            String aenderungsanfrageTestJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(JSON_ANFRAGE_TEST), (String)"UTF-8");
            AenderungsanfrageJson aenderungsanfrageDeserialized = AenderungsanfrageUtils.getInstance().createAenderungsanfrageJson(aenderungsanfrageTestJson);
            Assert.assertNotNull((Object)aenderungsanfrageDeserialized);
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    private AenderungsanfrageJson getSimpleAnfrageJson() {
        HashMap<String, FlaecheAenderungGroesseJson> flaechen = new HashMap<String, FlaecheAenderungGroesseJson>();
        flaechen.put("5", new FlaecheAenderungGroesseJson(Integer.valueOf(12)));
        HashMap geometrien = new HashMap();
        AenderungsanfrageJson anederungsanfrage = new AenderungsanfrageJson(Integer.valueOf(60004629), null, null, null, flaechen, geometrien, new ArrayList<NachrichtEigentuemerJson>(Arrays.asList(new NachrichtEigentuemerJson("test-simple-1", new Date(47110815L), null, "Da passt was nicht weil isso, siehe lustiges pdf !", "B\u00fcrger", Arrays.asList(new NachrichtAnhangJson("lustiges.pdf", "aaa-bbb-ccc")), null))), null);
        return anederungsanfrage;
    }

    private AenderungsanfrageJson getComplexAnfrageJson() {
        HashMap<String, Object> flaechen = new HashMap<String, Object>();
        flaechen.put("1", new FlaecheAenderungGroesseJson(Integer.valueOf(1430)));
        flaechen.put("2", new FlaecheAenderungGroesseJson(Integer.valueOf(921), new FlaechePruefungGroesseJson(new PruefungGroesseJson(null, Integer.valueOf(921), null, null))));
        flaechen.put("8", new FlaecheAenderungFlaechenartJson(new FlaecheFlaechenartJson("Gr\u00fcndachfl\u00e4che", "GDF"), new FlaechePruefungFlaechenartJson(new PruefungFlaechenartJson(null, new FlaecheFlaechenartJson("Gr\u00fcndachfl\u00e4che", "GDF"), null, null))));
        HashMap geometrien = new HashMap();
        ArrayList<Object> nachrichten = new ArrayList<Object>();
        nachrichten.add(new NachrichtSachberarbeiterJson("test-complex-1", new Date(1562059800000L), null, "Sehr geehrte*r Nutzer*in, hier haben Sie die M\u00f6glichkeit \u00c4nderungen an Ihren Fl\u00e4chen mitzuteilen.", "verdis", null));
        nachrichten.add(new NachrichtEigentuemerJson("test-complex-2", new Date(1562060700000L), null, "Fl\u00e4che B ist kleiner. Sie ist nicht 40 m\u00b2 gro\u00df, sondern nur 37 m\u00b2. Sie ist auch nicht an dem Kanal angeschlossen, sondern besteht aus \u00d6kopflaster und versickert. Siehe Foto.", "B\u00fcrger", Arrays.asList(new NachrichtAnhangJson("\u00d6kopflasterfoto.pdf", "1337")), null));
        nachrichten.add(new NachrichtSachberarbeiterJson("test-complex-3", new Date(1562136300000L), null, "Die \u00c4nderung der Fl\u00e4che werde ich \u00fcbernehmen. Das Foto ist nicht ausreichend. Bitte \u00fcbersenden Sie zus\u00e4tzlich ein Foto der gesamten Fl\u00e4che. \u00d6kopflaster wird auch nicht als vollst\u00e4ndig versickernd angesehen, sondern muss laut Satzung mit 70% seiner Fl\u00e4chen zur Geb\u00fchrenerhebung herangezogen werden.", "Dirk Steinbacher", null));
        nachrichten.add(new NachrichtSystemJson("test-complex-4", new Date(1562136360000L), null, (NachrichtParameterJson)new NachrichtParameterAnschlussgradJson(NachrichtParameterJson.Type.REJECTED, "1", new FlaecheAnschlussgradJson("Dachfl\u00e4che", "DF")), "Dirk Steinbacher"));
        nachrichten.add(new NachrichtEigentuemerJson("test-complex-5", new Date(1562179560000L), null, "Hier das gew\u00fcnschte Foto. Die Zufahrt entw\u00e4ssert seitlich in die Beete.", "B\u00fcrger", Arrays.asList(new NachrichtAnhangJson("Foto2.pdf", "13374")), null));
        nachrichten.add(new NachrichtSachberarbeiterJson("test-complex-6", new Date(1562227500000L), null, "Auf dem 2ten Foto sind Rasenkantensteine und ein Gully zu erkennen. Aus diesem Grund muss ich f\u00fcr diese Fl\u00e4che 24 m\u00b2 (70% von 37 m\u00b2) zur Veranlagung an das Steueramt weitergeben.", "Dirk Steinbacher", null));
        nachrichten.add(new NachrichtSystemJson("test-complex-7", new Date(1562227560000L), null, (NachrichtParameterJson)new NachrichtParameterAnschlussgradJson(NachrichtParameterJson.Type.CHANGED, "1", new FlaecheAnschlussgradJson("Dachfl\u00e4che", "DF")), "Dirk Steinbacher"));
        nachrichten.add(new NachrichtEigentuemerJson("test-complex-8", new Date(1562486760000L), null, "So wird eine Nachricht visualisiert, die noch nicht abgesschickt ist.", "B\u00fcrger", null, Boolean.valueOf(true)));
        AenderungsanfrageJson aenderungsanfrage = new AenderungsanfrageJson(Integer.valueOf(60004629), null, null, flaechen, geometrien, nachrichten);
        return aenderungsanfrage;
    }

    private void testProcessing(String aenderungsanfrageOrigJson, String aenderungsanfrageChangeJson, String aenderungsanfrageProcessedJson) throws Exception {
        AenderungsanfrageUtils.getInstance().setUnitTestContext(true);
        Integer kassenzeichen = 60004629;
        AenderungsanfrageJson aenderungsanfrageOrig = aenderungsanfrageOrigJson != null ? AenderungsanfrageUtils.getInstance().createAenderungsanfrageJson(aenderungsanfrageOrigJson) : new AenderungsanfrageJson(kassenzeichen);
        AenderungsanfrageJson aenderungsanfrageChange = aenderungsanfrageChangeJson != null ? AenderungsanfrageUtils.getInstance().createAenderungsanfrageJson(aenderungsanfrageChangeJson) : new AenderungsanfrageJson(kassenzeichen);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("5", null);
        AenderungsanfrageJson aenderungsanfrageNew = AenderungsanfrageUtils.getInstance().doProcessing(null, kassenzeichen, map, aenderungsanfrageOrig, aenderungsanfrageChange, Boolean.TRUE, null, "test", new Date(2500000000000L), null, null);
        String aenderungsanfrageNewJson = aenderungsanfrageNew.toPrettyJson();
        Assert.assertEquals((Object)aenderungsanfrageProcessedJson, (Object)aenderungsanfrageNewJson);
    }

    @Test
    public void testProcessing1() throws JsonProcessingException, Exception {
        Integer jsonNumber = 1;
        String aenderungsanfrageOrigJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(String.format(JSON_ANFRAGE_PROCESSING_ORIG, jsonNumber)), (String)"UTF-8");
        String aenderungsanfrageChangeJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(String.format(JSON_ANFRAGE_PROCESSING_CHANGE, jsonNumber)), (String)"UTF-8");
        String aenderungsanfrageProcessedJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(String.format(JSON_ANFRAGE_PROCESSING_PROCESSED, jsonNumber)), (String)"UTF-8");
        this.testProcessing(null, aenderungsanfrageChangeJson, aenderungsanfrageProcessedJson);
        this.testProcessing(aenderungsanfrageOrigJson, aenderungsanfrageChangeJson, aenderungsanfrageProcessedJson);
    }

    @Test
    public void testProcessing2() throws JsonProcessingException, Exception {
        Integer jsonNumber = 2;
        String aenderungsanfrageOrigJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(String.format(JSON_ANFRAGE_PROCESSING_ORIG, jsonNumber)), (String)"UTF-8");
        String aenderungsanfrageChangeJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(String.format(JSON_ANFRAGE_PROCESSING_CHANGE, jsonNumber)), (String)"UTF-8");
        String aenderungsanfrageProcessedJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(String.format(JSON_ANFRAGE_PROCESSING_PROCESSED, jsonNumber)), (String)"UTF-8");
        this.testProcessing(aenderungsanfrageOrigJson, aenderungsanfrageChangeJson, aenderungsanfrageProcessedJson);
    }

    @Test
    public void testProcessing3() throws JsonProcessingException, Exception {
        Integer jsonNumber = 3;
        String aenderungsanfrageOrigJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(String.format(JSON_ANFRAGE_PROCESSING_ORIG, jsonNumber)), (String)"UTF-8");
        String aenderungsanfrageChangeJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(String.format(JSON_ANFRAGE_PROCESSING_CHANGE, jsonNumber)), (String)"UTF-8");
        String aenderungsanfrageProcessedJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(String.format(JSON_ANFRAGE_PROCESSING_PROCESSED, jsonNumber)), (String)"UTF-8");
        this.testProcessing(aenderungsanfrageOrigJson, aenderungsanfrageChangeJson, aenderungsanfrageProcessedJson);
    }

    @Test
    public void testProcessing4() throws JsonProcessingException, Exception {
        Integer jsonNumber = 4;
        String aenderungsanfrageOrigJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(String.format(JSON_ANFRAGE_PROCESSING_ORIG, jsonNumber)), (String)"UTF-8");
        String aenderungsanfrageChangeJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(String.format(JSON_ANFRAGE_PROCESSING_CHANGE, jsonNumber)), (String)"UTF-8");
        String aenderungsanfrageProcessedJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(String.format(JSON_ANFRAGE_PROCESSING_PROCESSED, jsonNumber)), (String)"UTF-8");
        this.testProcessing(aenderungsanfrageOrigJson, aenderungsanfrageChangeJson, aenderungsanfrageProcessedJson);
    }

    @Test
    public void testProcessing5() throws JsonProcessingException, Exception {
        Integer jsonNumber = 5;
        String aenderungsanfrageOrigJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(String.format(JSON_ANFRAGE_PROCESSING_ORIG, jsonNumber)), (String)"UTF-8");
        String aenderungsanfrageChangeJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(String.format(JSON_ANFRAGE_PROCESSING_CHANGE, jsonNumber)), (String)"UTF-8");
        String aenderungsanfrageProcessedJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(String.format(JSON_ANFRAGE_PROCESSING_PROCESSED, jsonNumber)), (String)"UTF-8");
        this.testProcessing(aenderungsanfrageOrigJson, aenderungsanfrageChangeJson, aenderungsanfrageProcessedJson);
    }

    @Test
    public void testProcessing6() throws JsonProcessingException, Exception {
        Integer jsonNumber = 6;
        String aenderungsanfrageOrigJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(String.format(JSON_ANFRAGE_PROCESSING_ORIG, jsonNumber)), (String)"UTF-8");
        String aenderungsanfrageChangeJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(String.format(JSON_ANFRAGE_PROCESSING_CHANGE, jsonNumber)), (String)"UTF-8");
        String aenderungsanfrageProcessedJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(String.format(JSON_ANFRAGE_PROCESSING_PROCESSED, jsonNumber)), (String)"UTF-8");
        this.testProcessing(aenderungsanfrageOrigJson, aenderungsanfrageChangeJson, aenderungsanfrageProcessedJson);
    }

    @Test
    public void testComplexAnfrageSerializer() throws JsonProcessingException, Exception {
        AenderungsanfrageJson aenderungsanfrage = this.getComplexAnfrageJson();
        String aenderungsanfrageJson = aenderungsanfrage.toPrettyJson();
        Assert.assertNotNull((Object)aenderungsanfrageJson);
        String aenderungsanfrageComplexJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(JSON_ANFRAGE_COMPLEX), (String)"UTF-8");
        Assert.assertEquals((Object)aenderungsanfrageJson, (Object)aenderungsanfrageComplexJson);
    }

    @Test
    public void testSimpleAnfrageSerializer() throws JsonProcessingException, Exception {
        AenderungsanfrageJson aenderungsanfrage = this.getSimpleAnfrageJson();
        String aenderungsanfrageJson = aenderungsanfrage.toPrettyJson();
        Assert.assertNotNull((Object)aenderungsanfrageJson);
        String aenderungsanfrageSimpleJson = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(JSON_ANFRAGE_SIMPLE), (String)"UTF-8");
        Assert.assertEquals((Object)aenderungsanfrageJson, (Object)aenderungsanfrageSimpleJson);
    }

    @Test
    public void testSimpleAnfrageDeserializer() throws JsonProcessingException, Exception {
        AenderungsanfrageJson aenderungsanfrage = this.getSimpleAnfrageJson();
        String aenderungsanfrageJson = aenderungsanfrage.toPrettyJson();
        Assert.assertNotNull((Object)aenderungsanfrageJson);
        AenderungsanfrageJson aenderungsanfrageDeserialized = AenderungsanfrageUtils.getInstance().createAenderungsanfrageJson(aenderungsanfrage.toPrettyJson());
        String aenderungsanfrageDeserializedJson = aenderungsanfrageDeserialized.toPrettyJson();
        Assert.assertEquals((Object)aenderungsanfrageJson, (Object)aenderungsanfrageDeserializedJson);
    }

    @Test
    public void testComplexAnfrageDeserializer() throws JsonProcessingException, Exception {
        AenderungsanfrageJson aenderungsanfrage = this.getComplexAnfrageJson();
        String aenderungsanfrageJson = aenderungsanfrage.toPrettyJson();
        Assert.assertNotNull((Object)aenderungsanfrageJson);
        AenderungsanfrageJson aenderungsanfrageDeserialized = AenderungsanfrageUtils.getInstance().createAenderungsanfrageJson(aenderungsanfrage.toPrettyJson());
        String aenderungsanfrageDeserializedJson = aenderungsanfrageDeserialized.toPrettyJson();
        Assert.assertEquals((Object)aenderungsanfrageJson, (Object)aenderungsanfrageDeserializedJson);
    }

    @Test
    public void testEqualsTest() throws JsonProcessingException, Exception {
        AenderungsanfrageJson aenderungsanfrage1 = this.getComplexAnfrageJson();
        AenderungsanfrageJson aenderungsanfrage2 = this.getComplexAnfrageJson();
        Assert.assertEquals((Object)aenderungsanfrage1.toPrettyJson(), (Object)aenderungsanfrage2.toPrettyJson());
        Assert.assertEquals((Object)aenderungsanfrage1, (Object)aenderungsanfrage2);
    }
}

