/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.action;

import Sirius.server.newuser.User;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;
import de.cismet.commons.security.WebDavClient;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.netutil.ProxyHandler;
import de.cismet.verdis.server.json.NachrichtAnhangJson;
import de.cismet.verdis.server.utils.AenderungsanfrageConf;
import de.cismet.verdis.server.utils.AenderungsanfrageUtils;
import java.io.InputStream;
import java.net.URLEncoder;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class DownloadChangeRequestAnhangServerAction
implements ServerAction,
UserAwareServerAction,
ConnectionContextStore {
    private static final transient Logger LOG = Logger.getLogger(DownloadChangeRequestAnhangServerAction.class);
    public static final String TASK_NAME = "downloadChangeRequestAnhang";
    private User user;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    public Object execute(Object body, ServerActionParameter ... params) {
        String nachrichtAnhangJson = (String)body;
        String uuid = null;
        String fileName = null;
        try {
            if (params != null) {
                for (ServerActionParameter sap : params) {
                    if (sap.getKey().equals(Parameter.ANHANG_JSON.toString())) {
                        nachrichtAnhangJson = (String)sap.getValue();
                        continue;
                    }
                    if (sap.getKey().equals(Parameter.UUID.toString())) {
                        uuid = (String)sap.getValue();
                        continue;
                    }
                    if (!sap.getKey().equals(Parameter.FILE_NAME.toString())) continue;
                    fileName = (String)sap.getValue();
                }
            }
            if (nachrichtAnhangJson != null) {
                NachrichtAnhangJson nachrichtAnhang = AenderungsanfrageUtils.getInstance().createNachrichtAnhangJson(nachrichtAnhangJson);
                uuid = nachrichtAnhang.getUuid();
                fileName = nachrichtAnhang.getName();
            }
            if (fileName == null) {
                return new Exception("fileName can't be null");
            }
            if (uuid == null) {
                return new Exception("uuid can't be null");
            }
            AenderungsanfrageConf conf = AenderungsanfrageUtils.getConfFromServerResource();
            String webdavUrl = conf.getWebdavUrl();
            String downloadDirPath = webdavUrl.endsWith("/") ? webdavUrl : webdavUrl + "/";
            String downloadFilePath = String.format("%s%s_%s", downloadDirPath, uuid, URLEncoder.encode(fileName, "utf-8").replaceAll("\\+", "%20"));
            WebDavClient webdavClient = new WebDavClient(ProxyHandler.getInstance().getProxy(), conf.getWebdavUser(), conf.getWebdavPassword());
            return IOUtils.toByteArray((InputStream)webdavClient.getInputStream(downloadFilePath));
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return ex;
        }
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static enum Parameter {
        UUID{

            public String toString() {
                return "uuid";
            }
        }
        ,
        FILE_NAME{

            public String toString() {
                return "fileName";
            }
        }
        ,
        ANHANG_JSON{

            public String toString() {
                return "nachrichtAnhangJson";
            }
        };

    }
}

