/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.action;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.verdis.server.json.AenderungsanfrageJson;
import de.cismet.verdis.server.json.ContactInfoJson;
import de.cismet.verdis.server.utils.AenderungsanfrageUtils;
import de.cismet.verdis.server.utils.StacEntry;
import de.cismet.verdis.server.utils.StacUtils;
import org.apache.log4j.Logger;

public class GetMyKassenzeichenViaStacServerAction
implements MetaServiceStore,
UserAwareServerAction,
ServerAction,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(GetMyKassenzeichenViaStacServerAction.class);
    public static final String TASKNAME = "getMyKassenzeichen";
    private static final int MAX_CONCURRENT_RUNS = 4;
    private static volatile int currentRuns = 0;
    private MetaService metaService;
    private ConnectionContext connectionContext;
    private User user;

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void setMetaService(MetaService metaService) {
        this.metaService = metaService;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Object o, ServerActionParameter ... saps) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getMyKassenzeichen increaseCurrentRuns: existing runs: " + currentRuns));
        }
        try {
            this.increaseCurrentRuns();
            while (!this.canRunStart()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            long startTime = System.currentTimeMillis();
            String stac = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("GetMyKassenzeichenViaStacServerAction Run: " + currentRuns));
            }
            if (saps != null) {
                for (ServerActionParameter sap : saps) {
                    if (!sap.getKey().equals(PARAMETER_TYPE.STAC.toString())) continue;
                    stac = (String)sap.getValue();
                    break;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("STAC=" + stac));
                }
                StacEntry stacEntry = StacUtils.getStacEntry(stac, this.getMetaService(), this.getConnectionContext());
                CidsBean kassenzeichenBean = StacUtils.getKassenzeichenBean(stacEntry, this.getMetaService(), this.getConnectionContext());
                CidsBean aenderungsanfrageBean = AenderungsanfrageUtils.getInstance().getAenderungsanfrageBean(stacEntry, this.getMetaService(), this.getConnectionContext());
                String aenderungsanfrageJson = aenderungsanfrageBean != null ? (String)aenderungsanfrageBean.getProperty("changes_json") : null;
                AenderungsanfrageJson aenderungsanfrage = aenderungsanfrageJson != null ? AenderungsanfrageUtils.getInstance().createAenderungsanfrageJson(aenderungsanfrageJson) : null;
                AenderungsanfrageJson anderungsanfrageFiltered = AenderungsanfrageUtils.getInstance().doFilteringOutWhatIShouldntSee(aenderungsanfrage, "stac".equals(this.getUser().getName()));
                String clerkUsername = aenderungsanfrageBean != null ? (String)aenderungsanfrageBean.getProperty("clerk_username") : (stacEntry != null && stacEntry.getStacOptions() != null ? stacEntry.getStacOptions().getCreatorUserName() : null);
                ContactInfoJson contactInfo = clerkUsername != null ? AenderungsanfrageUtils.getInstance().getContactInfo(clerkUsername, AenderungsanfrageUtils.getConfFromServerResource().getSachbearbeiterDefaultname()) : null;
                kassenzeichenBean.setProperty("stac_options", (Object)stacEntry.getStacOptions());
                kassenzeichenBean.setProperty("stac_expiration", (Object)stacEntry.getExpiration());
                kassenzeichenBean.setProperty("aenderungsanfrage", anderungsanfrageFiltered != null ? StacUtils.asMap(anderungsanfrageFiltered.toJson()) : null);
                kassenzeichenBean.setProperty("contactinfo", (Object)(contactInfo != null ? contactInfo : null));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("getMyKassenzeichen runtime: " + (System.currentTimeMillis() - startTime)));
                }
                String string = kassenzeichenBean.toJSONString(false);
                return string;
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error during GetMyKassenzeichenViaStacServerAction.execute()", (Throwable)ex);
        }
        finally {
            this.decreaseCurrentRuns();
        }
        return "{\"nothing\":\"at all\"}";
    }

    private synchronized void increaseCurrentRuns() {
        ++currentRuns;
    }

    private synchronized boolean canRunStart() {
        return currentRuns <= 4;
    }

    private synchronized void decreaseCurrentRuns() {
        if (--currentRuns < 0) {
            currentRuns = 0;
        }
    }

    public String getTaskName() {
        return TASKNAME;
    }

    public static enum PARAMETER_TYPE {
        STAC;

    }
}

