/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.action;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class RenameKassenzeichenServerAction
implements MetaServiceStore,
UserAwareServerAction {
    private static final transient Logger LOG = Logger.getLogger(RenameKassenzeichenServerAction.class);
    private static final String QUERY_SELECT_CSLOCKS = "SELECT cs_locks.id FROM cs_locks, {mcTableKassenzeichen} AS kassenzeichen WHERE kassenzeichen.id = cs_locks.object_id AND cs_locks.class_id = {mcIdKassenzeichen} AND kassenzeichen.{fieldKassenzeichenKassenzeichennummer} = ?;";
    public static final String TASKNAME = "renameKassenzeichen";
    private Connection connection;
    private PreparedStatement selectKassenzeichenStatement;
    private PreparedStatement selectLocksStatement;
    private MetaService service;
    private User user;

    private Connection getConnection() throws Exception {
        if (this.connection == null) {
            this.connection = DomainServerImpl.getServerInstance().getConnectionPool().getConnection();
        }
        return this.connection;
    }

    private PreparedStatement getSelectLocksPreparedStatement() throws Exception {
        if (this.selectLocksStatement == null) {
            MetaClass mcKassenzeichen = this.getMetaService().getClassByTableName(this.getUser(), "kassenzeichen");
            String query = QUERY_SELECT_CSLOCKS.replaceAll("\\{mcTableKassenzeichen\\}", mcKassenzeichen.getTableName()).replaceAll("\\{mcIdKassenzeichen\\}", Integer.toString(mcKassenzeichen.getID())).replaceAll("\\{fieldKassenzeichenKassenzeichennummer\\}", "kassenzeichennummer8");
            this.selectLocksStatement = this.getConnection().prepareStatement(query);
        }
        return this.selectLocksStatement;
    }

    public Object execute(Object body, ServerActionParameter ... params) {
        Integer kassenzeichennummerOld = null;
        Integer kassenzeichennummerNew = null;
        for (ServerActionParameter sap : params) {
            if (sap == null) continue;
            if (sap.getKey().equals(ParameterType.KASSENZEICHENNUMMER_OLD.toString())) {
                kassenzeichennummerOld = (Integer)sap.getValue();
                continue;
            }
            if (!sap.getKey().equals(ParameterType.KASSENZEICHENNUMMER_NEW.toString())) continue;
            kassenzeichennummerNew = (Integer)sap.getValue();
        }
        if (kassenzeichennummerOld == null) {
            return new Exception("Es fehlt die Nummer des Kassenzeichens, welches umbenannt werden soll.");
        }
        if (kassenzeichennummerNew == null) {
            return new Exception("Es fehlt die Nummer, welche das Kassenzeichen erhalten soll.");
        }
        int numOfDigits = 8;
        if ((double)kassenzeichennummerNew.intValue() < Math.pow(10.0, 7.0) || (double)kassenzeichennummerNew.intValue() >= Math.pow(10.0, 8.0)) {
            return new Exception("Die neue Kassenzeichennummer muss 8-stellig sein.");
        }
        try {
            CidsBean source = this.getKassenzeichen(kassenzeichennummerOld);
            CidsBean target = this.getKassenzeichen(kassenzeichennummerNew);
            boolean locked = this.checkLocksExists(kassenzeichennummerOld);
            if (source == null) {
                return new Exception("Das Kassenzeichen mit der Nummer " + kassenzeichennummerOld + " wurde nicht gefunden.");
            }
            if (target != null) {
                return new Exception("Das Kassenzeichen mit der Nummer " + kassenzeichennummerNew + " existiert bereits.");
            }
            if (locked) {
                return new Exception("Das Kassenzeichen mit der Nummer " + kassenzeichennummerOld + " ist gesperrt.");
            }
            this.updateKassenzeichennummer(source, kassenzeichennummerNew);
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return ex;
        }
        return null;
    }

    private boolean checkLocksExists(int kassenzeichennummer) throws Exception {
        PreparedStatement preparedSelectStatement = this.getSelectLocksPreparedStatement();
        preparedSelectStatement.setInt(1, kassenzeichennummer);
        ResultSet rs = preparedSelectStatement.executeQuery();
        return rs.next();
    }

    private CidsBean getKassenzeichen(int kassenzeichennummer) throws Exception {
        User user = this.getUser();
        MetaService metaService = this.getMetaService();
        MetaClass mc = metaService.getClassByTableName(user, "kassenzeichen");
        String kassenzeichenQuery = "SELECT DISTINCT " + mc.getID() + ", " + mc.getTableName() + "." + mc.getPrimaryKey() + " FROM " + mc.getTableName() + " WHERE " + mc.getTableName() + "." + "kassenzeichennummer8" + " = " + kassenzeichennummer + " LIMIT 1;";
        MetaObject[] mos = metaService.getMetaObject(user, kassenzeichenQuery);
        if (mos.length == 1) {
            return mos[0].getBean();
        }
        return null;
    }

    private void updateKassenzeichennummer(CidsBean kassenzeichen, int kassenzeichennumer) throws Exception {
        if (kassenzeichen != null) {
            kassenzeichen.setProperty("kassenzeichennummer8", (Object)kassenzeichennumer);
            kassenzeichen.setProperty("letzte_aenderung_ts", (Object)new Timestamp(new Date().getTime()));
            kassenzeichen.setProperty("letzte_aenderung_von", (Object)String.format("%s@%s", this.getUser().getName(), this.getUser().getUserGroup().getName()));
            DomainServerImpl.getServerInstance().updateMetaObject(this.getUser(), kassenzeichen.getMetaObject());
        }
    }

    public String getTaskName() {
        return TASKNAME;
    }

    public void setMetaService(MetaService service) {
        this.service = service;
    }

    public MetaService getMetaService() {
        return this.service;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public static enum ParameterType {
        KASSENZEICHENNUMMER_OLD,
        KASSENZEICHENNUMMER_NEW;

    }
}

