/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.verdis.server.action;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import Sirius.server.middleware.interfaces.domainserver.UserStore;
import Sirius.server.newuser.User;
import Sirius.util.collections.MultiMap;
import de.cismet.cids.server.actions.DefaultScheduledServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.commons.security.WebDavClient;
import de.cismet.netutil.ProxyHandler;
import de.cismet.verdis.server.utils.VerdisServerResources;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.Logger;

public class VeranlagungsdateiScheduledServerAction
extends DefaultScheduledServerAction
implements MetaServiceStore,
UserStore {
    private static final transient Logger LOG = Logger.getLogger(VeranlagungsdateiScheduledServerAction.class);
    public static final String TASKNAME = "veranlagungsdatei";
    private static final transient SimpleDateFormat SUFFIX_DATEFORMAT = new SimpleDateFormat("yyMMdd");
    private static final transient SimpleDateFormat DATUM_DATEFORMAT = new SimpleDateFormat("dd.MM.yyyy");
    private transient WebDavClient webdavClient;
    private MetaService service;
    private User user;

    public String createKey(ServerActionParameter ... params) {
        return this.getTaskName();
    }

    public static String implodeArray(String[] inputArray, String glueString) {
        String output = "";
        if (inputArray.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(inputArray[0]);
            for (int i = 1; i < inputArray.length; ++i) {
                sb.append(glueString);
                sb.append(inputArray[i]);
            }
            output = sb.toString();
        }
        return output;
    }

    public Object execute(Object body, ServerActionParameter ... params) {
        Connection con = null;
        try {
            con = DomainServerImpl.getServerInstance().getConnectionPool().getConnection();
            String selectQuery = "SELECT veranlagungseintrag.id AS id,     MIN(kassenzeichen.kassenzeichennummer8) AS kassenzeichennummer,     veranlagungsnummer.nummer AS nummer,     SUM(veranlagungsposten.wert) AS wert,     MIN(veranlagungseintrag.veranlagungsdatum),     EXTRACT( MONTH FROM MIN(veranlagungseintrag.veranlagungsdatum))::INTEGER AS veranlagungsmonat,     EXTRACT( YEAR FROM MIN(veranlagungseintrag.veranlagungsdatum))::INTEGER AS veranlagungsjahr,     MIN(veranlagungseintrag.datum) AS datum FROM veranlagungseintrag,     veranlagungsposten,     veranlagungsnummer,     kassenzeichen WHERE     veranlagungseintrag.kassenzeichen = kassenzeichen.id AND     veranlagungseintrag.id = veranlagungsposten.veranlagungseintrag AND     veranlagungsposten.veranlagungsnummer = veranlagungsnummer.id AND     (veranlagungseintrag.ist_veranlagt IS NULL OR veranlagungseintrag.ist_veranlagt IS FALSE) AND     veranlagungsnummer.nummer BETWEEN '700' AND '800' GROUP BY veranlagungseintrag.id, veranlagungsnummer.nummer ORDER BY MIN(veranlagungseintrag.datum) ASC";
            ResultSet set = con.createStatement().executeQuery("SELECT veranlagungseintrag.id AS id,     MIN(kassenzeichen.kassenzeichennummer8) AS kassenzeichennummer,     veranlagungsnummer.nummer AS nummer,     SUM(veranlagungsposten.wert) AS wert,     MIN(veranlagungseintrag.veranlagungsdatum),     EXTRACT( MONTH FROM MIN(veranlagungseintrag.veranlagungsdatum))::INTEGER AS veranlagungsmonat,     EXTRACT( YEAR FROM MIN(veranlagungseintrag.veranlagungsdatum))::INTEGER AS veranlagungsjahr,     MIN(veranlagungseintrag.datum) AS datum FROM veranlagungseintrag,     veranlagungsposten,     veranlagungsnummer,     kassenzeichen WHERE     veranlagungseintrag.kassenzeichen = kassenzeichen.id AND     veranlagungseintrag.id = veranlagungsposten.veranlagungseintrag AND     veranlagungsposten.veranlagungsnummer = veranlagungsnummer.id AND     (veranlagungseintrag.ist_veranlagt IS NULL OR veranlagungseintrag.ist_veranlagt IS FALSE) AND     veranlagungsnummer.nummer BETWEEN '700' AND '800' GROUP BY veranlagungseintrag.id, veranlagungsnummer.nummer ORDER BY MIN(veranlagungseintrag.datum) ASC");
            MultiMap postenToEintragMap = new MultiMap();
            StringBuffer csvBuffer = new StringBuffer();
            while (set.next()) {
                int id = set.getInt("id");
                int kassenzeichennummer = set.getInt("kassenzeichennummer");
                int nummer = set.getInt("nummer");
                int wert = set.getInt("wert");
                int veranlagungsmonat = set.getInt("veranlagungsmonat");
                int veranlagungsjahr = set.getInt("veranlagungsjahr");
                Timestamp datum = set.getTimestamp("datum");
                String[] row = new String[]{Integer.toString(kassenzeichennummer), Integer.toString(nummer), Integer.toString(wert), Integer.toString(veranlagungsmonat), Integer.toString(veranlagungsjahr), DATUM_DATEFORMAT.format(datum)};
                postenToEintragMap.put(Integer.toString(id), row);
                csvBuffer.append(VeranlagungsdateiScheduledServerAction.implodeArray(row, ";")).append("\n");
            }
            if (!postenToEintragMap.keySet().isEmpty()) {
                String filename = "Veranlagung_VERDIS_fuer_GESKA_" + SUFFIX_DATEFORMAT.format(new Date()) + ".csv";
                ByteArrayInputStream data = new ByteArrayInputStream(csvBuffer.toString().getBytes("UTF-8"));
                Properties webdavProperties = ServerResourcesLoader.getInstance().loadProperties(VerdisServerResources.WEBDAV.getValue());
                String webdavPath = webdavProperties.getProperty("url_veranlagung");
                if (this.webdavClient == null) {
                    this.webdavClient = new WebDavClient(ProxyHandler.getInstance().getProxy(), webdavProperties.getProperty("user"), webdavProperties.getProperty("password"));
                }
                this.webdavClient.put(webdavPath + "/" + filename, (InputStream)data);
                String updateQuery = "UPDATE veranlagungseintrag SET ist_veranlagt = TRUE WHERE id IN (" + VeranlagungsdateiScheduledServerAction.implodeArray(postenToEintragMap.keySet().toArray(new String[0]), ", ") + ")";
                con.createStatement().executeUpdate(updateQuery);
                return filename;
            }
        }
        catch (Exception ex) {
            LOG.fatal((Object)"error while creating veranlagungsdatei", (Throwable)ex);
        }
        return null;
    }

    public String getTaskName() {
        return TASKNAME;
    }

    public void setMetaService(MetaService service) {
        this.service = service;
    }

    public MetaService getMetaService() {
        return this.service;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }
}

